/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class Netlist {
    NetCell netCell;
    int expectedModCount;
    int[] netMap;
    int[] nm_net;
    private JNetwork[] networks;

    Netlist(NetCell netCell) {
        this.netCell = netCell;
        this.expectedModCount = netCell.modCount;
    }

    void initNetMap(int size) {
        if (this.netMap == null || this.netMap.length != size) {
            this.netMap = new int[size];
            this.nm_net = new int[size];
        }
        for (int i = 0; i < this.netMap.length; ++i) {
            this.netMap[i] = i;
        }
    }

    void initNetworks() {
        int i;
        Netlist.closureMap(this.netMap);
        int k = 0;
        for (i = 0; i < this.netMap.length; ++i) {
            if (this.netMap[i] != i) continue;
            ++k;
        }
        if (this.networks == null || this.networks.length != k) {
            this.networks = new JNetwork[k];
        }
        Arrays.fill(this.networks, null);
        k = 0;
        for (i = 0; i < this.netMap.length; ++i) {
            if (this.netMap[i] == i) {
                this.networks[k] = new JNetwork(this, k);
                this.nm_net[i] = k++;
                continue;
            }
            this.nm_net[i] = this.nm_net[this.netMap[i]];
        }
    }

    final void connectMap(int a1, int a2) {
        Netlist.connectMap(this.netMap, a1, a2);
    }

    private static void connectMap(int[] map, int a1, int a2) {
        int k;
        int m1 = a1;
        while (map[m1] != m1) {
            m1 = map[m1];
        }
        int m2 = a2;
        while (map[m2] != m2) {
            m2 = map[m2];
        }
        int m = m1 < m2 ? m1 : m2;
        while (true) {
            k = map[a1];
            map[a1] = m;
            if (a1 == k) break;
            a1 = k;
        }
        while (true) {
            k = map[a2];
            map[a2] = m;
            if (a2 == k) break;
            a2 = k;
        }
    }

    private static void closureMap(int[] map) {
        for (int i = 0; i < map.length; ++i) {
            map[i] = map[map[i]];
        }
    }

    private static boolean equalMaps(int[] map1, int[] map2) {
        if (map1.length != map2.length) {
            return false;
        }
        for (int i = 0; i < map1.length; ++i) {
            if (map1[i] == map2[i]) continue;
            return false;
        }
        return true;
    }

    JNetwork getNetworkByMap(int mapOffset) {
        return this.networks[this.nm_net[mapOffset]];
    }

    private final void checkForModification() {
        if (this.expectedModCount != this.netCell.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    public static Nodable getNodableFor(NodeInst ni, int arrayIndex) {
        Cell parent = ni.getParent();
        Netlist netlist = Network.getUserNetlist(parent);
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            if (!no.contains(ni, arrayIndex)) continue;
            return no;
        }
        return null;
    }

    public Iterator getNodables() {
        this.checkForModification();
        return this.netCell.getNodables();
    }

    public Netlist getNetlist(Nodable no) {
        NodeProto np = no.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        return Network.getUserNetlist((Cell)np);
    }

    public Global.Set getGlobals() {
        this.checkForModification();
        return this.netCell.getGlobals();
    }

    public int getNumNetworks() {
        this.checkForModification();
        return this.networks.length;
    }

    public JNetwork getNetwork(int netIndex) {
        this.checkForModification();
        return this.networks[netIndex];
    }

    public Iterator getNetworks() {
        this.checkForModification();
        return Arrays.asList(this.networks).iterator();
    }

    public int getNetIndex(Global global) {
        this.checkForModification();
        int netMapIndex = this.netCell.getNetMapOffset(global);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public int getNetIndex(Nodable no, PortProto portProto, int busIndex) {
        this.checkForModification();
        if (no.getParent() != this.netCell.cell) {
            return -1;
        }
        if (portProto.getParent() != no.getProto()) {
            System.out.println("Netlist.getNetwork: invalid argument portProto");
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(no, portProto, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public int getNetIndex(Export export, int busIndex) {
        this.checkForModification();
        if (export.getParent() != this.netCell.cell) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= export.getNameKey().busWidth()) {
            System.out.println("Nodable.getNetwork: invalid arguments busIndex=" + busIndex + " export=" + export);
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(export, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public int getNetIndex(ArcInst ai, int busIndex) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(ai, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public JNetwork getNetwork(Nodable no, PortProto portProto, int busIndex) {
        int netIndex = this.getNetIndex(no, portProto, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public boolean portsConnected(Nodable no, PortProto port1, PortProto port2) {
        int busWidth = port1.getNameKey().busWidth();
        if (port2.getNameKey().busWidth() != busWidth) {
            return false;
        }
        for (int i = 0; i < busWidth; ++i) {
            if (this.getNetIndex(no, port1, i) == this.getNetIndex(no, port2, i)) continue;
            return false;
        }
        return true;
    }

    public JNetwork getNetwork(PortInst pi) {
        PortProto portProto = pi.getPortProto();
        if (portProto.getNameKey().isBus()) {
            System.out.println("PortInst.getNetwork() was called for instance of bus port " + portProto.getName());
            return null;
        }
        return this.getNetwork(pi.getNodeInst(), portProto, 0);
    }

    public JNetwork getNetwork(Export export, int busIndex) {
        int netIndex = this.getNetIndex(export, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public JNetwork getNetwork(ArcInst ai, int busIndex) {
        int netIndex = this.getNetIndex(ai, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public boolean sameNetwork(ArcInst ai1, ArcInst ai2) {
        int busWidth2;
        if (ai1 == null || ai2 == null) {
            return false;
        }
        int busWidth1 = this.netCell.getBusWidth(ai1);
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(ai2))) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(ai1, i) == this.getNetIndex(ai2, i)) continue;
            return false;
        }
        return true;
    }

    public boolean sameNetwork(Nodable no, PortProto pp, ArcInst ai) {
        int busWidth2;
        if (no == null || pp == null || ai == null) {
            return false;
        }
        int busWidth1 = pp.getNameKey().busWidth();
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(ai))) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(no, pp, i) == this.getNetIndex(ai, i)) continue;
            return false;
        }
        return true;
    }

    public boolean sameNetwork(Nodable no1, PortProto pp1, Nodable no2, PortProto pp2) {
        int busWidth2;
        if (no1 == null || pp1 == null || no2 == null || pp2 == null) {
            return false;
        }
        int busWidth1 = pp1.getNameKey().busWidth();
        if (busWidth1 != (busWidth2 = pp2.getNameKey().busWidth())) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(no1, pp1, i) == this.getNetIndex(no2, pp2, i)) continue;
            return false;
        }
        return true;
    }

    public String getNetworkName(ArcInst ai) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth > 1) {
            return this.netCell.getBusName(ai).toString();
        }
        JNetwork network = this.getNetwork(ai, 0);
        if (network == null) {
            return null;
        }
        return network.describe();
    }

    public Name getBusName(ArcInst ai) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth <= 1) {
            return null;
        }
        return this.netCell.getBusName(ai);
    }

    public int getBusWidth(Export e) {
        return e.getNameKey().busWidth();
    }

    public int getBusWidth(ArcInst ai) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return 0;
        }
        return this.netCell.getBusWidth(ai);
    }

    public String toString() {
        return "Netlist of " + this.netCell.cell;
    }
}

