#line 5 "meta1-lex.l"
/* MeTA1 configuration lexer for Grecs.
   Copyright (C) 2007-2016 Sergey Poznyakoff

   Grecs is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3 of the License, or (at your
   option) any later version.

   Grecs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Grecs. If not, see <http://www.gnu.org/licenses/>. */

/* This file implements a lexical analyzer for MeTA1 main configuration file.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "grecs.h"
#include "meta1-gram.h"
#include <ctype.h>



#line 31 "meta1-lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define grecs_meta1_const const
#else
#define grecs_meta1_const
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (grecs_meta1__start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((grecs_meta1__start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE grecs_meta1_restart(grecs_meta1_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(grecs_meta1__state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct grecs_meta1__buffer_state *YY_BUFFER_STATE;
#endif

/* %if-not-reentrant */
extern int grecs_meta1_leng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *grecs_meta1_in, *grecs_meta1_out;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define grecs_meta1_less(n) \
	do \
		{ \
		/* Undo effects of setting up grecs_meta1_text. */ \
        int grecs_meta1_less_macro_arg = (n); \
        YY_LESS_LINENO(grecs_meta1_less_macro_arg);\
		*grecs_meta1__cp = (grecs_meta1__hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(grecs_meta1__c_buf_p) = grecs_meta1__cp = grecs_meta1__bp + grecs_meta1_less_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up grecs_meta1_text again */ \
		} \
	while ( 0 )

#define unput(c) grecs_meta1_unput( c, (grecs_meta1_text_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t grecs_meta1__size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct grecs_meta1__buffer_state
	{
/* %if-c-only */
	FILE *grecs_meta1__input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *grecs_meta1__ch_buf;		/* input buffer */
	char *grecs_meta1__buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	grecs_meta1__size_t grecs_meta1__buf_size;

	/* Number of characters read into grecs_meta1__ch_buf, not including EOB
	 * characters.
	 */
	int grecs_meta1__n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int grecs_meta1__is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int grecs_meta1__is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int grecs_meta1__at_bol;

    int grecs_meta1__bs_lineno; /**< The line count. */
    int grecs_meta1__bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int grecs_meta1__fill_buffer;

	int grecs_meta1__buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via grecs_meta1_restart()), so that the user can continue scanning by
	 * just pointing grecs_meta1_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t grecs_meta1__buffer_stack_top = 0; /**< index of top of stack. */
static size_t grecs_meta1__buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * grecs_meta1__buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (grecs_meta1__buffer_stack) \
                          ? (grecs_meta1__buffer_stack)[(grecs_meta1__buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (grecs_meta1__buffer_stack)[(grecs_meta1__buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* grecs_meta1__hold_char holds the character lost when grecs_meta1_text is formed. */
static char grecs_meta1__hold_char;
static int grecs_meta1__n_chars;		/* number of characters read into grecs_meta1__ch_buf */
int grecs_meta1_leng;

/* Points to current character in buffer. */
static char *grecs_meta1__c_buf_p = (char *) 0;
static int grecs_meta1__init = 0;		/* whether we need to initialize */
static int grecs_meta1__start = 0;	/* start state number */

/* Flag which is used to allow grecs_meta1_wrap()'s to do buffer switches
 * instead of setting up a fresh grecs_meta1_in.  A bit of a hack ...
 */
static int grecs_meta1__did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void grecs_meta1_restart (FILE *input_file  );
void grecs_meta1__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE grecs_meta1__create_buffer (FILE *file,int size  );
void grecs_meta1__delete_buffer (YY_BUFFER_STATE b  );
void grecs_meta1__flush_buffer (YY_BUFFER_STATE b  );
void grecs_meta1_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void grecs_meta1_pop_buffer_state (void );

static void grecs_meta1_ensure_buffer_stack (void );
static void grecs_meta1__load_buffer_state (void );
static void grecs_meta1__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER grecs_meta1__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE grecs_meta1__scan_buffer (char *base,grecs_meta1__size_t size  );
YY_BUFFER_STATE grecs_meta1__scan_string (grecs_meta1_const char *grecs_meta1__str  );
YY_BUFFER_STATE grecs_meta1__scan_bytes (grecs_meta1_const char *bytes,int len  );

/* %endif */

void *grecs_meta1_alloc (grecs_meta1__size_t  );
void *grecs_meta1_realloc (void *,grecs_meta1__size_t  );
void grecs_meta1_free (void *  );

#define grecs_meta1__new_buffer grecs_meta1__create_buffer

#define grecs_meta1__set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        grecs_meta1_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            grecs_meta1__create_buffer(grecs_meta1_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->grecs_meta1__is_interactive = is_interactive; \
	}

#define grecs_meta1__set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        grecs_meta1_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            grecs_meta1__create_buffer(grecs_meta1_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->grecs_meta1__at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->grecs_meta1__at_bol)

/* %% [1.0] grecs_meta1_text/grecs_meta1_in/grecs_meta1_out/grecs_meta1__state_type/grecs_meta1_lineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *grecs_meta1_in = (FILE *) 0, *grecs_meta1_out = (FILE *) 0;

typedef int grecs_meta1__state_type;

extern int grecs_meta1_lineno;

int grecs_meta1_lineno = 1;

extern char *grecs_meta1_text;
#define grecs_meta1_text_ptr grecs_meta1_text

/* %if-c-only Standard (non-C++) definition */

static grecs_meta1__state_type grecs_meta1__get_previous_state (void );
static grecs_meta1__state_type grecs_meta1__try_NUL_trans (grecs_meta1__state_type current_state  );
static int grecs_meta1__get_next_buffer (void );
static void grecs_meta1__fatal_error (grecs_meta1_const char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up grecs_meta1_text.
 */
#define YY_DO_BEFORE_ACTION \
	(grecs_meta1_text_ptr) = grecs_meta1__bp; \
/* %% [2.0] code to fiddle grecs_meta1_text and grecs_meta1_leng for grecs_meta1_more() goes here \ */\
	grecs_meta1_leng = (size_t) (grecs_meta1__cp - grecs_meta1__bp); \
	(grecs_meta1__hold_char) = *grecs_meta1__cp; \
	*grecs_meta1__cp = '\0'; \
/* %% [3.0] code to copy grecs_meta1_text_ptr to grecs_meta1_text[] goes here, if %array \ */\
	(grecs_meta1__c_buf_p) = grecs_meta1__cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 23
#define YY_END_OF_BUFFER 24
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct grecs_meta1__trans_info
	{
	flex_int32_t grecs_meta1__verify;
	flex_int32_t grecs_meta1__nxt;
	};
static grecs_meta1_const flex_int16_t grecs_meta1__accept[54] =
    {   0,
        0,    0,    2,    2,    0,    0,   24,   22,   19,   20,
       22,    7,   11,   21,   11,   11,   11,    2,    4,    3,
       23,   18,   17,   23,   19,    0,   12,    0,    7,    6,
       11,    1,    9,   11,   10,    2,    3,    3,    5,    0,
       18,   17,    0,   16,   16,   14,   14,    8,   15,   13,
       15,   13,    0
    } ;

static grecs_meta1_const flex_int32_t grecs_meta1__ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    1,
        1,    6,    1,    7,    8,    8,    9,   10,   11,   11,
       11,   11,   11,   11,   11,   12,   12,    8,    7,    1,
        7,    1,    1,    1,   13,   13,   13,   13,   13,   13,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,   14,    8,    8,
        1,   15,    1,    1,    8,    1,   13,   13,   13,   13,

       13,   13,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,   16,
        8,    8,    7,    1,    7,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static grecs_meta1_const flex_int32_t grecs_meta1__meta[17] =
    {   0,
        1,    1,    2,    1,    1,    3,    1,    4,    4,    5,
        5,    5,    5,    4,    1,    4
    } ;

static grecs_meta1_const flex_int16_t grecs_meta1__base[68] =
    {   0,
        0,    0,   14,   15,   19,   32,   60,  136,   51,  136,
       15,   48,    0,  136,   44,   38,   45,    0,  136,   18,
       55,  136,  136,   30,   43,   22,  136,   28,   40,  136,
        0,    0,   18,   61,    0,    0,   32,   33,  136,   72,
      136,  136,   24,  136,    0,  136,    0,    0,    0,    0,
      136,  136,  136,   87,   92,   97,  102,  105,  110,  115,
      120,  125,  130,   28,   27,   26,   20
    } ;

static grecs_meta1_const flex_int16_t grecs_meta1__def[68] =
    {   0,
       53,    1,   54,   54,   55,   55,   53,   53,   53,   53,
       56,   57,   58,   53,   58,   58,   58,   59,   53,   60,
       61,   53,   53,   62,   53,   56,   53,   63,   57,   53,
       58,   58,   58,   58,   17,   59,   60,   60,   53,   61,
       53,   53,   62,   53,   64,   53,   65,   34,   66,   67,
       53,   53,    0,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53
    } ;

static grecs_meta1_const flex_int16_t grecs_meta1__nxt[153] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   13,   15,   16,
       17,   17,   13,   13,    8,   13,   19,   19,   27,   20,
       20,   22,   23,   38,   52,   27,   39,   33,   33,   28,
       51,   50,   49,   24,   22,   23,   28,   53,   38,   45,
       53,   39,   30,   47,   25,   45,   24,   33,   33,   32,
       30,   34,   25,   34,   35,   35,   35,   41,   42,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   43,
       48,   48,   48,   48,   41,   42,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   43,   18,   18,   18,
       18,   18,   21,   21,   21,   21,   21,   26,   53,   26,

       26,   26,   29,   29,   29,   29,   29,   31,   31,   31,
       36,   53,   53,   36,   36,   37,   53,   37,   37,   37,
       40,   40,   40,   40,   40,   44,   53,   44,   44,   44,
       46,   53,   46,   46,   46,    7,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53
    } ;

static grecs_meta1_const flex_int16_t grecs_meta1__chk[153] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    4,   11,    3,
        4,    5,    5,   20,   67,   26,   20,   33,   33,   11,
       66,   65,   64,    5,    6,    6,   26,   37,   38,   43,
       37,   38,   29,   28,   25,   24,    6,   16,   16,   15,
       12,   16,    9,   16,   17,   17,   17,   21,   21,    7,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   21,
       34,   34,   34,   34,   40,   40,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   40,   54,   54,   54,
       54,   54,   55,   55,   55,   55,   55,   56,    0,   56,

       56,   56,   57,   57,   57,   57,   57,   58,   58,   58,
       59,    0,    0,   59,   59,   60,    0,   60,   60,   60,
       61,   61,   61,   61,   61,   62,    0,   62,   62,   62,
       63,    0,   63,   63,   63,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53
    } ;

static grecs_meta1__state_type grecs_meta1__last_accepting_state;
static char *grecs_meta1__last_accepting_cpos;

extern int grecs_meta1__flex_debug;
int grecs_meta1__flex_debug = 1;

static grecs_meta1_const flex_int16_t grecs_meta1__rule_linenum[23] =
    {   0,
       50,   51,   52,   53,   54,   56,   57,   59,   60,   61,
       66,   71,   75,   79,   84,   85,   87,   92,   99,  100,
      101,  102
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define grecs_meta1_more() grecs_meta1_more_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *grecs_meta1_text;
#line 1 "meta1-lex.l"
/* MeTA1 configuration lexer for Grecs. -*- c -*- */
#define YY_NO_INPUT 1

#line 33 "meta1-lex.l"
static int grecs_meta1_wrap(void);
static void meta1_line_add_unescape_hex(const char *text, size_t len);	

#define YY_USER_ACTION do {						\
		if (YYSTATE == 0) {					\
			grecs_meta1_lloc.beg = grecs_current_locus_point;		\
			grecs_meta1_lloc.beg.col++;				\
		}							\
  		grecs_current_locus_point.col += grecs_meta1_leng;		\
 		grecs_meta1_lloc.end = grecs_current_locus_point;			\
   	} while (0);

#line 633 "meta1-lex.c"

#define INITIAL 0
#define COMMENT 1
#define STR 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int grecs_meta1__init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int grecs_meta1_lex_destroy (void );

int grecs_meta1_get_debug (void );

void grecs_meta1_set_debug (int debug_flag  );

YY_EXTRA_TYPE grecs_meta1_get_extra (void );

void grecs_meta1_set_extra (YY_EXTRA_TYPE user_defined  );

FILE *grecs_meta1_get_in (void );

void grecs_meta1_set_in  (FILE * in_str  );

FILE *grecs_meta1_get_out (void );

void grecs_meta1_set_out  (FILE * out_str  );

int grecs_meta1_get_leng (void );

char *grecs_meta1_get_text (void );

int grecs_meta1_get_lineno (void );

void grecs_meta1_set_lineno (int line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int grecs_meta1_wrap (void );
#else
extern int grecs_meta1_wrap (void );
#endif
#endif

/* %not-for-header */

/* %ok-for-header */

/* %endif */

#ifndef grecs_meta1_text_ptr
static void grecs_meta1__flex_strncpy (char *,grecs_meta1_const char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int grecs_meta1__flex_strlen (grecs_meta1_const char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int grecs_meta1_input (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( grecs_meta1_text, grecs_meta1_leng, 1, grecs_meta1_out )
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->grecs_meta1__is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( grecs_meta1_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( grecs_meta1_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, grecs_meta1_in))==0 && ferror(grecs_meta1_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(grecs_meta1_in); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "grecs_meta1_terminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef grecs_meta1_terminate
#define grecs_meta1_terminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) grecs_meta1__fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-grecs_meta1_dmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int grecs_meta1_lex (void);

#define YY_DECL int grecs_meta1_lex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after grecs_meta1_text and grecs_meta1_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register grecs_meta1__state_type grecs_meta1__current_state;
	register char *grecs_meta1__cp, *grecs_meta1__bp;
	register int grecs_meta1__act;
    
/* %% [7.0] user's declarations go here */
#line 48 "meta1-lex.l"

         /* C-style comments */
#line 878 "meta1-lex.c"

	if ( !(grecs_meta1__init) )
		{
		(grecs_meta1__init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (grecs_meta1__start) )
			(grecs_meta1__start) = 1;	/* first start state */

		if ( ! grecs_meta1_in )
/* %if-c-only */
			grecs_meta1_in = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! grecs_meta1_out )
/* %if-c-only */
			grecs_meta1_out = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			grecs_meta1_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				grecs_meta1__create_buffer(grecs_meta1_in,YY_BUF_SIZE );
		}

		grecs_meta1__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] grecs_meta1_more()-related code goes here */
		grecs_meta1__cp = (grecs_meta1__c_buf_p);

		/* Support of grecs_meta1_text. */
		*grecs_meta1__cp = (grecs_meta1__hold_char);

		/* grecs_meta1__bp points to the position in grecs_meta1__ch_buf of the start of
		 * the current run.
		 */
		grecs_meta1__bp = grecs_meta1__cp;

/* %% [9.0] code to set up and find next match goes here */
		grecs_meta1__current_state = (grecs_meta1__start);
grecs_meta1__match:
		do
			{
			register YY_CHAR grecs_meta1__c = grecs_meta1__ec[YY_SC_TO_UI(*grecs_meta1__cp)];
			if ( grecs_meta1__accept[grecs_meta1__current_state] )
				{
				(grecs_meta1__last_accepting_state) = grecs_meta1__current_state;
				(grecs_meta1__last_accepting_cpos) = grecs_meta1__cp;
				}
			while ( grecs_meta1__chk[grecs_meta1__base[grecs_meta1__current_state] + grecs_meta1__c] != grecs_meta1__current_state )
				{
				grecs_meta1__current_state = (int) grecs_meta1__def[grecs_meta1__current_state];
				if ( grecs_meta1__current_state >= 54 )
					grecs_meta1__c = grecs_meta1__meta[(unsigned int) grecs_meta1__c];
				}
			grecs_meta1__current_state = grecs_meta1__nxt[grecs_meta1__base[grecs_meta1__current_state] + (unsigned int) grecs_meta1__c];
			++grecs_meta1__cp;
			}
		while ( grecs_meta1__base[grecs_meta1__current_state] != 136 );

grecs_meta1__find_action:
/* %% [10.0] code to find the action number goes here */
		grecs_meta1__act = grecs_meta1__accept[grecs_meta1__current_state];
		if ( grecs_meta1__act == 0 )
			{ /* have to back up */
			grecs_meta1__cp = (grecs_meta1__last_accepting_cpos);
			grecs_meta1__current_state = (grecs_meta1__last_accepting_state);
			grecs_meta1__act = grecs_meta1__accept[grecs_meta1__current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for grecs_meta1_lineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( grecs_meta1__flex_debug )
			{
			if ( grecs_meta1__act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( grecs_meta1__act < 23 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)grecs_meta1__rule_linenum[grecs_meta1__act], grecs_meta1_text );
			else if ( grecs_meta1__act == 23 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         grecs_meta1_text );
			else if ( grecs_meta1__act == 24 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( grecs_meta1__act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*grecs_meta1__cp = (grecs_meta1__hold_char);
			grecs_meta1__cp = (grecs_meta1__last_accepting_cpos);
			grecs_meta1__current_state = (grecs_meta1__last_accepting_state);
			goto grecs_meta1__find_action;

case 1:
YY_RULE_SETUP
#line 50 "meta1-lex.l"
BEGIN (COMMENT);
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 51 "meta1-lex.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 52 "meta1-lex.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 53 "meta1-lex.l"
grecs_locus_point_advance_line(grecs_current_locus_point);
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 54 "meta1-lex.l"
BEGIN (INITIAL);
	YY_BREAK
/* End-of-line comments */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 56 "meta1-lex.l"
{ grecs_locus_point_advance_line(grecs_current_locus_point); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 57 "meta1-lex.l"
/* end-of-file comment */;
	YY_BREAK
/* Number */
case 8:
#line 60 "meta1-lex.l"
case 9:
#line 61 "meta1-lex.l"
case 10:
YY_RULE_SETUP
#line 61 "meta1-lex.l"
{ grecs_line_begin();
	                  grecs_line_add(grecs_meta1_text, grecs_meta1_leng);
	                  grecs_meta1_lval.string = grecs_line_finish();
                          return META1_STRING; }
	YY_BREAK
/* Identifiers (unquoted strings) */
case 11:
YY_RULE_SETUP
#line 66 "meta1-lex.l"
{ grecs_line_begin();
	                  grecs_line_add(grecs_meta1_text, grecs_meta1_leng);
	                  grecs_meta1_lval.string = grecs_line_finish();
                          return META1_IDENT; }
	YY_BREAK
/* Quoted strings */
case 12:
YY_RULE_SETUP
#line 71 "meta1-lex.l"
{ grecs_line_begin();
	                  grecs_line_add(grecs_meta1_text + 1, grecs_meta1_leng - 2);
	                  grecs_meta1_lval.string = grecs_line_finish();
                          return META1_STRING; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 75 "meta1-lex.l"
{ BEGIN(STR);
                          grecs_line_begin();
			  meta1_line_add_unescape_hex(grecs_meta1_text + 1, grecs_meta1_leng - 1);
		        }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 79 "meta1-lex.l"
{ BEGIN(STR);
	                  grecs_line_begin();
			  grecs_line_acc_grow_unescape_last(grecs_meta1_text + 1,
                                                            grecs_meta1_leng - 1,
                                                            &grecs_meta1_lloc); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 84 "meta1-lex.l"
{ meta1_line_add_unescape_hex(grecs_meta1_text, grecs_meta1_leng); }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 85 "meta1-lex.l"
{ grecs_line_acc_grow_unescape_last(grecs_meta1_text, grecs_meta1_leng, 
                                                            &grecs_meta1_lloc); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 87 "meta1-lex.l"
{ BEGIN(INITIAL);
                          if (grecs_meta1_leng > 1) 
                            grecs_line_add(grecs_meta1_text, grecs_meta1_leng - 1); 
                          grecs_meta1_lval.string = grecs_line_finish();
		          return META1_STRING; }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 92 "meta1-lex.l"
{ BEGIN(INITIAL);
                          grecs_error(&grecs_meta1_lloc, 0,
                                      _("newline in a string"));
                          grecs_line_add(grecs_meta1_text, grecs_meta1_leng - 1);
                          grecs_meta1_lval.string = grecs_line_finish();
                          return META1_STRING; }
	YY_BREAK
/* Other tokens */
case 19:
YY_RULE_SETUP
#line 99 "meta1-lex.l"
;
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 100 "meta1-lex.l"
{ grecs_locus_point_advance_line(grecs_current_locus_point); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 101 "meta1-lex.l"
return grecs_meta1_text[0];
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 102 "meta1-lex.l"
{ grecs_error(&grecs_meta1_lloc, 0,
                       (isascii(grecs_meta1_text[0]) && isprint(grecs_meta1_text[0])) ?
                          _("stray character %c") :
                          _("stray character \\%03o"),
			         (unsigned char) grecs_meta1_text[0]); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 107 "meta1-lex.l"
ECHO;
	YY_BREAK
#line 1140 "meta1-lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
	grecs_meta1_terminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int grecs_meta1__amount_of_matched_text = (int) (grecs_meta1__cp - (grecs_meta1_text_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*grecs_meta1__cp = (grecs_meta1__hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed grecs_meta1_in at a new source and called
			 * grecs_meta1_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(grecs_meta1__n_chars) = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars;
			YY_CURRENT_BUFFER_LVALUE->grecs_meta1__input_file = grecs_meta1_in;
			YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for grecs_meta1__c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since grecs_meta1__c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (grecs_meta1__c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars)] )
			{ /* This was really a NUL. */
			grecs_meta1__state_type grecs_meta1__next_state;

			(grecs_meta1__c_buf_p) = (grecs_meta1_text_ptr) + grecs_meta1__amount_of_matched_text;

			grecs_meta1__current_state = grecs_meta1__get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * grecs_meta1__get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			grecs_meta1__next_state = grecs_meta1__try_NUL_trans( grecs_meta1__current_state );

			grecs_meta1__bp = (grecs_meta1_text_ptr) + YY_MORE_ADJ;

			if ( grecs_meta1__next_state )
				{
				/* Consume the NUL. */
				grecs_meta1__cp = ++(grecs_meta1__c_buf_p);
				grecs_meta1__current_state = grecs_meta1__next_state;
				goto grecs_meta1__match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up grecs_meta1__cp goes here */
				grecs_meta1__cp = (grecs_meta1__c_buf_p);
				goto grecs_meta1__find_action;
				}
			}

		else switch ( grecs_meta1__get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(grecs_meta1__did_buffer_switch_on_eof) = 0;

				if ( grecs_meta1_wrap( ) )
					{
					/* Note: because we've taken care in
					 * grecs_meta1__get_next_buffer() to have set up
					 * grecs_meta1_text, we can now set up
					 * grecs_meta1__c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(grecs_meta1__c_buf_p) = (grecs_meta1_text_ptr) + YY_MORE_ADJ;

					grecs_meta1__act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (grecs_meta1__did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(grecs_meta1__c_buf_p) =
					(grecs_meta1_text_ptr) + grecs_meta1__amount_of_matched_text;

				grecs_meta1__current_state = grecs_meta1__get_previous_state(  );

				grecs_meta1__cp = (grecs_meta1__c_buf_p);
				grecs_meta1__bp = (grecs_meta1_text_ptr) + YY_MORE_ADJ;
				goto grecs_meta1__match;

			case EOB_ACT_LAST_MATCH:
				(grecs_meta1__c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars)];

				grecs_meta1__current_state = grecs_meta1__get_previous_state(  );

				grecs_meta1__cp = (grecs_meta1__c_buf_p);
				grecs_meta1__bp = (grecs_meta1_text_ptr) + YY_MORE_ADJ;
				goto grecs_meta1__find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of grecs_meta1_lex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* grecs_meta1__get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int grecs_meta1__get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf;
	register char *source = (grecs_meta1_text_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (grecs_meta1__c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->grecs_meta1__fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (grecs_meta1__c_buf_p) - (grecs_meta1_text_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((grecs_meta1__c_buf_p) - (grecs_meta1_text_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars = (grecs_meta1__n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int grecs_meta1__c_buf_p_offset =
				(int) ((grecs_meta1__c_buf_p) - b->grecs_meta1__ch_buf);

			if ( b->grecs_meta1__is_our_buffer )
				{
				int new_size = b->grecs_meta1__buf_size * 2;

				if ( new_size <= 0 )
					b->grecs_meta1__buf_size += b->grecs_meta1__buf_size / 8;
				else
					b->grecs_meta1__buf_size *= 2;

				b->grecs_meta1__ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					grecs_meta1_realloc((void *) b->grecs_meta1__ch_buf,b->grecs_meta1__buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->grecs_meta1__ch_buf = 0;

			if ( ! b->grecs_meta1__ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(grecs_meta1__c_buf_p) = &b->grecs_meta1__ch_buf[grecs_meta1__c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[number_to_move]),
			(grecs_meta1__n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars = (grecs_meta1__n_chars);
		}

	if ( (grecs_meta1__n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			grecs_meta1_restart(grecs_meta1_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((grecs_meta1__size_t) ((grecs_meta1__n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		grecs_meta1__size_t new_size = (grecs_meta1__n_chars) + number_to_move + ((grecs_meta1__n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf = (char *) grecs_meta1_realloc((void *) YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1__get_next_buffer()" );
	}

	(grecs_meta1__n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(grecs_meta1_text_ptr) = &YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[0];

	return ret_val;
}

/* grecs_meta1__get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static grecs_meta1__state_type grecs_meta1__get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register grecs_meta1__state_type grecs_meta1__current_state;
	register char *grecs_meta1__cp;
    
/* %% [15.0] code to get the start state into grecs_meta1__current_state goes here */
	grecs_meta1__current_state = (grecs_meta1__start);

	for ( grecs_meta1__cp = (grecs_meta1_text_ptr) + YY_MORE_ADJ; grecs_meta1__cp < (grecs_meta1__c_buf_p); ++grecs_meta1__cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR grecs_meta1__c = (*grecs_meta1__cp ? grecs_meta1__ec[YY_SC_TO_UI(*grecs_meta1__cp)] : 1);
		if ( grecs_meta1__accept[grecs_meta1__current_state] )
			{
			(grecs_meta1__last_accepting_state) = grecs_meta1__current_state;
			(grecs_meta1__last_accepting_cpos) = grecs_meta1__cp;
			}
		while ( grecs_meta1__chk[grecs_meta1__base[grecs_meta1__current_state] + grecs_meta1__c] != grecs_meta1__current_state )
			{
			grecs_meta1__current_state = (int) grecs_meta1__def[grecs_meta1__current_state];
			if ( grecs_meta1__current_state >= 54 )
				grecs_meta1__c = grecs_meta1__meta[(unsigned int) grecs_meta1__c];
			}
		grecs_meta1__current_state = grecs_meta1__nxt[grecs_meta1__base[grecs_meta1__current_state] + (unsigned int) grecs_meta1__c];
		}

	return grecs_meta1__current_state;
}

/* grecs_meta1__try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = grecs_meta1__try_NUL_trans( current_state );
 */
/* %if-c-only */
    static grecs_meta1__state_type grecs_meta1__try_NUL_trans  (grecs_meta1__state_type grecs_meta1__current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int grecs_meta1__is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *grecs_meta1__cp = (grecs_meta1__c_buf_p);

	register YY_CHAR grecs_meta1__c = 1;
	if ( grecs_meta1__accept[grecs_meta1__current_state] )
		{
		(grecs_meta1__last_accepting_state) = grecs_meta1__current_state;
		(grecs_meta1__last_accepting_cpos) = grecs_meta1__cp;
		}
	while ( grecs_meta1__chk[grecs_meta1__base[grecs_meta1__current_state] + grecs_meta1__c] != grecs_meta1__current_state )
		{
		grecs_meta1__current_state = (int) grecs_meta1__def[grecs_meta1__current_state];
		if ( grecs_meta1__current_state >= 54 )
			grecs_meta1__c = grecs_meta1__meta[(unsigned int) grecs_meta1__c];
		}
	grecs_meta1__current_state = grecs_meta1__nxt[grecs_meta1__base[grecs_meta1__current_state] + (unsigned int) grecs_meta1__c];
	grecs_meta1__is_jam = (grecs_meta1__current_state == 53);

	return grecs_meta1__is_jam ? 0 : grecs_meta1__current_state;
}

/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int grecs_meta1_input (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(grecs_meta1__c_buf_p) = (grecs_meta1__hold_char);

	if ( *(grecs_meta1__c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* grecs_meta1__c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (grecs_meta1__c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->grecs_meta1__ch_buf[(grecs_meta1__n_chars)] )
			/* This was really a NUL. */
			*(grecs_meta1__c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (grecs_meta1__c_buf_p) - (grecs_meta1_text_ptr);
			++(grecs_meta1__c_buf_p);

			switch ( grecs_meta1__get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because grecs_meta1__g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					grecs_meta1_restart(grecs_meta1_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( grecs_meta1_wrap( ) )
						return EOF;

					if ( ! (grecs_meta1__did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return grecs_meta1_input();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(grecs_meta1__c_buf_p) = (grecs_meta1_text_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (grecs_meta1__c_buf_p);	/* cast for 8-bit char's */
	*(grecs_meta1__c_buf_p) = '\0';	/* preserve grecs_meta1_text */
	(grecs_meta1__hold_char) = *++(grecs_meta1__c_buf_p);

/* %% [19.0] update BOL and grecs_meta1_lineno */

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void grecs_meta1_restart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        grecs_meta1_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            grecs_meta1__create_buffer(grecs_meta1_in,YY_BUF_SIZE );
	}

	grecs_meta1__init_buffer(YY_CURRENT_BUFFER,input_file );
	grecs_meta1__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void grecs_meta1__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		grecs_meta1_pop_buffer_state();
	 *		grecs_meta1_push_buffer_state(new_buffer);
     */
	grecs_meta1_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(grecs_meta1__c_buf_p) = (grecs_meta1__hold_char);
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_pos = (grecs_meta1__c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars = (grecs_meta1__n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	grecs_meta1__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (grecs_meta1_wrap()) processing, but the only time this flag
	 * is looked at is after grecs_meta1_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(grecs_meta1__did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void grecs_meta1__load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(grecs_meta1__n_chars) = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars;
	(grecs_meta1_text_ptr) = (grecs_meta1__c_buf_p) = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_pos;
	grecs_meta1_in = YY_CURRENT_BUFFER_LVALUE->grecs_meta1__input_file;
	(grecs_meta1__hold_char) = *(grecs_meta1__c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE grecs_meta1__create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) grecs_meta1_alloc(sizeof( struct grecs_meta1__buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1__create_buffer()" );

	b->grecs_meta1__buf_size = size;

	/* grecs_meta1__ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->grecs_meta1__ch_buf = (char *) grecs_meta1_alloc(b->grecs_meta1__buf_size + 2  );
	if ( ! b->grecs_meta1__ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1__create_buffer()" );

	b->grecs_meta1__is_our_buffer = 1;

	grecs_meta1__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with grecs_meta1__create_buffer()
 * 
 */
/* %if-c-only */
    void grecs_meta1__delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->grecs_meta1__is_our_buffer )
		grecs_meta1_free((void *) b->grecs_meta1__ch_buf  );

	grecs_meta1_free((void *) b  );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a grecs_meta1_restart() or at EOF.
 */
/* %if-c-only */
    static void grecs_meta1__init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	grecs_meta1__flush_buffer(b );

	b->grecs_meta1__input_file = file;
	b->grecs_meta1__fill_buffer = 1;

    /* If b is the current buffer, then grecs_meta1__init_buffer was _probably_
     * called from grecs_meta1_restart() or through grecs_meta1__get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->grecs_meta1__bs_lineno = 1;
        b->grecs_meta1__bs_column = 0;
    }

/* %if-c-only */

        b->grecs_meta1__is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void grecs_meta1__flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->grecs_meta1__n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->grecs_meta1__ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->grecs_meta1__ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->grecs_meta1__buf_pos = &b->grecs_meta1__ch_buf[0];

	b->grecs_meta1__at_bol = 1;
	b->grecs_meta1__buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		grecs_meta1__load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void grecs_meta1_push_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	grecs_meta1_ensure_buffer_stack();

	/* This block is copied from grecs_meta1__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(grecs_meta1__c_buf_p) = (grecs_meta1__hold_char);
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__buf_pos = (grecs_meta1__c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->grecs_meta1__n_chars = (grecs_meta1__n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(grecs_meta1__buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from grecs_meta1__switch_to_buffer. */
	grecs_meta1__load_buffer_state( );
	(grecs_meta1__did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void grecs_meta1_pop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	grecs_meta1__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((grecs_meta1__buffer_stack_top) > 0)
		--(grecs_meta1__buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		grecs_meta1__load_buffer_state( );
		(grecs_meta1__did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void grecs_meta1_ensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int num_to_alloc;
    
	if (!(grecs_meta1__buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(grecs_meta1__buffer_stack) = (struct grecs_meta1__buffer_state**)grecs_meta1_alloc
								(num_to_alloc * sizeof(struct grecs_meta1__buffer_state*)
								);
		if ( ! (grecs_meta1__buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1_ensure_buffer_stack()" );
								  
		memset((grecs_meta1__buffer_stack), 0, num_to_alloc * sizeof(struct grecs_meta1__buffer_state*));
				
		(grecs_meta1__buffer_stack_max) = num_to_alloc;
		(grecs_meta1__buffer_stack_top) = 0;
		return;
	}

	if ((grecs_meta1__buffer_stack_top) >= ((grecs_meta1__buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (grecs_meta1__buffer_stack_max) + grow_size;
		(grecs_meta1__buffer_stack) = (struct grecs_meta1__buffer_state**)grecs_meta1_realloc
								((grecs_meta1__buffer_stack),
								num_to_alloc * sizeof(struct grecs_meta1__buffer_state*)
								);
		if ( ! (grecs_meta1__buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((grecs_meta1__buffer_stack) + (grecs_meta1__buffer_stack_max), 0, grow_size * sizeof(struct grecs_meta1__buffer_state*));
		(grecs_meta1__buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE grecs_meta1__scan_buffer  (char * base, grecs_meta1__size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) grecs_meta1_alloc(sizeof( struct grecs_meta1__buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1__scan_buffer()" );

	b->grecs_meta1__buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->grecs_meta1__buf_pos = b->grecs_meta1__ch_buf = base;
	b->grecs_meta1__is_our_buffer = 0;
	b->grecs_meta1__input_file = 0;
	b->grecs_meta1__n_chars = b->grecs_meta1__buf_size;
	b->grecs_meta1__is_interactive = 0;
	b->grecs_meta1__at_bol = 1;
	b->grecs_meta1__fill_buffer = 0;
	b->grecs_meta1__buffer_status = YY_BUFFER_NEW;

	grecs_meta1__switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to grecs_meta1_lex() will
 * scan from a @e copy of @a str.
 * @param grecs_meta1_str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       grecs_meta1__scan_bytes() instead.
 */
YY_BUFFER_STATE grecs_meta1__scan_string (grecs_meta1_const char * grecs_meta1_str )
{
    
	return grecs_meta1__scan_bytes(grecs_meta1_str,strlen(grecs_meta1_str) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to grecs_meta1_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE grecs_meta1__scan_bytes  (grecs_meta1_const char * grecs_meta1_bytes, int  _grecs_meta1_bytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	grecs_meta1__size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _grecs_meta1_bytes_len + 2;
	buf = (char *) grecs_meta1_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in grecs_meta1__scan_bytes()" );

	for ( i = 0; i < _grecs_meta1_bytes_len; ++i )
		buf[i] = grecs_meta1_bytes[i];

	buf[_grecs_meta1_bytes_len] = buf[_grecs_meta1_bytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = grecs_meta1__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in grecs_meta1__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->grecs_meta1__is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void grecs_meta1__fatal_error (grecs_meta1_const char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine grecs_meta1_less() so it works in section 3 code. */

#undef grecs_meta1_less
#define grecs_meta1_less(n) \
	do \
		{ \
		/* Undo effects of setting up grecs_meta1_text. */ \
        int grecs_meta1_less_macro_arg = (n); \
        YY_LESS_LINENO(grecs_meta1_less_macro_arg);\
		grecs_meta1_text[grecs_meta1_leng] = (grecs_meta1__hold_char); \
		(grecs_meta1__c_buf_p) = grecs_meta1_text + grecs_meta1_less_macro_arg; \
		(grecs_meta1__hold_char) = *(grecs_meta1__c_buf_p); \
		*(grecs_meta1__c_buf_p) = '\0'; \
		grecs_meta1_leng = grecs_meta1_less_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int grecs_meta1_get_lineno  (void)
{
        
    return grecs_meta1_lineno;
}

/** Get the input stream.
 * 
 */
FILE *grecs_meta1_get_in  (void)
{
        return grecs_meta1_in;
}

/** Get the output stream.
 * 
 */
FILE *grecs_meta1_get_out  (void)
{
        return grecs_meta1_out;
}

/** Get the length of the current token.
 * 
 */
int grecs_meta1_get_leng  (void)
{
        return grecs_meta1_leng;
}

/** Get the current token.
 * 
 */

char *grecs_meta1_get_text  (void)
{
        return grecs_meta1_text;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param line_number
 * 
 */
void grecs_meta1_set_lineno (int  line_number )
{
    
    grecs_meta1_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see grecs_meta1__switch_to_buffer
 */
void grecs_meta1_set_in (FILE *  in_str )
{
        grecs_meta1_in = in_str ;
}

void grecs_meta1_set_out (FILE *  out_str )
{
        grecs_meta1_out = out_str ;
}

int grecs_meta1_get_debug  (void)
{
        return grecs_meta1__flex_debug;
}

void grecs_meta1_set_debug (int  bdebug )
{
        grecs_meta1__flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int grecs_meta1__init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from grecs_meta1_lex_destroy(), so don't allocate here.
     */

    (grecs_meta1__buffer_stack) = 0;
    (grecs_meta1__buffer_stack_top) = 0;
    (grecs_meta1__buffer_stack_max) = 0;
    (grecs_meta1__c_buf_p) = (char *) 0;
    (grecs_meta1__init) = 0;
    (grecs_meta1__start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    grecs_meta1_in = stdin;
    grecs_meta1_out = stdout;
#else
    grecs_meta1_in = (FILE *) 0;
    grecs_meta1_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * grecs_meta1_lex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* grecs_meta1_lex_destroy is for both reentrant and non-reentrant scanners. */
int grecs_meta1_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		grecs_meta1__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		grecs_meta1_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	grecs_meta1_free((grecs_meta1__buffer_stack) );
	(grecs_meta1__buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * grecs_meta1_lex() is called, initialization will occur. */
    grecs_meta1__init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef grecs_meta1_text_ptr
static void grecs_meta1__flex_strncpy (char* s1, grecs_meta1_const char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int grecs_meta1__flex_strlen (grecs_meta1_const char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *grecs_meta1_alloc (grecs_meta1__size_t  size )
{
	return (void *) malloc( size );
}

void *grecs_meta1_realloc  (void * ptr, grecs_meta1__size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void grecs_meta1_free (void * ptr )
{
	free( (char *) ptr );	/* see grecs_meta1_realloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-grecs_meta1_tables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "grecs_meta1_tables"
/* %endif */

/* %ok-for-header */

#line 107 "meta1-lex.l"



int
grecs_meta1_wrap()
{
        return 1;
}

static void
meta1_line_add_unescape_hex(const char *text, size_t len)
{
        for (; text[len-1] != 'x' && len > 0; len--)
		;
	grecs_line_acc_grow(text, len - 2);
	grecs_line_acc_grow_char((char) strtoul (text + len, NULL, 16));
}





