/* LocaleInformation_sk.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_sk extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jord\u00e1nsky din\u00e1r|Boliv\u00edjske mvdol|Zlato|Faeroe Islands Kronur|Libanonsk\u00e1 libra|Euro|Vietnamsk\u00fd dong|Tanzansk\u00fd \u0161iling|Boliv\u00edjske peso|Kambod\u017esk\u00fd riel|Kambod\u017esk\u00fd star\u00fd riel|Zambsk\u00e1 libra|Austr\u00e1lska libra|CFA frank BEAC|Maltsk\u00e1 libra|Ghansk\u00fd prehodnoten\u00fd cedi|Zambsk\u00e1 kwacha|Ghansk\u00e1 libra|Ghansk\u00fd star\u00fd cedi|Maltsk\u00e1 lira|Austr\u00e1lsky dol\u00e1r|US dol\u00e1r (Same day)|Taliansk\u00e1 lira|US dol\u00e1r (Next day)|Ghansk\u00fd cedi|Singap\u00farsky dol\u00e1r|Panamsk\u00e1 balboa|Laosk\u00fd kip|Kyrgysk\u00fd som|\u0160vaj\u010diarsk\u00fd frank|Rak\u00fasky \u0161iling|US dol\u00e1r|Ethiopsk\u00fd dol\u00e1r|Bruneisk\u00fd dol\u00e1r|Jamajsk\u00e1 libra|Ethiopsk\u00fd birr|Al\u017e\u00edrsky frank Germinal|Al\u017e\u00edrsky nov\u00fd frank|Al\u017e\u00edrsky din\u00e1r|Paraguaysk\u00e9 guarani|Libyjsk\u00e1 libra|Jamajsk\u00fd dol\u00e1r|Islandsk\u00e1 krona|\u0160panielsk\u00e1 peseta|Bermudsk\u00e1 libra|Libyjsk\u00fd din\u00e1r|Libyjsk\u00e1 BMA lira|Bermudsk\u00fd dol\u00e1r|Nizozemsk\u00fd guilder|Mauritania Ouguiya|Ir\u00e1nsky rial|\u0160v\u00e9dska krona|Eritrejsk\u00e1 nakfa|Ke\u0148sk\u00fd \u0161iling|CAR CFA frank|Argentinsk\u00e9 peso|Argentinsk\u00e9 peso (1983-1985)|Argentinsk\u00e9 peso Moneda Nacional|Taiwansk\u00fd nov\u00fd dol\u00e1r|Sud\u00e1nska libra|Gruz\u00ednsky lari|Gruz\u00ednsky Kupon Larit|Martinique frank|Falklandsk\u00e1 libra|Argentinsk\u00fd austral|Sud\u00e1nsky din\u00e1r|Irack\u00fd din\u00e1r|Tuvalu dol\u00e1r|Sej\u0161elsk\u00e1 rupia|Loty\u0161sk\u00fd rube\u013e|Fiji libra|Loty\u0161sk\u00fd lats|Kon\u017esk\u00fd zaire|Kon\u017esk\u00fd frank|Kon\u017esk\u00fd frank Congolais|Fiji dol\u00e1r|Nikaragujsk\u00e1 Cordoba Oro|Macao Pataca|Nikaragujsk\u00e1 zlat\u00e1 Cordoba|Nikaragujsk\u00e1 cordoba|COMECON rube\u013e|Finsk\u00e1 marka (1860-1962)|Finsk\u00e1 marka|Solomon Islands dol\u00e1r|Luxembursk\u00fd frank|Trinidad a Tobago star\u00fd dol\u00e1r|Angolsk\u00e9 eskudo|Angolsk\u00e1 kwanza Reajustado (1995-1999)|Mongolsk\u00fd tugrik|Ma\u010farsk\u00fd forint|Burundsk\u00fd frank|Angolsk\u00e1 nov\u00e1 kwanza (1990-2000)|Angolsk\u00e1 kwanza (1977-1990)|Trinidad a Tobago dol\u00e1r|Swaziland lilangeni|New Hebrides CFP frank|Britsk\u00e1 libra|Saudsk\u00fd Riyal|Saudsk\u00fd riyal|Litevsk\u00fd talonas|Indijsk\u00e1 rupia|Portugalsk\u00e9 eskudo|Angolsk\u00e1 kwanza|Portugalsk\u00e9 conto|Litevsk\u00e1 lita|Kaza\u017esk\u00fd tenge|Kaza\u017esk\u00fd rube\u013e|British Virgin Islands dol\u00e1r|Nigersk\u00e1 libra|Myanmarsk\u00e9 dol\u00e1rov\u00e9 certifik\u00e1ty|Nigersk\u00e1 naira|Haitsk\u00e9 gourde|Syrsk\u00e1 libra|Palest\u00ednska libra|Bahraisk\u00fd din\u00e1r|Myanmarsk\u00fd kyat|Nizozemsk\u00fd Antilsk\u00fd guilder|\u010cesk\u00e1 koruna|Libra Isle of Man|Bulharsk\u00e9 certifik\u00e1ty v leva|Lesothsk\u00fd loti|Gab\u00fansky CFA frank|Bulharsk\u00fd leva (1879-1952)|Bulharsk\u00fd leva nov\u00fd|Bulharsk\u00fd socialistick\u00fd leva|Kanadsk\u00fd dol\u00e1r|Bulharsk\u00fd leva|Tureck\u00e1 lira|Kajmansk\u00fd dol\u00e1r|Cyprusk\u00e1 libra|Izraelsk\u00fd \u0161ekel|Guyansk\u00fd dol\u00e1r|Armensk\u00fd dram|Izraelsk\u00e1 libra|Malsk\u00fd frank|Izraelsk\u00fd \u0161ekel|Venezuelsk\u00fd bolivar|Alb\u00e1nske dol\u00e1rov\u00e9 certifik\u00e1ty|Lib\u00e9rsk\u00fd dol\u00e1r|Alb\u00e1nsky valutov\u00fd lek|Chorv\u00e1tska kuna|Reunion frank|Chorv\u00e1tsky din\u00e1r|Alb\u00e1nsky lek|Jersey libra|Alb\u00e1nsky lek (1946-1961)|Maced\u00f3nsky den\u00e1r (1992-1993)|Severovietnamsk\u00fd Viet Minh Piastre Dong Viet|Severovietnamsk\u00fd nov\u00fd Dong|Maced\u00f3nsky den\u00e1r|Severovietnamsk\u00fd Piastre Dong Viet|Timorsk\u00e1 pataca|CFP frank|Belgick\u00fd frank (finan\u010dn\u00fd)|Guinea-Bissau peso|Kuvaitsk\u00fd din\u00e1r|Portugalsk\u00e9 Guinea Mil Reis|Belgick\u00fd frank|Timorsk\u00e9 eskudo|Belgick\u00fd frank (konvertibiln\u00fd)|Portugalsk\u00e1 Guinea eskudo|El Salvadorsk\u00fd colon|Curacao guilder|Banglad\u00e9\u0161ska taka|Tonga libra|Tonga Pa\u02bbanga|CFA frank BCEAO|Sovietsk\u00fd rube\u013e|Sovietsk\u00fd nov\u00fd rube\u013e|New Caledonia frank Germinal|Cape Verde eskudo|Franc\u00fazske Antilly CFA frank|Juhoafrick\u00fd rand|Dominik\u00e1nske peso|Kub\u00e1nske certifik\u00e1ty|Juhoafrick\u00e1 libra|Juhoafrick\u00fd rand (financial)|Tunisk\u00fd din\u00e1r|Kub\u00e1nske peso|Franc\u00fazska Guyana frank Guiana|Ugandsk\u00fd \u0161iling|Ceylonsk\u00e1 rupia|Affars a Issas frank|Vatik\u00e1nska lira|Sao Tome a Principe eskudo|Ugandan \u0161iling (1966-1987)|Sao Tome a Principe dobra|Marshall Islands dol\u00e1r|Nikaragujsk\u00e1 libra|Z\u00e1padn\u00e1 Samoa tala|Z\u00e1padn\u00e1 Samoa libra|Hodurask\u00e1 lempira|Franc\u00fazsky Metropolitan Nouveau frank|Turkm\u00e9nsky manat|Guatemalsk\u00fd quetzal|Novoz\u00e9landsk\u00fd dol\u00e1r|\u0160k\u00f3tska libra|Barbadosk\u00fd dol\u00e1r|Namibsk\u00fd dol\u00e1r|Madagaskarsk\u00fd frank|Madagaskarsk\u00fd ariary|Egyptsk\u00e1 libra|Britisk\u00fd Hondurask\u00fd dol\u00e1r|Polsk\u00fd zloty (1950-1995)|Bosniansk\u00fd nov\u00fd din\u00e1r|Polsk\u00e9 certifik\u00e1ty v  US dol\u00e1roch|Bosniansk\u00fd konvertibiln\u00e1 marka|Belize dol\u00e1r|Bosniansk\u00fd din\u00e1r|Polsk\u00fd zloty|Jemensk\u00fd rial|Surinamsk\u00fd guilder|\u010ceskoslovensk\u00e1 koruna|Juhok\u00f3rejsk\u00fd won|Belarussian rube\u013e|Jemensk\u00fd Imadi Riyal|Belarussian rube\u013e (1992-1994)|\u010ceskoslovensk\u00e1 koruna|Juhok\u00f3rejsk\u00fd star\u00fd won|Juhok\u00f3rejsk\u00fd hwan|Belarussian nov\u00fd rube\u013e (1994-1999)|Som\u00e1lsky \u0161iling|Gr\u00e9cka nov\u00e1 drachma|Pakistansk\u00e1 rupia|Zimbabsk\u00fd dol\u00e1r|\u0160rilansk\u00e1 rupia|Gr\u00e9cka drachma|\u00cdrska libra|Jemensk\u00fd din\u00e1r|Rwandsk\u00fd frank|Kostariksk\u00fd colon|Tad\u017eikistansk\u00fd somoni|Tad\u017eikistansk\u00fd rube\u013e|Est\u00f3nska kroon|Rovn\u00edkov\u00e1 Guinea Peseta Guineana|Moldavsk\u00fd rube\u013e|Hong Kongsk\u00fd dol\u00e1r|D\u00e1nska krone|Moldavsk\u00fd leu|Rovn\u00edkov\u00e1 Guinea franko|Rovn\u00edkov\u00e1 Guinea Ekwele Guineana|Indon\u00e9zska rupia|UAE dirham|Severok\u00f3rejsk\u00fd won|Indon\u00e9zska nov\u00e1 rupia|Botswanan Pula|Moldavsk\u00fd Leu Cupon|Indon\u00e9zska Java rupia|Severok\u00f3rejsk\u00fd won|Indon\u00e9zsky nica guilder|Vanuatu vatu|Islamsk\u00fd din\u00e1r|Som\u00e1lsky \u0161iling|Andorsk\u00e1 peseta|Rusk\u00fd rube\u013e (1991-1998)|Guadeloupsk\u00fd frank|D\u017eibutsk\u00fd frank|Andorsk\u00fd diner|Monack\u00fd frank Germinal|Monack\u00fd frank Nouveau|Ekuadorsk\u00fd Unidad de Valor Constante (UVC)|Ekuadorsk\u00fd sucre|Lichten\u0161teinsk\u00fd frank|Rusk\u00fd rube\u013e|Filip\u00ednske peso|Uzbekistansk\u00fd sum|Colombijsk\u00e9 peso|Thajsk\u00fd b\u00e1t|Severo\u00edrska libra|Burmese rupia|Kon\u017esk\u00fd CFA frank|Burmese Kyat|Colombijsk\u00e9 papierov\u00e9 peso|Uzbekistansk\u00fd Coupon Som|Ukrainsk\u00fd karbovanetz|Qatarsk\u00fd rial|Ukrainsk\u00e1 hrivna|Guinejsk\u00fd syli|\u010c\u00ednsky Yuan Renminbi|Mozambijsk\u00e9 metical|\u010c\u00ednsky certifik\u00e1ty v US dol\u00e1roch|Uruguajsk\u00e9 peso Uruguayo|Guinejsk\u00fd frank (1960-1972)|San Marino lira|Mozambijsk\u00e9 eskudo|\u010c\u00ednsky Jen Min Piao Yuan|Guinejsk\u00fd frank|Om\u00e1nsk\u00fd rial Saidi|Papua Nov\u00e1 Guinea kina|Om\u00e1nsk\u00fd rial|Uruguajsk\u00e9 peso (1975-1993)|Franc\u00fazsky UIC-frank|Bhutan rupia|Zairsk\u00fd Zaire|Marock\u00fd frank|Marock\u00fd dirham|Bhutansky ngultrum|Franc\u00fazsky zlat\u00fd frank|Uruguajsk\u00e9 peso Fuerte|Malajsk\u00fd ringgit|Zairsk\u00fd nov\u00fd zaire|Azerbaid\u017eansk\u00fd manat|Gambsk\u00e1 libra|Comoro frank|Sierra Leone Leone|Gambsk\u00fd dalasi|Bahamsk\u00e1 libra|Camerunsk\u00fd CFA frank|Mexick\u00e9 Unidad de Inversion (UDI)|CFA frank BCEAEC|Bahamsk\u00fd dol\u00e1r|Mexick\u00e9 striborn\u00e9 peso (1861-1992)|Mexick\u00e9 peso|Peruvsk\u00fd sol|Gr\u00f3nsky krone|Braz\u00edlske cruzeiro (1942-1967)|Peruvsk\u00fd sol Nuevo|\u010c\u00edlske peso|Slovensk\u00e1 koruna|Peruvsk\u00fd inti|Braz\u00edlske cruzeiro|\u0160peci\u00e1lne pr\u00e1va \u010derpania|Franc\u00fazsky frank Germinal/frank Poincare|Franc\u00fazsky frank|Braz\u00edlske Cruzado Novo|\u010c\u00edlske Unidades de Fomento|\u010c\u00edlske eskudo|Boliv\u00edjsky real|\u010c\u00edlsky condor|Boliv\u00edjske cruzeiro (1990-1993)|Nemeck\u00e1 sperrmarka|Malavsk\u00e1 libra|Boliv\u00edjske cruzado|Boliv\u00edjske Cruzeiro Novo (1967-1986)|Malavsk\u00e1 kwacha|Transdniestria rube\u013e|Nemeck\u00e1 marka|Chadsk\u00fd CFA frank|Transdniestria nov\u00fd rube\u013e|Transdniestria rube\u013e Kupon|Nep\u00e1lska rupia|Cook Islands dol\u00e1r|Japonsk\u00fd yen|Maldivsk\u00e1 rufiyaa|CFA Nouveau frank|Maldivsk\u00e1 rupia|East Caribbean dol\u00e1r|Slovinsk\u00fd Tolar|Juhosl\u00e1vsky din\u00e1r|Arubsk\u00fd guilder|Juhosl\u00e1vsky okt\u00f3brov\u00fd din\u00e1r|V\u00fdchodonemeck\u00e1 marka|Juhosl\u00e1vsky din\u00e1r|Juhosl\u00e1vsky Noviy din\u00e1r|Turks a Caicos Crown|Juhosl\u00e1vsky din\u00e1r|Juhosl\u00e1vsky din\u00e1r|Rumunsk\u00fd nov\u00fd leu|Juhosl\u00e1vsky din\u00e1r|Rumunsk\u00fd leu|Slovinsk\u00fd tolar Bons|N\u00f3rksy krone|Mauritsk\u00e1 rupia|Gibraltarsk\u00e1 libra|Vietnamsk\u00fd n\u00e1rodn\u00fd dong|Vietnamsk\u00fd dong|Kiribati dol\u00e1r|Libra|Vietnamsk\u00fd nov\u00fd dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|INR|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Z$|SL Re|GRD|IR\u00a3|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|MZE|CNP|PGK|OMS|GF|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|GIP|VNS|VNR|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "m\u00e1j",
    "j\u00fan",
    "j\u00fal",
    "aug",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "janu\u00e1r",
    "febru\u00e1r",
    "marec",
    "apr\u00edl",
    "m\u00e1j",
    "j\u00fan",
    "j\u00fal",
    "august",
    "september",
    "okt\u00f3ber",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Ne",
    "Po",
    "Ut",
    "St",
    "\u0160t",
    "Pi",
    "So",
  };

  private static final String[] weekdays = {
    null,
    "Nede\u013ea",
    "Pondelok",
    "Utorok",
    "Streda",
    "\u0160tvrtok",
    "Piatok",
    "Sobota",
  };

  private static final String[] eras = {
    "pred n.l.",
    "n.l.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "V\u00fdchodn\u00fd Timor|Tokelau|Tad\u017eikistan|Thajsko|Togo|Franc\u00fazske ju\u017en\u00e9 \u00fazemia|Guayana|\u010cad|Turks a Caicos|Guinea-Bissau|Guam|Guatemala|Ju\u017en\u00e1 Georgia a Ju\u017en\u00e9 Sandwichove ostrovy|Gr\u00e9cko|Rovn\u00edkov\u00e1 Guinea|Guadeloupe|Svazijsko|S\u00fdrska arabsk\u00e1 republika|Guinea|Gambia|Gr\u00f3nsko|Salvador|Sv\u00e4t\u00fd Tom\u00e1\u0161 a Princove ostrovy|Gibralt\u00e1r|Ghana|Surinam|Franc\u00fazska Guayana|Serbia|Gruz\u00ednsko|Som\u00e1lsko|Grenada|Senegal|San Mar\u00edno|Spojen\u00e9 kr\u00e1\u013eovstvo|Sierra Leone|Gabon|Slovensk\u00e1 republika|\u0160picbergy a Jan Mayen|Slovinsko|Sv\u00e4t\u00e1 Helena|Singapur|\u0160v\u00e9dsko|Sud\u00e1n|Seychelsk\u00e9 ostrovy|\u0160alam\u00fanove ostrovy|Saudsk\u00e1 Ar\u00e1bia|Franc\u00fazsko|Faersk\u00e9 ostrovy|Mikron\u00e9zia, Federat\u00edvne \u0161t\u00e1ty|Rwanda|Falklandsk\u00e9 ostrovy|Rusk\u00e1 feder\u00e1cia|Fid\u017ei|F\u00ednsko|Rumunsko|Reunion|Eti\u00f3pia|\u0160panielsko|Eritrea|Z\u00e1padn\u00e1 Sahara|Egypt|Est\u00f3nsko|Ekv\u00e1dor|Al\u017e\u00edrsko|Katar|Dominik\u00e1nska republika|Paraguaj|Dominika|Palau|D\u00e1nsko|D\u017eibuti|Portugalsko|Palest\u00ednske \u00fazemie|Portoriko|Nemecko|Pitcairnove ostrovy|Saint Pierre a Miquelon|Po\u013esko|Pakistan|Filip\u00edny|Papua Nov\u00e1 Guinea|Franc\u00fazska Polyn\u00e9zia|\u010cesk\u00e1 republika|Peru|Cyprus|Viano\u010dn\u00fd ostrov|Kapverdy|Panama|Kuba|Kostarika|Kolumbia|\u010c\u00edna|Kamerun|\u010cile|Cookove ostrovy|Pobre\u017eie Slonoviny|\u0160vaj\u010diarsko|Kongo|Stredoafrick\u00e1 republika|Kon\u017esk\u00e1 demokratick\u00e1 republika|Kokosov\u00e9 (Keelingove) ostrovy|Om\u00e1n|Kanada|Belize|Bielorusko|Botswana|Bouvetov ostrov|But\u00e1n|Bahamy|Braz\u00edlia|Nov\u00fd Z\u00e9land|Bol\u00edvia|Brunej|Bermudy|Niue|Benin|Burundi|Bahrajn|Nauru|Bulharsko|Burkina Faso|Nep\u00e1l|Belgicko|N\u00f3rsko|Banglad\u00e9\u0161|Barbados|Zimbabwe|Holandsko|Bosna a Hercegovina|Nikaragua|Nig\u00e9ria|Norfolkov ostrov|Azerbajd\u017ean|Niger|Nov\u00e1 Kaled\u00f3nia|Aruba|Zambia|Nam\u00edbia|Austr\u00e1lia|Rak\u00fasko|Americk\u00e1 Samoa|Argent\u00edna|Antarctica|Mozambik|Angola|Malajzia|Holandsk\u00e9 Antily|Mexiko|Arm\u00e9nsko|Malawi|Alb\u00e1nsko|Maldivy|Ju\u017en\u00e1 Afrika|Maur\u00edcius|Malta|Anguilla|Montserrat|Maurit\u00e1nia|Antigua a Barbados|Martinik|Afganistan|Severn\u00e9 Mari\u00e1ny|Spojen\u00e9 arabsk\u00e9 emir\u00e1ty|Makao S.A.R. \u010c\u00edny|Andorra|Mongolsko|Mjanmarsko|Mali|Maced\u00f3nsko, republika|Juhosl\u00e1via|Mayotte|Marshallove ostrovy|Madagaskar|Moldavsko, republika|Monako|Maroko|Jemen|L\u00fdbijsk\u00e1 arabsk\u00e1 d\u017eamah\u00edrija|Loty\u0161sko|Luxembursko|Litva|Lesotho|Lib\u00e9ria|Sr\u00ed Lanka|Lichten\u0161tajnsko|Sv\u00e4t\u00e1 Lucia|Libanon|Laosk\u00e1 \u013eudovodemokratick\u00e1 republika|Kazachstan|Kajmansk\u00e9 ostrovy|Kuvajt|K\u00f3rea, Ju\u017en\u00e1|K\u00f3rea, Severn\u00e1|Saint Kitts a Nevis|Komory|Kiribati|Samoa|Kambod\u017ea|Kirgizsko|Ke\u0148a|Wallis a Futuna|Japonsko|Jord\u00e1nsko|Jamajka|Vanuatu|Vietnam|Panensk\u00e9 ostrovy - USA|Britsk\u00e9 panensk\u00e9 ostrovy|Venezuela|Sv\u00e4t\u00fd Vincent a Grenad\u00edny|Sv\u00e4t\u00e1 stolica (Vatik\u00e1nsky mestsk\u00fd \u0161t\u00e1t)|Taliansko|Island|Ir\u00e1n|Irak|Uzbekistan|Britsk\u00e9 \u00fazemie v Indickom oce\u00e1ne|Uruguaj|India|Izrael|Spojen\u00e9 \u0161t\u00e1ty|\u00cdrsko|Indon\u00e9zia|Men\u0161ie od\u013eahl\u00e9 ostrovy USA|Uganda|Ukrajina|Ma\u010farsko|Haiti|Chorv\u00e1tsko|Tanz\u00e1nia|Honduras|Heardove ostrovy a McDonaldove ostrovy|Tajwan|Tuvalu|Hong Kong S.A.R. \u010c\u00edny|Trinidad a Tobago|Turecko|Tonga|Tunisko|Turkm\u00e9nsko";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja|en|tr|ko|no|el|nl|bg|lv|he|cs|it|lt|fr|zh|ru|ro|fi|ar|sv|pt|pl|sl|sk|de|hu|et|es|hr|da";

  private static final String languagesValues = "japonsk\u00fd|anglick\u00fd|tureck\u00fd|k\u00f3rejsk\u00fd|n\u00f3rsky|gr\u00e9cky|holandsk\u00fd|bulharsk\u00fd|loty\u0161sk\u00fd|hebrejsk\u00fd|\u010desk\u00fd|taliansky|litovsk\u00fd|franc\u00fazsky|\u010d\u00ednsky|rusk\u00fd|rumunsk\u00fd|f\u00ednsky|arabsk\u00fd|\u0161v\u00e9dsky|portugalsk\u00fd|po\u013esk\u00fd|slovinsk\u00fd|slovensk\u00fd|nemeck\u00fd|ma\u010farsk\u00fd|est\u00f3nsky|\u0161panielsky|chorv\u00e1tsky|d\u00e1nsky";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "d.M.yyyy" },
    { "mediumDateFormat", "d.M.yyyy" },
    { "longDateFormat", "d. MMMM yyyy" },
    { "fullDateFormat", "EEEE, d. MMMM yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
