/* LocaleInformation_it.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_it extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Dinaro Giordano|Mvdol Boliviano|Oro|Kronur delle Isole Faeroe|Sterlina Libanese|Euro|Dong Vietnamita|Scellino della Tanzania|Peso Boliviano|Riel Cambogiano|Unit\u00e0 Monetaria Asiatica|Boliviano (1863-1962)|Vecchio riel cambogiano|Sterlina dello Zambia|Sterlina Australiana|Franco CFA BEAC|Sterlina Maltese|Cedi rivalutato del Ghana|Kwacha dello Zambia|Unit\u00e0 di conto in dinari asiatica|Sterlina del Ghana|Boliviano|Vecchi cedi del Ghana|Lira Maltese|Dollaro Australiano|Dollaro Statunitense (Same day)|Lira Italiana|Dollaro Statunitense (Next day)|Cedi del Ghana|Dollaro di Singapore|Balboa di Panama|Kip Laotiano|Som  Kirghiso|Franco Svizzero|Scellino Austriaco|Dollaro Statunitense|Dollaro Etiopico|Dollaro del Brunei|Sterlina Giamaicana|Birr Etiopico|Franco germinale algerino|Nuovo franco algerino|Dinaro Algerino|Guarani del Paraguay|Sterlina Libica|Dollaro Giamaicano|Corona Islandese|Peseta Spagnola|Sterlina delle Bermuda|Dinaro Libico|Lira libica della British Military Authority|Dollaro delle Bermuda|Fiorino Olandese|Ouguiya della Mauritania|Rial Iraniano|Corona Svedese|Nakfa Eritreo|Scellino Keniota|Franco CFA della Repubblica dell\u2019Africa Centrale|Peso Argentino|Peso Argentino (vecchio Cod.)|Peso Moneda Nacional argentino|Nuovo dollaro taiwanese|Sterlina Sudanese|Lari Georgiano|Kupon Larit Georgiano|Franco della Martinica|Sterlina delle Falkland|Austral Argentino|Dinaro Sudanese|Dinaro Iracheno|Dollaro di Tuvalu|Rupia delle Seychelles|Rublo Lettone|Sterlina delle Figi|Lat Lettone|Zaire Congolese|Franco della Repubblica Congolese|Franco Congolese|Dollaro delle Figi|C\u00f3rdoba oro nicaraguense|Pataca di Macao|C\u00f3rdoba d\u2019oro nicaraguense|Cordoba Nicaraguense|Rublo Trasferibile COMECON|Markka Finlandese (1860-1962)|Markka Finlandese|Dollaro delle Isole Solomon|Franco del Lussemburgo|Vecchio dollaro di Trinidad e Tobago|Escudo Angolano|Kwanza Reajustado Angolano (1995-1999)|Tugrik Mongolo|Fiorino Ungherese|Franco del Burundi|Nuovo Kwanza Angolano (1990-2000)|Kwanza Angolano (1977-1990)|Dollaro di Trinidad e Tobago|Lilangeni dello Swaziland|Franco CFP delle Nuove Ebridi|Sterlina Inglese|Riyal sovrano saudita|Ryal Saudita|Talonas Lituani|Rupia Indiana|Escudo Portoghese|Kwanza Angolano|Conto Portoghese|Lita Lituana|Tenge Kazaco|Rublo Kazaco|Dollaro delle Isole Vergini britanniche|Sterlina Nigeriana|Certificati di cambio esteri in dollari Myanmar|Naira Nigeriana|Gourde Haitiano|Sterlina Siriana|Sterlina della Palestina|Dinaro del Bahraini|Kyat di Myanmar|Fiorino delle Antille Olandesi|Corona Ceca|Lira Sterlina dell\u2019Isola di Man|Certificati di cambio esteri in Lev bulgari|Loti del Lesotho|Franco CFA Gabon|Lev Bulgaro (1879-1952)|Nuovo Lev Bulgaro|Lev Bulgaro Socialista|Dollaro Canadese|Lev Bulgaro|Lira Turca|Dollaro delle Isole Cayman|Sterlina Cipriota|Nuovo sheqel israeliano|Dollaro della Guyana|Dram Armeno|Sterlina Israeliana|Franco di Mali|Sheqel Israeliano|Bolivar Venezuelano|Certificati di cambio esteri albanesi in dollari|Dollaro Liberiano|Lek Valute Albanese|Kuna Croata|Franco di Reunion|Dinaro Croato|Lek Albanese|Lira Sterlina di Jersey|Lek Albanese (1946-1961)|Dinaro Macedone (1992-1993)|Viet Minh Piastre Dong Viet nordvietnamita|Nuovo Dong nordvietnamita|Dinaro Macedone|Piastre Dong Viet nordvietnamita|Pataca di Timor|Franco CFP|Franco Belga (finanziario)|Peso della Guinea-Bissau|Dinaro Kuwaitiano|Mil Reis della Guinea portoghese|Franco Belga|Escudo di Timor|Franco Belga (convertibile)|Escudo della Guinea portoghese|Col\u00f3n Salvadoregno|Guilder del Curacao|Taka Bangladese|Lira sterlina di Tonga|Pa\u02bbanga di Tonga|Franco CFA BCEAO|Rublo Sovietico|Nuovo rublo sovietico|Franco germinale della Nuova Caledonia|Escudo del Capo Verde|Franco CFA delle Antille Francesi|Rand Sudafricano|Peso Dominicano|Certificati di cambio esteri cubani|Sterlina Sudafricana|Rand Sudafricano (finanziario)|Dinaro Tunisino|Peso Cubano|Franco Guiana della Guyana francese|Scellino Ugandese|Rupia di Ceylon|Franco di Affars e Issas|Lira della Citt\u00e0 del Vaticano|Escudo di S\u00e3o Tom\u00e9 e Principe|Scellino Ugandese (1966-1987)|Dobra di S\u00e3o Tom\u00e9 e Principe|Dollaro delle Isole Marshall|Sterlina Neozelandese|Tala della Samoa Occidentale|Sterlina della Samoa Occidentale|Lempira Hoduregno|Nouveau Franc francese metropolitano|Manat Turkmeno|Quetzal Guatemalteco|Dollaro Neozelandese|Sterlina Scozzese|Dollaro di Barbados|Dollaro Namibiano|Franco Malgascio|Ariary Malgascio|Sterlina Egiziana|Dollaro Honduras Britannico|Zloty Polacco (1950-1995)|Nuovo Dinar Bosnia-Herzegovina|Certificati di cambio esteri polacchi in dollari statunitensi|Marco Conv. Bosnia-Erzegovina|Dollaro Belize|Dinar Bosnia-Herzegovina|Zloty Polacco|Rial dello Yemen|Fiorino del Suriname|Corona forte cecoslovacca|Won Sudcoreano|Rublo Bielorussia|Riyal Imadi dello Yemen|Rublo Bielorussia (1992-1994)|Corona Cecoslovacca|Vecchi won sudcoreano|Hwan sudcoreano|Nuovo Rublo Bielorussia (1994-1999)|Scellino del Somaliland|Nuova dracma greca|Rupia del Pakistan|Afgani|Dollaro dello Zimbabwe|Rupia di Sri Lanka|Dracma Greca|Lira Irlandese|Afgani (1927-2002)|Dinaro dello Yemen|Franco Ruandese|Col\u00f3n Costaricano|Somoni del Tajikistan|Rublo del Tajikistan|Corona dell\u2019Estonia|Peseta Guineana della Guinea Equatoriale|Coupon Rublo della Moldavia|Dollaro di Hong Kong|Corona Danese|Leu Moldavo|Franco della Guinea Equatoriale|Ekwele della Guinea Equatoriale|Rupia Indiana|Dirham degli Emirati Arabi Uniti|Won Nordcoreano|Nuova rupia indonesiana|Pula del Botswana|Coupon Leu della Moldavia|Rupia indonesiana di Java|Won della Repubblica popolare democratica nordcoreana|Fiorino Nica indonesiano|Vatu di Vanuatu|Dinaro Islamico|Scellino Somalo|Peseta Andorrana|Rublo della CSI|Franco della Guadalupa|Franco Gibutiano|Diner Andorrano|Franco germinale di Monaco|Franc Nouveau di Monaco|Unidad de Valor Constante (UVC) dell\u2019Ecuador|Sucre dell\u2019Ecuador|Franco del Liechtenstein|Rublo Russo|Peso delle Filippine|Sum dell\u2019Uzbekistan|Peso Colombiano|Baht Tailandese|Sterlina dell\u2019Irlanda del Nord|Rupia Birmana|Franco CFA del Congo|Kyat Birmano|Peso in banconote colombiano|Som Coupon dell\u2019Uzbekistan|Karbovanetz Ucraino|Rial del Qatar|Hrivna Ucraina|Syli della Guinea|Renmimbi Cinese|Metical del Mozambico|Certificati di cambio esteri cinesi in dollari statunitensi|Peso Uruguayo uruguaiano|Franco della Guinea (1960-1972)|Lira di San Marino|Jen Min Piao Yuan Cinese|Escudo del Mozambico|Franco della Guinea|Rial Saidi dell\u2019Oman|Kina della Papua Nuova Guinea|Rial Omanita|Peso Uruguaiano (1975-1993)|Franco UIC Francese|Rupia Butanese|Zaire dello Zaire|Franco Marocchino|Dirham Marocchino|Ngultrum Butanese|Franco Oro Francese|Peso Fuerte dell\u2019Uruguaiano|Ringgit della Malesia|Nuovo Zaire dello Zaire|Manat Azero|Sterlina del Gambia|Franco Comoriano|Leone della Sierra Leone|Dalasi del Gambia|Unit\u00e0 Monetaria Europea|Libra delle Bahamas|Franco CFA del Camerun|Unidad de Inversion (UDI) Messicana|Franco CFA BCEAEC|Dollaro delle Bahamas|Peso messicano d\u2019argento (1861-1992)|Peso Messicano|Sol Peruviano|Corona della Groenlandia|Cruzeiro Brasiliano (1942-1967)|Sol Nuevo Peruviano|Peso Cileno|Corona Slovacca|Inti Peruviano|Cruzeiro Brasiliano|Diritti Speciali di Incasso|Franco germinale/franco Poincare francese|Franco Francese|Cruzado Novo Brasiliano|Unidades de Fomento Chilene|Escudo Cileno|Real Brasiliano|Condor Cileno|Cruzeiro Brasiliano (1990-1993)|Sperrmark Tedesco|Sterlina Malawiana|Cruzado Brasiliano|Cruzeiro Novo Brasiliano (1967-1986)|Kwacha Malawiano|Rublo della Transdniestria|Marco Tedesco|Franco CFA del Chad|Nuovo rublo della Transdniestria|Coupon in rubli della Transdniestria|Rupia Nepalese|Dollaro delle Isole Cook|Yen Giapponese|Rufiyaa delle Maldive|Nuovo Franco CFA|Rupia delle Maldive|Dollaro dei Caraibi Orientali|Tallero Sloveno|Dinaro Riformato Yugoslavo|Fiorino di Aruba|Dinaro di Ottobre Yugoslavo|Ostmark della Germania Orientale|Dinaro Convertibile Yugoslavo|Dinaro Noviy Yugoslavo|Corona di Turks e Caicos|Dinaro 1994 Yugoslavo|Dinaro della Federazione Yugoslava|Nuovo Leu della Romania|Dinaro Forte Yugoslavo|Leu della Romania|Tallero Bons Sloveno|Corona Norvegese|Rupia Mauriziana|Unit\u00e0 di acconto europea (XBD)|Sterlina di Gibilterra|Dong Nazionale Vietnamita|Unit\u00e0 di acconto europea (XBC)|Dong della Repubblica Vietnamita|Unit\u00e0 monetaria europea|Unit\u00e0 composita europea|Dollaro di Kiribati|Sterlina di Sant\u2019Elena|Nuovo dong vietnamita";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|Lm|AUD|USS|USN|GHC|SGD|PAB|LAK|som|SFr.|ATS|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SEK|ERN|K Sh|CFF|ARS|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|HUF|Fbu|AON|AOK|TT$|E|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|lev|BGM|CAD|BGL|TRL|KYD|CYP|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|ZAR|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|CNY|Mt|CNX|Ur$|GNI|SML|MZE|CNP|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|CLP|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "gen",
    "feb",
    "mar",
    "apr",
    "mag",
    "giu",
    "lug",
    "ago",
    "set",
    "ott",
    "nov",
    "dic",
    null,
  };

  private static final String[] months = {
    "gennaio",
    "febbraio",
    "marzo",
    "aprile",
    "maggio",
    "giugno",
    "luglio",
    "agosto",
    "settembre",
    "ottobre",
    "novembre",
    "dicembre",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dom",
    "lun",
    "mar",
    "mer",
    "gio",
    "ven",
    "sab",
  };

  private static final String[] weekdays = {
    null,
    "domenica",
    "luned\u00ec",
    "marted\u00ec",
    "mercoled\u00ec",
    "gioved\u00ec",
    "venerd\u00ec",
    "sabato",
  };

  private static final String[] eras = {
    "aC",
    "dC",
  };

  private static final String[] ampms = {
    "m.",
    "p.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Ora Standard Pacifico", "PDT", "Ora Legale Pacifico",  "America/Los_Angeles" },
    { "GMT", "Ora Meridiano Greenwich", "GMT", "Ora Meridiano Greenwich",  "Africa/Casablanca" },
    { "EST", "Ora Standard Orientale", "EDT", "Ora Legale Orientale",  "America/New_York" },
    { "AST", "Ora Standard Alaska", "ADT", "Ora Legale Alaska",  "America/Anchorage" },
    { "GMT", "Ora Meridiano Greenwich", "GMT", "Ora Meridiano Greenwich",  "Etc/GMT" },
    { "CTT", "Ora Standard Cina", "CDT", "Ora Standard Cina",  "Asia/Shanghai" },
    { "AST", "Ora Standard Atlantico", "ADT", "Ora Legale Atlantico",  "America/Halifax" },
    { "CET", "Ora Standard Centrale Europeo", "CEST", "Ora Legale Centrale Europeo",  "Europe/Paris" },
    { "MST", "Ora Standard Mountain", "MDT", "Ora Legale Mountain",  "America/Denver" },
    { "IST", "Ora Standard Israele", "IDT", "Ora Legale Israele",  "Asia/Jerusalem" },
    { "HST", "Ora Standard Hawaii", "HST", "Ora Standard Hawaii",  "Pacific/Honolulu" },
    { "CNT", "Ora Standard Newfoundland", "CDT", "Ora Legale Newfoundland",  "America/St_Johns" },
    { "EST", "Ora Standard Orientale", "EST", "Ora Standard Orientale",  "America/Indianapolis" },
    { "CST", "Ora Standard Centrale", "CDT", "Ora Legale Centrale",  "America/Chicago" },
    { "EET", "Ora Standard Europa Orientale", "EEST", "Ora Legale Europa Orientale",  "Europe/Bucharest" },
    { "JST", "Ora Standard Giappone", "JST", "Ora Standard Giappone",  "Asia/Tokyo" },
    { "MST", "Ora Standard Mountain", "MST", "Ora Standard Mountain",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor Est|Tokelau|Tagikistan|Tailandia|Togo|Territori australi francesi|Guyana|Ciad|Isole Turks e Caicos|Guinea-Bissau|Guam|Guatemala|Georgia del Sud e Isole Sandwich del Sud|Grecia|Guinea Equatoriale|Guadalupa|Swaziland|Siria|Guinea|Gambia|Groenlandia|El Salvador|S\u00e3o Tom\u00e9 e Pr\u00edncipe|Gibilterra|Ghana|Suriname|Guiana Francese|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Regno Unito|Sierra Leone|Gabon|Slovacchia|Svalbard e Jan Mayen|Slovenia|Sant\u2019Elena|Singapore|Svezia|Sudan|Seychelles|Isole Solomon|Arabia Saudita|Francia|Isole Faroe|Micronesia|Ruanda|Isole Falkland|Federazione Russa|Fiji|Finlandia|Romania|R\u00e9union|Etiopia|Spagna|Eritrea|Sahara Occidentale|Egitto|Estonia|Ecuador|Algeria|Qatar|Repubblica Dominicana|Paraguay|Dominica|Palau|Danimarca|Gibuti|Portogallo|Palestina|Portorico|Germania|Pitcairn|Saint Pierre e Miquelon|Polonia|Pakistan|Filippine|Papua Nuova Guinea|Polinesia Francese|Repubblica Ceca|Per\u00f9|Cipro|Isola Christmas|Capo Verde|Panama|Cuba|Costa Rica|Colombia|Cina|Camerun|Cile|Isole Cook|Costa d\u2019Avorio|Svizzera|Congo|Repubblica Centrafricana|Repubblica Democratica del Congo|Isole Cocos (Keeling)|Oman|Canada|Belize|Bielorussia|Botswana|Isola Bouvet|Bhutan|Bahamas|Brasile|Nuova Zelanda|Bolivia|Brunei|Bermuda|Niue|Benin|Burundi|Bahrein|Nauru|Bulgaria|Burkina Faso|Nepal|Belgio|Norvegia|Bangladesh|Barbados|Zimbabwe|Paesi Bassi|Bosnia Erzegovina|Nicaragua|Nigeria|Isola Norfolk|Azerbaigian|Niger|Nuova Caledonia|Aruba|Zambia|Namibia|Australia|Austria|Samoa Americane|Argentina|Antartide|Mozambico|Angola|Malesia|Antille Olandesi|Messico|Armenia|Malawi|Albania|Maldive|Sud Africa|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua e Barbuda|Martinica|Afghanistan|Isole Marianne Settentrionali|Emirati Arabi Uniti|Regione Amministrativa Speciale di Macao, Cina|Andorra|Mongolia|Myanmar|Mali|Macedonia, Repubblica|Yugoslavia|Mayotte|Isole Marshall|Madagascar|Moldavia|Monaco|Marocco|Yemen|Libia|Lettonia|Lussemburgo|Lituania|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Libano|Laos|Kazakistan|Isole Cayman|Kuwait|Corea del Sud|Corea del Nord|Saint Kitts e Nevis|Comore|Kiribati|Samoa|Cambogia|Kirghizistan|Kenya|Wallis e Futuna|Giappone|Giordania|Giamaica|Vanuatu|Vietnam|Isole Vergini Americane|Isole Vergini Britanniche|Venezuela|Saint Vincent e Grenadines|Vaticano|Italia|Islanda|Iran|Iraq|Uzbekistan|Territorio Britannico dell\u2019Oceano Indiano|Uruguay|India|Israele|Stati Uniti|Irlanda|Indonesia|Isole Minori lontane dagli Stati Uniti|Uganda|Ucraina|Ungheria|Haiti|Croazia|Tanzania|Honduras|Isole Heard ed Isole McDonald|Taiwan|Tuvalu|Regione Amministrativa Speciale di Hong Kong, Cina|Trinidad e Tobago|Turchia|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwich\u02bbin|accado|ekajuka|xosa|sumero|susu|lingue diverse|lozi|tonga (nyasa)|ponape|menangkabau|sukuma|volof|lolo (bantu)|kutenai|micmac|walloon|kumyk|zapotec|cuscitica (altra lingua)|lojban|dogri|volap\u00fck|lingue otomi|vietnamita|rarotonga|venda|rapanui|rajasthani|turco ottomano (1500-1928)|nzima|napoletano|usbeco|ugaritico|tamashek|indiano del Nord America (altra lingua)|nahuatl|urdu|fanti|ucraino|egiziano (antico)|uigurico|nilo-sahariana (altra lingua)|irlandese medio (900-1200)|baltica (altra lingua)|nyoro|basa|nyankole|nyamwezi|hmong|balinese|osage|beluci|taitiano|lingue bamileke|ci|serer|tlingit|tatarico|tsonga|banda|turco|tonga (Isole Tonga)|tswana|tagalog|turcomanno|tigrinya|thai|kurukh|tagicco|blin|telugu|kru|kashubian|tamil|tokelau|efik|swahili|svedese|sundanese|karachay-Balkar|sotho del sud|swati|serbo|albanese|mende|creola e Pidgins (altra lingua)|somalo|afrihili|shona|samoano|sloveno|greco, antico (fino al 1453)|slovacco|gerbo|singalese|serbo-croato|turco crimeo; tatar crimeo|afro-asiatica (altra lingua)|sango|sami del nord|sindhi|udmurt|sardo|sanscrito|kinyarwanda|russo|mandar|romeno|rundi|lingua rhaeto-romance|moksha|adyghe|zuni|kpelle|quechua|tigre|songhai|creolo e pidgins, basato sul portoghese (altra lingua)|sogdiano|adangme|Kosraean|hittite|creolo e pidgins, basato sul francese (altra lingua)|creolo e pidgins, basato sull\u2019inglese (altra lingua)|himachali|konkani|hiligayna|gotico|gorontalo|gondi|dinca|nubiano|portoghese|pashto|friulano|fenicio|tedesco, antico alto (ca.750-1050)|soninke|copto|Yapese|acioli|yao (bantu)|filippino (altra lingua)|polacco|accinese|pali|punjabi|bugi|iban|sami skolt|buriat|masai|sami inari|ossetico|austronesiano|oriya|mandingo|sami lule|lingue sami (altra lingua)|makasar|oromo|maithili|ojibwa|magahi|madurese|sami del sud|occitano (post 1500); provenzale|sotho del nord|batak|erzya|dogrib|nyanja; chichewa; chewa|lingue maya|navajo|kimbundu|ndebele del sud|tedesco, medio alto (ca.1050-1500)|norvegese|norvegese nynorsk|olandese|ndonga|slavo (altra lingua)|nepali|ndebele del nord|lingue chamic|tetum|norvegese bokm\u00e5l|nauru|tereno|temne|burmese|lezghian|maltese|antico persiano (600-400 A.C.)|malay|marathi|francese, antico (842-ca.1400)|moldavo|francese, medio (ca.1400-1600)|mongolo|giudeo arabo|malayalam|macedone|maori|marshallese|malagasy|marwari|braj|slave|lettone|luba-katanga|delaware|lituano|lao|lingala|limburgish|ewondo|ganda|lussemburghese|latino|giudeo persiano|voto|sino-tibetano (altra lingua)|kirghiso|cornico|komi|curdo|lingue sioux|kashmiri|kanuri|awadhi|coreano|kannada|khmer|kalaallisut|kazako|romani|kuanyama|sidamo|kikuyu|kongo|norse antico|georgiano|creek|lingua romanza (altra lingua)|nogai|munda (altra lingua)|multilingua|giavanese|gilbertese|zande|shan|kalmyk|lingue australiane|khotanese|giapponese|khoisan (altra lingua)|palau|cheyenne|tailandese (altra lingua)|inuktitut|papiamento|italiano|lingue sign|islandese|khasi|cherokee|pampanga|pahlavi|chipewyan|ido|choctaw|gergo chinook|mari|tuvinian|bantu|pangasinan|inupiak|chuukese|sichuan yi|hawaiano|lamba|igbo|ciagataico|irlandese, antico (fino al \u2019900)|papuano-australiano (altra lingua)|interlingue|indonesiano|lahnda|dayak|chibcha|interlingua|ladino|herero|haida|dargwa|armeno|lingue athabaska|ungherese|haitian|dakota|croato|hiri motu|hindi|diula|ebraico|asturiano|haussa|sorabo|manx|gujarati|semitico (altra lingua)|selkup|lingue irochesi|guarana|galiziano|aruaco|geez|artificiale (altra lingua)|gaelico scozzese|iraniana|irlandese|arapaho|araucano|frisone|siksika|germanica (altra lingua)|lingue yupik|aramaico|francese|faroese|celtica altra lingua|figiano|finlandese|fulah|tuvalu|cebuano|persiano|basco|scozzese|estone|spagnolo|esperanto|inglese|greco|turco-tatarica (altra lingua)|niue|lingue tupi|ewe|tumbuka|mossi|dzongkha|niger - cordofan (altra lingua)|lushai|ugrofinnica (altra lingua)|divehi|mohawk|luo (Kenia e Tanzania)|lunda|lingue apache|luiseno|hupa|bini|tedesco|luba-lulua|bicol|washo|lingua imprecisata|waray|danese|olandese, medio (ca. 1050-1350)|walamo|manobo|lingue wakash|santali|gallese|sasak|kabardia|chuvash|slavo della Chiesa|manipuri|ceco|aramaico samaritano|cree|lingue salish|duala|corso|indiano del Sud America (altra lingua)|manchu|yakut|kawi|ingush|gbaya|sandawe|chamorro|indoeuropea (altra lingua)|bhojpuri|inglese, medio (1100-1500)|karen|indiana (altra lingua)|ceceno|gayo|catalano|mbundu|siriaco|kamba|tsimshian|inglese, antico (ca.450-1100)|kachin|caucasica (altra lingua)|kabyle|kara-kalpak|bosniaco|caribico|bretone|tibetano|bengalese|bambara|ga|indiana dell\u2019America Centrale (altra lingua)|bislama|bihari|bulgaro|bielorusso|caddo|baschiro|zulu|zenaga|provenzale, antico (fino al 1500)|alto sorabo|azerbaigiano|aymara|avaro|assamese|basso sorabo|arabo|ilocano|elamitico|cinese|aragonese|pracrito|amarico|newari|akan|zhuang|afrikaans|avestan|abkhazian|afar|yoruba|lingue algonchine|aleuto|mon-khmer (altra lingua)|yiddish|dravidica (altra lingua)|berbero|basso tedesco; basso sassone|wemba|begia|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Modificato";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "dd/MMM/yy" },
    { "longDateFormat", "dd MMMM yyyy" },
    { "fullDateFormat", "EEEE d MMMM yyyy" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
