// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

Binder	Binder::troll;

Binder::Binder() :
BayonneBinder("troll")
{
        static ScriptInterp::Define interp[] = {
		{"dial", false, (Method)&Methods::scrConnect,
			(Check)&Checks::chkConnect},
                {"connect", false, (Method)&Methods::scrConnect,
                        (Check)&Checks::chkConnect},   
		{"timeslot", false, (Method)&ScriptMethods::scrNop,
			(Check)&Checks::chkTrunking},
		{"span", false, (Method)&ScriptMethods::scrNop,
			(Check)&Checks::chkTrunking},
                {"cdr", false, (Method)&ScriptMethods::scrNop,
                        (Check)&Checks::chkCDR},    
                {"accept", false, (Method)&Methods::scrAccept,
                        (Check)&Checks::chkAccept},
                {"register", false, (Method)&ScriptMethods::scrNop,
                        (Check)&Checks::chkRegister},      
                {NULL, false, NULL, NULL}};   

	bind(interp);
	slog.info("binding troll...");

	Bayonne::provision_ripple = true;
	Bayonne::use_prefix = true;
	Bayonne::use_macros = true;
	Bayonne::use_merge = false;
	Bayonne::exec_funcs = true;

#ifdef	HAVE_TESTING
	if(Bayonne::provision_test)
	{
		server->setValue("exec.func", SOURCE_FILES "/config/exec.conf");
		server->setValue("macro.func", SOURCE_FILES "/config/macro.conf");
		server->setValue("service.conf", SOURCE_FILES "/config/service.conf");
		if(BayonneDriver::getTrunking() != NULL)
		{
			server->setValue("caller.conf", SOURCE_FILES "/config/caller.conf");
			server->setValue("dialed.conf", SOURCE_FILES "/config/dialed.conf");
			server->setValue("timeslot.conf", SOURCE_FILES "/config/timeslot.conf");
			server->setValue("span.conf", SOURCE_FILES "/config/span.conf");
			server->setValue("dialing.conf", SOURCE_FILES "/config/dialing.conf");
		}
		if(BayonneDriver::getProtocol() != NULL)
			server->setValue("routing.conf", SOURCE_FILES "/config/routing.conf");
		return;
	}
#endif
	server->setValue("service.conf", CONFIG_FILES "/service.conf");
	server->setValue("macro.func", CONFIG_FILES "/macro.conf");
	server->setValue("exec.func", CONFIG_FILES "/exec.conf");
	if(BayonneDriver::getTrunking() != NULL)
	{
		server->setValue("caller.conf", CONFIG_FILES "/caller.conf");
		server->setValue("dialed.conf", CONFIG_FILES "/dialed.conf");
		server->setValue("timeslot.conf", CONFIG_FILES "/timeslot.conf");
		server->setValue("span.conf", CONFIG_FILES "/span.conf");
		server->setValue("dialing.conf", CONFIG_FILES "/dialing.conf");
	}
	if(BayonneDriver::getProtocol() != NULL)
		server->setValue("routing.conf", CONFIG_FILES "/routing.conf");
};

Script::Name *Binder::service(ScriptImage *img, ScriptInterp *interp, const char *sid)
{
	char buf[65];

	if(!sid)
		return img->getScript("service::down");

	if(!*sid)
		return NULL;

	snprintf(buf, sizeof(buf), "service::%s", sid);
	return img->getScript(buf);
}

bool Binder::select(ScriptInterp *interp)
{
        char buf[65]; 
	BayonneSession *s = (BayonneSession *)interp;

	const char *cinfo = interp->getSymbol("session.info");
	const char *ctype = interp->getExternal("session.type");
	const char *rings = interp->getExternal("session.rings");

	if(!stricmp(ctype, "incoming") && cinfo && *cinfo)
	{
		snprintf(buf, sizeof(buf), "incoming:%s", cinfo);
		if(scriptEvent(interp, buf))
			return true;

		if(rings && atoi(rings) > 0)
		{
			if(scriptEvent(interp, "incoming:ringing"))
				return true;
		}
		else if(scriptEvent(interp, "incoming:immediate"))
			return true;
	}
	else if(!stricmp(ctype, "forward"))
	{
		if(scriptEvent(interp, "incoming:forward"))
			return true;
	}
	else if(!stricmp(ctype, "recall"))
	{
		if(scriptEvent(interp, "incoming:recall"))
			return true;
	}
	else if(!stricmp(ctype, "pickup"))
	{
		if(scriptEvent(interp, "incoming:pickup"))
			return true;
	}
	return false;		
}

void Binder::attach(ScriptInterp *interp)
{
};

void Binder::detach(ScriptInterp *interp)
{
	Line *cdr;
	char buffer[256];
	char var[65];
	char *p;
	unsigned idx = 0;
	const char *cp;
	size_t len;

	ScriptImage *img = interp->getImage();
	Name *scr = interp->getName();

	snprintf(var, sizeof(var), "cdr.%s", scr->name);
	p = strchr(var, ':');
	if(p)
		*p = 0; 

	cdr = (Line *)img->getPointer(var);	
	if(!cdr)
		return;

	snprintf(buffer, sizeof(buffer), "%s:", var + 4);
	len = strlen(buffer);
	
	while(len < sizeof(buffer) - 2 && NULL != (cp = getOption(cdr, &idx)))
	{
		if(isalpha(*cp))
		{
			var[0] = '%';
			snprintf(var + 1, sizeof(var) - 1, "session.%s", cp);
			cp = interp->getContent(var);
		}
		else
			cp = interp->getContent(cp);
		if(!cp || !*cp)
			cp = "-";
		snprintf(buffer + len, sizeof(buffer) - len, " %s", cp);
		len = strlen(buffer);
	}
#ifndef	WIN32
	if(getppid() > 1)
		fprintf(stderr, "%s\n", buffer);
#endif
	buffer[len++] = '\n';
	buffer[len] = 0;

#ifdef	WIN32
	HANDLE fd;
	DWORD res;
	fd = CreateFile(Bayonne::server->getLast("calls"), 
		GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	if(fd == INVALID_HANDLE_VALUE)
			return;

	Thread::yield();
	SetFilePointer(fd, 0, 0, FILE_END);
	WriteFile(fd, buffer, (DWORD)len, &res, NULL);
	CloseHandle(fd);
#else
	int fd;
	fd = ::open(server->getLast("calls"), O_WRONLY | O_APPEND | O_CREAT, 0640);
	if(fd < 0)
		return;

	::write(fd, buffer, len);
	::close(fd);
#endif
}

void Binder::down(void)
{
}

bool Binder::reload(ScriptCompiler *img)
{
	ScriptCommand *server;
	const char *prefix;
	const char *file;
	unsigned count;
	char **keys;
	char *ext;
	char path[MAX_PATHNAME];
	unsigned len;
	char *pp;
	Dir dir;

	server = img->getCommand();
	count = server->Keydata::getCount();	
	keys = new char *[count + 1];

	count = server->Keydata::getIndex(keys, count);
	while(count)
	{
		prefix = *(keys++);
		if(!prefix)
			break;

		ext = strrchr(prefix, '.');
		if(ext && strstr(Bayonne::exec_extensions, ext))
		{
			Bayonne::use_funcs = false;
			goto compile;
		}

		if(ext && stricmp(ext, ".func"))
		{
			Bayonne::use_funcs = true;
			goto compile;
		}

		if(ext && stricmp(ext, ".conf"))
		{
			Bayonne::use_funcs = false;
			goto compile;
		}

		continue;

compile:
		++Bayonne::compile_count;
		prefix = server->getLast(prefix);
		img->compile(prefix);
	}

	Bayonne::use_funcs = false;

	prefix = server->getLast("scripts");
	if(!prefix)
		return true;

	if(!isDir(prefix))
		return true;

	slog.info("compiler scanning %s", prefix);
	setString(path, sizeof(path), prefix);
        len = strlen(path);
        pp = path + len;
        len = sizeof(path) - len; 
        *pp++ = '/';
        --len;  

	dir.open(prefix);	
	while(NULL != (file = dir.getName()))
	{
		if(*file == '.')
			continue;

		ext = strrchr(file, '.');
                if(!ext || !strstr(Bayonne::exec_extensions, ext))
                        continue;

		++Bayonne::compile_count;
		setString(pp, len, file);
		img->compile(path);
	}
	dir.close();

	return true;
}

} // end namespace
