[+:   -*- nroff -*-

## agman1.tpl -- Template for command line man pages
##
##  AutoOpts copyright 1992-2004 Bruce Korb
##
## Time-stamp:      "2004-10-04 09:23:51 bkorb"
## Author:          Jim Van Zandt <jrv@vanzandt.mv.com>
## Maintainer:      Bruce Korb <bkorb@gnu.org>
## Created:         Mon Jun 28 15:35:12 1999
##              by: bkorb
## ---------------------------------------------------------------------
## $Id: agman1.tpl,v 2.49 2004/10/07 16:03:58 bkorb Exp $
## ---------------------------------------------------------------------

AutoGen5 template man=%s.1

(setenv "SHELL" "/bin/sh")

:+]
.TH [+: % prog-name (string-upcase! "%s") :+] 1 [+:
  `date +%Y-%m-%d` :+] "" "Programmer's Manual"
[+:

;; The following "dne" argument is a string of 5 characters:
;; '.' '\\' '"' and two spaces.  It _is_ hard to read.
;;
(dne ".\\\"  ") :+][+:  # balance quotes for emacs: "

:+]
.\"
.SH NAME
[+: (define prog-name (string-downcase! (get "prog-name")))
    (define PROG_NAME (string-tr! (get "prog-name") "a-z^-" "A-Z__"))
    (define prog_name (string-tr! (get "prog-name") "A-Z^-" "a-z__"))
    prog-name :+] \- [+: prog-title :+]
.SH SYNOPSIS
.B [+:
  (define use-flags (if (exist? "flag.value") #t #f))
  prog-name

:+][+:
    ;; * * * * * * * * * * * * * * * * * * * * * * * * *
    ;;
    ;;  Display the command line prototype,
    ;;  based only on the argument processing type.
    ;;
    ;;  And run the entire output through "sed" to convert texi-isms
    ;;
    (out-push-new)

:+]
sed \
 -e   's;@code{\([^}]*\)};\\fB\1\\fP;g' \
 -e    's;@var{\([^}]*\)};\\fB\1\\fP;g' \
 -e   's;@samp{\([^}]*\)};\\fB\1\\fP;g' \
 -e      's;@i{\([^}]*\)};\\fI\1\\fP;g' \
 -e   's;@file{\([^}]*\)};\\fI\1\\fP;g' \
 -e   's;@emph{\([^}]*\)};\\fI\1\\fP;g' \
 -e 's;@strong{\([^}]*\)};\\fB\1\\fP;g' \
 -e 's/@\([{}]\)/\1/g' \
 -e 's,^\$\*$,.br,' \
 -e '/@ *example/,/@ *end *example/s/^/    /' \
 -e 's/^ *@ *example/.nf/' \
 -e 's/^ *@ *end *example/.fi/' \
 -e '/^ *@ *noindent/d' \
 -e '/^ *@ *enumerate/d' \
 -e 's/^ *@ *end *enumerate/.br/' \
 -e '/^ *@ *table/d' \
 -e 's/^ *@ *end *table/.br/' \
 -e 's/^@item \(.*\)/.IR "\1"/' \
 -e 's/^@item/.sp 1/' \
 -e 's/\*\([a-zA-Z0-9:~=_ -]*\)\*/\\fB\1\\fP/g' \
 -e 's/``\([a-zA-Z0-9:~+=_ -]*\)'"''"'/\\fI\1\\fP/g' \
 -e 's/^@\*/.br/' <<'_End_Of_Man_'
[+:
  IF (define named-mode (not (or use-flags (exist? "long_opts") )))
     use-flags  :+][+:

    IF (exist? "long_opts") :+][+:

      # * * * * *
      #
      :+]
.\" Mixture of short (flag) options and long options
.RB [ -\fIflag\fP " [\fIvalue\fP]]... [" --\fIopt-name\fP " [[=| ]\fIvalue\fP]]..."[+:

    ELSE no long options:+][+:

      # * * * * *
      #
      :+]
.\" Short (flag) options only
.RB [ -\fIflag\fP " [\fIvalue\fP]]..."[+:
    ENDIF :+][+:

  ELIF (exist? "long_opts") :+][+:

      # * * * * *
      #
      :+]
.\" Long options only
.RB [ --\fIopt-name\fP [ = "| ] \fIvalue\fP]]..."[+:

  ELIF  (not (exist? "argument")) :+][+:

      # * * * * *
      #
      :+]
.\" All arguments are named options.
.RI [ opt-name "[\fB=\fP" value ]]...
.PP
All arguments are named options.[+:

  ELSE :+][+:
    (error "Named option programs cannot have arguments") :+][+:
  ENDIF :+][+:

  IF (exist? "argument") :+]
.br
.in +8
[+: argument :+][+:

    IF (exist? "reorder-args") :+]
.br
Operands and options may be intermixed.  They will be reordered.
[+: ENDIF :+][+:

  ELIF (or (exist? "long_opts") use-flags) :+]
.PP
All arguments must be options.[+:
  ENDIF :+][+:

      # * * * * * * * * * * * * * * * * * * * * * * * * *
      #
      #  Describe the command.  Use 'prog_man_desrip' if it exists,
      #  otherwise use the 'detail' help option.  If not that,
      #  then the thing is undocumented.
      #
      :+][+:
IF (exist? "explain") :+]
.PP
[+:explain:+][+:
ENDIF :+]
.SH "DESCRIPTION"
This manual page documents, briefly, the \fB[+:
    (. prog-name) :+]\fP command.
[+:

IF (exist? "prog-man-descrip")   :+][+:
  FOR prog-man-descrip "\n.PP\n" :+][+:
    prog-man-descrip             :+][+:
  ENDFOR                         :+][+:
ELIF (exist? "detail")           :+][+:
  FOR detail  "\n.PP\n"          :+][+:
    (string-substitute (get "detail") "\\" "\\\\") :+][+:
  ENDFOR                         :+][+:
ELSE
  :+]Its description is not documented.[+:
ENDIF :+]
.SH OPTIONS[+:

;; * * * * * * * * * * * * * * * * * * * * * * * * *
;;
;; Describe each option
;;
(define opt-arg  "")
(define dis-name "")
(define opt-name "")
(if (exist? "preserve-case")
    (begin
      (define optname-from "_^")
      (define optname-to   "--") )
    (begin
      (define optname-from "A-Z_^")
      (define optname-to   "a-z--") )
) :+][+:

FOR flag

:+][+:
  ;;  Skip the documentation options!
  ;;
  (if (exist? "enable")
      (set! opt-name (string-append (get "enable") "-" (get "name")))
      (set! opt-name (get "name")) )
  (if (exist? "disable")
      (set! dis-name (string-append (get "disable") "-" (get "name")))
      (set! dis-name "") )

  (set! opt-name (string-tr! opt-name optname-from optname-to))
  (set! dis-name (string-tr! dis-name optname-from optname-to))

  (if (not (exist? "arg-type"))
      (set! opt-arg "")
      (set! opt-arg (string-append "\\fI"
            (if (exist? "arg-name") (get "arg-name")
                (string-downcase! (get "arg-type")))
            "\\fP" ))
  )
  :+][+:
  IF (not (exist? "documentation")) :+]
.TP[+:
    IF (exist? "value") :+][+:
      IF (exist? "long-opts") :+][+:

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option has a flag value (character) AND
          *  the program uses long options
          *
          :+]
.BR -[+:value:+][+:
          IF (not (exist? "arg-type")) :+] ", " --[+:
          ELSE  :+] " [+:(. opt-arg):+], " --[+:
          ENDIF :+][+: (. opt-name)    :+][+:
          IF (exist? "arg-type")       :+][+:
              ? arg-optional " [ =" ' "=" '
              :+][+:  (. opt-arg)      :+][+:
              arg-optional " ]"        :+][+:
          ENDIF :+][+:
          IF (exist? "disable") :+], " \fB--[+:(. dis-name):+]\fP"[+:
          ENDIF :+][+:

        ELSE   :+][+:

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option has a flag value (character) BUT
          *  the program does _NOT_ use long options
          *
          :+]
.BR -[+:value:+][+:
          IF (exist? "arg-type") :+][+:
            arg-optional "["     :+] "[+:(. opt-arg):+][+:
            arg-optional '"]"'   :+][+:
          ENDIF " :+][+:
        ENDIF     :+][+:


      ELSE  value does not exist -- named option only  :+][+:

        IF (not (exist? "long-opts")) :+][+:

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option does not have a flag value (character).
          *  The program does _NOT_ use long options either.
          *  Special magic:  All arguments are named options.
          *
          :+]
.BR [+: (. opt-name) :+][+:
          IF (exist? "arg-type") :+] [+:
             ? arg-optional " [ =" ' "=" '
             :+][+:(. opt-arg):+][+:
             arg-optional "]" :+][+:
          ENDIF:+][+:
          IF (exist? "disable") :+], " \fB[+:(. dis-name):+]\fP"[+:
          ENDIF :+][+:


        ELSE   :+][+:

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option does not have a flag value (character).
          *  The program, instead, only accepts long options.
          *
          :+]
.BR --[+: (. opt-name) :+][+:
          IF (exist? "arg-type") :+] "[+:
            arg-optional "["     :+]=[+:(. opt-arg):+][+:
            arg-optional "]"     :+]"[+:
          ENDIF:+][+:
          IF (exist? "disable") :+], " \fB--[+:(. dis-name):+]\fP"[+:
          ENDIF :+][+:
        ENDIF  :+][+:
      ENDIF :+]
[+: (string-substitute (get "descrip") "\\" "\\\\") :+].[+:
      IF (exist? "min") :+]
This option is required to appear.[+:ENDIF:+][+:
      IF (exist? "max") :+]
This option may appear [+:
          IF % max (= "%s" "NOLIMIT")
          :+]an unlimited number of times[+:ELSE
          :+]up to [+:max:+] times[+:
          ENDIF:+].[+:
      ENDIF:+][+:
      IF (exist? "disable") :+]
The \fI[+:(. dis-name):+]\fP form will [+:
         IF (exist? "stack-arg") :+]clear the list of option arguments[+:
         ELSE  :+]disable the option[+:
         ENDIF :+].[+:
      ENDIF:+][+:
      IF (exist? "enabled") :+]
This option is enabled by default.[+:ENDIF:+][+:
      IF (exist? "no-preset") :+]
This option may not be preset with environment variables
or in initialization (rc) files.[+:ENDIF:+][+:
      IF (and (exist? "default") named-mode) :+]
This option is the default option.[+:
      ENDIF:+][+:
      IF (exist? "equivalence") :+]
This option is a member of the [+:equivalence:+] class of options.[+:ENDIF:+][+:
      IF (exist? "flags-must") :+]
This option must appear in combination with the following options:
[+: FOR flags-must ", " :+][+:flags-must:+][+:ENDFOR:+].[+:ENDIF:+][+:
      IF (exist? "flags-cant") :+]
This option must not appear in combination with any of the following options:
[+: FOR flags-cant ", " :+][+:flags-cant:+][+:ENDFOR:+].[+:
      ENDIF     :+][+:
      IF (~* (get "arg-type") "key|set") :+]
This option takes a keyword as its argument[+:

         IF (=* (get "arg-type") "set")

:+] list.  Each entry turns on or off
membership bits.  The bits are set by name or numeric value and cleared
by preceding the name or number with an exclamation character ('!').
They can all be cleared with the magic name \fInone\fR and they can all be set
with
.IR all .
A single option will process a list of these values.[+:

         ELSE

:+].  The argument sets an enumeration value that can
be tested by comparing the option value macro.[+:

         ENDIF

:+]
The available keywords are:
.in +4
.nf
.na
[+: (shellf "columns --spread=1 -W50 <<_EOF_\n%s\n_EOF_"
            (join "\n" (stack "keyword"))  ) :+]
.fi
.in -4[+: (if (exist? "arg-default") "\n.sp" ) :+][+:
      ENDIF     :+][+:
      IF (exist? "arg-default") :+]
The default [+:(. opt-arg):+] for this option is:
.ti +4
 [+: arg-default :+][+:
      ENDIF     :+]
.sp
[+: (if (exist? "doc")
        (string-substitute (get "doc") "\\" "\\\\")
        "This option has not been fully documented." ) :+][+:

  ENDIF (not (exist? "documentation")) :+][+:

ENDFOR flag


:+]
.TP
.BR [+:

  IF (. use-flags)  :+]\-[+: ?% help-value "%s" "?" :+][+:
     IF (exist? "long-opts") :+] , " \--help"[+: ENDIF :+][+:
  ELSE   :+][+:
     IF (exist? "long-opts") :+]\--[+: ENDIF :+]help[+:
  ENDIF  :+]
Display usage information and exit.
.TP
.BR [+:

  IF (. use-flags)  :+]\-[+: ?% more-help-value "%s" "!" :+][+:
     IF (exist? "long-opts") :+] , " \--more-help"[+: ENDIF :+][+:
  ELSE   :+][+:
     IF (exist? "long-opts") :+]\--[+: ENDIF :+]more-help[+:
  ENDIF  :+]
Extended usage information passed thru pager.[+:


IF (exist? "homerc") :+]
.TP
.BR [+:

  IF (. use-flags)  :+]\-[+: ?% save-opts-value "%s" ">"
     :+] " [\fIrcfile\fP][+:
     IF (exist? "long-opts") :+]," " \--save-opts" "[=\fIrcfile\fP][+:
     ENDIF :+]"[+:
  ELSE     :+][+:
     IF (exist? "long-opts") :+]\--[+:
     ENDIF :+]save-opts "[=\fIrcfile\fP]"[+:
  ENDIF    :+]
Save the option state to \fIrcfile\fP.  The default is the \fIlast\fP
rc file listed in the \fBOPTION PRESETS\fP section, below.
.TP
.BR [+:

  IF (. use-flags)  :+]\-[+: ?% load-opts-value "%s" "<"
     :+] " \fIrcfile\fP[+:
     IF (exist? "long-opts")
           :+]," " \--load-opts" "=\fIrcfile\fP," " --no-load-opts[+:
     ENDIF :+]"[+:
  ELSE     :+][+:
     IF (exist? "long-opts") :+]\--[+:
     ENDIF :+]load-opts "=\fIrcfile\fP," " --no-load-opts"[+:
  ENDIF    :+]
Load options from \fIrcfile\fP.
The \fIno-load-opts\fP form will disable the loading
of earlier RC/INI files.  \fI--no-load-opts\fP is handled early,
out of order.[+:
ENDIF (exist? "homerc") :+][+:


IF (exist? "version") :+]
.TP
.BR [+:

  IF (. use-flags)  :+]\-[+: ?% version-value "%s" "v"
     :+] " [{\fIv|c|n\fP}][+:
     IF (exist? "long-opts") :+]," " \--version" "[=\fI{v|c|n}\fP][+:
     ENDIF :+]"[+:
  ELSE     :+][+:
     IF (exist? "long-opts") :+]\--[+:
     ENDIF :+]version "[=\fI{v|c|n}\fP]"[+:
  ENDIF    :+]
Output version of program and exit.  The default mode is `v', a simple
version.  The `c' mode will print copyright information and `n' will
print the full copyright notice.[+:
ENDIF


:+][+:
IF (or (exist? "homerc") (exist? "environrc")) :+]
.SH OPTION PRESETS
Any option that is not marked as ``not presettable'' may be preset
by loading values from [+:
  IF (exist? "homerc")
    :+]RC (.ini) file(s)[+:
    IF (exist? "environrc")
            :+] and values from
[+:
    ENDIF   :+][+:
  ENDIF     :+][+:
  IF (exist? "environrc") :+]environment variables named:
.nf
  \fB[+: (. PROG_NAME) :+]_<option-name>\fP or \fB[+: (. PROG_NAME) :+]\fP
.fi
.aj[+:
    IF (exist? "homerc") :+]
The environmental presets take precedence (are processed later than)
the RC files.[+:
    ENDIF   :+][+:
  ELSE      :+].[+:
  ENDIF     :+][+:

  CASE (count "homerc") :+][+:
  == "0"    :+][+:
  == "1"    :+]
The \fIhomerc\fP file is "\fI[+:homerc:+]\fP", unless that is a directory.
In that case, the file "\fI[+: ?% rcfile "%s"
(string-append "." prog_name "rc") :+]\fP"
is searched for within that directory.[+:

  *         :+]
The \fIhomerc\fP files are [+:
    FOR homerc ", "  :+][+:
      IF (last-for?) :+]and [+:
      ENDIF :+]"\fI[+: homerc :+]\fP"[+: ENDFOR :+].
If any of these are directories, then the file \fI[+: ?% rcfile "%s"
(string-append "." prog_name "rc") :+]\fP
is searched for within those directories.[+:
  ESAC      :+][+:


ENDIF       :+][+:
IF (exist? "man-doc") :+]
[+:man-doc:+][+:
ENDIF:+][+:

IF (define tmp-str (get "copyright.author" (get "copyright.owner")))
   (> (string-length tmp-str) 0) :+]
.SH AUTHOR
[+: (. tmp-str) :+][+:

 (set! tmp-str (get "copyright.eaddr" (get "eaddr")))
 (if (> (string-length tmp-str) 0)
   (string-append "\n.br\nPlease send bug reports to:  " tmp-str "\n") ) :+][+:

  CASE copyright.type :+][+:
   =  gpl  :+]
.PP
Released under the GNU General Public License.[+:
   = lgpl  :+]
.PP
Released under the GNU General Public License with Library Extensions.[+:
   =  bsd  :+]
.PP
Released under the Free BSD License.[+:
   *       :+][+:
     IF (exist? "copyright.text")
           :+]
.PP
.nf
.na
[+: copyright.text :+]
.fi
.ad[+:
     ELIF (exist? "copyright.date") :+]
.PP
Released under an unspecified copyright license.[+:
     ENDIF :+][+:
  ESAC     :+][+:
ENDIF      :+]
_End_Of_Man_[+:

(shell (out-pop #t) ) :+]
.PP
This manual page was \fIAutoGen\fP-erated from the \fB[+: prog-name :+]\fP
option definitions.[+: #

agman.tpl ends here  :+]
