/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

static gint ValaInitializerList_private_offset;
static gpointer vala_initializer_list_parent_class = NULL;

static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);
static GType vala_initializer_list_get_type_once (void);

static inline gpointer
vala_initializer_list_get_instance_private (ValaInitializerList* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInitializerList_private_offset);
}

/**
 * Appends the specified expression to this initializer
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}

/**
 * Returns the initializer expression list
 *
 * @return expression list
 */
ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	result = _tmp0_;
	return result;
}

gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
 * Creates a new initializer
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}

static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_constant (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_pure (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp4_ = _initializer_index;
			_tmp5_ = _initializer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _initializer_list;
			_tmp7_ = vala_list_get (_tmp6_, _initializer_index);
			initializer = (ValaExpression*) _tmp7_;
			_tmp8_ = initializer;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	result = TRUE;
	return result;
}

static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			_initializer_index = _initializer_index + 1;
			_tmp5_ = _initializer_index;
			_tmp6_ = _initializer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _initializer_list;
			_tmp8_ = vala_list_get (_tmp7_, _initializer_index);
			initializer = (ValaExpression*) _tmp8_;
			if (first) {
				GString* _tmp9_;
				ValaExpression* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = builder;
				_tmp10_ = initializer;
				_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				first = FALSE;
			} else {
				GString* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = builder;
				_tmp14_ = initializer;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_string_append_printf (_tmp13_, ", %s", _tmp16_);
				_g_free0 (_tmp16_);
			}
			_vala_code_node_unref0 (initializer);
		}
	}
	_tmp17_ = builder;
	g_string_append_c (_tmp17_, '}');
	_tmp18_ = builder;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_string_free0 (builder);
	return result;
}

static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaExpression* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->initializers;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->initializers;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaExpression*) _tmp6_;
				_tmp8_ = _tmp7_ == old_node;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->initializers;
					vala_list_set (_tmp9_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp231_;
	gboolean _tmp232_;
	gboolean _tmp276_;
	gboolean _tmp277_;
	ValaDataType* _tmp284_;
	ValaDataType* _tmp285_;
	gboolean _tmp288_;
	gboolean _tmp289_;
	gboolean result;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				gboolean requires_constants_only = FALSE;
				gboolean is_global_constant_inline = FALSE;
				ValaCodeNode* node = NULL;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				ValaCodeNode* _tmp35_;
				ValaCodeNode* _tmp36_;
				ValaDataType* inner_target_type = NULL;
				ValaArrayType* _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp15_ = _tmp14_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				requires_constants_only = FALSE;
				is_global_constant_inline = FALSE;
				_tmp16_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				node = _tmp17_;
				while (TRUE) {
					ValaCodeNode* _tmp18_;
					ValaCodeNode* _tmp19_;
					ValaCodeNode* _tmp29_;
					ValaCodeNode* _tmp30_;
					ValaCodeNode* _tmp31_;
					_tmp18_ = node;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = node;
					if (VALA_IS_CONSTANT (_tmp19_)) {
						requires_constants_only = TRUE;
						break;
					} else {
						gboolean _tmp20_ = FALSE;
						ValaCodeNode* _tmp21_;
						_tmp21_ = node;
						if (VALA_IS_FIELD (_tmp21_)) {
							ValaCodeNode* _tmp22_;
							ValaSymbol* _tmp23_;
							ValaSymbol* _tmp24_;
							_tmp22_ = node;
							_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_FIELD, ValaField));
							_tmp24_ = _tmp23_;
							_tmp20_ = VALA_IS_NAMESPACE (_tmp24_);
						} else {
							_tmp20_ = FALSE;
						}
						if (_tmp20_) {
							gboolean _tmp25_ = FALSE;
							ValaArrayType* _tmp26_;
							gboolean _tmp27_;
							gboolean _tmp28_;
							_tmp26_ = array_type;
							_tmp27_ = vala_array_type_get_inline_allocated (_tmp26_);
							_tmp28_ = _tmp27_;
							if (_tmp28_) {
								_tmp25_ = vala_expression_is_constant ((ValaExpression*) self);
							} else {
								_tmp25_ = FALSE;
							}
							is_global_constant_inline = _tmp25_;
						}
					}
					_tmp29_ = node;
					_tmp30_ = vala_code_node_get_parent_node (_tmp29_);
					_tmp31_ = _tmp30_;
					node = _tmp31_;
				}
				_tmp35_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp36_ = _tmp35_;
				if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp36_)) {
					_tmp34_ = !requires_constants_only;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					_tmp33_ = !is_global_constant_inline;
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					gboolean _tmp37_ = FALSE;
					ValaCodeNode* _tmp38_;
					ValaCodeNode* _tmp39_;
					_tmp38_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp39_ = _tmp38_;
					if (!VALA_IS_INITIALIZER_LIST (_tmp39_)) {
						_tmp37_ = TRUE;
					} else {
						ValaCodeNode* _tmp40_;
						ValaCodeNode* _tmp41_;
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						ValaTypeSymbol* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						_tmp40_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp41_ = _tmp40_;
						_tmp42_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_data_type_get_type_symbol (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp37_ = VALA_IS_STRUCT (_tmp45_);
					}
					_tmp32_ = _tmp37_;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					ValaCodeNode* old_parent_node = NULL;
					ValaCodeNode* _tmp46_;
					ValaCodeNode* _tmp47_;
					ValaCodeNode* _tmp48_;
					ValaArrayCreationExpression* array_creation = NULL;
					ValaArrayType* _tmp49_;
					ValaDataType* _tmp50_;
					ValaDataType* _tmp51_;
					ValaDataType* _tmp52_;
					ValaDataType* _tmp53_;
					ValaArrayType* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					ValaSourceReference* _tmp57_;
					ValaSourceReference* _tmp58_;
					ValaArrayCreationExpression* _tmp59_;
					ValaArrayCreationExpression* _tmp60_;
					ValaArrayCreationExpression* _tmp61_;
					ValaArrayType* _tmp62_;
					ValaDataType* _tmp63_;
					ValaDataType* _tmp64_;
					ValaDataType* _tmp65_;
					ValaDataType* _tmp66_;
					ValaArrayCreationExpression* _tmp67_;
					ValaDataType* _tmp68_;
					ValaDataType* _tmp69_;
					ValaArrayCreationExpression* _tmp70_;
					ValaDataType* _tmp71_;
					ValaDataType* _tmp72_;
					ValaCodeNode* _tmp73_;
					ValaArrayCreationExpression* _tmp74_;
					ValaArrayCreationExpression* _tmp75_;
					_tmp46_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp47_ = _tmp46_;
					_tmp48_ = _vala_code_node_ref0 (_tmp47_);
					old_parent_node = _tmp48_;
					_tmp49_ = array_type;
					_tmp50_ = vala_array_type_get_element_type (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = vala_data_type_copy (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = array_type;
					_tmp55_ = vala_array_type_get_rank (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp58_ = _tmp57_;
					_tmp59_ = vala_array_creation_expression_new (_tmp53_, _tmp56_, self, _tmp58_);
					_tmp60_ = _tmp59_;
					_vala_code_node_unref0 (_tmp53_);
					array_creation = _tmp60_;
					_tmp61_ = array_creation;
					_tmp62_ = array_type;
					_tmp63_ = vala_array_type_get_length_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_data_type_copy (_tmp64_);
					_tmp66_ = _tmp65_;
					vala_array_creation_expression_set_length_type (_tmp61_, _tmp66_);
					_vala_code_node_unref0 (_tmp66_);
					_tmp67_ = array_creation;
					_tmp68_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp69_ = _tmp68_;
					vala_expression_set_target_type ((ValaExpression*) _tmp67_, _tmp69_);
					_tmp70_ = array_creation;
					_tmp71_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
					_tmp72_ = _tmp71_;
					vala_expression_set_formal_target_type ((ValaExpression*) _tmp70_, _tmp72_);
					_tmp73_ = old_parent_node;
					_tmp74_ = array_creation;
					vala_code_node_replace_expression (_tmp73_, (ValaExpression*) self, (ValaExpression*) _tmp74_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp75_ = array_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp75_, context);
					_vala_code_node_unref0 (array_creation);
					_vala_code_node_unref0 (old_parent_node);
					return result;
				}
				_tmp76_ = array_type;
				_tmp77_ = vala_array_type_get_rank (_tmp76_);
				_tmp78_ = _tmp77_;
				if (_tmp78_ > 1) {
					ValaArrayType* inner_array_type = NULL;
					ValaArrayType* _tmp79_;
					ValaDataType* _tmp80_;
					ValaArrayType* _tmp81_;
					gint _tmp82_;
					gint _tmp83_;
					ValaArrayType* _tmp84_;
					ValaDataType* _tmp85_;
					_tmp79_ = array_type;
					_tmp80_ = vala_data_type_copy ((ValaDataType*) _tmp79_);
					inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp81_ = inner_array_type;
					_tmp82_ = vala_array_type_get_rank (_tmp81_);
					_tmp83_ = _tmp82_;
					vala_array_type_set_rank (_tmp81_, _tmp83_ - 1);
					_tmp84_ = inner_array_type;
					_tmp85_ = _vala_code_node_ref0 ((ValaDataType*) _tmp84_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp85_;
					_vala_code_node_unref0 (inner_array_type);
				} else {
					ValaArrayType* _tmp86_;
					ValaDataType* _tmp87_;
					ValaDataType* _tmp88_;
					ValaDataType* _tmp89_;
					_tmp86_ = array_type;
					_tmp87_ = vala_array_type_get_element_type (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = vala_data_type_copy (_tmp88_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp89_;
				}
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp90_;
					gint _e_size = 0;
					ValaList* _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					gint _e_index = 0;
					_tmp90_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp90_;
					_tmp91_ = _e_list;
					_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
					_tmp93_ = _tmp92_;
					_e_size = _tmp93_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp94_;
						gint _tmp95_;
						ValaExpression* e = NULL;
						ValaList* _tmp96_;
						gpointer _tmp97_;
						ValaExpression* _tmp98_;
						ValaDataType* _tmp99_;
						_e_index = _e_index + 1;
						_tmp94_ = _e_index;
						_tmp95_ = _e_size;
						if (!(_tmp94_ < _tmp95_)) {
							break;
						}
						_tmp96_ = _e_list;
						_tmp97_ = vala_list_get (_tmp96_, _e_index);
						e = (ValaExpression*) _tmp97_;
						_tmp98_ = e;
						_tmp99_ = inner_target_type;
						vala_expression_set_target_type (_tmp98_, _tmp99_);
						_vala_code_node_unref0 (e);
					}
				}
				_vala_code_node_unref0 (inner_target_type);
			} else {
				ValaDataType* _tmp100_;
				ValaDataType* _tmp101_;
				ValaTypeSymbol* _tmp102_;
				ValaTypeSymbol* _tmp103_;
				_tmp100_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_data_type_get_type_symbol (_tmp101_);
				_tmp103_ = _tmp102_;
				if (VALA_IS_STRUCT (_tmp103_)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					gboolean _tmp114_ = FALSE;
					ValaCodeNode* _tmp115_;
					ValaCodeNode* _tmp116_;
					gboolean in_array_creation_initializer = FALSE;
					ValaObjectCreationExpression* struct_creation = NULL;
					ValaIterator* field_it = NULL;
					ValaStruct* _tmp164_;
					ValaList* _tmp165_;
					ValaIterator* _tmp166_;
					_tmp104_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_STRUCT, ValaStruct);
					while (TRUE) {
						ValaStruct* _tmp108_;
						ValaStruct* _tmp109_;
						ValaStruct* _tmp110_;
						ValaStruct* _tmp111_;
						ValaStruct* _tmp112_;
						ValaStruct* _tmp113_;
						_tmp108_ = st;
						_tmp109_ = vala_struct_get_base_struct (_tmp108_);
						_tmp110_ = _tmp109_;
						if (!(_tmp110_ != NULL)) {
							break;
						}
						_tmp111_ = st;
						_tmp112_ = vala_struct_get_base_struct (_tmp111_);
						_tmp113_ = _tmp112_;
						st = _tmp113_;
					}
					_tmp115_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp116_ = _tmp115_;
					if (VALA_IS_INITIALIZER_LIST (_tmp116_)) {
						ValaCodeNode* _tmp117_;
						ValaCodeNode* _tmp118_;
						ValaCodeNode* _tmp119_;
						ValaCodeNode* _tmp120_;
						_tmp117_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp118_ = _tmp117_;
						_tmp119_ = vala_code_node_get_parent_node (_tmp118_);
						_tmp120_ = _tmp119_;
						_tmp114_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp120_);
					} else {
						_tmp114_ = FALSE;
					}
					in_array_creation_initializer = _tmp114_;
					struct_creation = NULL;
					if (in_array_creation_initializer) {
						ValaSymbol* sym = NULL;
						ValaStruct* _tmp121_;
						ValaMemberAccess* ma = NULL;
						ValaSymbol* _tmp122_;
						const gchar* _tmp123_;
						const gchar* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaSourceReference* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaSymbol* _tmp129_;
						ValaMemberAccess* inner = NULL;
						ValaMemberAccess* _tmp130_;
						ValaMemberAccess* _tmp131_;
						ValaMemberAccess* _tmp154_;
						ValaSourceReference* _tmp155_;
						ValaSourceReference* _tmp156_;
						ValaObjectCreationExpression* _tmp157_;
						ValaObjectCreationExpression* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaObjectCreationExpression* _tmp163_;
						_tmp121_ = st;
						sym = (ValaSymbol*) _tmp121_;
						_tmp122_ = sym;
						_tmp123_ = vala_symbol_get_name (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_member_access_new_simple (_tmp124_, _tmp126_);
						ma = _tmp127_;
						_tmp128_ = ma;
						_tmp129_ = sym;
						vala_expression_set_symbol_reference ((ValaExpression*) _tmp128_, _tmp129_);
						_tmp130_ = ma;
						_tmp131_ = _vala_code_node_ref0 (_tmp130_);
						inner = _tmp131_;
						while (TRUE) {
							gboolean _tmp132_ = FALSE;
							ValaSymbol* _tmp133_;
							ValaSymbol* _tmp134_;
							ValaSymbol* _tmp135_;
							ValaSymbol* _tmp141_;
							ValaSymbol* _tmp142_;
							ValaSymbol* _tmp143_;
							ValaMemberAccess* ma_inner = NULL;
							ValaSymbol* _tmp144_;
							const gchar* _tmp145_;
							const gchar* _tmp146_;
							ValaSourceReference* _tmp147_;
							ValaSourceReference* _tmp148_;
							ValaMemberAccess* _tmp149_;
							ValaMemberAccess* _tmp150_;
							ValaMemberAccess* _tmp151_;
							ValaMemberAccess* _tmp152_;
							ValaMemberAccess* _tmp153_;
							_tmp133_ = sym;
							_tmp134_ = vala_symbol_get_parent_symbol (_tmp133_);
							_tmp135_ = _tmp134_;
							if (_tmp135_ != NULL) {
								ValaSymbol* _tmp136_;
								ValaSymbol* _tmp137_;
								ValaSymbol* _tmp138_;
								ValaNamespace* _tmp139_;
								ValaNamespace* _tmp140_;
								_tmp136_ = sym;
								_tmp137_ = vala_symbol_get_parent_symbol (_tmp136_);
								_tmp138_ = _tmp137_;
								_tmp139_ = vala_code_context_get_root (context);
								_tmp140_ = _tmp139_;
								_tmp132_ = _tmp138_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp132_ = FALSE;
							}
							if (!_tmp132_) {
								break;
							}
							_tmp141_ = sym;
							_tmp142_ = vala_symbol_get_parent_symbol (_tmp141_);
							_tmp143_ = _tmp142_;
							sym = _tmp143_;
							_tmp144_ = sym;
							_tmp145_ = vala_symbol_get_name (_tmp144_);
							_tmp146_ = _tmp145_;
							_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp148_ = _tmp147_;
							_tmp149_ = vala_member_access_new_simple (_tmp146_, _tmp148_);
							ma_inner = _tmp149_;
							_tmp150_ = inner;
							_tmp151_ = ma_inner;
							vala_member_access_set_inner (_tmp150_, (ValaExpression*) _tmp151_);
							_tmp152_ = ma_inner;
							_tmp153_ = _vala_code_node_ref0 (_tmp152_);
							_vala_code_node_unref0 (inner);
							inner = _tmp153_;
							_vala_code_node_unref0 (ma_inner);
						}
						_tmp154_ = ma;
						_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_object_creation_expression_new (_tmp154_, _tmp156_);
						_vala_code_node_unref0 (struct_creation);
						struct_creation = _tmp157_;
						_tmp158_ = struct_creation;
						_tmp159_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_data_type_copy (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_expression_set_target_type ((ValaExpression*) _tmp158_, _tmp162_);
						_vala_code_node_unref0 (_tmp162_);
						_tmp163_ = struct_creation;
						vala_object_creation_expression_set_struct_creation (_tmp163_, TRUE);
						_vala_code_node_unref0 (inner);
						_vala_code_node_unref0 (ma);
					}
					_tmp164_ = st;
					_tmp165_ = vala_struct_get_fields (_tmp164_);
					_tmp166_ = vala_iterable_iterator ((ValaIterable*) _tmp165_);
					field_it = _tmp166_;
					{
						ValaList* _e_list = NULL;
						ValaList* _tmp167_;
						gint _e_size = 0;
						ValaList* _tmp168_;
						gint _tmp169_;
						gint _tmp170_;
						gint _e_index = 0;
						_tmp167_ = vala_initializer_list_get_initializers (self);
						_e_list = _tmp167_;
						_tmp168_ = _e_list;
						_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
						_tmp170_ = _tmp169_;
						_e_size = _tmp170_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp171_;
							gint _tmp172_;
							ValaExpression* e = NULL;
							ValaList* _tmp173_;
							gpointer _tmp174_;
							ValaField* field = NULL;
							_e_index = _e_index + 1;
							_tmp171_ = _e_index;
							_tmp172_ = _e_size;
							if (!(_tmp171_ < _tmp172_)) {
								break;
							}
							_tmp173_ = _e_list;
							_tmp174_ = vala_list_get (_tmp173_, _e_index);
							e = (ValaExpression*) _tmp174_;
							field = NULL;
							while (TRUE) {
								ValaField* _tmp175_;
								ValaIterator* _tmp176_;
								ValaIterator* _tmp184_;
								gpointer _tmp185_;
								ValaField* _tmp186_;
								ValaMemberBinding _tmp187_;
								ValaMemberBinding _tmp188_;
								_tmp175_ = field;
								if (!(_tmp175_ == NULL)) {
									break;
								}
								_tmp176_ = field_it;
								if (!vala_iterator_next (_tmp176_)) {
									ValaExpression* _tmp177_;
									ValaSourceReference* _tmp178_;
									ValaSourceReference* _tmp179_;
									ValaDataType* _tmp180_;
									ValaDataType* _tmp181_;
									gchar* _tmp182_;
									gchar* _tmp183_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp177_ = e;
									_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
									_tmp179_ = _tmp178_;
									_tmp180_ = vala_expression_get_target_type ((ValaExpression*) self);
									_tmp181_ = _tmp180_;
									_tmp182_ = vala_code_node_to_string ((ValaCodeNode*) _tmp181_);
									_tmp183_ = _tmp182_;
									vala_report_error (_tmp179_, "too many expressions in initializer list for `%s'", _tmp183_);
									_g_free0 (_tmp183_);
									result = FALSE;
									_vala_code_node_unref0 (field);
									_vala_code_node_unref0 (e);
									_vala_iterator_unref0 (field_it);
									_vala_code_node_unref0 (struct_creation);
									return result;
								}
								_tmp184_ = field_it;
								_tmp185_ = vala_iterator_get (_tmp184_);
								_vala_code_node_unref0 (field);
								field = (ValaField*) _tmp185_;
								_tmp186_ = field;
								_tmp187_ = vala_field_get_binding (_tmp186_);
								_tmp188_ = _tmp187_;
								if (_tmp188_ != VALA_MEMBER_BINDING_INSTANCE) {
									_vala_code_node_unref0 (field);
									field = NULL;
								}
							}
							if (in_array_creation_initializer) {
								ValaMemberInitializer* member_init = NULL;
								ValaField* _tmp189_;
								const gchar* _tmp190_;
								const gchar* _tmp191_;
								ValaExpression* _tmp192_;
								ValaExpression* _tmp193_;
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								ValaMemberInitializer* _tmp196_;
								ValaObjectCreationExpression* _tmp197_;
								ValaMemberInitializer* _tmp198_;
								_tmp189_ = field;
								_tmp190_ = vala_symbol_get_name ((ValaSymbol*) _tmp189_);
								_tmp191_ = _tmp190_;
								_tmp192_ = e;
								_tmp193_ = e;
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp193_);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_member_initializer_new (_tmp191_, _tmp192_, _tmp195_);
								member_init = _tmp196_;
								_tmp197_ = struct_creation;
								_tmp198_ = member_init;
								vala_object_creation_expression_add_member_initializer (_tmp197_, _tmp198_);
								_vala_code_node_unref0 (member_init);
							} else {
								ValaExpression* _tmp199_;
								ValaField* _tmp200_;
								ValaDataType* _tmp201_;
								ValaDataType* _tmp202_;
								ValaDataType* _tmp203_;
								ValaDataType* _tmp204_;
								ValaDataType* _tmp205_;
								ValaDataType* _tmp206_;
								gboolean _tmp207_;
								gboolean _tmp208_;
								_tmp199_ = e;
								_tmp200_ = field;
								_tmp201_ = vala_variable_get_variable_type ((ValaVariable*) _tmp200_);
								_tmp202_ = _tmp201_;
								_tmp203_ = vala_data_type_copy (_tmp202_);
								_tmp204_ = _tmp203_;
								vala_expression_set_target_type (_tmp199_, _tmp204_);
								_vala_code_node_unref0 (_tmp204_);
								_tmp205_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp206_ = _tmp205_;
								_tmp207_ = vala_data_type_get_value_owned (_tmp206_);
								_tmp208_ = _tmp207_;
								if (!_tmp208_) {
									ValaExpression* _tmp209_;
									ValaDataType* _tmp210_;
									ValaDataType* _tmp211_;
									_tmp209_ = e;
									_tmp210_ = vala_expression_get_target_type (_tmp209_);
									_tmp211_ = _tmp210_;
									vala_data_type_set_value_owned (_tmp211_, FALSE);
								}
							}
							_vala_code_node_unref0 (field);
							_vala_code_node_unref0 (e);
						}
					}
					if (in_array_creation_initializer) {
						ValaCodeNode* _tmp212_;
						ValaCodeNode* _tmp213_;
						ValaObjectCreationExpression* _tmp214_;
						ValaObjectCreationExpression* _tmp215_;
						_tmp212_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp213_ = _tmp212_;
						_tmp214_ = struct_creation;
						vala_code_node_replace_expression (_tmp213_, (ValaExpression*) self, (ValaExpression*) _tmp214_);
						vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
						_tmp215_ = struct_creation;
						result = vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
						_vala_iterator_unref0 (field_it);
						_vala_code_node_unref0 (struct_creation);
						return result;
					}
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
				} else {
					ValaSourceReference* _tmp216_;
					ValaSourceReference* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_code_node_to_string ((ValaCodeNode*) _tmp219_);
					_tmp221_ = _tmp220_;
					vala_report_error (_tmp217_, "initializer list used for `%s', which is neither array nor struct", _tmp221_);
					_g_free0 (_tmp221_);
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp222_;
		gint _expr_size = 0;
		ValaList* _tmp223_;
		gint _tmp224_;
		gint _tmp225_;
		gint _expr_index = 0;
		_tmp222_ = self->priv->initializers;
		_expr_list = _tmp222_;
		_tmp223_ = _expr_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_expr_size = _tmp225_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp226_;
			gint _tmp227_;
			ValaExpression* expr = NULL;
			ValaList* _tmp228_;
			gpointer _tmp229_;
			ValaExpression* _tmp230_;
			_expr_index = _expr_index + 1;
			_tmp226_ = _expr_index;
			_tmp227_ = _expr_size;
			if (!(_tmp226_ < _tmp227_)) {
				break;
			}
			_tmp228_ = _expr_list;
			_tmp229_ = vala_list_get (_tmp228_, _expr_index);
			expr = (ValaExpression*) _tmp229_;
			_tmp230_ = expr;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp230_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp231_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp232_ = _tmp231_;
	if (_tmp232_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp233_;
		gint _e_size = 0;
		ValaList* _tmp234_;
		gint _tmp235_;
		gint _tmp236_;
		gint _e_index = 0;
		_tmp233_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp233_;
		_tmp234_ = _e_list;
		_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
		_tmp236_ = _tmp235_;
		_e_size = _tmp236_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp237_;
			gint _tmp238_;
			ValaExpression* e = NULL;
			ValaList* _tmp239_;
			gpointer _tmp240_;
			ValaExpression* _tmp241_;
			ValaDataType* _tmp242_;
			ValaDataType* _tmp243_;
			gboolean _tmp247_ = FALSE;
			gboolean _tmp248_ = FALSE;
			ValaExpression* _tmp249_;
			_e_index = _e_index + 1;
			_tmp237_ = _e_index;
			_tmp238_ = _e_size;
			if (!(_tmp237_ < _tmp238_)) {
				break;
			}
			_tmp239_ = _e_list;
			_tmp240_ = vala_list_get (_tmp239_, _e_index);
			e = (ValaExpression*) _tmp240_;
			_tmp241_ = e;
			_tmp242_ = vala_expression_get_value_type (_tmp241_);
			_tmp243_ = _tmp242_;
			if (_tmp243_ == NULL) {
				ValaExpression* _tmp244_;
				ValaSourceReference* _tmp245_;
				ValaSourceReference* _tmp246_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp244_ = e;
				_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp244_);
				_tmp246_ = _tmp245_;
				vala_report_error (_tmp246_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp249_ = e;
			if (VALA_IS_NULL_LITERAL (_tmp249_)) {
				ValaExpression* _tmp250_;
				ValaDataType* _tmp251_;
				ValaDataType* _tmp252_;
				_tmp250_ = e;
				_tmp251_ = vala_expression_get_target_type (_tmp250_);
				_tmp252_ = _tmp251_;
				_tmp248_ = _tmp252_ != NULL;
			} else {
				_tmp248_ = FALSE;
			}
			if (_tmp248_) {
				ValaExpression* _tmp253_;
				ValaDataType* _tmp254_;
				ValaDataType* _tmp255_;
				_tmp253_ = e;
				_tmp254_ = vala_expression_get_target_type (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp247_ = vala_data_type_is_real_non_null_struct_type (_tmp255_);
			} else {
				_tmp247_ = FALSE;
			}
			if (_tmp247_) {
			} else {
				ValaExpression* _tmp256_;
				ValaDataType* _tmp257_;
				ValaDataType* _tmp258_;
				ValaExpression* _tmp259_;
				ValaDataType* _tmp260_;
				ValaDataType* _tmp261_;
				_tmp256_ = e;
				_tmp257_ = vala_expression_get_value_type (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = e;
				_tmp260_ = vala_expression_get_target_type (_tmp259_);
				_tmp261_ = _tmp260_;
				if (!vala_data_type_compatible (_tmp258_, _tmp261_)) {
					ValaExpression* _tmp262_;
					ValaExpression* _tmp263_;
					ValaSourceReference* _tmp264_;
					ValaSourceReference* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					gchar* _tmp269_;
					gchar* _tmp270_;
					ValaExpression* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					gchar* _tmp274_;
					gchar* _tmp275_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp262_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp262_, TRUE);
					_tmp263_ = e;
					_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = e;
					_tmp267_ = vala_expression_get_target_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = vala_code_node_to_string ((ValaCodeNode*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = e;
					_tmp272_ = vala_expression_get_value_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_code_node_to_string ((ValaCodeNode*) _tmp273_);
					_tmp275_ = _tmp274_;
					vala_report_error (_tmp265_, "Expected initializer of type `%s' but got `%s'", _tmp270_, _tmp275_);
					_g_free0 (_tmp275_);
					_g_free0 (_tmp270_);
				}
			}
			_vala_code_node_unref0 (e);
		}
	}
	_tmp276_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp277_ = _tmp276_;
	if (!_tmp277_) {
		ValaDataType* _tmp278_;
		ValaDataType* _tmp279_;
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		_tmp278_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_data_type_copy (_tmp279_);
		_tmp281_ = _tmp280_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp281_);
		_vala_code_node_unref0 (_tmp281_);
		_tmp282_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp283_ = _tmp282_;
		vala_data_type_set_nullable (_tmp283_, FALSE);
	}
	_tmp284_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp285_ = _tmp284_;
	if (_tmp285_ != NULL) {
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		_tmp286_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp287_ = _tmp286_;
		vala_code_node_check ((ValaCodeNode*) _tmp287_, context);
	}
	_tmp288_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp289_ = _tmp288_;
	result = !_tmp289_;
	return result;
}

static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		gint _expr_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_expr_list = _tmp0_;
		_tmp1_ = _expr_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_expr_size = _tmp3_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* expr = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_expr_index = _expr_index + 1;
			_tmp4_ = _expr_index;
			_tmp5_ = _expr_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _expr_list;
			_tmp7_ = vala_list_get (_tmp6_, _expr_index);
			expr = (ValaExpression*) _tmp7_;
			_tmp8_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_initializer_list_class_init (ValaInitializerListClass * klass,
                                  gpointer klass_data)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInitializerList_private_offset);
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}

static void
vala_initializer_list_instance_init (ValaInitializerList * self,
                                     gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_initializer_list_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}

static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}

/**
 * Represents an array or struct initializer list in the source code.
 */
static GType
vala_initializer_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
	GType vala_initializer_list_type_id;
	vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
	ValaInitializerList_private_offset = g_type_add_instance_private (vala_initializer_list_type_id, sizeof (ValaInitializerListPrivate));
	return vala_initializer_list_type_id;
}

GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__once = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__once)) {
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = vala_initializer_list_get_type_once ();
		g_once_init_leave (&vala_initializer_list_type_id__once, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__once;
}

