/*
 * CORBA C language mapping tests
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Mark McLoughlin <mark@skynet.ie>
 */

#include "everything.h"

CORBA_Object dead_reference;

static void
DeadReferenceObj_test (PortableServer_Servant  servant,
		       CORBA_Environment      *ev)
{
	PortableServer_Current poa_current;
	PortableServer_POA     poa;
	CORBA_Object           obj = CORBA_OBJECT_NIL;

	poa_current = (PortableServer_Current)
			CORBA_ORB_resolve_initial_references (global_orb,
							      "POACurrent",
							      ev);

	g_assert (ev->_major == CORBA_NO_EXCEPTION);

	poa = PortableServer_Current_get_POA (poa_current, ev);

	g_assert (ev->_major == CORBA_NO_EXCEPTION);

	obj = PortableServer_POA_servant_to_reference (poa, servant, ev);

	g_assert (ev->_major == CORBA_NO_EXCEPTION);
	g_assert (obj != CORBA_OBJECT_NIL);
}

static PortableServer_ServantBase__epv DeadReferenceObj_base_epv = {
	NULL,
	NULL,
	NULL
};

static POA_test_DeadReferenceObj__epv DeadReferenceObj_epv = {
	NULL,
	DeadReferenceObj_test,
};

static POA_test_DeadReferenceObj__vepv DeadReferenceObj_vepv = {
	&DeadReferenceObj_base_epv,
	&DeadReferenceObj_epv
};

static POA_test_DeadReferenceObj DeadReferenceObj_servant = {
	NULL,
	&DeadReferenceObj_vepv
};
