/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpcontext_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpcontext
 * @title: gimpcontext
 * @short_description: Functions to manipulate a plug-in's context.
 *
 * Functions to manipulate a plug-in's context.
 **/


/**
 * gimp_context_push:
 *
 * Pushes a context to the top of the plug-in's context stack.
 *
 * This procedure creates a new context by copying the current context.
 * This copy becomes the new current context for the calling plug-in
 * until it is popped again using gimp_context_pop().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_push (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-push",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_pop:
 *
 * Pops the topmost context from the plug-in's context stack.
 *
 * This procedure removes the topmost context from the plug-in's
 * context stack. The context that was active before the corresponding
 * call to gimp_context_push() becomes the new current context of the
 * plug-in.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_pop (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-pop",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_defaults:
 *
 * Reset context settings to their default values.
 *
 * This procedure resets context settings used by various procedures to
 * their default value. This procedure will usually be called after a
 * context push so that a script which calls procedures affected by
 * context settings will not be affected by changes in the global
 * context.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_defaults (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-defaults",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_list_paint_methods:
 * @num_paint_methods: The number of the available paint methods.
 * @paint_methods: The names of the available paint methods.
 *
 * Lists the available paint methods.
 *
 * This procedure lists the names of the available paint methods. Any
 * of the results can be used for gimp_context_set_paint_method().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 **/
gboolean
gimp_context_list_paint_methods (gint    *num_paint_methods,
                                 gchar ***paint_methods)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;
  gint i;

  return_vals = gimp_run_procedure ("gimp-context-list-paint-methods",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  *num_paint_methods = 0;
  *paint_methods = NULL;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_paint_methods = return_vals[1].data.d_int32;
      *paint_methods = g_new (gchar *, *num_paint_methods);
      for (i = 0; i < *num_paint_methods; i++)
        (*paint_methods)[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_paint_method:
 *
 * Retrieve the currently active paint method.
 *
 * This procedure returns the name of the currently active paint
 * method.
 *
 * Returns: The name of the active paint method.
 *
 * Since: GIMP 2.4
 **/
gchar *
gimp_context_get_paint_method (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-paint-method",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_paint_method:
 * @name: The name of the paint method.
 *
 * Set the specified paint method as the active paint method.
 *
 * This procedure allows the active paint method to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the available paint methods. If there is no
 * matching method found, this procedure will return an error.
 * Otherwise, the specified method becomes active and will be used in
 * all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 **/
gboolean
gimp_context_set_paint_method (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-paint-method",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_foreground:
 * @foreground: The foreground color.
 *
 * Get the current GIMP foreground color.
 *
 * This procedure returns the current GIMP foreground color. The
 * foreground color is used in a variety of tools such as paint tools,
 * blending, and bucket fill.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_get_foreground (GimpRGB *foreground)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-foreground",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *foreground = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_foreground:
 * @foreground: The foreground color.
 *
 * Set the current GIMP foreground color.
 *
 * This procedure sets the current GIMP foreground color. After this is
 * set, operations which use foreground such as paint tools, blending,
 * and bucket fill will use the new value.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_foreground (const GimpRGB *foreground)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-foreground",
                                    &nreturn_vals,
                                    GIMP_PDB_COLOR, foreground,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_background:
 * @background: The background color.
 *
 * Get the current GIMP background color.
 *
 * This procedure returns the current GIMP background color. The
 * background color is used in a variety of tools such as blending,
 * erasing (with non-alpha images), and image filling.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_get_background (GimpRGB *background)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-background",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *background = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_background:
 * @background: The background color.
 *
 * Set the current GIMP background color.
 *
 * This procedure sets the current GIMP background color. After this is
 * set, operations which use background such as blending, filling
 * images, clearing, and erasing (in non-alpha images) will use the new
 * value.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_background (const GimpRGB *background)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-background",
                                    &nreturn_vals,
                                    GIMP_PDB_COLOR, background,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_default_colors:
 *
 * Set the current GIMP foreground and background colors to black and
 * white.
 *
 * This procedure sets the current GIMP foreground and background
 * colors to their initial default values, black and white.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_default_colors (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-default-colors",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_swap_colors:
 *
 * Swap the current GIMP foreground and background colors.
 *
 * This procedure swaps the current GIMP foreground and background
 * colors, so that the new foreground color becomes the old background
 * color and vice versa.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_swap_colors (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-swap-colors",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_opacity:
 *
 * Get the opacity.
 *
 * This procedure returns the opacity setting. The return value is a
 * floating point number between 0 and 100.
 *
 * Returns: The opacity.
 *
 * Since: GIMP 2.2
 **/
gdouble
gimp_context_get_opacity (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble opacity = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-opacity",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    opacity = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return opacity;
}

/**
 * gimp_context_set_opacity:
 * @opacity: The opacity.
 *
 * Set the opacity.
 *
 * This procedure modifies the opacity setting. The value should be a
 * floating point number between 0 and 100.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_opacity (gdouble opacity)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-opacity",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, opacity,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_paint_mode:
 *
 * Get the paint mode.
 *
 * This procedure returns the paint-mode setting. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The paint mode.
 *
 * Since: GIMP 2.2
 **/
GimpLayerModeEffects
gimp_context_get_paint_mode (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpLayerModeEffects paint_mode = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-paint-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    paint_mode = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return paint_mode;
}

/**
 * gimp_context_set_paint_mode:
 * @paint_mode: The paint mode.
 *
 * Set the paint mode.
 *
 * This procedure modifies the paint_mode setting.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_paint_mode (GimpLayerModeEffects paint_mode)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-paint-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, paint_mode,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush:
 *
 * Retrieve the currently active brush.
 *
 * This procedure returns the name of the currently active brush. All
 * paint operations and stroke operations use this brush to control the
 * application of paint to the image.
 *
 * Returns: The name of the active brush.
 *
 * Since: GIMP 2.2
 **/
gchar *
gimp_context_get_brush (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_brush:
 * @name: The name of the brush.
 *
 * Set the specified brush as the active brush.
 *
 * This procedure allows the active brush to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed brushes. If there is no matching brush found,
 * this procedure will return an error. Otherwise, the specified brush
 * becomes active and will be used in all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_brush (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_pattern:
 *
 * Retrieve the currently active pattern.
 *
 * This procedure returns name of the the currently active pattern. All
 * clone and bucket-fill operations with patterns will use this pattern
 * to control the application of paint to the image.
 *
 * Returns: The name of the active pattern.
 *
 * Since: GIMP 2.2
 **/
gchar *
gimp_context_get_pattern (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_pattern:
 * @name: The name of the pattern.
 *
 * Set the specified pattern as the active pattern.
 *
 * This procedure allows the active pattern to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed patterns. If there is no matching pattern
 * found, this procedure will return an error. Otherwise, the specified
 * pattern becomes active and will be used in all subsequent paint
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_pattern (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_gradient:
 *
 * Retrieve the currently active gradient.
 *
 * This procedure returns the name of the currently active gradient.
 *
 * Returns: The name of the active gradient.
 *
 * Since: GIMP 2.2
 **/
gchar *
gimp_context_get_gradient (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-gradient",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_gradient:
 * @name: The name of the gradient.
 *
 * Sets the specified gradient as the active gradient.
 *
 * This procedure lets you set the specified gradient as the active or
 * \"current\" one. The name is simply a string which corresponds to
 * one of the loaded gradients. If no matching gradient is found, this
 * procedure will return an error. Otherwise, the specified gradient
 * will become active and will be used for subsequent custom gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_gradient (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_palette:
 *
 * Retrieve the currently active palette.
 *
 * This procedure returns the name of the the currently active palette.
 *
 * Returns: The name of the active palette.
 *
 * Since: GIMP 2.2
 **/
gchar *
gimp_context_get_palette (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-palette",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_palette:
 * @name: The name of the palette.
 *
 * Set the specified palette as the active palette.
 *
 * This procedure allows the active palette to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed palettes. If no matching palette is found,
 * this procedure will return an error. Otherwise, the specified
 * palette becomes active and will be used in all subsequent palette
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_palette (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-palette",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_font:
 *
 * Retrieve the currently active font.
 *
 * This procedure returns the name of the currently active font.
 *
 * Returns: The name of the active font.
 *
 * Since: GIMP 2.2
 **/
gchar *
gimp_context_get_font (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-font",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_font:
 * @name: The name of the font.
 *
 * Set the specified font as the active font.
 *
 * This procedure allows the active font to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed fonts. If no matching font is found, this
 * procedure will return an error. Otherwise, the specified font
 * becomes active and will be used in all subsequent font operations.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 **/
gboolean
gimp_context_set_font (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-font",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_antialias:
 *
 * Get the antialias setting.
 *
 * This procedure returns the antialias setting.
 *
 * Returns: The antialias setting.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_get_antialias (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean antialias = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-antialias",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    antialias = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return antialias;
}

/**
 * gimp_context_set_antialias:
 * @antialias: The antialias setting.
 *
 * Set the antialias setting.
 *
 * This procedure modifies the antialias setting. If antialiasing is
 * turned on, the edges of selected region will contain intermediate
 * values which give the appearance of a sharper, less pixelized edge.
 * This should be set as TRUE most of the time unless a binary-only
 * selection is wanted. This settings affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_image_select_round_rectangle(), gimp_image_select_ellipse(),
 * gimp_image_select_polygon(), gimp_image_select_item().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_antialias (gboolean antialias)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-antialias",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, antialias,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_feather:
 *
 * Get the feather setting.
 *
 * This procedure returns the feather setting.
 *
 * Returns: The feather setting.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_get_feather (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean feather = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-feather",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    feather = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return feather;
}

/**
 * gimp_context_set_feather:
 * @feather: The feather setting.
 *
 * Set the feather setting.
 *
 * This procedure modifies the feather setting. If the feather option
 * is enabled, selections will be blurred before combining. The blur is
 * a gaussian blur; its radii can be controlled using
 * gimp_context_set_feather_radius(). This setting affects the
 * following procedures: gimp_image_select_color(),
 * gimp_image_select_contiguous_color(), gimp_image_select_rectangle(),
 * gimp_image_select_round_rectangle(), gimp_image_select_ellipse(),
 * gimp_image_select_polygon(), gimp_image_select_item().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_feather (gboolean feather)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-feather",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, feather,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_feather_radius:
 * @feather_radius_x: The horizontal feather radius.
 * @feather_radius_y: The vertical feather radius.
 *
 * Get the feather radius setting.
 *
 * This procedure returns the feather radius setting.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_get_feather_radius (gdouble *feather_radius_x,
                                 gdouble *feather_radius_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-feather-radius",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  *feather_radius_x = 0.0;
  *feather_radius_y = 0.0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *feather_radius_x = return_vals[1].data.d_float;
      *feather_radius_y = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_feather_radius:
 * @feather_radius_x: The horizontal feather radius.
 * @feather_radius_y: The vertical feather radius.
 *
 * Set the feather radius setting.
 *
 * This procedure modifies the feather radius setting. This setting
 * affects the all procedures that are affected by
 * gimp_context_set_feather().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_feather_radius (gdouble feather_radius_x,
                                 gdouble feather_radius_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-feather-radius",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, feather_radius_x,
                                    GIMP_PDB_FLOAT, feather_radius_y,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_merged:
 *
 * Get the sample merged setting.
 *
 * This procedure returns the sample merged setting.
 *
 * Returns: The sample merged setting.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_get_sample_merged (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean sample_merged = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-merged",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_merged = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_merged;
}

/**
 * gimp_context_set_sample_merged:
 * @sample_merged: The sample merged setting.
 *
 * Set the sample merged setting.
 *
 * This procedure modifies the sample merged setting. If an operation
 * depends on the colors of the pixels present in a drawable, like when
 * doing a seed fill, this setting controls whether the pixel data from
 * the specified drawable is used ('sample-merged' is FALSE), or the
 * pixel data from the composite image ('sample-merged' is TRUE. This
 * is equivalent to sampling for colors after merging all visible
 * layers). This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_sample_merged (gboolean sample_merged)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-merged",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_merged,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_criterion:
 *
 * Get the sample criterion setting.
 *
 * This procedure returns the sample criterion setting.
 *
 * Returns: The sample criterion setting.
 *
 * Since: GIMP 2.8
 **/
GimpSelectCriterion
gimp_context_get_sample_criterion (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpSelectCriterion sample_criterion = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-criterion",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_criterion = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_criterion;
}

/**
 * gimp_context_set_sample_criterion:
 * @sample_criterion: The sample criterion setting.
 *
 * Set the sample criterion setting.
 *
 * This procedure modifies the sample criterion setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls how color
 * similarity is determined. SELECT_CRITERION_COMPOSITE is the default
 * value. This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_sample_criterion (GimpSelectCriterion sample_criterion)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-criterion",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_criterion,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold:
 *
 * Get the sample threshold setting.
 *
 * This procedure returns the sample threshold setting.
 *
 * Returns: The sample threshold setting.
 *
 * Since: GIMP 2.8
 **/
gdouble
gimp_context_get_sample_threshold (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble sample_threshold = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-threshold",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_threshold = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting.
 *
 * This procedure modifies the sample threshold setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls what is
 * \"sufficiently close\" to be considered a similar color. If the
 * sample threshold has not been set explicitly, the default threshold
 * set in gimprc will be used. This setting affects the following
 * procedures: gimp_image_select_color(),
 * gimp_image_select_contiguous_color().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_sample_threshold (gdouble sample_threshold)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-threshold",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, sample_threshold,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold_int:
 *
 * Get the sample threshold setting as an integer value.
 *
 * This procedure returns the sample threshold setting as an integer
 * value. See gimp_context_get_sample_threshold().
 *
 * Returns: The sample threshold setting.
 *
 * Since: GIMP 2.8
 **/
gint
gimp_context_get_sample_threshold_int (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint sample_threshold = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-threshold-int",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_threshold = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold_int:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting as an integer value.
 *
 * This procedure modifies the sample threshold setting as an integer
 * value. See gimp_context_set_sample_threshold().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_sample_threshold_int (gint sample_threshold)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-threshold-int",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_threshold,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_transparent:
 *
 * Get the sample transparent setting.
 *
 * This procedure returns the sample transparent setting.
 *
 * Returns: The sample transparent setting.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_get_sample_transparent (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean sample_transparent = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-transparent",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_transparent = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_transparent;
}

/**
 * gimp_context_set_sample_transparent:
 * @sample_transparent: The sample transparent setting.
 *
 * Set the sample transparent setting.
 *
 * This procedure modifies the sample transparent setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls whether
 * transparency is considered to be a unique selectable color. When
 * this setting is TRUE, transparent areas can be selected or filled.
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_sample_transparent (gboolean sample_transparent)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-transparent",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_transparent,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_interpolation:
 *
 * Get the interpolation type.
 *
 * This procedure returns the interpolation setting. The return value
 * is an integer which corresponds to the values listed in the argument
 * description. If the interpolation has not been set explicitly by
 * gimp_context_set_interpolation(), the default interpolation set in
 * gimprc will be used.
 *
 * Returns: The interpolation type.
 *
 * Since: GIMP 2.8
 **/
GimpInterpolationType
gimp_context_get_interpolation (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpInterpolationType interpolation = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-interpolation",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    interpolation = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return interpolation;
}

/**
 * gimp_context_set_interpolation:
 * @interpolation: The interpolation type.
 *
 * Set the interpolation type.
 *
 * This procedure modifies the interpolation setting. This setting
 * affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix(), gimp_image_scale(),
 * gimp_layer_scale().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_interpolation (GimpInterpolationType interpolation)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-interpolation",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_direction:
 *
 * Get the transform direction.
 *
 * This procedure returns the transform direction. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The transform direction.
 *
 * Since: GIMP 2.8
 **/
GimpTransformDirection
gimp_context_get_transform_direction (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpTransformDirection transform_direction = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-direction",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_direction = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_direction;
}

/**
 * gimp_context_set_transform_direction:
 * @transform_direction: The transform direction.
 *
 * Set the transform direction.
 *
 * This procedure modifies the transform direction setting. This
 * setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_transform_direction (GimpTransformDirection transform_direction)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-direction",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_direction,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_resize:
 *
 * Get the transform resize type.
 *
 * This procedure returns the transform resize setting. The return
 * value is an integer which corresponds to the values listed in the
 * argument description.
 *
 * Returns: The transform resize type.
 *
 * Since: GIMP 2.8
 **/
GimpTransformResize
gimp_context_get_transform_resize (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpTransformResize transform_resize = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-resize",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_resize = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_resize;
}

/**
 * gimp_context_set_transform_resize:
 * @transform_resize: The transform resize type.
 *
 * Set the transform resize type.
 *
 * This procedure modifies the transform resize setting. When
 * transforming pixels, if the result of a transform operation has a
 * different size than the original area, this setting determines how
 * the resulting area is sized. This setting affects affects the
 * following procedures: gimp_item_transform_flip(),
 * gimp_item_transform_flip_simple(),
 * gimp_item_transform_perspective(), gimp_item_transform_rotate(),
 * gimp_item_transform_rotate_simple(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_transform_resize (GimpTransformResize transform_resize)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-resize",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_resize,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_recursion:
 *
 * Get the transform supersampling recursion.
 *
 * This procedure returns the transform supersampling recursion level.
 *
 * Returns: The transform recursion level.
 *
 * Since: GIMP 2.8
 **/
gint
gimp_context_get_transform_recursion (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint transform_recursion = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-recursion",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_recursion = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_recursion;
}

/**
 * gimp_context_set_transform_recursion:
 * @transform_recursion: The transform recursion level.
 *
 * Set the transform supersampling recursion.
 *
 * This procedure modifies the transform supersampling recursion level
 * setting. Whether or not a transformation does supersampling is
 * determined by the interplolation type. The recursion level defaults
 * to 3, which is a nice default value. This setting affects affects
 * the following procedures: gimp_item_transform_flip(),
 * gimp_item_transform_perspective(), gimp_item_transform_rotate(),
 * gimp_item_transform_scale(), gimp_item_transform_shear(),
 * gimp_item_transform_2d(), gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.8
 **/
gboolean
gimp_context_set_transform_recursion (gint transform_recursion)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-recursion",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_recursion,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
