/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalette_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_palette_new:
 * @name: The requested name of the new palette.
 *
 * Creates a new palette
 *
 * This procedure creates a new, uninitialized palette
 *
 * Returns: The actual new palette name.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_palette_new (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp-palette-new",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_palette_duplicate:
 * @name: The palette name.
 *
 * Duplicates a palette
 *
 * This procedure creates an identical palette by a different name
 *
 * Returns: The name of the palette's copy.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_palette_duplicate (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp-palette-duplicate",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_palette_rename:
 * @name: The palette name.
 * @new_name: The new name of the palette.
 *
 * Rename a palette
 *
 * This procedure renames a palette
 *
 * Returns: The actual new name of the palette.
 *
 * Since: GIMP 2.2
 */
gchar *
gimp_palette_rename (const gchar *name,
		     const gchar *new_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *ret_name = NULL;

  return_vals = gimp_run_procedure ("gimp-palette-rename",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_STRING, new_name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_name;
}

/**
 * gimp_palette_delete:
 * @name: The palette name.
 *
 * Deletes a palette
 *
 * This procedure deletes a palette
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_delete (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-delete",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_is_editable:
 * @name: The palette name.
 *
 * Tests if palette can be edited
 *
 * Returns True if you have permission to change the palette
 *
 * Returns: True if the palette can be edited.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_palette_is_editable (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean editable = FALSE;

  return_vals = gimp_run_procedure ("gimp-palette-is-editable",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    editable = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return editable;
}

/**
 * gimp_palette_get_info:
 * @name: The palette name.
 * @num_colors: The number of colors in the palette.
 *
 * Retrieve information about the specified palette.
 *
 * This procedure retrieves information about the specified palette.
 * This includes the name, and the number of colors.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_get_info (const gchar *name,
		       gint        *num_colors)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-get-info",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  *num_colors = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *num_colors = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_get_columns:
 * @name: The palette name.
 *
 * Retrieves the number of columns to use to display this palette
 *
 * This procedures retrieves the prefered number of columns to use when
 * the palette is being displayed.
 *
 * Returns: The number of columns used to display this palette.
 *
 * Since: GIMP 2.4
 */
gint
gimp_palette_get_columns (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint num_columns = 0;

  return_vals = gimp_run_procedure ("gimp-palette-get-columns",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    num_columns = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return num_columns;
}

/**
 * gimp_palette_set_columns:
 * @name: The palette name.
 * @columns: The new number of columns.
 *
 * Sets the number of columns to use when displaying the palette
 *
 * This procedures allows to control how many colors are shown per row
 * when the palette is being displayed. This value can only be changed
 * if the palette is writable. The maximum allowed value is 64.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_palette_set_columns (const gchar *name,
			  gint         columns)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-set-columns",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, columns,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_add_entry:
 * @name: The palette name.
 * @entry_name: The name of the entry.
 * @color: The new entry's color color.
 * @entry_num: The index of the added entry.
 *
 * Adds a palette entry to the specified palette.
 *
 * This procedure adds an entry to the specifed palette. It returns an
 * error if the entry palette does not exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_add_entry (const gchar   *name,
			const gchar   *entry_name,
			const GimpRGB *color,
			gint          *entry_num)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-add-entry",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_STRING, entry_name,
				    GIMP_PDB_COLOR, color,
				    GIMP_PDB_END);

  *entry_num = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *entry_num = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_delete_entry:
 * @name: The palette name.
 * @entry_num: The index of the added entry.
 *
 * Deletes a palette entry from the specified palette.
 *
 * This procedure deletes an entry from the specifed palette. It
 * returns an error if the entry palette does not exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_delete_entry (const gchar *name,
			   gint         entry_num)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-delete-entry",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, entry_num,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_entry_get_color:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @color: The color requested.
 *
 * Gets the specified palette entry from the specified palette.
 *
 * This procedure retrieves the color of the zero-based entry specifed
 * for the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_entry_get_color (const gchar *name,
			      gint         entry_num,
			      GimpRGB     *color)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-entry-get-color",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, entry_num,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *color = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_entry_set_color:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @color: The new color.
 *
 * Sets the specified palette entry in the specified palette.
 *
 * This procedure sets the color of the zero-based entry specifed for
 * the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_entry_set_color (const gchar   *name,
			      gint           entry_num,
			      const GimpRGB *color)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-entry-set-color",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, entry_num,
				    GIMP_PDB_COLOR, color,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_entry_get_name:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @entry_name: The name requested.
 *
 * Gets the specified palette entry from the specified palette.
 *
 * This procedure retrieves the name of the zero-based entry specifed
 * for the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_entry_get_name (const gchar  *name,
			     gint          entry_num,
			     gchar       **entry_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-entry-get-name",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, entry_num,
				    GIMP_PDB_END);

  *entry_name = NULL;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *entry_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_palette_entry_set_name:
 * @name: The palette name.
 * @entry_num: The entry to retrieve.
 * @entry_name: The new name.
 *
 * Sets the specified palette entry in the specified palette.
 *
 * This procedure sets the name of the zero-based entry specifed for
 * the specified palette. It returns an error if the entry does not
 * exist.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.2
 */
gboolean
gimp_palette_entry_set_name (const gchar *name,
			     gint         entry_num,
			     const gchar *entry_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-palette-entry-set-name",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_INT32, entry_num,
				    GIMP_PDB_STRING, entry_name,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
