/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbrushes_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"
#undef GIMP_DISABLE_DEPRECATED
#undef __GIMP_BRUSHES_PDB_H__
#include "gimpbrushes_pdb.h"

/**
 * gimp_brushes_refresh:
 *
 * Refresh current brushes. This function always succeeds.
 *
 * This procedure retrieves all brushes currently in the user's brush
 * path and updates the brush dialogs accordingly.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_brushes_refresh (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-brushes-refresh",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brushes_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_brushes: The number of brushes in the brush list.
 *
 * Retrieve a complete listing of the available brushes.
 *
 * This procedure returns a complete listing of available GIMP brushes.
 * Each name returned can be used as input to the
 * gimp_context_set_brush() procedure.
 *
 * Returns: The list of brush names.
 */
gchar **
gimp_brushes_get_list (const gchar *filter,
                       gint        *num_brushes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **brush_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-brushes-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_brushes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_brushes = return_vals[1].data.d_int32;
      brush_list = g_new (gchar *, *num_brushes);
      for (i = 0; i < *num_brushes; i++)
        brush_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return brush_list;
}

/**
 * gimp_brushes_get_brush:
 * @width: The brush width.
 * @height: The brush height.
 * @spacing: The brush spacing.
 *
 * This procedure is deprecated! Use gimp_context_get_brush() instead.
 *
 * Returns: The brush name.
 */
gchar *
gimp_brushes_get_brush (gint *width,
                        gint *height,
                        gint *spacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-brushes-get-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      name = g_strdup (return_vals[1].data.d_string);
      *width = return_vals[2].data.d_int32;
      *height = return_vals[3].data.d_int32;
      *spacing = return_vals[4].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_brushes_get_spacing:
 *
 * This procedure is deprecated! Use gimp_brush_get_spacing() instead.
 *
 * Returns: The brush spacing.
 */
gint
gimp_brushes_get_spacing (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint spacing = 0;

  return_vals = gimp_run_procedure ("gimp-brushes-get-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    spacing = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return spacing;
}

/**
 * gimp_brushes_set_spacing:
 * @spacing: The brush spacing.
 *
 * This procedure is deprecated! Use gimp_brush_set_spacing() instead.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_brushes_set_spacing (gint spacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-brushes-set-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, spacing,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_brushes_get_brush_data:
 * @name: The brush name (\"\" means current active brush).
 * @opacity: The brush opacity.
 * @spacing: The brush spacing.
 * @paint_mode: The paint mode.
 * @width: The brush width.
 * @height: The brush height.
 * @length: Length of brush mask data.
 * @mask_data: The brush mask data.
 *
 * This procedure is deprecated! Use gimp_brush_get_pixels() instead.
 *
 * Returns: The brush name.
 */
gchar *
gimp_brushes_get_brush_data (const gchar           *name,
                             gdouble               *opacity,
                             gint                  *spacing,
                             GimpLayerModeEffects  *paint_mode,
                             gint                  *width,
                             gint                  *height,
                             gint                  *length,
                             guint8               **mask_data)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *actual_name = NULL;

  return_vals = gimp_run_procedure ("gimp-brushes-get-brush-data",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  *length = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      actual_name = g_strdup (return_vals[1].data.d_string);
      *opacity = return_vals[2].data.d_float;
      *spacing = return_vals[3].data.d_int32;
      *paint_mode = return_vals[4].data.d_int32;
      *width = return_vals[5].data.d_int32;
      *height = return_vals[6].data.d_int32;
      *length = return_vals[7].data.d_int32;
      *mask_data = g_new (guint8, *length);
      memcpy (*mask_data,
              return_vals[8].data.d_int8array,
              *length * sizeof (guint8));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return actual_name;
}
