#! perl
use strict;
use warnings FATAL => 'all';

use CPAN::Meta;
use Path::Tiny;
use Test::More;
use Test::DZil;
use Module::Metadata;

my $tzil = Builder->from_config(
	{ dist_root => 't/does_not_exist' },
	{
		add_files => {
			'source/dist.ini' => simple_ini(
				[ DistBuild => {
						minimum_perl => $],
					}
				],
				'ShareDir',
				'MetaJSON',
			),
		},
	},
);
$tzil->build;

my $VERSION = Dist::Zilla::Plugin::DistBuild->VERSION || '<self>';
my $expected = <<"END";
# This Build.PL for DZT-Sample was generated by Dist::Zilla::Plugin::DistBuild $VERSION.
use strict;
use warnings;


use $];
use Dist::Build 0.019;
Build_PL(\\\@ARGV, \\\%ENV);

END

my $base = path($tzil->built_in);
is($base->child('Build.PL')->slurp, $expected, 'Build.PL is exactly like expected');

my $meta = CPAN::Meta->load_file($base->child('META.json'), { lazy_validation => 0 });
my $configure_requires = $meta->effective_prereqs->requirements_for('configure', 'requires')->as_string_hash;
is_deeply($configure_requires, { 'Dist::Build' => '0.019' }, 'configure requires' );

done_testing;

# vim: set ts=4 sw=4 noet nolist :
