/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.SimpleConstituent;

public class LabeledConstituent
extends SimpleConstituent {
    private Label label;

    public LabeledConstituent() {
    }

    public LabeledConstituent(int start, int end) {
        super(start, end);
    }

    public LabeledConstituent(int start, int end, Label label) {
        super(start, end);
        this.label = label;
    }

    public LabeledConstituent(int start, int end, String stringValue) {
        super(start, end);
        this.label = new StringLabel(stringValue);
    }

    public Label label() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setFromString(String labelStr) {
        this.label = new StringLabel(labelStr);
    }

    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public ConstituentFactory constituentFactory() {
        return ConstituentFactoryHolder.cf;
    }

    public static ConstituentFactory factory() {
        return ConstituentFactoryHolder.cf;
    }

    private static class ConstituentFactoryHolder {
        static final ConstituentFactory cf = new LabeledConstituentFactory();

        private ConstituentFactoryHolder() {
        }

        private static class LabeledConstituentFactory
        implements ConstituentFactory {
            private LabeledConstituentFactory() {
            }

            public Constituent newConstituent(int start, int end) {
                return new LabeledConstituent(start, end);
            }

            public Constituent newConstituent(int start, int end, Label label, double score) {
                return new LabeledConstituent(start, end, label);
            }
        }
    }

    private static class LabelFactoryHolder {
        static final LabelFactory lf = new LabeledConstituentLabelFactory();

        private LabelFactoryHolder() {
        }
    }

    private static class LabeledConstituentLabelFactory
    implements LabelFactory {
        private LabeledConstituentLabelFactory() {
        }

        public Label newLabel(String labelStr) {
            return new LabeledConstituent(0, 0, new StringLabel(labelStr));
        }

        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        public Label newLabelFromString(String labelStr) {
            return this.newLabel(labelStr);
        }

        public Label newLabel(Label oldLabel) {
            return new LabeledConstituent(0, 0, oldLabel);
        }
    }
}

