/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include "zelibm.h"

double
zetanh_diff (double x, double lx)
{
  mpq_t q;
  mpq_t qlm;
  mpq_t sq;
  mpq_t res;
  mpq_t res2;
  mpq_t next;
  mpq_t next2;
  mpq_t nexta;
  unsigned int n = 1;
  int more;

  /* Get the value of X in rational form.  */
  extract_double (q, x);

  /* And the result of the other implementation.  */
  extract_double (qlm, lx);

  /* Initialize the other variables.  */
  mpq_init (res);
  mpq_set (res, q);
  mpq_init (res2);
  mpq_set_ui (res2, 1, 1);
  mpq_init (next);
  mpq_set (next, q);
  mpq_init (next2);
  mpq_set_ui (next2, 1, 1);
  mpq_init (nexta);
  mpq_init (sq);
  mpq_mul (sq, q, q);

  do
    {
      mpq_mul (next, next, sq);
      mpq_mul (next2, next2, sq);
      mpz_mul_ui (mpq_denref (next), mpq_denref (next), 2 * n * (2 * n + 1));
      mpz_mul_ui (mpq_denref (next2), mpq_denref (next2), 2 * n * (2 * n - 1));
      mpq_add (res, res, next);
      mpq_add (res2, res2, next2);
      ++n;

      mpz_abs (mpq_numref (nexta), mpq_numref (next));
      mpz_set (mpq_denref (nexta), mpq_denref (next));
      more = mpq_cmp (nexta, limit) > 0;
      if (!more)
	{
	  mpz_abs (mpq_numref (nexta), mpq_numref (next2));
	  mpz_set (mpq_denref (nexta), mpq_denref (next2));
	  more = mpq_cmp (nexta, limit) > 0;
	}
    }
  while (more);

  mpq_div (res, res, res2);

  /* Subtract the value found with the other implementation.  */
  mpq_sub (res, res, qlm);

  /* Generate the result.  */
  x = mpq_get_d (res);

  /* Clean up.  */
  mpq_clear (q);
  mpq_clear (qlm);
  mpq_clear (sq);
  mpq_clear (res);
  mpq_clear (res2);
  mpq_clear (next);
  mpq_clear (next2);
  mpq_clear (nexta);

  return x;
}
