/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Simple.h>

#include "Plot.h"
#include "Progress.h"


/* Application context.  */
static XtAppContext app_context;
/* The toplevel.  */
static Widget toplevel;
/* The parts of the main window.  */
static Widget vertpane;
static Widget horpane;
static Widget plotwidget;
static Widget progress;
static Widget exitbutton;


static unsigned long int max;
static volatile unsigned long int *c;

static const char *fname;
static double glow, ghigh;
static double *result;

extern void write_image (const char *name, double low, double high,
			 double *r, int n);


static void
term (Widget w, XtPointer d, XtPointer p)
{
  write_image (fname, glow, ghigh, result, *c);
  exit (0);
}


void *
create_window (int *pargc, char *argv[], const char *name,
	       double low, double high, double *maxerror,
	       unsigned long int *counter, unsigned long int n)
{
  float flow = (float) low;
  float fhigh = (float) high;

  /* We need this later.  */
  max = n;

  fname = name;
  glow = low;
  ghigh = high;

#if XtSpecificationRelease >= 6
  toplevel = XtVaOpenApplication
#else
  toplevel = XtVaAppInitialize
#endif
    (&app_context,
     "LibmTest",
     NULL,
     0,
     pargc,
     argv,
     NULL,
#if XtSpecificationRelease >= 6
     sessionShellWidgetClass,
#endif
     NULL);

  vertpane = XtVaCreateManagedWidget
    ("vertpane",
     panedWidgetClass,
     toplevel,
     XtNallowResize, False,
     XtNshowGrip, False,
     NULL);

  plotwidget = XtVaCreateManagedWidget
    ("plot",
     plotWidgetClass,
     vertpane,
     XtNwidth, 640,
     XtNheight, 480,
     XtNlow, *(XtVarArgsList *) &flow,
     XtNhigh, *(XtVarArgsList *) &fhigh,
     XtNmaxptr, maxerror,
     NULL);

  horpane =  XtVaCreateManagedWidget
    ("horpane",
     panedWidgetClass,
     vertpane,
     XtNallowResize, False,
     XtNshowGrip, False,
     XtNorientation, XtorientHorizontal,
     NULL);

  progress = XtVaCreateManagedWidget
    ("progress",
     progressWidgetClass,
     horpane,
     XtNwidth, 120,
     XtNheight, 30,
     XtNcounter, counter,
     XtNmax, n,
     NULL);

  exitbutton = XtVaCreateManagedWidget
    ("exit",
     commandWidgetClass,
     horpane,
     XtNlabel, "Exit",
     NULL);
  XtAddCallback
    (exitbutton,
     XtNcallback, term,
     (XtPointer) NULL);

  XtRealizeWidget (toplevel);

  return NULL;
}


static void
timeout (XtPointer p, XtIntervalId *i)
{
  static unsigned long int last;
  unsigned long int nc = *c;

  progress_update ((ProgressWidget) progress);

  if (last < nc)
    {
      plot ((PlotWidget) plotwidget, result, last, nc);
      last = nc;
    }

  if (last < max)
    XtAppAddTimeOut (app_context, 500, timeout, NULL);
}


void
display_loop (void *handle, volatile unsigned long int *counter,
	      double *r)
{
  c = counter;
  result = r;

  XtAppAddTimeOut (app_context, 500, timeout, NULL);

  XtAppMainLoop (app_context);
}
