/* -*- mode: C; c-file-style: "bsd"; tab-width: 4 -*- */
/* strokedata.h - character data included by bootdata.c.
 * JStroke 1.x - Japanese Kanji handwriting recognition technology demo.
 *  GNU Copyright (C) 2003  Gaspar Sinai <gsinai@yudit.org>  
 * Copyright (C) 1997  Robert E. Wells
 * http://wellscs.com/pilot
 * mailto:robert@wellscs.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.html); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See readme.txt, changelo, and gpl.html for more information.
 *
 * Commentary:
 *
 * The data in this file was generated via an earlier version of the
 * compact.pl perl script, from the StrokeDic.txt file from Todd Rudick.

 * Character data. This is a special header file that is included
 * in "bootdata.c" to create the Pilot database, but is also parsed
 * directly by a Perl script in KanjiPad to create its database. For this
 * reason, all lines with the first character '"' _must_ be character
 * data. In the future, maybe change KanjiPad to work from StrokeDic.txt
 * directly. owt 090497.
 *
 * ------------------------------------------------------------------------- */
#ifndef __STROKEDATA_H__
#define __STROKEDATA_H__

#ifdef FOR_STROKEDIC_CREATE_1

CharPtr LoadStrokeDicPtr(void) {
	return 
	"A\210\352F\n"
    "A\211\263Faf\n"
    "B\213\343JFl\n"
    "B\216\265FL\n"
    "B\217\134FB|b1-y2\n"
    "B\220\154JC|y2-y1! x1-x2!\n"
    "B\222\232FB|b2-b1\n"
    "B\223\201MgJ|b2-y1\n"
    "B\223\361FF\n"
    "B\223\374AC|x1-x2! y1-y2!\n"
    "B\224\252AC|x2-x1! y1-y2\n"
    "B\226\224FaC\n"
    "B\227\271FaBg\n"
    "B\227\315MgJ|y1-y2\n"
    "C\211\272FBC|i3-x2\n"
    "C\212\261FFB\n"
    "C\212\333JFlC|x1-x2\n"
    "C\213\166AFaC|x3-x2\n"
    "C\213\171JFafaC\n"
    "C\213\174MFBmg\n"
    "C\214\310MFL\n"
    "C\214\373BMF\n"
    "C\215\110FBF|b2-b1 l3-l1\n"
    "C\215\313FBA\n"
    "C\216\117FFF\n"
    "C\216\122BLB\n"
    "C\216\155FBF|b1-y2 l1-l3\n"
    "C\216\161FaBgF\n"
    "C\216\331AMgC\n"
    "C\217\227AcJF\n"
    "C\217\254BAC\n"
    "C\217\343BFF\n"
    "C\217\344FJC|x2-x3\n"
    "C\220\156MgJC\n"
    "C\220\241FBC|x2-i3\n"
    "C\220\347AFB\n"
    "C\220\354JBB\n"
    "C\221\345FJC|x3-i2\n"
    "C\223\171FBF|b1-y2 l3-l1\n"
    "C\226\123BFL\n"
    "C\226\175JFlC|x3-x1\n"
    "C\226\234FMgJ\n"
    "C\226\347MgBL\n"
    "C\227\133AFaC|l1-l3\n"
    "C\227\136FBmgF\n"
    "D\210\344FFJB\n"
    "D\210\370MFBfbdB\n"
    "D\211\135FFAfC\n"
    "D\211\176BMBF\n"
    "D\211\244FBFF\n"
    "D\211\273ABAL\n"
    "D\211\316CAJC\n"
    "D\211\356ACJB\n"
    "D\212\240ACBB\n"
    "D\213\215AFFB|b1-y4\n"
    "D\213\245ACLB\n"
    "D\213\322AJFB|a1-x2\n"
    "D\213\346FACL\n"
    "D\214\207AFaJC\n"
    "D\214\216JMFF|j2-y4! j1-y4! x1-i1 j1-b4 j2-b4\n"
    "D\214\242FJCC|b1-b4\n"
    "D\214\263FFJL\n"
    "D\214\266AcAfCM\n"
    "D\214\313FMFJ\n"
    "D\214\334FBMF\n"
    "D\214\337AFFB|b4-b2\n"
    "D\214\366ACAfC\n"
    "D\215\105FaBgIL\n"
    "D\215\206BMFFbmg\n"
    "D\215\241ACFFa\n"
    "D\216\170FBFaC\n"
    "D\216\176BFBF\n"
    "D\216\201ABiFK\n"
    "D\216\332MFJC\n"
    "D\216\350AFFB|a1-x2\n"
    "D\217\241AJFB|x2-i1\n"
    "D\217\255BACA\n"
    "D\217\347BFaJFl\n"
    "D\220\123ALCC\n"
    "D\220\155ABFF\n"
    "D\220\205FaBAC\n"
    "D\220\330FLFjJ\n"
    "D\221\157FjCFjK\n"
    "D\221\276FJCC|b4-b1\n"
    "D\222\117JMCF\n"
    "D\222\206BMFB\n"
    "D\222\242MFBmgB\n"
    "D\223\126FFJC|l1-l2\n"
    "D\223\154CCFB\n"
    "D\223\324ALBL\n"
    "D\223\340BMJC\n"
    "D\223\372BMFF|y4-b1! j4-b2!\n"
    "D\224\275FJFaC|a1-x2\n"
    "D\224\344FLAL\n"
    "D\225\103FJLL\n"
    "D\225\163FABC\n"
    "D\225\166FFJC|b1-y3\n"
    "D\225\203ACJC\n"
    "D\225\247ABAfC\n"
    "D\225\252ACMgJ\n"
    "D\225\266BFJK|x3-x4!\n"
    "D\225\320JBFM\n"
    "D\225\373BFMgJ\n"
    "D\226\122ABFaCf\n"
    "D\226\122ABFaIcf\n"
    "D\226\321AFFL\n"
    "D\226\330FBAC\n"
    "D\226\346AMgAC\n"
    "D\226\357FJMgL\n"
    "D\227\106FJFaC|b1-y2 x2-x1\n"
    "D\227\134FaCFaBg\n"
    "D\230\132BFAC|x4-x3!\n"
    "D\230\274ABMJ\n"
    "E\210\263FJFBF|b3-y4\n"
    "E\210\310BICAC\n"
    "E\211\105JFBMF\n"
    "E\211\151CFbFaAC\n"
    "E\211\232MfBFLB\n"
    "E\211\233BMFJC|x5-i4\n"
    "E\211\301FjJBMF\n"
    "E\211\302FBMFB\n"
    "E\212\117JFjCBC\n"
    "E\212\216BMFFF|l5-l4 i1-x5! i5-i2!\n"
    "E\212\247FFBBB\n"
    "E\212\303FBBFF\n"
    "E\213\165ABFBF\n"
    "E\213\214BBMFF\n"
    "E\213\216FBFAfC\n"
    "E\213\220BFMFF\n"
    "E\213\312FBFFC\n"
    "E\213\345AMgBMF\n"
    "E\214\132BMFJL\n"
    "E\214\212BBFaAC\n"
    "E\214\272BFAcAfC\n"
    "E\214\303FBBMF\n"
    "E\214\367FBIFaJ\n"
    "E\215\111FBIFBmg|y3-j2\n"
    "E\215\114BFJAfC\n"
    "E\215\142BMFFB|b5-y3\n"
    "E\215\236ACCFacaCf\n"
    "E\215\266FJFBF|b4-b3\n"
    "E\215\373BMBBF|j1-y5\n"
    "E\216\104FBACL\n"
    "E\216\115BMBBF|y5-b1\n"
    "E\216\144ABFBF|y5-y3\n"
    "E\216\151MFBMF\n"
    "E\216\152BMFJC|x4-x5 y5-y3\n"
    "E\216\154BMJLF\n"
    "E\216\163BFBMB\n"
    "E\216\246FFBAC|l2-l1 y3-y1\n"
    "E\216\266BMFAL\n"
    "E\216\270AFFJC|y2-y4\n"
    "E\216\312BFaFBmgF\n"
    "E\216\345CFBFF\n"
    "E\216\372BMJCF\n"
    "E\216\373BBIFjC\n"
    "E\217\140CCIFB\n"
    "E\217\157BLBLB\n"
    "E\217\210AFaCJFl\n"
    "E\217\242MgJBMF\n"
    "E\220\113MFJJFl\n"
    "E\220\134BMFFB|y1-y5\n"
    "E\220\242FBBFL\n"
    "E\220\263FBFBF\n"
    "E\220\266AFBFF\n"
    "E\220\313AJFBC\n"
    "E\220\316FJBMF\n"
    "E\220\345ABBLB\n"
    "E\220\350BFBMF\n"
    "E\221\274ABMBL|y3-y5\n"
    "E\221\305FBIFB|j2-y3 y1-y2\n"
    "E\221\343ABFKC\n"
    "E\221\344AfCBMF\n"
    "E\222\241BFJFB\n"
    "E\223\143BMBFF|b3-y1\n"
    "E\223\172BcJFFjC\n"
    "E\223\176AFaCCC\n"
    "E\223\312FBMfLB\n"
    "E\223\362MFJAL\n"
    "E\224\222ABMFF\n"
    "E\224\274CAFFB\n"
    "E\224\306ACbAML\n"
    "E\224\347JFaBFaC\n"
    "E\225\113CALAC\n"
    "E\225\130BCFjAC\n"
    "E\225\164ABFBC\n"
    "E\225\172JFBMB\n"
    "E\225\245FBIAfC|j2-y3\n"
    "E\225\270FBMJC\n"
    "E\225\275FCAFB\n"
    "E\225\323MgJCFacaCf\n"
    "E\225\331AfCFJB\n"
    "E\225\352AcMCCF\n"
    "E\225\357AMgMFL\n"
    "E\226\153FBIAL\n"
    "E\226\173FBACF\n"
    "E\226\226FFBAC|l1-l2\n"
    "E\226\242FFBAC|l2-l1\n"
    "E\226\257MFBiFK\n"
    "E\226\265FaCFaBA\n"
    "E\226\274AFaBMF\n"
    "E\226\332BMFFF\n"
    "E\226\356AFFJC|b4-y2\n"
    "E\227\122BMBFF|y1-y3\n"
    "E\227\143AcAfCFjJ\n"
    "E\227\160JMFFB\n"
    "E\227\247BFCAF\n"
    "E\227\337ACCFaC\n"
    "E\227\337ACFMgB\n"
    "E\227\347BFaBCL\n"
    "F\210\265FBIJFafaK|j2-y3\n"
    "F\210\300BBFaBcJF\n"
    "F\210\337BFABiAC\n"
    "F\210\360FBBFFB\n"
    "F\210\363ABFFMB\n"
    "F\210\366BMFJCF\n"
    "F\211\106BBFaFFB\n"
    "F\211\110MCIMCI\n"
    "F\211\120ABMFFF|x3-x2\n"
    "F\211\230CCIFFBm\n"
    "F\211\274ABFJFjC\n"
    "F\211\357ACFFAfC\n"
    "F\211\361BMBMFF\n"
    "F\212\104FJBAJC\n"
    "F\212\145AFaCBMF\n"
    "F\212\276CCIFFB\n"
    "F\212\312AFFBLB\n"
    "F\212\351ACBFBF\n"
    "F\212\353AFaFJMgL\n"
    "F\212\367FBACJFl\n"
    "F\213\103AFFFkAC\n"
    "F\213\147FBFBMF\n"
    "F\213\170ABFBAC\n"
    "F\213\172BMFJFafaC\n"
    "F\213\200FBACFBmg\n"
    "F\213\244FBBFAC\n"
    "F\213\251BMFBFB\n"
    "F\213\302ABABiMB\n"
    "F\213\310BMBBFF\n"
    "F\214\131FFJBBB\n"
    "F\214\214ABMBBF\n"
    "F\214\217ABAFFB\n"
    "F\214\360BFACAC|b6-b1!\n"
    "F\214\365BCAFJL\n"
    "F\214\374ABMBMF\n"
    "F\215\100AJFBMF\n"
    "F\215\104BcJFFaBF\n"
    "F\215\106FBFAFabgF\n"
    "F\215\135CCIFBF\n"
    "F\215\154FBFAALbg\n"
    "F\215\163AABFFB\n"
    "F\215\207ACFBMF\n"
    "F\215\304FBMBFF\n"
    "F\215\335FJBFBF\n"
    "F\216\174ALBMFF\n"
    "F\216\200FAFaCAL\n"
    "F\216\205AcAfCBAC\n"
    "F\216\212FAfCFBF\n"
    "F\216\232BBFaFaBgF\n"
    "F\216\233FBFFBC\n"
    "F\216\237CIAFaJK\n"
    "F\216\247FABMBB\n"
    "F\216\250FBFFIB\n"
    "F\216\251ABMFFF|y5-y4\n"
    "F\216\256FFBIKC\n"
    "F\216\305FBBBFaCf\n"
    "F\216\305FBBBFaIcf\n"
    "F\216\347BBFaFBC\n"
    "F\216\351AFFBAC|b6-b1!\n"
    "F\217\102AJCBCB\n"
    "F\217\115AJMCBF\n"
    "F\217\133BFAfCJL\n"
    "F\217\173AMgBMFF\n"
    "F\217\204AcAcAcCFacaCf\n"
    "F\217\240FAJFBL\n"
    "F\217\257BFJFBF\n"
    "F\220\106AFaMBFL\n"
    "F\220\163MFJCCC\n"
    "F\220\166FkFBCFacaCf\n"
    "F\220\254JFMgKAC\n"
    "F\220\274FBMJLF\n"
    "F\220\343AFBBMF\n"
    "F\220\346AFBFJL\n"
    "F\221\123ACFBFF\n"
    "F\221\163BCIFBF\n"
    "F\221\201BMFFFB\n"
    "F\221\210AFaMFFB\n"
    "F\221\266FJBFaBgF\n"
    "F\221\275AFaCAFaC\n"
    "F\221\356BBFaAFL\n"
    "F\222\143BMFBCF\n"
    "F\222\156FBFMBL\n"
    "F\222\162CCIFbBL\n"
    "F\222\174AFBAFB\n"
    "F\222\207ABBMFB\n"
    "F\222\216BMFBIC\n"
    "F\222\233JCILAC\n"
    "F\222\322FBCCFacaCf\n"
    "F\223\140ABFFAfC\n"
    "F\223\146BMFFBF\n"
    "F\223\224BIJCFBg\n"
    "F\223\226BCAMFF\n"
    "F\223\257BMFBMF\n"
    "F\223\363FFFIKC\n"
    "F\223\367BMJCAC\n"
    "F\224\100BcJFBMF\n"
    "F\224\103ABAFBF\n"
    "F\224\116AFFBFB\n"
    "F\224\247JMFFJFl\n"
    "F\224\260ABFCAC\n"
    "F\224\277BMBJFlC\n"
    "F\224\334BcJFMFL\n"
    "F\225\123FABMFF\n"
    "F\225\232ABFJCC\n"
    "F\225\304CAFBAC\n"
    "F\226\132BACBFL\n"
    "F\226\160FBACBC\n"
    "F\226\210AFAfMBF\n"
    "F\226\222BFJBAC|b6-b1!\n"
    "F\226\317BFLAcJF\n"
    "F\227\114JFBMFF\n"
    "F\227\162CAFFFB\n"
    "F\227\231FBMFJC\n"
    "F\227\274FBMBLB\n"
    "F\227\361FJFaCBB\n"
    "F\227\362BACAMgJ\n"
    "F\230\152FBMFFF\n"
    "G\210\237FBMFBBF\n"
    "G\210\312ABBFCAF\n"
    "G\210\315BMFFJBF\n"
    "G\210\343FAFFJCL\n"
    "G\210\353FBFBFaAL\n"
    "G\211\236BFJALCC\n"
    "G\211\253CCIBMFB\n"
    "G\211\275ABFBMFB\n"
    "G\211\324FBBABAL\n"
    "G\211\344AFBIKAC\n"
    "G\211\365BACMFJC\n"
    "G\211\372FFJBKAC\n"
    "G\211\374MFLAFJK\n"
    "G\212\114BMFFFAC\n"
    "G\212\160AFaJMBFF\n"
    "G\212\256BBFaFFJL\n"
    "G\212\314JMFFFFB\n"
    "G\212\334ACFFaBMF\n"
    "G\212\362BLBFBFaC\n"
    "G\212\363ACAFBMB\n"
    "G\212\365MFLALCC\n"
    "G\213\104CCIAFFFk\n"
    "G\213\132FBIFBFaC|j2-y3\n"
    "G\213\160FBFAfCMgB\n"
    "G\213\201FBCIACC\n"
    "G\213\206BBFaJLJFl\n"
    "G\213\266ABgAFBFF\n"
    "G\213\307MFJMgBMF\n"
    "G\213\317FBIJMCI\n"
    "G\213\337AJFBCFacaCf\n"
    "G\213\341BMFACFM\n"
    "G\214\116MFFJBMF\n"
    "G\214\140FFJBAAA\n"
    "G\214\156AAcAfCBAC\n"
    "G\214\174FBBFFAfC\n"
    "G\214\175ABiMgBCFacaCf\n"
    "G\214\210CCIMFJC\n"
    "G\214\251BMFFFJL\n"
    "G\214\276CFFFBMF\n"
    "G\214\340BMFBmFAC\n"
    "G\215\102FBIBFJFl\n"
    "G\215\107BBFaFJAfC\n"
    "G\215\122FBIBFJFl|j2-y3\n"
    "G\215\125FBIAFJK\n"
    "G\215\130FBMFFJC\n"
    "G\215\216FBBMFJL\n"
    "G\215\220AFBFBMF\n"
    "G\215\242BMFBACF\n"
    "G\215\262ABFJFBF\n"
    "G\215\320AcAcAcCAJC\n"
    "G\215\336FBACFBA\n"
    "G\215\342FBIFJFaC\n"
    "G\215\343FaCaBFJFaC\n"
    "G\215\354ABAFBFF\n"
    "G\216\146ABMFBMF\n"
    "G\216\165FBFALCC\n"
    "G\216\204AFBACAfC|y6-y7 i6-x7!\n"
    "G\216\227ABBICJC\n"
    "G\216\231BBMFFJL\n"
    "G\216\320BFaBCFBF\n"
    "G\216\324FBMFFFB\n"
    "G\216\365FFFJFBC\n"
    "G\217\107AFBACJMmg\n"
    "G\217\132ABCFBFF\n"
    "G\217\211BFaBACMgA\n"
    "G\217\225BMFFIMgJ\n"
    "G\217\230BFJFaCFaBg\n"
    "G\217\260BFJFBAC\n"
    "G\217\264FBIBACA|j2-y3\n"
    "G\217\321BACBMFF\n"
    "G\217\360AFaCFBAC\n"
    "G\217\363BCIFJCC\n"
    "G\220\114ABBMFFB\n"
    "G\220\142BFBMFBF\n"
    "G\220\147ABMFFIA\n"
    "G\220\150BFCAFFB\n"
    "G\220\175BMCCACF\n"
    "G\220\201BMFAFaJK\n"
    "G\220\231FBACAAA\n"
    "G\220\272FBFMBFJ\n"
    "G\220\324FBFJBAC\n"
    "G\220\334FBIAJFB|j2-y3\n"
    "G\221\226FBFBFJC\n"
    "G\221\246MFFBiCMgB\n"
    "G\221\251FBMFBAC\n"
    "G\221\253BMFBFJC\n"
    "G\221\272FBACFBC\n"
    "G\221\303ACCAAcJF\n"
    "G\221\314ABFBACF\n"
    "G\221\316BFJCFBC\n"
    "G\221\360FBIMFJC|j2-y3\n"
    "G\221\362CCIJMFC\n"
    "G\222\101ABBMFFF\n"
    "G\222\112ACACBMF\n"
    "G\222\152BMBFFMgJ\n"
    "G\222\254BMBFFFBg\n"
    "G\222\276CCIBFaJL\n"
    "G\222\341ABABiFKF\n"
    "G\222\346BMFFBFF|y4-j2\n"
    "G\222\354AFBFFaFaCf\n"
    "G\222\355CAMFBmgBA\n"
    "G\223\167AcAFFaCMgJ\n"
    "G\223\212FBIJFlFaC|j2-y3\n"
    "G\223\244FBMFCAF\n"
    "G\223\337MFFJFaCdB\n"
    "G\224\101MFJBFaAC\n"
    "G\224\104BcJFAFBF\n"
    "G\224\105MgJCALCC\n"
    "G\224\143FBIMBFL|j2-y3\n"
    "G\224\204FBFBFaJL\n"
    "G\224\214ABABMFF\n"
    "G\224\236FBFFAFaC\n"
    "G\224\262FBIFJFaC|j2-y3\n"
    "G\224\272ABCAFFB\n"
    "G\224\273CAFFBBB\n"
    "G\224\333FABCBMF\n"
    "G\224\341FBIFBiAL|j2-y3\n"
    "G\224\354JMFFMBL\n"
    "G\224\366MFJAFFL\n"
    "G\225\175FBIFFJC|j2-y3\n"
    "G\225\272ABFBFAC\n"
    "G\225\312BMFMgABB\n"
    "G\225\324FJFaCCFacaCf\n"
    "G\225\341FBMFFBC\n"
    "G\226\106FBBBFMgJ\n"
    "G\226\115FFFJFaCdB\n"
    "G\226\126FBIBFFbgJ\n"
    "G\226\127BcJFBFFbgJ\n"
    "G\226\131BFLBLCC\n"
    "G\226\150FaCaBBFFbgJ\n"
    "G\226\166CCIJFlFaC\n"
    "G\226\230AFFlCCFacaCf\n"
    "G\226\255BcJFBACA\n"
    "G\226\337FMFJFJC\n"
    "G\226\360AABJFlFaC\n"
    "G\227\135ACFFBAC\n"
    "G\227\175FBIABiMB|j2-y3\n"
    "G\227\210FCAFBAC\n"
    "G\227\220AFBBMFL\n"
    "G\227\221ABiCJFbgBC\n"
    "G\227\230AFBACBB|y7-y6 x7-i6!\n"
    "G\227\242BMFFBFF|j2-y3\n"
    "G\227\307BMFFBiAC\n"
    "G\227\342CIACCFaC\n"
    "G\227\342CIACFMB\n"
    "G\227\343FJFMgJMgJ\n"
    "G\230\112CCABFaMgJ\n"
    "G\343\350JMFFFBF\n"
    "H\210\266BBFaAFaCML\n"
    "H\210\313ABBFABiAK\n"
    "H\210\317AFBACAcJF\n"
    "H\210\325BMFFAMgAA\n"
    "H\210\347BFAfCBMFF\n"
    "H\211\112FBMBCCCC\n"
    "H\211\152CCICFbgFaAC\n"
    "H\211\160FBBBMFJC\n"
    "H\211\204ABFBFFaFaC\n"
    "H\211\210CCIACBMF\n"
    "H\211\212CAJCCAJC\n"
    "H\211\221FBBJFaCML\n"
    "H\211\235AABCFBFF\n"
    "H\211\237FBIBMFFB|j2-y3\n"
    "H\211\242FJCLAFaJC\n"
    "H\211\243FJCLJLFaC\n"
    "H\211\252BMCAFBLB\n"
    "H\211\277ABFBMBBF\n"
    "H\211\300ABFBFFBF\n"
    "H\211\312BMFFFBAC|y5-y3\n"
    "H\211\315CCIFBMFB\n"
    "H\211\346FBMBFFLB\n"
    "H\211\350FBBFBFBA\n"
    "H\211\366ACBFaCFBF\n"
    "H\211\373FBIBMFFbgJ|j2-y3\n"
    "H\212\116BFAcAACMgJ\n"
    "H\212\147FBIBFJAfC|j2-y3\n"
    "H\212\167CCABFaFaBgF\n"
    "H\212\170ABFBFBLB\n"
    "H\212\257BBFaBMFMF\n"
    "H\212\335BLBFJFFB\n"
    "H\212\342BLBFJBMF\n"
    "H\212\357FJCFBMFB\n"
    "H\213\106BFaBCAJFB\n"
    "H\213\107AFBACFaBgF\n"
    "H\213\130BBFaBMFFF\n"
    "H\213\203CCIBFCAF\n"
    "H\213\217MFJFBBMF\n"
    "H\213\221FBIBFMFF|j2-y3\n"
    "H\213\222FBIJFjKJFl|j2-y3\n"
    "H\213\235BFBMFFaBgC\n"
    "H\213\236BFBMFBAC\n"
    "H\213\237ABFBBFAC\n"
    "H\213\246FBMJMJMJ\n"
    "H\213\254BLBFCAJC\n"
    "H\213\265CCIBMFJL\n"
    "H\213\340ACFFBCAF\n"
    "H\213\352FBBFBBMF\n"
    "H\213\357BMFFFFAC\n"
    "H\213\363BBFaJLFBF\n"
    "H\213\374MFJBLBLB\n"
    "H\214\141AABFaCFBF\n"
    "H\214\163FBBFaCFBF\n"
    "H\214\224CAFFJCMgJ\n"
    "H\214\250FMFJBMFF\n"
    "H\214\267MFLbgBFAcAfC\n"
    "H\214\304BMFACAFBg\n"
    "H\214\305BMFBBMFF\n"
    "H\214\325BFJFaFLJL\n"
    "H\214\370BFACJCMgJ\n"
    "H\215\113FBFCAFFB\n"
    "H\215\123FBIAMgBMF|j2-y3\n"
    "H\215\126BMFFABiMgB\n"
    "H\215\155BFBFBMFF\n"
    "H\215\217BFAcAACBB\n"
    "H\215\221BMFBFFCF\n"
    "H\215\251BMFFFBiAL\n"
    "H\215\310FMFFBAcJF\n"
    "H\215\343BcJFAfCBMF\n"
    "H\215\374MFJBMBBB\n"
    "H\216\121AfCFJCAAA\n"
    "H\216\147ABFBMFJC\n"
    "H\216\150FBMBACBB\n"
    "H\216\157BcJFBFBMB\n"
    "H\216\175FBACFBFjK\n"
    "H\216\203BFaBCBFBF\n"
    "H\216\210JMFFFBFaC\n"
    "H\216\226FBMFMFFB\n"
    "H\216\230ABFBFFBC\n"
    "H\216\241CCIAfCBMF\n"
    "H\216\300BBFaFFFJC\n"
    "H\216\311ACFBFBMF\n"
    "H\216\322FBFABMFF\n"
    "H\216\327FBFBAFaCdB\n"
    "H\216\341FBBJFBMF\n"
    "H\216\346FBFFIBFaC\n"
    "H\216\363ACCABFaFaC\n"
    "H\216\374JMFBFBMF\n"
    "H\217\100BBFaFFBAC\n"
    "H\217\146BFFBACFjK\n"
    "H\217\161FBACCCFacaCf\n"
    "H\217\212FMFJAJFB\n"
    "H\217\256BCABMBMF\n"
    "H\217\263FaBFFFFaAC\n"
    "H\217\265FBIFbgJBMF|j2-y3\n"
    "H\217\270BMFFAJFB\n"
    "H\217\274FBACACAfC\n"
    "H\217\300CCIMJBMF\n"
    "H\220\202AFFBBFBF\n"
    "H\220\206CAJCAFaJC\n"
    "H\220\225FBACFACL\n"
    "H\220\247AFFBMBBB\n"
    "H\220\251BcJFAFBFF\n"
    "H\220\252AABFBFBF\n"
    "H\220\253ACBAFBFF\n"
    "H\220\302FBFFBMFF\n"
    "H\220\304BFACJFFB\n"
    "H\220\314FBBFBMFF\n"
    "H\220\315FBACAJFB\n"
    "H\220\331FBIBLBLB|j2-y3\n"
    "H\221\152FaCdBBMFFF\n"
    "H\221\262BFACACFB\n"
    "H\221\354BFBMFFFB\n"
    "H\221\361FBIFJBMF|j2-y3\n"
    "H\222\123FBIBMFFF|j2-y3\n"
    "H\222\155AFFJCBMF\n"
    "H\222\210BBFaBMBFF\n"
    "H\222\211BMFBALCC\n"
    "H\222\212FBIBMBFF|j2-y3\n"
    "H\222\215CCICFBFF\n"
    "H\222\267BFFFFBiAC\n"
    "H\222\274FBBMFFFL\n"
    "H\222\330FBIFCAFB\n"
    "H\222\350BBFaFBFJC\n"
    "H\222\352BFJABiFCF\n"
    "H\222\357FBIABiFCF|j2-y3\n"
    "H\223\100ABiFCFFaCdB\n"
    "H\223\104CCIMFJAL\n"
    "H\223\111ABMFFAMgC\n"
    "H\223\122AFFJCCFacaCf\n"
    "H\223\124BMBBFFAC\n"
    "H\223\130BFJBFBMF\n"
    "H\223\214FBMFFBAC\n"
    "H\223\236FAfCFBIBB\n"
    "H\223\305FBFFAfMBF\n"
    "H\223\313BBFaJLFJK\n"
    "H\223\315MFJBMBFF\n"
    "H\223\373ACCAFaBgIL\n"
    "H\224\117ACFFaBLCC\n"
    "H\224\147CCIJFaBFaC\n"
    "H\224\161FBIFFFFB|j2-y3\n"
    "H\224\164FBACFABC\n"
    "H\224\217FBIABMFF|j2-y3\n"
    "H\224\221CCIABMFF\n"
    "H\224\227ABMFFCFacaCf\n"
    "H\224\302FBACFJFjK\n"
    "H\224\305JBFMFJFaC\n"
    "H\224\336AABJFaBFaC\n"
    "H\224\342FBIJFaBFaC|j2-y3\n"
    "H\224\345CCICJKCC\n"
    "H\224\361JFFIBFFF\n"
    "H\225\134FBFFABiAC\n"
    "H\225\143FBBBMBFF\n"
    "H\225\173BFJABFBC\n"
    "H\225\174ACBAFBMB\n"
    "H\225\215FaCdBABFBC\n"
    "H\225\216ABAFLMFB\n"
    "H\225\220FFBFBIKC\n"
    "H\225\236JMFFBMFaC\n"
    "H\225\246CCIMFBmgJB\n"
    "H\225\250AFBIAMgAA\n"
    "H\225\271ABCAFFJB\n"
    "H\225\300CAFBBCAF\n"
    "H\225\340BFBFBACA\n"
    "H\225\362FFFJCFFB\n"
    "H\225\363BBFaFBFFC\n"
    "H\225\370FBIAMgMFL|j2-y3\n"
    "H\225\372BFMgJAFJK\n"
    "H\226\100CCIFBFAfC\n"
    "H\226\101CCIAMMFL\n"
    "H\226\133FMFJBFMgJ\n"
    "H\226\142JMFFBFMgJ\n"
    "H\226\161AFBIAFJC\n"
    "H\226\172FJCFBFJB\n"
    "H\226\205BcJFFFBAC\n"
    "H\226\207FBACAFJK\n"
    "H\226\225FBIFFBAC|j2-y3\n"
    "H\226\241BMFFFBAC|a6-a3\n"
    "H\226\246BLBBMFFB\n"
    "H\226\275ACFBMFMB\n"
    "H\226\276BMFFJMFF\n"
    "H\226\306AFaBMBFJL\n"
    "H\226\316FBBJFKAC\n"
    "H\226\323BFLBMFFF\n"
    "H\226\345BMFFBMFF\n"
    "H\226\351BFABAFaCC\n"
    "H\226\373CCIBMBFF\n"
    "H\227\321FBACFBAC\n"
    "H\227\341ABFJFaCBB\n"
    "H\230\106CAJCFMFJ\n"
    "H\230\141AFBACBMF\n"
    "H\230\147FBACJFlFB\n"
    "H\237\251CCIBCAJL\n"
    "H\347\214BMBFFCFacaCf\n"
    "I\210\243BFBMFABiAC\n"
    "I\210\320JFFAcAFKAC\n"
    "I\210\327CAMMMACCC\n"
    "I\210\335BMBFFBMFF\n"
    "I\210\367BcJFBMFJCF\n"
    "I\211\146BMFFBMFJC\n"
    "I\211\150CCABFaFBAC\n"
    "I\211\165BFJCIJFlFaC\n"
    "I\211\256MFJFAfCFBF\n"
    "I\211\265AFFBFBIMB\n"
    "I\211\271BFCAFBMFF\n"
    "I\211\310AFBACCCFB\n"
    "I\211\313MgJBMFFBAC\n"
    "I\211\367ACBAFJfMJF\n"
    "I\212\103CCIAFBfFjJF\n"
    "I\212\105BMBFFACJB\n"
    "I\212\106FBiALABMFF\n"
    "I\212\137FBIFBMFFF\n"
    "I\212\166FBBFBMFFB\n"
    "I\212\207FBIAFBBMF|j2-y3\n"
    "I\212\210CCIAFBBMF\n"
    "I\212\245BFaFFJLFBC\n"
    "I\212\252CAFFJCMFL\n"
    "I\212\305AFFJBMFFF\n"
    "I\213\111AcAfCBACMFL\n"
    "I\213\117FBMFFFBJFl\n"
    "I\213\161BBFaAFaCBMF\n"
    "I\213\163BFJFaFLFFL\n"
    "I\213\164CAFLBJCFacaCf\n"
    "I\213\175AFaMFFALCC\n"
    "I\213\211AcAfCBACJFafaC\n"
    "I\213\212AcAfCBACBFB\n"
    "I\213\262FBIFCAFJC|j2-y3\n"
    "I\213\267ABgAFCAFJC\n"
    "I\214\122BFaFBMFFFB\n"
    "I\214\127ABAAcAfCBAC\n"
    "I\214\136FFJBBBFBF\n"
    "I\214\137FBFIMgJFJC\n"
    "I\214\166CFFFBMFFB|b8-y9\n"
    "I\214\232MFFFFBFaFaCf\n"
    "I\214\244FJBMFFFJB\n"
    "I\214\247BMFFFLBAC\n"
    "I\214\300FaCdBMFFBiAC\n"
    "I\214\307FaBgIAJBICK\n"
    "I\214\312MFBmgAJBICK\n"
    "I\214\314FBBMFACJK\n"
    "I\214\315FBACFBBMF\n"
    "I\214\343AABAcAfCJFaC\n"
    "I\214\362ABMFAFFJK\n"
    "I\214\372FJBMFFFaBgF\n"
    "I\215\120ACBFBMFFF\n"
    "I\215\127BMFFBCAJL\n"
    "I\215\136CCIFBBFAC\n"
    "I\215\143ABMFFFBFF\n"
    "I\215\147AcAfCBACFBF\n"
    "I\215\162FBBBFLJBL\n"
    "I\215\170BFACJCFaCdB\n"
    "I\215\201AFBACBMFF\n"
    "I\215\211FBIFBFAABmg|j2-y3\n"
    "I\215\246ACBMFFBiAC|a5-a3\n"
    "I\215\270FBACBMFFF|b5-b2\n"
    "I\215\273FJBMFBACA\n"
    "I\215\323FJBMFJFlFB\n"
    "I\215\347BMFCAFFJC\n"
    "I\215\355BCABMFFBB\n"
    "I\215\360BMFFAFMFF\n"
    "I\216\160CIAFaJCAcJF\n"
    "I\216\166BMBFFALCC\n"
    "I\216\167FBIALBMFF|j2-y3\n"
    "I\216\173BFJMgAFMBL\n"
    "I\216\235FBIFBFFBC|j2-y3\n"
    "I\216\272BBFaFAfCFBF\n"
    "I\216\353ABgABBFaFBC\n"
    "I\216\361CAFABMFFF\n"
    "I\217\105FBIACFBMF|j2-y3\n"
    "I\217\110AFBACCAJC\n"
    "I\217\114ABMFFFFJC\n"
    "I\217\137FaCFaBAFBAC\n"
    "I\217\144AFBMFFBFF\n"
    "I\217\152BFaBCBMFJL\n"
    "I\217\162ABAbCJLJFjC\n"
    "I\217\164FFFJCBMFF\n"
    "I\217\202AJFBBMFFF\n"
    "I\217\226ACFFBACFjC\n"
    "I\217\272BMFFMJBMF\n"
    "I\217\310BACABMFFF\n"
    "I\217\346AFFBBFBAC\n"
    "I\217\351FBIJFFbgCAC\n"
    "I\217\362CCIAFaMFFB\n"
    "I\220\110ACBMFFBiAC|b6-y1\n"
    "I\220\115ABCFFFBMF\n"
    "I\220\116ABMFFAFaFaC\n"
    "I\220\137BFaBCBMFFB\n"
    "I\220\162FBBFFFJLL\n"
    "I\220\203ABMFMFBMB\n"
    "I\220\210CABACJFlFB\n"
    "I\220\245BMFFFBFJC\n"
    "I\220\255FBFBIAFJC\n"
    "I\220\257BMFFAFBFF\n"
    "I\220\265AFBIAFBFF\n"
    "I\220\336BBFaJLALMgJ\n"
    "I\220\351BBFaFBMFFF\n"
    "I\220\352FBMFFBFBC\n"
    "I\220\362ABMFFBFaAC\n"
    "I\220\363CCIFFFKAC\n"
    "I\220\364CCIAFBFJL\n"
    "I\220\365CCIJFlFBAC\n"
    "I\221\117CAFBMFFBB\n"
    "I\221\143BFaBCBMFFF\n"
    "I\221\164FFFJCFFJC\n"
    "I\221\212FBACBMFFF|a5-a2\n"
    "I\221\220FBBBMFFFB\n"
    "I\221\221FBBBCIFBF\n"
    "I\221\227CAFFJCCFacaCf\n"
    "I\221\243ABBMFBFJK\n"
    "I\221\245BMFFFACBB\n"
    "I\221\255ABACACBMF\n"
    "I\221\317FABMBBFBC\n"
    "I\221\322AABFBFFBC\n"
    "I\221\323AfCBMFALCC\n"
    "I\221\331JMFFAfCBMF\n"
    "I\221\336MFFBiACCFacaCf\n"
    "I\222\120CCABMFFFB\n"
    "I\222\131BMBFJCAJC\n"
    "I\222\137JMFFBMFFF\n"
    "I\222\151ABFFFJFlFaC\n"
    "I\222\203FBBACFBAC\n"
    "I\222\213MFJCBMFFF\n"
    "I\222\214FBACCFBFF\n"
    "I\222\217FBMFBABiAC\n"
    "I\222\247FBIJCILAC|j2-y3\n"
    "I\222\272FBMFBACMgJ\n"
    "I\222\277FBFIACAAA\n"
    "I\222\303CCIMFFFFB\n"
    "I\222\307ABMFMFCFacaCf\n"
    "I\222\340BFBMFBFaFB\n"
    "I\222\345BFBMFFFAC\n"
    "I\222\351BFCABFaBMB\n"
    "I\222\371CFFFBMFFB|b9-b8\n"
    "I\223\137BFBMFACCC\n"
    "I\223\170BFJFBBFFaC\n"
    "I\223\173AcJFFaCALCC\n"
    "I\223\246JCILACCFacaCf\n"
    "I\223\264CCIBMFBMF\n"
    "I\223\273BLBBFFFBC\n"
    "I\223\275FFBBABMFL\n"
    "I\223\306ABgABMFBIC\n"
    "I\223\354FBBMCAFFB\n"
    "I\224\150CCIAJAJAC\n"
    "I\224\167FBIALBMFF\n"
    "I\224\170JMFFBFBMB\n"
    "I\224\250CAJCBMBFF\n"
    "I\224\255FaCACAFFJL\n"
    "I\224\332ABMBFFAFB\n"
    "I\224\362FkACBAJFkAC\n"
    "I\224\374CAFBFFFJC\n"
    "I\225\142AFBACBACA\n"
    "I\225\151BMFBMFBMF\n"
    "I\225\211AFaBMFFFAC\n"
    "I\225\213FBFBFACBC\n"
    "I\225\225FBFFBIFBC\n"
    "I\225\227JFkABMFBIC\n"
    "I\225\262CABACACMgJ\n"
    "I\225\277FBACFBMJC\n"
    "I\225\305FABMFFFAC\n"
    "I\225\317BFJBACAFaC\n"
    "I\225\326ABFBMFFJC\n"
    "I\225\333ABBMFFBAC\n"
    "I\226\105JMFFAMMFL\n"
    "I\226\136FBBFFFBAC\n"
    "I\226\140BMFFBMFFF\n"
    "I\226\176ACMgABMBBF\n"
    "I\226\300CAFBACCFacaCf\n"
    "I\226\312FABMBBFFF\n"
    "I\226\361AcAfCBACAMgC\n"
    "I\226\366FBACABiJMgB\n"
    "I\227\105FaCBMBFFMgJ\n"
    "I\227\110BAcAfCAcAfCLB\n"
    "I\227\123BFaBCJFBMF\n"
    "I\227\155CCICAFFFB\n"
    "I\227\166FBMBBFAcJF\n"
    "I\227\201CCIACACbMF\n"
    "I\227\245AABMFFFFB\n"
    "I\227\277CABACCCFB\n"
    "I\227\320FJBMFFBFF\n"
    "I\227\346FBFIACCFaC\n"
    "I\227\346FBFIACFMgB\n"
    "I\230\131BMFFBiCFaCdB\n"
    "I\237\253CCIAMgBMFF\n"
    "J\210\304BBFaAcJFFBAC\n"
    "J\210\365BMFBMFFFAC\n"
    "J\211\100FaCdBBBFaFFJL\n"
    "J\211\131CCIFBMFFBC\n"
    "J\211\166CAFACBMBBF\n"
    "J\211\170ACBCABMFJL\n"
    "J\211\203BBFaBMFFAcJF\n"
    "J\211\245ACAfCMCIMCI\n"
    "J\211\264ABFJCBMFFL\n"
    "J\211\266BMFJCFALCC\n"
    "J\211\304FABMFFFAFaC\n"
    "J\211\306BBFaFACbgAAAC\n"
    "J\211\327FBBABFBMFB\n"
    "J\211\330FBBFFBBFFB\n"
    "J\211\341BMFBICBFJK\n"
    "J\212\121BBFaFBFFBMF\n"
    "J\212\151FBACAFaCBMF\n"
    "J\212\152FBACBFAcAAC\n"
    "J\212\224FBACAFFBAC\n"
    "J\212\327FaCdBAFaBBMFF\n"
    "J\212\371MFFBiCFBFJL\n"
    "J\213\101BJMFFAFaBMF\n"
    "J\213\114CFFFBMFMFL\n"
    "J\213\116FBFBFACMFL\n"
    "J\213\121ACBMFFBiCJFl\n"
    "J\213\123ABMBFFJLAfC\n"
    "J\213\173BBFaBMFABMF\n"
    "J\213\223CCAFACAFFBg\n"
    "J\213\260FBIJFlCALCC\n"
    "J\213\261FBBFACBACC\n"
    "J\213\271JMFFAMgACLB\n"
    "J\213\272MgAMgAMgABMFF\n"
    "J\214\111FBMBBFFBAC\n"
    "J\214\113FaCFaCFaCFBAC\n"
    "J\214\120CFFFBMFJBB\n"
    "J\214\123MFFJBMFFaCdB\n"
    "J\214\142FBMFFBALCC\n"
    "J\214\220ABACFBMFJC\n"
    "J\214\223CAFMFFBBAC\n"
    "J\214\225ACFBMFJCBB\n"
    "J\214\254FBMFFFBFFB\n"
    "J\214\264FJABMFFBAC\n"
    "J\214\302ABBMFBBMFF\n"
    "J\214\311BFJFBMFFFB\n"
    "J\214\342BcJFBMFBmFAC\n"
    "J\214\345ACBFBMFBMF\n"
    "J\214\363ABBMFAFFJK\n"
    "J\215\132FBACBFACJK\n"
    "J\215\153FFFBACFFJB\n"
    "J\215\161AJMCBIBFJFl\n"
    "J\215\166FBFBMFFFAC\n"
    "J\215\176FaCdBAFaCFBFB\n"
    "J\215\202BFBMFBMBMF\n"
    "J\215\204BMCAFBLBBB\n"
    "J\215\234BMBFBFaBMFF\n"
    "J\215\252FBACMFFBiAC\n"
    "J\215\264BMFAfCALAFaC\n"
    "J\215\267CAFBFFAFBF\n"
    "J\215\300BFJACACFBF\n"
    "J\215\311BBFaBFCAFFB\n"
    "J\215\315FBFFBACKAC\n"
    "J\215\334BFACJFFBBB\n"
    "J\215\340BMFFFACFBA\n"
    "J\215\365FBBFaAcAfCBAC\n"
    "J\215\367FBACCCAAcJF\n"
    "J\216\105ACFBACJFlFaC\n"
    "J\216\126FBACFFFCAC\n"
    "J\216\134FFJCBMFBFC\n"
    "J\216\143FJFjCFFFCAC\n"
    "J\216\164ABMFMFFBMB\n"
    "J\216\206AcAfCBACABiFK\n"
    "J\216\211JMFFALBMFF\n"
    "J\216\236BMFFFBFFBC\n"
    "J\216\276BFJCIAFFJC\n"
    "J\216\313ABMFFIIFBC\n"
    "J\216\321AcAfCBACBACA\n"
    "J\216\330ABFBBFBMFF\n"
    "J\216\336FBMJLFFAMgC\n"
    "J\216\343MFBmgCIMFBmgCI\n"
    "J\216\352FJFjCAFFBAC\n"
    "J\216\354FBFIAFFBAC\n"
    "J\216\360CCIFBMJLFF\n"
    "J\217\103ABBAFACAAA\n"
    "J\217\135AABCAFBFAC\n"
    "J\217\171CIABAFBFFF\n"
    "J\217\175FJFjCAMgBMFF\n"
    "J\217\203AcAfCBACALBL\n"
    "J\217\221MFFFFBBMFF\n"
    "J\217\231AABACFFBAC\n"
    "J\217\234FaCdBACFFBAC\n"
    "J\217\252BBFaBCABMFF\n"
    "J\217\253BCIACCAFBC\n"
    "J\217\301CCIBCABMFF\n"
    "J\217\307BFJCIFBFBF\n"
    "J\217\313BFaBCCAFBFF\n"
    "J\217\314AFBACAFBAC\n"
    "J\217\316AFBAFBAFJC\n"
    "J\220\112FJFFBiACFBC\n"
    "J\220\117FJFFBiACBMF\n"
    "J\220\120BcJFFJFFBiAC\n"
    "J\220\125FBIFJFFBiAC|j2-y3\n"
    "J\220\127FBBCAFBMFF\n"
    "J\220\132CCIMFFBFaFaC\n"
    "J\220\136FBBMFFFFAC\n"
    "J\220\152ACFFBCAIFB\n"
    "J\220\167FaCdBFBMFFFB\n"
    "J\220\212BFBMFFABiAC\n"
    "J\220\244BFBMBFFAFjC\n"
    "J\220\300FBIAJFBCFacaCf\n"
    "J\220\307ABAFBFFFFaC\n"
    "J\220\310BFJFBBFBMB\n"
    "J\220\356FMFJMCIMCI\n"
    "J\220\360FBACACFBFF\n"
    "J\221\144AFBACBMFFF\n"
    "J\221\146FBFFAcAfCBAC\n"
    "J\221\161ACFMFFJBMF\n"
    "J\221\173FBIBMFFBFaC|j2-y3\n"
    "J\221\175FBIAFBMFFB|j2-y3\n"
    "J\221\242AFBFBMFCFacaCf\n"
    "J\221\247ABMFFFALCC\n"
    "J\221\254FBMFBACCFacaCf\n"
    "J\221\263BFaBACBMBFF\n"
    "J\221\267FaBgIAAcAfCBAC\n"
    "J\221\321FBBBFBFaBMB\n"
    "J\221\327FFFJCBCIAC\n"
    "J\221\365CFFFBMFAFL\n"
    "J\222\154ABFBBMFFFL\n"
    "J\222\160FBFFIBBLCC\n"
    "J\222\166FAfCFBIAFJK\n"
    "J\222\173BFAcAfCBMBFF\n"
    "J\222\200FACbgAAACCFacaCf\n"
    "J\222\201AFBACAFFJC\n"
    "J\222\275JMFFCAFFJC\n"
    "J\222\312FaCBMFFBCFacaCf\n"
    "J\222\353BFJAFBFFaFaCf\n"
    "J\222\374AJFFBMBCFacaCf\n"
    "J\223\116FBIAJFBBMF\n"
    "J\223\127MFJFBBFBiAC\n"
    "J\223\153AABFBFBFAC\n"
    "J\223\162ACFFBACCFacaCf\n"
    "J\223\174ABFAfCFBIBB\n"
    "J\223\175BCABFaBMFJL\n"
    "J\223\200CIFBMFFBAC\n"
    ;
}

#endif /* FOR_STROKEDIC_CREATE_1 */

#ifdef FOR_STROKEDIC_CREATE_2

CharPtr LoadStrokeDicPtr(void) {
	return 
    "J\223\202BFJMFFBBMF\n"
    "J\223\207ABMFFFMgBLB\n"
    "J\223\215FBACJCILAC\n"
    "J\223\242CFFFBMFFBC\n"
    "J\223\247AFBACAMmgCFacaCf\n"
    "J\223\267JMFFBMFBMF\n"
    "J\223\301AFBIFBFFBC\n"
    "J\224\131ACBCCAACLB\n"
    "J\224\133AcAfCBACBMJC\n"
    "J\224\134AfCBMFFALAL\n"
    "J\224\152FJBMFJFaBFaC\n"
    "J\224\156BFBFFMgCCCC\n"
    "J\224\157ABJFFFBFFF\n"
    "J\224\172FBMJLFFMFL\n"
    "J\224\173ABBFCAFBMF\n"
    "J\224\176FBACAFLMBF\n"
    "J\224\307FBFIBJFBFF\n"
    "J\224\310BMBFFCAFFB\n"
    "J\224\312AJMCBIJFlFaC\n"
    "J\224\346BFJCIJFaBFaC\n"
    "J\224\351AFBACCALBC\n"
    "J\224\355BFaBACJFaBFaC\n"
    "J\225\120BcJFBFBMFBF\n"
    "J\225\125ABFBFFJBiAaC\n"
    "J\225\141BFJCIFBMJC\n"
    "J\225\154CCIABFBFAC\n"
    "J\225\161AFLMBFAFJK\n"
    "J\225\162CAFFJBFBiFlC\n"
    "J\225\202CCIACCAFaBgF\n"
    "J\225\264AcAfCBACACMgJ\n"
    "J\225\303FaCdBFBiALFBF\n"
    "J\225\327AFaBMBFJLMgJ\n"
    "J\225\337FBIFBMFFBC|j2-y3\n"
    "J\225\355ABBFFbgJJFJK\n"
    "J\225\356ABFFFJCFFB\n"
    "J\225\364BLBAFaCFFFB\n"
    "J\226\103FJBMFAMMFL\n"
    "J\226\125BFCAFBMFBB\n"
    "J\226\141AcAfCBACBFMgJ\n"
    "J\226\204FBIBMFFBFF\n"
    "J\226\254JMFFAJABAC\n"
    "J\226\260BMFFFMFBiFC\n"
    "J\226\272BcJFBMFFBiAC\n"
    "J\226\325FFFBACAFFL\n"
    "J\226\344AcAfCBACBFJK\n"
    "J\227\145BBFaACACBMF\n"
    "J\227\254CCIBFAfCJBL\n"
    "J\227\257ABiCMgJBMBFF\n"
    "J\227\263BFCAFBMFFL\n"
    "J\227\267BFMgJAFABAC\n"
    "J\227\317ABACFBMFBB\n"
    "J\227\334CCIFMFJFJC\n"
    "J\227\363FAFaCBBACCC\n"
    "J\227\366BFJBACALCC\n"
    "J\230\101FBMFFFBCFacaCf\n"
    "J\230\116BMFFBiCJMFF\n"
    "J\230\121CCIBMFFBiAC\n"
    "K\210\253FBMFBBFALCC\n"
    "K\210\262FBACBFCAFFB\n"
    "K\210\321MFJFFBACFBC\n"
    "K\210\331BMBFFFBBFAC\n"
    "K\210\332AFBACAFaCAFaC\n"
    "K\210\346FBIFBMFICAC\n"
    "K\210\355AFaBMBFJLCFacaCf\n"
    "K\211\101FaCdBACFMFFAfC\n"
    "K\211\164CCIBFABAFaCC\n"
    "K\211\251FBBFBMBFFAC\n"
    "K\211\331FBBBMFFFBAC\n"
    "K\211\335ABALBMFFFAC\n"
    "K\212\102FBACFFJBKJC\n"
    "K\212\125CCIFJFBFFBF\n"
    "K\212\153FBFAFaJMiJFlFaC\n"
    "K\212\163BFBMFFaBgIFaCdB\n"
    "K\212\174FBIFBFFBIBC|j2-y3\n"
    "K\212\205BMFBMFFAMgAL\n"
    "K\212\211CCIBMFFAMgAL\n"
    "K\212\243FBBMFFFBAFFaf\n"
    "K\212\250FBBFFFJLLMgJ\n"
    "K\212\263BMFBMFBALCC\n"
    "K\212\321LMBFBMFFFAC\n"
    "K\212\341BMFFFMFFBiAC\n"
    "K\212\356FBBFFFACFBF\n"
    "K\212\361BBFaFJCFBMFB\n"
    "K\213\113FFJCBMFFFJL\n"
    "K\213\124AFaBMFFBMFFL\n"
    "K\213\125ABCAMMMBCCC\n"
    "K\213\145FBBAMgCAFBAC\n"
    "K\213\162JMFFFBFAfCMgB\n"
    "K\213\176FBCIACCAFAC\n"
    "K\213\205FBFIFBCIACC\n"
    "K\213\225BFJFaFLBBCAF\n"
    "K\213\226CFFFBMFAFFB\n"
    "K\213\233AFaBMBFFACCC\n"
    "K\213\255MFBmgAfCBMFBIC\n"
    "K\213\263FBFAFaBgIAFAC\n"
    "K\213\275AcAfJMFFBiCFaCdB\n"
    "K\213\333FBBBMAFBACF\n"
    "K\213\364ABBMFFBMBFC\n"
    "K\214\100FBIMFJFLBLB|j2-y3\n"
    "K\214\133FMFJAFACBMF\n"
    "K\214\146FBIBMFFAMgAL|j2-y3\n"
    "K\214\153CCIACCAFFJC\n"
    "K\214\157AcAfCBACFaCFBF\n"
    "K\214\165CCABFaBMFBFC\n"
    "K\214\222ABMFFFFBFaFaC\n"
    "K\214\257FaCdBACFBMFJC\n"
    "K\214\273FBFIBMFFFJL\n"
    "K\215\116BFJMFFBCIAC\n"
    "K\215\124FBIBBFaJLFBF|j2-y3\n"
    "K\215\225BMFFBFFACCC\n"
    "K\215\240DLFABMFFFAC\n"
    "K\215\245BcJFABiFKBMFF\n"
    "K\215\254CCIBMFFFBiAL\n"
    "K\215\256AcAfCBACFBBFF\n"
    "K\215\305BMFFFBFFIFaC\n"
    "K\215\312ACCAFBACAAA\n"
    "K\215\314FBIACCAFBAC|j2-y3\n"
    "K\215\317CCIBFACJFFB\n"
    "K\215\325AFaCCFaCFFBAC\n"
    "K\215\326BFACJFFBACB\n"
    "K\215\327AcAfCBACBMBFF\n"
    "K\215\330FBBACCAFBAC\n"
    "K\215\350BLBFJCFBMFBg\n"
    "K\216\123ACBAfCFACAAA\n"
    "K\216\131BFCAFJAFBFF\n"
    "K\216\213BFaBCBMFFFJL\n"
    "K\216\267FBFCAFFBJFlC\n"
    "K\216\314FBIACFBFBMF|j2-y3\n"
    "K\216\315FBFJBBCAFJK\n"
    "K\216\316ACFFBACCCFB\n"
    "K\216\326BMFBICBBFaAL\n"
    "K\216\337ACAFBACMFJC\n"
    "K\216\342BBFaBFFBACFaC\n"
    "K\216\366FBIACCABFaFaC|j2-y3\n"
    "K\217\111AcAfCBACACaCCC\n"
    "K\217\113MCIMCIABMFF\n"
    "K\217\124JMFBFBMFCFacaCf\n"
    "K\217\141CCIBFBFCIAC\n"
    "K\217\150BBFaABFABMFF\n"
    "K\217\151CCIFBFBACFjK\n"
    "K\217\154MFFBCAFACJB\n"
    "K\217\160AABFBACCFFBg\n"
    "K\217\216BFJFBBFACCC\n"
    "K\217\244BFCABMJLBMF\n"
    "K\217\245BMFBMFFBMFF\n"
    "K\217\302CCIBFBFBACA\n"
    "K\217\315BFCAFBMFFFB\n"
    "K\217\320AcAfCBACMgJBMF\n"
    "K\217\327CFFFBMFACAfC\n"
    "K\217\350AFFBBFBACBB\n"
    "K\217\355BCABFaBMFBMB\n"
    "K\217\356ACBFBFFBMFF\n"
    "K\220\133CCIBFaJLFBAC\n"
    "K\220\141AcAfCBACBMFFB\n"
    "K\220\151ABAFBFFFCFacaCf\n"
    "K\220\204FBIABAFBFFF|j2-y3\n"
    "K\220\214FBMJLFFJFlFB\n"
    "K\220\222BLBBBFaFFBAC\n"
    "K\220\230FBIMFJFBBMF|j2-y3\n"
    "K\220\235BACABAFBFFF\n"
    "K\220\264CCIFBFFBMFF\n"
    "K\220\311ACBFBBFBMFF\n"
    "K\220\323FBFFBMFFFAC\n"
    "K\220\332FBIBFCAFAcJF|j2-y3\n"
    "K\220\335CFFFBMFJFlFaC\n"
    "K\220\341FBFaBCCCCMFF\n"
    "K\220\371BFMgJAFFaBFJC\n"
    "K\221\104AJMCBIACBMF\n"
    "K\221\133FBIFBBFBMFF|j2-y3\n"
    "K\221\145CAFBACBMFFF\n"
    "K\221\147AcAfCBACBMFFF\n"
    "K\221\174FBIMFFBFaBMB|j2-y3\n"
    "K\221\202FBMBBFFBMFF\n"
    "K\221\203CCABMFFFBAC\n"
    "K\221\213BBFaJLAfCALCC\n"
    "K\221\244ABBMFFFACBB\n"
    "K\221\260BFMgJACAFFJC\n"
    "K\221\334ABFCCBFABiAC\n"
    "K\221\337MFFBCIACCFacaCf\n"
    "K\221\346AFBAFBMFBmgBA\n"
    "K\222\105JMFFCABMFJL\n"
    "K\222\124FBIBFaJLFBAC|j2-y3\n"
    "K\222\127CCIBIJKBIJK\n"
    "K\222\146CAFBACLAJFB\n"
    "K\222\202BBFaJLFAfCFBF\n"
    "K\222\230FBBFBFABMFF\n"
    "K\222\240BMBBFFFFBiAC\n"
    "K\222\243MFBmgBFFFFBiAC\n"
    "K\222\244JMFBFBMFAAA\n"
    "K\222\255BMFFFJCILAC\n"
    "K\222\257JMFFBFFFBiAC\n"
    "K\222\270FBFABMFFFAC\n"
    "K\222\271ABMFFFMgCCCC\n"
    "K\222\302FaCdBFBMFFBAC\n"
    "K\222\336ACFFBCAIAMgC\n"
    "K\222\342ABBFBMFBFaFB\n"
    "K\222\343ABBFBMFFFAC\n"
    "K\223\112AFBAFBBMBFF\n"
    "K\223\131CCIAFJCBACC\n"
    "K\223\135FBMFFFBFFAfC\n"
    "K\223\163FBFABMFFFaCdB\n"
    "K\223\211ACBBFBMFFFB\n"
    "K\223\220CIAFaJCBMBBF\n"
    "K\223\251FaCdBAMAFFBLB\n"
    "K\223\256AFBMFFBFIMgJ\n"
    "K\223\260BCABFaBMFFBF\n"
    "K\223\276AABBMFFFFBC\n"
    "K\223\330JMFFFACbgAAAC\n"
    "K\223\356FBMFFFBAFaJC\n"
    "K\224\114ABgAFBBBMBFF\n"
    "K\224\123CAFBACBFBMF\n"
    "K\224\135JMFFCCAACLB\n"
    "K\224\153CCIJFaBFaCAfJF\n"
    "K\224\162FBIJFFFBFFF|j2-y3\n"
    "K\224\163BMFFFACAFJK\n"
    "K\224\174FBIBFCAFBMF\n"
    "K\224\206FaCdBBFCAFBMF\n"
    "K\224\225AJMCBIABMFF\n"
    "K\224\314BMFFFACFJFaC\n"
    "K\225\115AFBAFBMFFFB\n"
    "K\225\133FBMBBFFFBAC\n"
    "K\225\140FBIFBBBMBFF|j2-y3\n"
    "K\225\156ACMgABMFFFAC\n"
    "K\225\167BcJFMFFBFaBMB\n"
    "K\225\204AFBAFBABFBC\n"
    "K\225\224BFCAFBMFFaCdB\n"
    "K\225\233FBMFBMBFFBB\n"
    "K\225\302BMFFBMFFFBA\n"
    "K\225\316ABFMFJBMFBB\n"
    "K\225\366BLBJMFFJMFF\n"
    "K\226\107FBBBMFFJMFF\n"
    "K\226\113CFFFBMFBFMgA\n"
    "K\226\135BFLJMFFFBFF\n"
    "K\226\170FBIMFJBLBLB\n"
    "K\226\203BFJFBACFBAC\n"
    "K\226\247BBFaBALBCBLB\n"
    "K\226\261FaCFaBgAAFACMgJ\n"
    "K\226\322ABgCFaBgFBMBBF\n"
    "K\226\342BMFFBMFFBMF\n"
    "K\226\354BMFFBFIFaCFaBg\n"
    "K\226\363CFFFBMFMFJC\n"
    "K\227\102BMFABAFBFFF\n"
    "K\227\111ABBAFACALCC\n"
    "K\227\130AFFBBFBIFaCdB\n"
    "K\227\146BFJMFFBMFFB\n"
    "K\227\156CCIBBFaACBMF\n"
    "K\227\176ACACBMFAFaJC\n"
    "K\227\202MCIMCIBFCAF\n"
    "K\227\235FBFIBMFFBFF\n"
    "K\227\244FaCdBFBFALFBF\n"
    "K\227\246BFAcAfCCIACFB\n"
    "K\227\252BMBFFAFaCBMF\n"
    "K\227\261CAFBACBFCAF\n"
    "K\227\262FaCdBAFaCAFBFF\n"
    "K\227\301CCIBFBMFBAC\n"
    "K\227\302ABgACCAJFkFFB\n"
    "K\227\313FaCdBFBFALAFaC\n"
    "K\227\335BMBFFAcAfCBAC\n"
    "K\235\352JFMgKACBMBBF\n"
    "L\210\250FBBFaCACAFFJC\n"
    "L\210\254FBIMFJFAfCFBF|j2-y3\n"
    "L\210\314ABBMFBMFFBFB\n"
    "L\210\371ACBMFFBiCAFaJC\n"
    "L\211\121CCIBMBFBMBMF\n"
    "L\211\136BMFBMFFFBCFacaCf\n"
    "L\211\137FBFaBCCCCFFAfC\n"
    "L\211\143CCABFaBMFABMF\n"
    "L\211\154FBFIFBBBMFJC\n"
    "L\211\162CFFFBMFCMFaAC\n"
    "L\211\172FBFBFACBiFKAC\n"
    "L\211\207FBIACCAFFJFaC|j2-y3\n"
    "L\211\234ABMCAFBACFJC\n"
    "L\211\267CCIBMFFBMBBF\n"
    "L\211\305BcJFBBFaACbgAAAC\n"
    "L\211\337BMBFBMBMFCFacaCf\n"
    "L\211\352MgJBMFBMFFFAC\n"
    "L\212\107AcAfCBACACFFAfC\n"
    "L\212\112BMFFBMFFFFJB\n"
    "L\212\113FaCdBFBiALABMFF\n"
    "L\212\130AABFBFFBIFFB\n"
    "L\212\157CCABFaBMFFFJL\n"
    "L\212\204BBFaFBFFBMFBB\n"
    "L\212\246BBFaFBBFFACCC\n"
    "L\212\253BMFAFaBMJLFJC\n"
    "L\212\254FBIFBBFFFALL\n"
    "L\212\267FBIAFaBMJLFJC|j2-y3\n"
    "L\212\270FBFBFFIBAFJC\n"
    "L\212\273FBACBBFaBMFMF\n"
    "L\212\274FBFFFBACAFaJC\n"
    "L\212\324BMFFBMFFBMFF|l1-l5\n"
    "L\212\325BMFFBMFFFBAC\n"
    "L\212\354FBFBMFCAFBMF\n"
    "L\212\364AcAfCAcAfCFJCKAC\n"
    "L\212\366FBIBFaFBMFFFB|j2-y3\n"
    "L\212\372FBBFFFACJMFF\n"
    "L\212\373FBACFBBFFFAC\n"
    "L\213\115BMFBFBMFFFAC\n"
    "L\213\134FBBFFFACAFaJC\n"
    "L\213\151BMFFBFIMgAFJC\n"
    "L\213\213AcAfCBACACFBMF\n"
    "L\213\227BMFBFBIBFMFF\n"
    "L\213\305BMFFFBFBBFJL\n"
    "L\213\316FBBBMFBFFIMgJ\n"
    "L\213\325FBFIFBFFACFFa\n"
    "L\213\330AFBAFBJMFFMgJ\n"
    "L\213\366BMFFBMBICCFacaCf\n"
    "L\213\367FaCdBBMFFBMFFC\n"
    "L\214\150FBBAFmgBMFAFJC\n"
    "L\214\151BMFFBFBMFBAC\n"
    "L\214\171FBMFFFBFaCFBF\n"
    "L\214\213AcAfCBACFBFBMF\n"
    "L\214\227BMCAFFJCMFLF\n"
    "L\214\230BFBMFBFFaCFBF\n"
    "L\214\237FBACACFBMFJC\n"
    "L\214\270CCIJFFBMFCAC\n"
    "L\214\316CCIFBBMFJMFF\n"
    "L\214\331FMFJABBFBFFF\n"
    "L\214\344AABAFFBFBIMgB\n"
    "L\215\121ACBFBBBFLJBL\n"
    "L\215\140CCIFBBFACMFL\n"
    "L\215\144FJBMFFBMFFJC\n"
    "L\215\151AcAfCBACBFACJK\n"
    "L\215\200FBIFABMFFFAC\n"
    "L\215\274CFFFBMFAFBFF\n"
    "L\215\331FBFBFABiACKAC\n"
    "L\215\364AFBAFBFBMBAC\n"
    "L\216\120ACACACACACFB\n"
    "L\216\125FBBFBMFFAFJC\n"
    "L\216\207BFBIALAcAfCBAC\n"
    "L\216\214CFFFBMFMFBMF\n"
    "L\216\225BFBFCAFBACLB\n"
    "L\216\240CCICAFAcAfCAcAfC\n"
    "L\216\262FBMFFFBBMBFF\n"
    "L\216\274CCIBMFFBBCAF\n"
    "L\216\317FBFABMFFACCC\n"
    "L\217\101BFBMFBACFJLC\n"
    "L\217\117ABMBBFABAAAC\n"
    "L\217\127ABAFBFFFFBAC\n"
    "L\217\172AABAJFBBMFFF\n"
    "L\217\207JBBFABMFFFAC\n"
    "L\217\213BMFFFBFABMFF\n"
    "L\217\237JMFFCAFFJCFaJ\n"
    "L\217\266BCABFaBMFAFFBg\n"
    "L\217\273BMFFBMFFBMFF|y5-y1\n"
    "L\217\304CAJCFBFBBFJL\n"
    "L\217\305ABAFBFFFACCC\n"
    "L\217\311FJBMFBCABMFF\n"
    "L\217\317CAFBACBFJFBF\n"
    "L\217\330CFFFBMFFBFBF\n"
    "L\217\331CFFFBMFMgABMF\n"
    "L\217\333AFaBMBFACbgAAAC\n"
    "L\217\364BMBFFBFaBMFFF\n"
    "L\220\101FBACFBBMFFFL\n"
    "L\220\102FJFjCFBBMFFFL\n"
    "L\220\130FBACFBACFBAC\n"
    "L\220\146CFFFBMFACAAA\n"
    "L\220\161MFFFBIBMFFBC\n"
    "L\220\174FBMJLFFAFBFF\n"
    "L\220\213CAFACbgAAACCFacaCf\n"
    "L\220\217FaCdBAFBMFFCFacaCf\n"
    "L\220\260BMFFFBFFBMFF\n"
    "L\220\305AFBACCABMFJL\n"
    "L\220\342AcAfCBACAFaMBFL\n"
    "L\221\120CAFFFBCAFBMF\n"
    "L\221\122AFaCCFJCCACCC\n"
    "L\221\141FaBFBIFBMFBAC\n"
    "L\221\151CFFFBMFAJFBC\n"
    "L\221\156ACFMFFJBMFBB\n"
    "L\221\162FBBMFBMFFBiAC\n"
    "L\221\222FBBFAFaCALFJB\n"
    "L\221\225BCIFBFBFABiAC\n"
    "L\221\252CCIBMFFFACBB\n"
    "L\221\256MFJABMFBMBIC\n"
    "L\221\265FBICAFBMFFBB|j2-y3\n"
    "L\221\270CAFBMJLFFFBC\n"
    "L\221\302FaCdBJFBMFFFBF\n"
    "L\221\304ACBFJFBFBMFF\n"
    "L\221\326FFJCFFJCBMFF\n"
    "L\221\335ABFCCBMFFFAC\n"
    "L\221\340FaCdBCAFACbgAAAC\n"
    "L\222\102FBFCAFFFBCFacaCf\n"
    "L\222\111FBACJMFFJMFF\n"
    "L\222\132AFFJCFBMFCAF\n"
    "L\222\145MFBmgCCABMFFFB\n"
    "L\222\161AFFJCBMFBMFF\n"
    "L\222\170MFJCAFFFBCFacaCf\n"
    "L\222\205CAFBFFABMFFF\n"
    "L\222\231BMFFFACBBFaFB\n"
    "L\222\251FBBMFFFBJMFF\n"
    "L\222\264FBFBFACMgABMF\n"
    "L\222\311BFJCIFaCBMFFB\n"
    "L\222\313FBIBFaFACbgAAAC\n"
    "L\222\347FBIBMFFFBFJC\n"
    "L\222\361FBIBMFFFBFJC|j2-y3\n"
    "L\222\366AFBACBMFFBFF\n"
    "L\223\141MJFBBFACJFlFaC\n"
    "L\223\156CCIBFJFBBFFaC\n"
    "L\223\157FaCACAFBMFCAF\n"
    "L\223\203FBIFBBACFBMF\n"
    "L\223\213FBIFBBACFBMF|j2-y3\n"
    "L\223\217FBACFBMFFBAC\n"
    "L\223\222CCIBMFFBAFaAA\n"
    "L\223\227BFJCIFBMFCAF\n"
    "L\223\231AFBAFBFBFFBC\n"
    "L\223\232AFBAFBACFBMF\n"
    "L\223\233AFBAFBBMFBMF\n"
    "L\223\235AcAfCBACBFAfCJL\n"
    "L\223\266BFCAFBMFFBFF\n"
    "L\223\271CAFABMFFFCFacaCf\n"
    "L\223\335ACFFBCAIALBL\n"
    "L\224\160BFJFaCACAFFJL\n"
    "L\224\175BcJFFBBFFFBAC\n"
    "L\224\203BMBBFBMFFFAC\n"
    "L\224\216FBFBMFFBCFBC\n"
    "L\224\321ACBMFFBiCFJFaC\n"
    "L\224\323BMFFAFaBMBFJL\n"
    "L\224\324ACAFBACBMBFF\n"
    "L\224\330BFJBACBMFBIC\n"
    "L\224\337JFFFBFFFALCC\n"
    "L\224\340FMFJJFFIBFFF\n"
    "L\224\357MFBmgJBBMFFFAC\n"
    "L\224\365ABFBBFABMFFB\n"
    "L\225\135CFFFBMFFCAFB\n"
    "L\225\170BBFaFBMFBMBFF\n"
    "L\225\201CAFBBCAFBMFF\n"
    "L\225\234AABAFBMFFAFaC\n"
    "L\225\235BMBFBMFBMBFF\n"
    "L\225\265FBFaBCCCCACMgJ\n"
    "L\225\273FBIBMFFFJFagAA\n"
    "L\225\325FMFJBMFBBCFacaCf\n"
    "L\225\342BFaBACFBMFFBC\n"
    "L\225\345FBBBMFFFACMgJ\n"
    "L\225\361FBFCAFFBMgBFaC\n"
    "L\226\124ABBFCABFaBFFbgA\n"
    "L\226\130BMBBMFFBMFFF\n"
    "L\226\137FBACFFFJCFFB\n"
    "L\226\146ABiCMgJBMFFFAC\n"
    "L\226\236CCIFBBFBMBLB\n"
    "L\226\263AFFBBBBFACCC\n"
    "L\226\271BcJFFaBFJCBMFF\n"
    "L\226\371ACBACFBMFFBB\n"
    "L\227\120ABgACAFBMJLFF\n"
    "L\227\124BFaBACACACBMF\n"
    "L\227\126BFMgJAFFaBgFCFacaCf\n"
    "L\227\131FJAfCABAFBFFF\n"
    "L\227\147FBIBMFFFJFagAA|j2-y3\n"
    "L\227\150FBIACCAFFBLB|j2-y3\n"
    "L\227\164FBBFBBFLFBAC\n"
    "L\227\172FaCdBBMFFFAFagAA\n"
    "L\227\215AcAfCBACAFaCBMF\n"
    "L\227\216FBBCCIAFaCBMF\n"
    "L\227\222BLBJFkABMFBIC\n"
    "L\227\237BFJCIAFBACBB\n"
    "L\227\260FJBMFBFAfCJBL\n"
    "L\227\312BMFFFBMFFBFF\n"
    "L\227\333BMBFFCIACFBF\n"
    "L\227\364FAFaCBBBFABiAC\n"
    "L\230\114BFJBMFFBiCFaCbgB\n"
    "L\230\146FBMFIKACALCC\n"
    "L\230\160CCIBFJBACMFBmg\n"
    "L\230\162JMFFBBFaJFjCML\n"
    "M\210\244ACCABFaALCCAFaC\n"
    "M\210\303BMFFBFCAFBMFF\n"
    "M\210\323BFCAFBMFFALCC\n"
    "M\210\341BMFBMFFBFBCFacaCf\n"
    "M\211\200BMFBFBMFABACF\n"
    "M\211\214CAJCFBMBBFFBF\n"
    "M\211\216ABgAFBFBMFABiAC\n"
    "M\211\223FBFBMFABACCFacaCf\n"
    "M\211\224ACFFBCAIACBMF\n"
    "M\211\226FBIAFBMFBMBBF\n"
    "M\211\311BMFFMFBFFMFFaC\n"
    "M\211\320BFaBCBMBFBMBMF\n"
    "M\211\353FBFBAABAFBFFF\n"
    "M\211\360AFaJMBFFMgAAFFB\n"
    "M\211\362FBIABMBFFJLAfC\n"
    "M\212\123ACBMFFBiCFBFJL\n"
    "M\212\131CFFFBMFBFAcAAC\n"
    "M\212\162FBMFFFBBFACAC\n"
    "M\212\165FaCdBFBMFBMALFB\n"
    "M\212\171ABMFFCIACFBAC\n"
    "M\212\212CCIBMBFBFaBLFF\n"
    "M\212\214BFaBACBMFFAMgAL\n"
    "M\212\251AFFJBBFBFFFMgJ\n"
    "M\212\260BBFaFBBBMFFFAL\n"
    "M\212\262FBBMFFFBACFFB\n"
    "M\212\264JFFBMFKACALCC\n"
    "M\212\277CCIFBBBMFFFJC|y10-j7\n"
    "M\212\346FFJBiFABMFFFAC\n"
    "M\212\374BFAfCFBBBFFBAC\n"
    "M\213\140CAFBFFAFBIKAC\n"
    "M\213\154CFFFBMFFBFBMF\n"
    "M\213\306BBCAFCAFFFBAC\n"
    "M\213\311FBACFBMgBMFFaCF\n"
    "M\213\326FBACFBACFFBAC\n"
    "M\213\360BMFFBMBICALCC\n"
    "M\213\361BFJFaFLBMFBmFAC\n"
    "M\214\103FBBFBMFFBABAL\n"
    "M\214\121MFFJBMFCAFFFB\n"
    "M\214\130ABALFABMFFFAC\n"
    "M\214\147FBIABBFBFFFAFafag|j2-y3\n"
    "M\214\160AcAfCBACCAFBACL\n"
    "M\214\206ABJFjCFBFBFBAC\n"
    "M\214\231BcJFCAFMFFBBAC\n"
    "M\214\243FBBMCAFFBFJCC\n"
    "M\214\246AcAfCBACBMFBMFF\n"
    "M\214\255BMFBFBMFMFCFacaCf\n"
    "M\214\271CCIFJBBMFFBAC\n"
    "M\214\326CFFFBMFFJCFFBmg\n"
    "M\214\333FBFBMFCAIFBFaC\n"
    "M\214\351FBBFFFACFABMF\n"
    "M\215\141CCIFBBFFBMBFF\n"
    "M\215\172ACFFBCAIBFJAfC\n"
    "M\215\230JMFFFBMBBFAcJF\n"
    "M\215\302ABFBFFBMFFFAC\n"
    "M\215\303ABBLBABBFBFFF\n"
    "M\215\316BFBFJFFBACCAC\n"
    "M\215\332FBFFBMFFFBKAC\n"
    "M\215\337BMBBFJFFIBFFF\n"
    "M\215\357FBIBBFaJLAFBFF|j2-y3\n"
    "M\216\153BMFBMFBBMFBMF\n"
    "M\216\215CFFFBMFFBFFBC\n"
    "M\216\216CFFFBMFFFBIKC\n"
    "M\216\221CIAFaJCBMFFFAC\n"
    "M\216\224ACBMFFBiCMFBMF\n"
    "M\216\234CAFAcAfCAcAfCALCC\n"
    "M\216\253AFBBMFBFCAFFB\n"
    "M\217\104AFBACBAJCALCC\n"
    "M\217\126FBMJLFFAJCBCB\n"
    "M\217\200CCIABAFBFFFFB\n"
    "M\217\220BMBBFFBFABMFF\n"
    "M\217\235ABAFBMFFFAMAA\n"
    "M\217\247BCIACCAFBCFJC\n"
    "M\217\306BMFFMgABMFACCC\n"
    "M\217\332CFFFBMFCAFFFB\n"
    "M\217\366FBBFaBgFaAFFACCC\n"
    "M\217\374ACBMFFBiCAFBMB\n"
    "M\220\107AFaJMBFFBMFBIC\n"
    "M\220\121BBFaBCIMFFBFaFaC\n"
    "M\220\124ACBFBBMFFFFAC\n"
    "M\220\126BFCAFFBACAJFB\n"
    "M\220\207BMFFFAFFBBFBF\n"
    "M\220\224CAFBACAcJFAFJK\n"
    "M\220\250FBFJLFBIJFlCMgJ\n"
    "M\220\271FBFFIBBMFFBFF\n"
    "M\220\275CFFFBMFJFMKAC\n"
    "M\220\325BMFBFBIBFJBAC\n"
    "M\220\333FBIFBFFIBCAAC|j2-y3\n"
    "M\220\337AFBAFBMFFBiCMB\n"
    "M\220\355CCABMFFFBFKAC\n"
    "M\221\102JMFFABMFFBFaAC\n"
    "M\221\110BMFBFBIFFFKAC\n"
    "M\221\124BFaBCCCABMFFFB\n"
    "M\221\131CAFLBJJMFFFBF\n"
    "M\221\155ABCABMBFFBMFF\n"
    "M\221\172FBACBMFFFALCC\n"
    "M\221\257BMFFFACFFBKAC\n"
    "M\221\261AcAfCBACFBFBFaJL\n"
    "M\221\271FBIBMFBMFFFAC|j2-y3\n"
    "M\221\330CCIFBBBFBFaBMB\n"
    "M\221\352CCIBFCAFBMFFL\n"
    "M\222\121BMFFBBBMFFFJC\n"
    "M\222\147BMFFACCAFFJFaC\n"
    "M\222\163BFJCIAFFJCBMF\n"
    "M\222\164AFBACABAFBFFF\n"
    "M\222\165BMBBFFBBMFFFL\n"
    "M\222\176FBBBFAcAfCBMBFF\n"
    "M\222\260JMFFBMFFFJMgAA\n"
    "M\222\265BMFBFBIJCILAC\n"
    "M\222\300ABAFBFBMFFFAC\n"
    "M\222\370AJMCBIAFBFFaFjC\n"
    "M\223\123ACFFBCAIAFFJC\n"
    "M\223\144FBFaBCCCCBMFFL\n"
    "M\223\150CCIACFFBACFBF\n"
    "M\223\255ABAFBMFFBFIMJ\n"
    "M\223\302BFFBACFaCBMFFF\n"
    "M\224\137BMBBFFFJFFBiAC\n"
    "M\224\231CCIFBBBMFFFJC|j7-y9\n"
    "M\224\253ACFFBCAIFBACF\n"
    "M\224\300FBIAJMCBIAFlFaC|j2-y3\n"
    "M\224\317CAJCFABMFFFAC\n"
    "M\224\320ACMJFABMFFFAC\n"
    "M\224\367AABBLBFJBiAFJK\n"
    "M\225\237BFaBCFBMFBMBFF\n"
    "M\225\240JMFFAFBMFFAFaC\n"
    "M\225\346FBBBMFFFACFBF\n"
    "M\226\114BMBBFFFBMFCAF\n"
    "M\226\117ACBMFFBiCAMgMFL\n"
    "M\226\213FBBBMFFFACBMB\n"
    "M\226\262FBBBMBBFAFaAFaC\n"
    "M\226\277BMFFJMFFBMBBF\n"
    "M\226\305CCIFJFBAJCCAC\n"
    "M\227\137CCAFACCFFFBMF\n"
    "M\227\141FaCFaBgFABMFFFAC\n"
    "M\227\165FBBBBFaACACBMF\n"
    "M\227\207BFaBACBMFFFBAC\n"
    "M\227\213FBFaBCCCCBMBFF\n"
    "M\227\217FBMJLFFAFaCBMF\n"
    "M\227\240BFBMFFBFFABiAC\n"
    "M\227\270BFJFaFLBMBFFMgJ\n"
    "M\227\351ACFFBCAIACCFaC\n"
    "M\227\351ACFFBCAIACFMgB\n"
    "M\227\353FBFaBCCCCACCFaC\n"
    "M\227\353FBFaBCCCCACFMgB\n"
    "M\227\365BFJCAFMFFBBAC\n"
    "M\230\110BMFBFBIAFaCBMF\n"
    "M\230\117FBACCAFBACAcJF\n"
    "M\230\142CFFFBMFAFBBMF\n"
    "M\230\144BMFFFACJFBMFF\n"
    "M\350\361ACAfCFABMFFFAC\n"
    "N\210\273AcAfCBACFBFJLAFaC\n"
    "N\210\333AcAfCBACABAFBFFF\n"
    "N\210\356AFBACACCABBMFF\n"
    "N\211\102FaCdBACCAMFFAMCC\n"
    "N\211\167BFBFFMgBCCCMFJC\n"
    "N\211\211CCIBBFaFBMBFFAC\n"
    "N\211\307BBFaFBBMFFFACMgA\n"
    "N\211\314FBMFBFBMFBAFaJC\n"
    "N\211\323AFBAFBBMFBBMFF\n"
    "N\212\124FBACMFFBiCFBFJL\n"
    "N\212\164BMFFBMFFAFaCBMF\n"
    "N\212\265ACBLMBFBMFFFAC\n"
    "N\212\307AFBAFBBBFaBMFMF\n"
    "N\212\326BMFFBMFFCAFFJC\n"
    "N\212\370BFMgJAFFBBFFFAC\n"
    "N\213\136ALAFFJCFaCFaBFJC\n"
    "N\213\231CCIAFaBMBFFACCC\n"
    "N\213\253FBIBFCAFBMFFJL\n"
    "N\213\342ACFFBCAIMFFBiAC\n"
    "N\213\354BFBFFMgBCCCFJCL\n"
    "N\214\352CFFFBMFFBMFBMF\n"
    "N\214\353CFFFBMFBMFLbFAC\n"
    "N\215\134FBACFBBFFBMBFF\n"
    "N\215\152AcAfCBACBMCAFBLB\n"
    "N\215\171FBMJLFFFBFAFaBgF\n"
    "N\215\213BFBMFBFaFACbgAAAC\n"
    "N\215\222FBFBFaAFBACJFlFaC\n"
    "N\215\223FBMJLFFAFBFBMF\n"
    "N\215\226ABgACFFFBMFFJKC\n"
    "N\215\260FFAfCABMBFFJLAfC\n"
    "N\215\333FaCdBAFaCCFaCFFBgAC\n"
    "N\216\100BBFaAFaCCFaCFFBAC\n"
    "N\216\107JFlFBACABAFBFFF\n"
    "N\216\132AFBAFBBMFFFFJB\n"
    "N\216\137FBMJLFFAfCJLAFaC\n"
    "N\216\217CFFFBMFFBFALCC\n"
    "N\216\223BFBIALABAFBFFF\n"
    "N\216\245FJBMFCAFAcAfCAcAfC\n"
    "N\216\275CCIFBACACBCAAC\n"
    "N\216\325BFJFBBFACCCCFacaCf\n"
    "N\216\355AFBACAFBMFFBFF\n"
    "N\216\371FBFaBCCCCFABMBB\n"
    "N\217\145ACFFBCAIBFAfCJL\n"
    "N\217\155BFBMFFaBgIJFlCFBF\n"
    "N\217\156BFBMFFaBgIJFlACCC\n"
    "N\217\217AcAfCBACFBFABMFF\n"
    "N\217\262BFCAFBMFFFBAAA\n"
    "N\217\341FaCdBBFCAFBMFFFB\n"
    "N\220\270CAFBACFBFFBMFF\n"
    "N\220\273AFFBMBBBBFABiAC\n"
    "N\220\276FBIAJFBCFFFBMF\n"
    "N\220\303FBFFBMFFAFaMFFB\n"
    "N\220\340CFFFBMFCABMFJL\n"
    "N\221\113ACFFBCAIFFFKAC\n"
    "N\221\114ACFFBCAIAFBFJL\n"
    "N\221\121CCIFBMFFFBAJFB\n"
    "N\221\167MFJCABMBFFBMFF\n"
    "N\221\215AcAfCBACACAfCBLCC\n"
    "N\221\230FBMBBFFBMFFCFacaCf\n"
    "N\221\234ABAFaBMBFACbgAAAC\n"
    "N\221\235FBICABMBFFBMFF\n"
    "N\221\236ACBCABMBFFBMFF\n"
    "N\221\312BFBFFMgBCCCFJCC\n"
    "N\221\324AfCBMFFALALALCC\n"
    "N\222\104FJCABAFBFFFFBC\n"
    "N\222\133BFCAIBLBFABMBB\n"
    "N\222\204BcJFBFCABMFBBMF\n"
    "N\222\245AABBLBFBFIAFJK\n"
    "N\222\320CCIFBFFBMFFFAC\n"
    "N\223\105FBIBFCABMFBBMF|j2-y3\n"
    "N\223\110CCIBFCABMFBBMF\n"
    "N\223\272ACFFBCAIBMFBMF\n"
    "N\223\277AABFBBMBBFALCC\n"
    "N\223\307CFFFBMFFBFBFaJL\n"
    "N\224\106CFFFBMFMgACALCC\n"
    "N\224\112BBFaALCCBMBBFFB\n"
    "N\224\257BFFFFAfCAAAFJFaC\n"
    "N\224\261BMBBFCFFFBMFBB\n"
    "N\224\264BMFFBMFFABFKAC\n"
    "N\224\350FJBMFABMBFFAFB\n"
    "N\225\100ABMFFFBMBFFFJK\n"
    "N\225\131CCIFBMBBFFFBAC\n"
    "N\225\205BFJABFBCBMACAC\n"
    "N\225\241BFaBACACBMFFAFaC\n"
    "N\225\267BMFFBMFFFBFFIB\n"
    "N\225\311FBFIABMFFFABMF\n"
    "N\225\347FBBBMFFFJCBACC\n"
    "N\225\351FBBBMFFFACBMFF\n"
    "N\226\154ABBBCAFCAFFFJC\n"
    "N\226\156BMFFBFFACCCFBF\n"
    "N\226\214JMFFFBBBMFFFJC\n"
    "N\226\235ACBBMFFBMBBFFaC\n"
    "N\226\237CCIBMFFBMBBFFaC\n"
    "N\226\301ACFFBCAIAFaCBMF\n"
    "N\226\302BMFABMFFFMgABCC\n"
    "N\226\310AcAfCBACABMFFBMB\n"
    "N\226\315FBACFBBBMFFFJC\n"
    "N\226\324AcAfCBACBMCAFBFL\n"
    "N\227\125CFFFBMFAFBACAFafag\n"
    "N\227\154FBACCAFFFBCIAC\n"
    "N\227\170BMFBFBIFaCBMFFB\n"
    "N\227\273ABFJCCABMFFBAC\n"
    "N\227\314ACCFaCFABMFFFAC\n"
    "N\227\314ACFMgBFABMFFFAC\n"
    "N\227\316AcAfCBACMFFBCIAC\n"
    "N\227\357FJFBACFBACBMFF\n"
    "N\227\360FJFBACFBACBFBF\n"
    "N\227\373AcAfCBACFBMFFBAC\n"
    "N\230\122CCIMFJFBMBCCCC\n"
    "O\210\324MFJFFBACFBCALCC\n"
    "O\210\342BMFBFBMFFFACCFacaCf\n"
    "O\211\145BMFFBFBMFBACAAA\n"
    "O\211\163ACFFBCAICABMFJL\n"
    "O\211\171CFFFBMFBMFFAMgAL\n"
    "O\211\173BMFFBMFFCABMFJL\n"
    "O\211\217AcAfCBACMFFACbgAAAC\n"
    "O\211\241FBACFBBFBMBFFAC\n"
    "O\211\255ABBFCAFBMFFACCC\n"
    "O\211\322AFBACBBFaFACbgAAAC\n"
    "O\211\333CFFFBMFBMFFFBAC\n"
    "O\211\354ACBMFFBiCAFBAKAC\n"
    "O\212\155FJBMFBFaJBAFBFFF\n"
    "O\212\203CCIABFMFFAMgACCC\n"
    "O\212\275AFFJBBFBFFFAFaJK\n"
    "O\212\304BFBMFBFAFFBMBBF\n"
    "O\212\311AcAfCBACACCAFFJFaC\n"
    "O\212\355BMFBMFFJCBMFBMF\n"
    "O\212\360BcJFFBFBMFCAFBMF\n"
    "O\213\120BCAFJBiBFaFBMFFFB\n"
    "O\213\126ABCAFBFFAFBICAC\n"
    "O\213\131BFJFaFLBBCAIFKAC\n"
    "O\213\207BBFaALABMFFIAMFBmg\n"
    "O\213\331BMBMFBFFaCAcAfCBAC\n"
    "O\213\356BFBFFMgBCCCAMgBMF\n"
    "O\214\115AFBMFFBFIMgJACCC\n"
    "O\214\143BFJMBBFFaACfCCAFaC\n"
    "O\214\200BFJFaFLFACbgAAACBB\n"
    "O\214\202FBMFFFBAFlFaCAFFBg\n"
    "O\214\211CCIFBFFMgAAcAfCBAC\n"
    "O\214\240FBACAFFJBBFBFFF\n"
    "O\215\145AFBACBFBMFBMBMF\n"
    "O\216\102FBIBMFFFBFFIBFaC|j2-y3\n"
    "O\216\136FFJCFFJCBMFFFAC\n"
    "O\216\142FBMFFFBAJFBBMFF\n"
    "O\216\222BMFFFACBMFFAFcgCC\n"
    "O\216\277AJFBAJFBBMFFFAC\n"
    "O\216\357FBFBFACFBFFIBFaC\n"
    "O\217\201CCIBMFFBMgFFFBFF\n"
    "O\217\205CAFBMJLFFFBCCFacaCf\n"
    "O\217\224CFFFBMFFBFABMFF\n"
    "O\217\325AABAFBMFFBFIFFB\n"
    "O\217\334BCABFaBMFBMFFFAC\n"
    "O\217\372BMFMFJABMFBMBFC\n"
    "O\220\122BBFaACAFBACBMBFF\n"
    "O\220\153FBFaBCCCCFJFFBiAC\n"
    "O\220\237CCIFaCACAFBMFCAF\n"
    "O\220\277CFFFBMFFBFFBMFF\n"
    "O\220\366CCIFFJCFFJCBMFF\n"
    "O\220\374AcAfCBACABMFFBFaAC\n"
    "O\221\111MFLMFLFBBFACCFacaCf\n"
    "O\221\112FBMBBFFACMFLCFacaCf\n"
    "O\221\205FBACFBBMBBFBMFF\n"
    "O\221\240FBBJFBFBMFBFKAC\n"
    "O\221\370CFFFBMFFBBJFBMF\n"
    "O\222\116CFFFBMFABAFBFFF\n"
    "O\222\141CFFFBMFABFBFFaCaC\n"
    "O\222\153CFFFBMFCAJCCAJC\n"
    "O\222\222ACFFBCAIFFFJFBC\n"
    "O\222\223BFBFFMgBCCCCFBFF\n"
    "O\222\252CCIFBBMFFFBJMFF\n"
    "O\222\262CFFFBMFJMFBFBMF\n"
    "O\222\304FaCdBCAFACbgAAACFBF\n"
    "O\222\367AcAfCBACBFCABFaBMB\n"
    "O\223\107BFCABMFBBMFAFJK\n"
    "O\223\117AABBFAfCBMFFAFJK\n"
    "O\223\120FBIBFAfCBMFFAFJK|j2-y3\n"
    "O\223\234CAFBACBFJFbFFBMF\n"
    "O\223\245BMFBFBIBFaACBMFF\n"
    "O\223\261CAFABMFFFCFacaCfFBC\n"
    "O\223\352AcAfCBACBMFFBMFFL\n"
    "O\224\115FBFALFBIJFlCACCC\n"
    "O\224\171JFFIBFFFFBMFFFB\n"
    "O\224\205BMFFFACBFCAFBMF\n"
    "O\224\240AFBAFBFBACBMFFF\n"
    "O\224\315AFBAFBFBMFFFBMgL\n"
    "O\224\325AJMCBIJLFaCBMBBF\n"
    "O\224\353BMBBFAfCBMFFALAL\n"
    "O\225\127FBACFBMBBFFFBAC\n"
    "O\225\157BBFaFBACABMFFFAC\n"
    "O\225\176FBMFFBCBFMgJAFJK\n"
    "O\225\206BFJFaFLBMBFFBMFF\n"
    "O\225\212BMFFFACFFBFBIKC\n"
    "O\225\221AFFBBBBFAFaCFBFB\n"
    "O\225\254BMFFBFBBBMFFFAC\n"
    "O\225\255FBIFBFBBBMFFFAC\n"
    "O\225\256BACFBFBBBMFFFAC\n"
    "O\225\274BCABMBACAFACBMB\n"
    "O\225\276BCABMBACAFACFJB\n"
    "O\225\322AcAfCBACFMFJBMFBB\n"
    "O\225\334ACFBFBMFFBMFFBC\n"
    "O\225\344AFBACFBMFFBALCC\n"
    "O\226\112BFABBMFFBACABiAC\n"
    "O\226\134BMFFFBBFACBCIAC\n"
    "O\226\157FBIBBCAFCAFFFJC|j2-y3\n"
    "O\226\200BFJFBACFBACAFFBg\n"
    "O\226\243ABMBFFJLAfCFFBAC\n"
    "O\226\331BMFFBFIFJCCACCC\n"
    "O\227\112FABMFFBFaALCCAFaC\n"
    "O\227\161BBFaALCAFBFFACCC\n"
    "O\227\173CAFBFFACBMFFBiAC\n"
    "O\227\232MFJAABAFBMFFAFaC\n"
    "O\227\266BFJFaFLBMBFFALCC\n"
    "O\227\276BBFaFJCCABMFFBAC\n"
    "O\227\326FBMFFFBACFBMFBB\n"
    "O\227\354FBFaBCCCCFFBBCAF\n"
    "O\230\137CFFFBMFACFBMFBB\n"
    "P\210\334AcAfCBACBMFBMFFBFB\n"
    "P\211\161AABBMFBMFFBFBFFBg\n"
    "P\211\257ACBBFCAFBMFFACfCC\n"
    "P\211\270AFBACACCAMFFALCC\n"
    "P\211\363FBIFBBMBBFBFABiAC\n"
    "P\211\371ACBFBBMBBFBFABiAC\n"
    "P\212\154ABgAFBBABAFBFFFFaC\n"
    "P\212\266ACBJFFBMFCACACfCC\n"
    "P\212\322BMBBFFBMFABACCFacaCf\n"
    "P\212\331ACBMFFBiCBBFaBMFMF\n"
    "P\213\100FBACAcAfCAcAfCFJCKAC\n"
    "P\213\264FBACAFJCBMFBMBMF\n"
    "P\213\273ABFFBMFBMFMFFFAC\n"
    "P\213\303CIALAFFJCFaCFaBFJK\n"
    "P\214\117FBBAFBMFFBFFACCC\n"
    "P\214\145AFBBMFABMFFFALCC\n"
    "P\214\203CCIABMFFBFMgJAFJK\n"
    "P\214\233BBFaFBFFBMBBFALCC\n"
    "P\214\253BFBMFBFFaCBMFFFAC\n"
    "P\215\164AABAFaBMBFFFJCFFBg\n"
    "P\215\244ACCACbgAAMFFBiACFBF\n"
    "P\215\366ACFFBCAIFBBFBMFF\n"
    "P\216\220CFFFBMFCIAFaJCBMF\n"
    "P\216\362ABFAFaBCCCCFABMBB\n"
    "P\216\367FBACFBFBMFCAIFBC\n"
    "P\217\142CCABMBFFFBMFFJKC\n"
    "P\217\143AcAfCBACAABCAFBFJC\n"
    "P\217\353FBIBFACFBBFFABiAC\n"
    "P\217\354BcJFBFACFBBFFABiAC\n"
    "P\217\371ACFFBCAIBBFaFBFJC\n"
    "P\220\144FBBBFCAFFBACAJFB\n"
    "P\220\145BFCAFFBACBMFFFJL\n"
    "P\220\216ACFFBCAIAFFBBFBF\n"
    "P\220\256FBMFBACAFACFBFBF\n"
    "P\220\317AFBACFBFFBMFFFAC\n"
    "P\221\105FBBBFJMBBFFBmgACCC\n"
    "P\221\200FBIBMFBMFBMFFBAC|j2-y3\n"
    "P\221\367CCIBMBBFAMgBMFBIC\n"
    "P\222\144FBIBFBMBMFFBMFFF\n"
    "P\222\172AFBAFBFBIJFlCFBAC\n"
    "P\223\252FBMFCAIFABMFFFAC\n"
    "P\223\304AFBAFBBMBFFMgACCC\n"
    "P\223\334BMFFFBFaBCCCCFFAfC\n"
    "P\224\122CAJCJFjCCFJCCACCC\n"
    "P\224\132CCIBMBBFFFJFFBiAC\n"
    "P\224\226FBBCCIFBMFFBCFBC\n"
    "P\224\233AcAfCBACFBMFFBCFBC\n"
    "P\224\311AFAcMBFAFACAcAfCBAC\n"
    "P\224\360MFJBMFBFCAFFBCFacaCf\n"
    "P\225\231FBBBMFBFBIAFaCBMF\n"
    "P\225\261FJCABAFBFFFBMBFF\n"
    "P\225\307MFJBMFBFCAFFBFBF\n"
    "P\226\104AcAfCBACAFaCFFFBCFacaC\n"
    "P\226\143JMFFFBFBMFCAIAAA\n"
    "P\226\144CFFFBMFFBBFFFBAC\n"
    "P\226\201BFJFBACFBACFABMF\n"
    "P\226\362FBBABMFFCIACFBAC\n"
    "P\227\100CFFFBMFACFBMFFBB\n"
    "P\227\101FBMFFFBACFBMFFBB\n"
    "P\227\132FBMFBMJLFBBMFBIC\n"
    "P\227\151FBIBFAcAfJABAFBFFF\n"
    "P\227\167CFFFBMFACCAFFBLB\n"
    "P\227\212FBMFBACFABMFFFAC\n"
    "P\227\264FBCAFBMFFFLbFLFFF\n"
    "P\227\327FaCdBCAFBACAFaCFBFB\n"
    "P\227\352FBFFFBACMFFBCIAC\n"
    "P\230\102ACFFBCAIFBMFFBAC\n"
    "P\230\136ACFFBCAIMFFBCIAC\n"
    "Q\212\144BMFFBFJBACFBFJBAC\n"
    "Q\212\215FBMFFFBBBFaFBFFBMF\n"
    "Q\212\302FBFIBMBBFFBMFABAC\n"
    "Q\212\330FBBMFFFBBMFBMFFLB\n"
    "Q\213\133FBIALAFFJCFaCFaBFJC|j2-y3\n"
    "Q\213\135AFBICAFBFFAFBgICAC\n"
    "Q\213\270AFFJCAFACBMFBMBMF\n"
    "Q\213\336CFFFBMFFBBBMFBFFF\n"
    "Q\214\252CFFFBMFCAFMFFBBAC\n"
    "Q\214\256ACFFBCAIMFFFFBFaFaC\n"
    "Q\214\265CCAFJFBFBFFIBAFAC\n"
    "Q\215\165CFFFBMFFBBFFBMBFF\n"
    "Q\215\167BMFFFACFBBFFBMBFF\n"
    "Q\215\247ACCACbgAAMFFBiACALCC\n"
    "Q\216\103FBIBBFaAFaCCFaCFFBAC|j2-y3\n"
    "Q\216\323CFFFBMFABMFFFAFBC\n"
    "Q\216\335ACCABMBBFMFFBiCFBC\n"
    "Q\217\130FBMJLFFABMBFFJLAfC\n"
    "Q\217\153AcAfCBACBBFaABFABMFF\n"
    "Q\217\236ABBCABFaBMFBMFFFAC\n"
    "Q\217\312FJBMFABAFBFFFACCC\n"
    "Q\220\321AcAfCBACFBFFBMFFFAC\n"
    "Q\221\100AcAfCBACFBFBBCAIKAC\n"
    "Q\221\116AFaBMBFFBCCCCAFFFB\n"
    "Q\221\207CAJCBMFBMFBMFFBAC\n"
    "Q\221\232FBFaBCCCCFBACBMFFF\n"
    "Q\221\363CCIMFFMFFABAFBFFF\n"
    "Q\222\142ACFFBCAIABFFIAFlFaC\n"
    "Q\222\256FBFFIBFBBMBBFBLCC\n"
    "Q\223\243JMFFCAFFJCCFFFBMF\n"
    "Q\223\265BMFFFBFCAFBMFFBFF\n"
    "Q\225\160BFBFBACAFABMFFFAC\n"
    "Q\227\104ABFABMFFAFaALCCAFaC\n"
    "Q\227\203MCIMCIBMBFFFBBFAC\n"
    "Q\227\227BFBMFBFAFFBMFFFJL\n"
    "Q\227\303BFJCIFJCCABMFFBAC\n"
    "Q\227\344BLBACCFaCFABMFFFAC\n"
    "Q\227\344BLBACFMgBFABMFFFAC\n"
    "Q\227\356BFBFCAFBACLBACCFaC\n"
    "Q\227\356BFBFCAFBACLBACFMB\n"
    "Q\350\117ACFFBCAIBMBFBMBMF\n"
    "R\212\156AFBACFBBABBFBFFFFaC\n"
    "R\212\172BBFaJFaCBMFFABMFFFAC\n"
    "R\212\310AFBAFBBMFFBMFFBMFF\n"
    "R\212\317AFFJBBFBFFFBMFFFJL\n"
    "R\212\347BFCAFJAAAFABMFFFAC\n"
    "R\213\122FBBFFMgBCCCFJCFBMFB\n"
    "R\213\335BFaBACFBACFBACFFBAC\n"
    "R\214\260BMFFBBCAIFABMFFFAC\n"
    "R\214\261BFBFFMgBCCCACFBMFJC\n"
    "R\215\275ACFFBCAIBCABMFFFAC\n"
    "R\217\165BMFFFACCABFaJFjCFBFB\n"
    "R\220\104AcAfCBACBFCAFBMFFKAC\n"
    "R\220\105FBFFIBBFCAFBMFFKAC\n"
    "R\221\125AcAfCBACCAFFFBCAFBMF\n"
    "R\221\142FJBMFFBACFBACFaBFAC\n"
    "R\221\241BMFFFACCABMBFFBMFF\n"
    "R\221\325FBFBMBFFFBFBFACKAC\n"
    "R\221\350BMFFFBFACFABMFFFAC\n"
    "R\222\246AABBLBFBFFAFACALCC\n"
    "R\222\301ACFFBCAIFBBMFFFFAC\n"
    "R\223\254BMFFBMFFFBMFCAIFBC\n"
    "R\223\357FBBBMFFFJCABBFBFFF\n"
    "R\224\313FBBCCIACAFBACBMBFF\n"
    "R\225\210CFFFBMFCAFBBACBMFF\n"
    "R\225\242FBMBBFAABAFBMFFAFaC\n"
    "R\225\310BFJCIMFJBMFBFCAFFB\n"
    "R\225\353AFBAFBCCIFBMFFBFBC\n"
    "R\226\174ACAFBACBMBFFMCIMCI\n"
    "R\226\232FBBBMBAcAfCBACBMFBIC\n"
    "R\226\266FBFaBCCCCFaCFaBAFACMgJ\n"
    "R\226\374BFJCIACFBMCCAcAcALCC\n"
    "R\227\152BMFFMFFMFFABAFBFFF\n"
    "R\227\224CCIBFBMFBFAFFBMBBF\n"
    "R\227\243BFACLBBMAfCABBFBFFF\n"
    "R\227\306CAFBACBMFFFBMFFBFF\n"
    "R\227\325BFBMFBFAFBMFBMFBMF\n"
    "R\227\336CAFBACFJCFABMFFFAC\n"
    "S\211\103BFCAFBMFFBMFBMFFFAC\n"
    "S\212\350FJBBMFFBACFABMFFFAC\n"
    "S\213\276ACFFBCAIBFCAFBMFFJL\n"
    "S\214\112AcAfCBACBMFBMFBMFFBAC\n"
    "S\214\170FBBAMgBMFAFACCFFFBMF\n"
    "S\214\173ACCAFFJCABMFFFMgBCCC\n"
    "S\214\176AFaBMBFFBCCCBFBMFBAC\n"
    "S\216\243FACBMBACACACACFBFFC\n"
    "S\216\257CFFFBMFBFCAFBMFFKAC\n"
    "S\220\221BMBFBFaBMFFAFBMFFCFacaC\n"
    "S\220\243CCIFBMFBACFABMFFFAC\n"
    "S\221\224FBBCCIBMFBMFBMFFBAC\n"
    "S\221\237JMFFFBBJFBFBMFBFKJC\n"
    "S\224\145FBMBBFFBBFBMFFBJMFF\n"
    "S\224\232CAJCBMFFFBBFACBCIAC\n"
    "S\226\202BFJFBACFBACABMBFFAL\n"
    "S\227\205BMBBFAcAfCBACABAFBFFF\n"
    "S\227\355FBMCFBMCBFJMBBFABiAL\n"
    "T\213\143CFFFBMFCAFBFFAFBICAC\n"
    "T\213\243BFCAFBMFJBiBFCAFBMFJL\n"
    "T\213\277AcAfAMFFBiCFaCdBBFCAFBMFF\n"
    "T\214\234BMFFFLBACAAcAfCBACALCC\n"
    "T\214\354CFFFBMFFBBABAFBFFFFaC\n"
    "T\217\340ACFFBCAIBFCAFBMFFBFF\n"
    "T\217\367CFFFBMFBFACFBBFFABiAC\n"
    "T\217\370FBMJLFFBFACFBBFFABiAC\n"
    "T\220\320AFBAFBFFFBACFBBFBMFF\n"
    "T\223\253JMFFCAFFJCBFBFFMgACCC\n"
    "T\227\223FBACBMFFBMFFFBMFFBAC\n"
    "U\212\315AJMCBIBMBMFBFAFFBMBBF\n"
    "U\214\332FMFJABBFBFFFFABMFFFAC\n"
    "U\226\364BMFBFBIMFFMFFABAFBFFF\n"
    "U\230\111FBFaBCCCCBMFBFBIAFaCBMF\n"
    "V\213\301FBBAMgBMFAFACBFBFFMgACCC\n"
    "V\217\120BFCAFBMFFFBmFLFFFBFABiAC\n"
    "V\342\304AFBAFBBFCAFBMFFFBmFLFFF\n"
    "W\212\323ACFFBCAIBMBMFBFAFFBMBBF\n"
    ;
}
#endif /* FOR_STROKEDIC_CREATE_2 */
#endif /*__STROKEDATA_H__*/
/* ----- End of strokedata.h ---------------------------------------------- */
