/* XWorm (C) 1995-96 by The Last Viking */
/* Revision: 1.02                       */
 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <time.h>
#include <string.h>
#include <stdio.h>

#define gridfile "xworm.grid"
#define fontfile "xworm.font"
#define logofile "xworm.raw"

#define maxQ 5000    /* max queue */
#define NCOLORS 15   /* number of colours */
#define stepi 7      /* snake steps */ 
#define maxApl 10    /* Max apples */
#define maxStone 12  /* Max Stones */
#define splode 20    /* number of cells in the explosion */
#define maxGrid 6481
#define maxVec 200 

char title[]="XWorm v1.02";

 /* Declarations */

 Bool		predproc();

 Display	*display;
 Window		window;
 GC			gc;
 XEvent		event;
 XImage		*image;
 KeySym		key;
 XSizeHints	hint;
 Font		font;

 int		screen;
 unsigned long 	background;
 XWindowAttributes	attribs;

 FILE *fp ; /* global structures and variables for the highscore */
 FILE *fpl; /* the logo file */
 char strint[80];

 float vec_tab[maxVec][4]; /* Character table */
 float vec_tabB[maxVec][4]; /* Character table RAM backup */

 char logo_buf[4002]; /* buffer for the logo file */
 int  logo_cnt;

 typedef struct {
  int     r,g,b;
 } rgb_info;

 static unsigned int npixels = NCOLORS; /* Number of customizable colorpixels allocated by X-server */
 static rgb_info rgb_tab[NCOLORS] = { /* RGB values for the first part of the color table: */
  {65535, 65535, 16384}, /* 0 - Gul */
  {65535, 65535, 65535}, /* 1 - White */
  {55296, 34048, 18944}, /* 2 - Snake colour */
  {65535,     0,     0}, /* 3 - Apple roed */
  {    0, 65535,     0}, /* 4 - Apple groenn. */
  {    0, 16384,     0}, /* 5 - Lawn */
  {36864, 36864, 36864}, /* 6 - Mushy Gray  */
  {64768, 13824, 13824}, /* 7 - Mushy Red */
  {60160, 60160, 60160}, /* 8 - Mushy White */
  {    0,     0, 10240}, /* 9 - Dark blue - background */
  { 9216, 22016,  9216}, /*10 - logo colour 1 dark */
  {    0, 57088, 16384}, /*11 - logo colour 2 light */
  {65025, 19456, 37376}, /*12 - Pink */
  {27136, 40960, 65280}, /*13 - Pastel like */
  {64768, 42240, 62464}  /*14 - Purple pastel */
 };
 XColor color_tab[NCOLORS]; /* Color table: */

 Colormap colormap;
 unsigned long pixels[NCOLORS];

 struct timeval timeout; /* used for the timer */

 int    x1,ny1,xbak,ybak,wx,wy,mx,my;
 int 	counter,addon,wlen;
 unsigned long int score=0;
 unsigned long int hiscore=0;
 int	bitT;

 long   event_mask;
 int	i;
 char 	text[50];
 static int	done,start;
 int    xit;

 int 	queue[maxQ+2][2];
 static int	head,tail=0;
 int    apple[maxApl+1][2];
 int    mush[maxStone+1][2];

 float	crashtab[splode+2][2];
 float  crashtabdir[splode+2][2];

 int	gridX[maxGrid][2];

void AllocColours(void);
void xwinactions(void);

void wormdraw (void);
void appledraw(void);
void mushdraw(void);
void fencedraw(void);
void blockdraw(void);
void simulatecrash(void);

int chcoll(void); 
void chacoll(void);
int chmcoll(int,int);

void crapple(void);
void crmush(void);
void crblank(void);

void intro(void);
void read_logo(void);
void plot_logo(int,int,int);
void xwinintroactions(void);

void put0 (int i);
void put1 (int i);
int get0 ();
int get1 ();
float rnd(int x);
void randomize(void);
void rgrid(void);

void vec_init(void);
int vec_plot(char,int,int);
void vec_line(int,int,int,int);
int vec_wrline(char *,int,int,int);
int vec_wrlineX(char *,int,int,int,float);

void main(int argc, char **argv) {

 memset(&timeout, 0, sizeof(struct timeval));

 randomize();
 rgrid();
 vec_init();
 
 printf("XWorm 1995-97 Ekran Design.\n");
 hiscore=0;

 display=XOpenDisplay("");
 screen=DefaultScreen(display);

 hint.x=100; hint.y=100;
 hint.width=637; hint.height=511;
 hint.flags=PPosition | PSize;

 AllocColours();
 background=color_tab[9].pixel;
 window=XCreateSimpleWindow(display,DefaultRootWindow(display),
          hint.x,hint.y,hint.width,hint.height,5,color_tab[1].pixel,background);

 XSetStandardProperties(display,window,title,title,None,argv,argc,&hint);
 

 gc=XCreateGC(display,window,0,0);
 XSetBackground(display,gc,color_tab[5].pixel);
 XSetForeground(display,gc,color_tab[2].pixel);
 XSelectInput(display,window,KeyPressMask | ExposureMask);
 XMapRaised(display,window);
 
 bailout:
 while (xit==0){ /* Main wrapping */
  done=0; xit=0;
  intro();
  if (xit!=0) goto bailout;
 
  done=0; head=0; tail=0;
  x1=4*stepi; ny1=25*stepi; 
  wx=hint.width; wy=hint.width; 
  mx=stepi; my=0;
  score=0;
  addon=30; wlen=0; /* worm length and how many more cells to add */

  event_mask=Expose | MappingNotify | KeymapNotify;
  for (i=1;i<=maxQ+1;i++){queue[i][0]=0; queue[i][1]=0;} /* initialize queue */
  for (i=0;i<=5;i++) {apple[i][0]=0; apple[i][1]=0;} /* initialize apple grid */

  xbak=x1;ybak=ny1; x1=0;ny1=0; /* draw the electric fence around the screen */
  for (i=0;i<92;i++) {fencedraw();x1=x1+stepi;} ny1=ny1+stepi; x1=hint.width;
  for (i=0;i<73;i++) {fencedraw();ny1=ny1+stepi;} x1=x1-stepi; ny1=hint.height;
  for (i=0;i<92;i++) {fencedraw();x1=x1-stepi;} x1=0; ny1=ny1-stepi;
  for (i=0;i<73;i++) {fencedraw();ny1=ny1-stepi;} 
  x1=xbak;ny1=ybak;

  crmush(); /* put the bad mushrooms onto the screen */
  put0(x1);put1(ny1); /* put the first cell in */

  /* ---   Game Loop   --- */
 
  while (done==0) {  /* done: 0 = ok, 1 = edge collide, 2 - full queue, 3 - crash */

   if (addon==0) {  /* this is the back part of the snake. If addon>0 then snake is growing */
    xbak=x1; ybak=ny1;
    x1=get0();
    ny1=get1(); 
    XSetForeground(display,gc,color_tab[5].pixel);
    wormdraw();
    x1=xbak; ny1=ybak;
   } 
   else { 
    addon--; wlen++;
    if (wlen>35) score=score+50;
   }
   XSetForeground(display,gc,color_tab[2].pixel);
   x1=x1+mx; ny1=ny1+my;
   wormdraw(); 
   done=chcoll(); /* crash into wall, itself or a mushroom */
   chacoll();
   put0(x1); put1(ny1);
   counter++;
   if (counter>100) { /* add a link for every 100'th movement */
    counter=0; addon=1;
    if (rnd(1000)>250) crapple(); 
   } 

   XSync(display,False);
   timeout.tv_usec = 20000;
   select(0,NULL,NULL,NULL, &timeout);
   XCheckIfEvent(display,&event,predproc,"foo");
   xwinactions();
  } /* game wrapping */

  simulatecrash();
 
  if (done==2) xit=1;
 } /* MAIN LOOP ENDS HERE! */

 XFreeGC(display,gc); /* shutdown */
 XDestroyWindow(display,window);
 XCloseDisplay(display);
 exit (0);
}


void xwinactions(void){
 switch(event.type) {
 case Expose:
   if (event.xexpose.count==0) {
    XGetWindowAttributes(display,window,&attribs);
    if ((wx=attribs.width) || (wy=attribs.height)) {
      XResizeWindow(display,window,hint.width,hint.height);
    }
   }
  break;

 case MappingNotify:
  XRefreshKeyboardMapping((XMappingEvent *)&event); 
  break;

 case KeyPress:
  i=XLookupString((XKeyEvent *)&event,text,10,&key,0);
  if (i==1) switch (text[0]) {
   case 'q': case '9': done=1; break; 
   case 'e': done=1; xit=1; break; 

   case 'w': case '5': if (my!=stepi) {my=-stepi;mx=0;} break; 
   case 'x': case '2': if (my!=-stepi) {my=stepi;mx=0;} break; 
   case 'a': case '1': if (mx!=stepi) {my=0;mx=-stepi;} break; 
   case 'd': case '3': if (mx!=-stepi) {my=0;mx=stepi;} break; 

   default: break; 
  }
  break; 
 } /* switch */
}

/*---------------------*/
/* graphical creations */
/*---------------------*/

void crmush(void) { /* create the 'bad' mushrooms' */
 int stcnt,stcnt2,tst;

 xbak=x1;ybak=ny1;

 for (stcnt=0; stcnt<maxStone; stcnt++) {
  mush[stcnt][0]=0;
  mush[stcnt][1]=0;
 }

 stcnt2=rnd(3)+4; /* total number of mushrooms */
 stcnt=0;
 while (stcnt<=stcnt2) {
  tst=1;
  while ((mush[stcnt][1]==25*stepi) || (tst==1)) {
   tst=0; 
   mush[stcnt][0]=(stepi*rnd((hint.width/stepi)-2*stepi)+4*stepi); /* random mushroom location */
   mush[stcnt][1]=(stepi*rnd((hint.height/stepi)-2*stepi)+4*stepi);
   for (i=0; i<stcnt; i++) if ((mush[i][0]==mush[stcnt][0]) || (mush[i][1]==mush[stcnt][1])) tst=1;
  }
  x1=mush[stcnt][0];
  ny1=mush[stcnt][1];
  mushdraw();
  stcnt++;
 }
 x1=xbak;ny1=ybak;
}

void crapple(void) { /* create a new apple */
 int tst,tst2,c,i;
 tst=0; tst2=1;
 while (apple[tst][0]!=0) tst++;
 if (tst<maxApl) {
  while (tst2==1) { 
   c=head;
   apple[tst][0]=stepi*rnd((hint.width/stepi)-2*stepi)+stepi*4; /* random apple location */
   apple[tst][1]=stepi*rnd((hint.height/stepi)-2*stepi)+stepi*4;
   tst2=0;
   while (c!=tail) { /* check if the new apple crash into a snake or mushroom location. */
    if ((apple[tst][0]==queue[c][0]) && (apple[tst][1]==queue[c][1])) tst2=1;
    if (chmcoll(apple[tst][0],apple[tst][1])==1) tst=1; 
    c++;
    if (c>maxQ) c=0;
   }
   for (i=0; i<maxApl; i++) 
    if (((apple[i][0]==apple[tst][0]) || (apple[i][1]==apple[tst][1])) && (tst!=i)) tst2=1;
  }
  xbak=x1;ybak=ny1; /* store xycord */
  x1=apple[tst][0];ny1=apple[tst][1];
  appledraw(); 
  x1=xbak;ny1=ybak;
 } 
}

void crblank(void) {
 int c=0;
 xbak=x1;ybak=ny1;
 for (c=0;c<=maxGrid;c++) {
  x1=gridX[c][0]*stepi;
  ny1=gridX[c][1]*stepi;
  blockdraw(); 
 }
 for (c=0;c<hint.height;c++) {
  XDrawLine(display,window,gc,0,c,hint.width,c);
 } 
 xbak=x1;ybak=ny1;
}

/*------------------------------*/
/* collision detection handling */
/*------------------------------*/

int chcoll(void) {
 int c;
 if ((x1>hint.width-stepi) || (x1<stepi) || (ny1>hint.height-stepi) || (ny1<stepi)) return (1);
 c=head;
 while (c!=tail) {
  if ((x1==queue[c][0]) && (ny1==queue[c][1])) return (3);
  c++;
  if (c>maxQ) c=0; 
 }
 if (chmcoll(x1,ny1)==1) return 3;
 return (0);
}

void chacoll (void) { /* check if the worm ate an apple */
 int tst,value;
 tst=0;value=0;
 while (tst<maxApl) {
  if ((apple[tst][0]==x1) && (apple[tst][1]==ny1)) {
   apple[tst][0]=0; apple[tst][1]=0;
   value=rnd(6)+2;
   score=score+100*value;
   addon=5+value;
   return;
  }
  tst++;
 }
}

int chmcoll(int x, int y) { /* check if x and y crash with a mushroom */
 int c;
 c=0;
 while ((mush[c][0]!=0) && (mush[c][1]!=0)) {
  if ((mush[c][0]==x) && (mush[c][1]==y)) return 1;
  c++;
 }
 return 0;
}

void simulatecrash(void){

 float grav;

 for (i=0;i<splode; i++) { /* set up a random table for directions */
  crashtab[i][0]=x1; crashtab[i][1]=ny1;
  crashtabdir[i][0]=(((rnd(10000)/10000)*2)-1)*5; crashtabdir[i][1]=(((rnd(10000)/10000)*2)-1)*5;
 } 
 done=0;
 XSetForeground(display,gc,color_tab[1].pixel);
 vec_wrlineX("GAME OVER",120,200,2,5.5); vec_wrlineX("GAME OVER",121,200,2,5.5);
 vec_wrlineX("GAME OVER",122,200,2,5.5);
 
 if (score>=hiscore) {
   vec_wrline("CONGRATULATIONS! NEW HIGH-SCORE!",150,100,4);
   vec_wrline("CONGRATULATIONS! NEW HIGH-SCORE!",151,100,4);
   hiscore=score;
 } 

 grav=0;

 for (counter=0;((counter<250) && (done==0)); counter++) {
 
  XSync(display,False);
  XCheckIfEvent(display,&event,predproc,"foo");
  xwinactions(); 
 
  XSetForeground(display,gc,color_tab[5].pixel);
  for (i=0;i<splode; i++) {
   x1=crashtab[i][0];ny1=crashtab[i][1];
   wormdraw();
  }
  XSetForeground(display,gc,color_tab[2].pixel);
  for (i=0;i<splode; i++) {
   crashtab[i][0]=crashtab[i][0]+crashtabdir[i][0];
   crashtab[i][1]=crashtab[i][1]+crashtabdir[i][1]+grav;
   x1=crashtab[i][0];ny1=crashtab[i][1];
   wormdraw(); grav=grav+0.002;
  } 
 }
 counter=0;
}

/*-------------------*/
/* graphical objects */
/*-------------------*/

void blockdraw(void) {
  XFillRectangle(display,window,gc, x1-3,ny1-3,stepi,stepi);
}

void wormdraw(void){

  XDrawPoint(display,window,gc,x1,ny1);
 
  XDrawPoint(display,window,gc,x1-1,ny1); XDrawPoint(display,window,gc,x1-1,ny1-1); 
  XDrawPoint(display,window,gc,x1,ny1-1); XDrawPoint(display,window,gc,x1+1,ny1-1); 
  XDrawPoint(display,window,gc,x1+1,ny1); XDrawPoint(display,window,gc,x1+1,ny1+1); 
  XDrawPoint(display,window,gc,x1,ny1+1); XDrawPoint(display,window,gc,x1-1,ny1+1); 

  XDrawPoint(display,window,gc,x1-2,ny1); XDrawPoint(display,window,gc,x1-2,ny1-1); 
  XDrawPoint(display,window,gc,x1-2,ny1-2); XDrawPoint(display,window,gc,x1-1,ny1-2); 
  XDrawPoint(display,window,gc,x1,ny1-2); XDrawPoint(display,window,gc,x1+1,ny1-2); 
  XDrawPoint(display,window,gc,x1+2,ny1-2); XDrawPoint(display,window,gc,x1+2,ny1-1); 
  XDrawPoint(display,window,gc,x1+2,ny1); XDrawPoint(display,window,gc,x1+2,ny1+1); 
  XDrawPoint(display,window,gc,x1+2,ny1+2); XDrawPoint(display,window,gc,x1+1,ny1+2); 
  XDrawPoint(display,window,gc,x1,ny1+2); XDrawPoint(display,window,gc,x1-1,ny1+2); 
  XDrawPoint(display,window,gc,x1-2,ny1+2); XDrawPoint(display,window,gc,x1-2,ny1+1); 

  XDrawPoint(display,window,gc,x1-2,ny1+3); XDrawPoint(display,window,gc,x1-1,ny1+3); 
  XDrawPoint(display,window,gc,x1,ny1+3); XDrawPoint(display,window,gc,x1+1,ny1+3); 
  XDrawPoint(display,window,gc,x1+2,ny1+3); XDrawPoint(display,window,gc,x1+3,ny1+2); 
  XDrawPoint(display,window,gc,x1+3,ny1+1); XDrawPoint(display,window,gc,x1+3,ny1); 
  XDrawPoint(display,window,gc,x1+3,ny1-1); XDrawPoint(display,window,gc,x1+3,ny1-2); 
  XDrawPoint(display,window,gc,x1+2,ny1-3); XDrawPoint(display,window,gc,x1+1,ny1-3); 
  XDrawPoint(display,window,gc,x1,ny1-3); XDrawPoint(display,window,gc,x1-1,ny1-3); 
  XDrawPoint(display,window,gc,x1-2,ny1-3); XDrawPoint(display,window,gc,x1-3,ny1-2); 
  XDrawPoint(display,window,gc,x1-3,ny1-1); XDrawPoint(display,window,gc,x1-3,ny1); 
  XDrawPoint(display,window,gc,x1-3,ny1+1); XDrawPoint(display,window,gc,x1-3,ny1+2); 
}

void appledraw(void) {
  XSetForeground(display,gc,color_tab[3].pixel); /* red */
  XDrawPoint(display,window,gc,x1-1,ny1+3); XDrawPoint(display,window,gc,x1,ny1+3);
  XDrawPoint(display,window,gc,x1+1,ny1+3); XDrawPoint(display,window,gc,x1-2,ny1+2);
  XDrawPoint(display,window,gc,x1-1,ny1+2); XDrawPoint(display,window,gc,x1,ny1+2);
  XDrawPoint(display,window,gc,x1+1,ny1+2); XDrawPoint(display,window,gc,x1+2,ny1+2);
  XDrawPoint(display,window,gc,x1-3,ny1+1); XDrawPoint(display,window,gc,x1-2,ny1+1);
  XDrawPoint(display,window,gc,x1-1,ny1+1); XDrawPoint(display,window,gc,x1,ny1+1);
  XDrawPoint(display,window,gc,x1+1,ny1+1); XDrawPoint(display,window,gc,x1+2,ny1+1);
  XDrawPoint(display,window,gc,x1+3,ny1+1);
  XDrawPoint(display,window,gc,x1-3,ny1); XDrawPoint(display,window,gc,x1-2,ny1);
  XDrawPoint(display,window,gc,x1-1,ny1); XDrawPoint(display,window,gc,x1,ny1);
  XDrawPoint(display,window,gc,x1+1,ny1); XDrawPoint(display,window,gc,x1+2,ny1);
  XDrawPoint(display,window,gc,x1+3,ny1);
  XDrawPoint(display,window,gc,x1-2,ny1-1); XDrawPoint(display,window,gc,x1-1,ny1-1);
  XDrawPoint(display,window,gc,x1+1,ny1-1); XDrawPoint(display,window,gc,x1+2,ny1-1);
  XDrawPoint(display,window,gc,x1-1,ny1-2);
  XSetForeground(display,gc,color_tab[4].pixel);
  XDrawPoint(display,window,gc,x1,ny1-1); XDrawPoint(display,window,gc,x1,ny1-2); 
  XDrawPoint(display,window,gc,x1+1,ny1-2); XDrawPoint(display,window,gc,x1,ny1-3); 
  XDrawPoint(display,window,gc,x1+1,ny1-3); XDrawPoint(display,window,gc,x1+2,ny1-3); 
}

void mushdraw(void) {
  XSetForeground(display,gc,color_tab[6].pixel); /* gray */
  XDrawPoint(display,window,gc,x1-1,ny1+3); XDrawPoint(display,window,gc,x1+1,ny1+3); 
  XDrawPoint(display,window,gc,x1,ny1+3); XDrawPoint(display,window,gc,x1,ny1+2); 
  XDrawPoint(display,window,gc,x1,ny1+1); 
  XSetForeground(display,gc,color_tab[7].pixel); /* red */
  XDrawPoint(display,window,gc,x1,ny1); XDrawPoint(display,window,gc,x1,ny1-1);
  XDrawPoint(display,window,gc,x1-1,ny1-1); XDrawPoint(display,window,gc,x1-3,ny1-1);
  XDrawPoint(display,window,gc,x1+2,ny1-1); XDrawPoint(display,window,gc,x1-2,ny1-2);
  XDrawPoint(display,window,gc,x1,ny1-2); XDrawPoint(display,window,gc,x1+1,ny1-2);
  XDrawPoint(display,window,gc,x1+2,ny1-2); XDrawPoint(display,window,gc,x1,ny1-3);
  XDrawPoint(display,window,gc,x1-1,ny1-3);
  XSetForeground(display,gc,color_tab[8].pixel); /* white */
  XDrawPoint(display,window,gc,x1-2,ny1-1); XDrawPoint(display,window,gc,x1+1,ny1-1);
  XDrawPoint(display,window,gc,x1+3,ny1-1); XDrawPoint(display,window,gc,x1-1,ny1-2);
  XDrawPoint(display,window,gc,x1+1,ny1-3);
}

void fencedraw(void) {
 
  XSetForeground(display,gc,color_tab[6].pixel); /* gray */

  XDrawPoint(display,window,gc,x1-3,ny1-3); XDrawPoint(display,window,gc,x1-2,ny1-3);
  XDrawPoint(display,window,gc,x1-1,ny1-3); XDrawPoint(display,window,gc,x1,ny1-3);
  XDrawPoint(display,window,gc,x1+1,ny1-3); XDrawPoint(display,window,gc,x1+2,ny1-3);
  XDrawPoint(display,window,gc,x1+3,ny1-3);
 
  XDrawPoint(display,window,gc,x1-3,ny1-2); XDrawPoint(display,window,gc,x1-1,ny1-2);
  XDrawPoint(display,window,gc,x1+1,ny1-2); XDrawPoint(display,window,gc,x1+3,ny1-2);

  XDrawPoint(display,window,gc,x1-3,ny1-1); XDrawPoint(display,window,gc,x1-2,ny1-1);
  XDrawPoint(display,window,gc,x1-1,ny1-1); XDrawPoint(display,window,gc,x1,ny1-1);
  XDrawPoint(display,window,gc,x1+1,ny1-1); XDrawPoint(display,window,gc,x1+2,ny1-1);
  XDrawPoint(display,window,gc,x1+3,ny1-1);

  XDrawPoint(display,window,gc,x1-3,ny1); XDrawPoint(display,window,gc,x1-1,ny1);
  XDrawPoint(display,window,gc,x1+1,ny1); XDrawPoint(display,window,gc,x1+3,ny1);

  XDrawPoint(display,window,gc,x1-3,ny1+1); XDrawPoint(display,window,gc,x1-2,ny1+1);
  XDrawPoint(display,window,gc,x1-1,ny1+1); XDrawPoint(display,window,gc,x1,ny1+1);
  XDrawPoint(display,window,gc,x1+1,ny1+1); XDrawPoint(display,window,gc,x1+2,ny1+1);
  XDrawPoint(display,window,gc,x1+3,ny1+1);

  XDrawPoint(display,window,gc,x1-3,ny1+2); XDrawPoint(display,window,gc,x1-1,ny1+2);
  XDrawPoint(display,window,gc,x1+1,ny1+2); XDrawPoint(display,window,gc,x1+3,ny1+2);

  XDrawPoint(display,window,gc,x1-3,ny1+3); XDrawPoint(display,window,gc,x1-2,ny1+3);
  XDrawPoint(display,window,gc,x1-1,ny1+3); XDrawPoint(display,window,gc,x1,ny1+3);
  XDrawPoint(display,window,gc,x1+1,ny1+3); XDrawPoint(display,window,gc,x1+2,ny1+3);
  XDrawPoint(display,window,gc,x1+3,ny1+3);
}

void AllocColours(void){
/* Allocates and initializes global color-table ... */
  
 colormap = DefaultColormap(display, screen);
  if (!XAllocColorCells(display, colormap, True, NULL, 0, pixels, npixels)) {
    fprintf(stderr, "failed to allocate all %d colours\n", NCOLORS);
    exit(1);
  }
  for (i = 0; i < NCOLORS; i++) { /* Initialize RGB values ... */
    color_tab[i].pixel = pixels[i];
    color_tab[i].red   = rgb_tab[i].r;
    color_tab[i].green = rgb_tab[i].g;
    color_tab[i].blue  = rgb_tab[i].b;
    color_tab[i].flags = DoRed | DoGreen | DoBlue;
  }
  XStoreColors(display, colormap, color_tab, npixels);
}

Bool predproc (display,event,arg)

Display	*display;
XEvent	*event;
char	*arg;
{
 switch (event->type) {
  case Expose:
    return (True);
    break;
  case MotionNotify:
    return (True);
    break;
  case KeyPress:
    return (True);
    break;
 }
 return (False);
}

/*----------------*/
/* queue handling */
/*----------------*/

void put0 (int i) {
 queue[tail++][0]=i;
 if (tail==head) { printf("The Queue is full!!\n"); done=2;}
 if (tail>maxQ) tail=0;
}

void put1 (int i) {
 queue[tail][1]=i;
}
int get0 () {
 int t=queue[head++][0]; if (head>maxQ) head=0;
 return t;
}

int get1 () {
 int t=queue[head][1];
 return t;
}

/*-----------------------*/
/* front screen handling */ 
/*-----------------------*/

void intro(void) {

 start=0;

 XSetForeground(display,gc,color_tab[9].pixel);
 crblank();
 logo_cnt=0; 
 read_logo();

 logo_cnt=0;
 plot_logo(0,60,10);
 plot_logo(0,60,11);

 while (start==0) {
  XSync(display,False);
  timeout.tv_usec = 20000;
  select(0,NULL,NULL,NULL, &timeout);

  XCheckIfEvent(display,&event,predproc,"foo");
  xwinintroactions();

  XSetForeground(display,gc,color_tab[7].pixel);
  vec_wrline("CODED BY THE LAST VIKING IN 1996.",192,180,2);
  XSetForeground(display,gc,color_tab[12].pixel);
  vec_wrline("CODED BY THE LAST VIKING IN 1996.",191,180,2);

  XSetForeground(display,gc,color_tab[1].pixel);
  vec_wrline("IN THIS GAME YOU MUST HELP WORMIE - THE HUNGRY MAGGOT, TO STEAL APPLES FROM",14,210,2);
  vec_wrline("BAZAR THE EVIL. BAZAR HAS PUT AN ELECTRIC FENCE AROUND THE GARDEN, AND HE",17,220,2);
  vec_wrline("HAS ALSO BEEN SPREADING POISIONOUS MUSHROOMS INTO IT. YOU MUST GUIDE WORMIE",16,230,2);
  vec_wrline("AROUND THESE OBJECTS, AND YOU MUST KEEP HIM FROM EATING HIMSELF.",59,240,2);

  XSetForeground(display,gc,color_tab[0].pixel);
  vec_wrline("5 OR W - UP",295,285,2);
  vec_wrline("1 OR A - LEFT     D OR 3 - RIGHT",226,305,2);
  vec_wrline("X OR 2 - DOWN",284,325,2);
  vec_wrline("S OR 7 - START",90,300,2);
  vec_wrline("E OR 9 - EXIT",480,300,2);

  x1=300; ny1=390;
  XSetForeground(display,gc,color_tab[2].pixel);
  for (i=0;i<6;i++) {
   wormdraw();
   x1=x1-stepi;
  } 
 
  x1=300; ny1=405;
  appledraw();
  x1=300; ny1=420;
  mushdraw();
  x1=300; ny1=435;
  fencedraw();
 
  XSetForeground(display,gc,color_tab[14].pixel);
  vec_wrline("WORMIE",320,385,2);
  vec_wrline("APPLE",320,400,2);
  vec_wrline("MUSHROOM",320,415,2);
  vec_wrline("FENCE",320,430,2);

  XSetForeground(display,gc,color_tab[13].pixel);

  vec_wrline("LAST SCORE ",80,455,2);
  vec_wrline("HIGHEST SCORE ",450,455,2);
  
  i=0;
  if (score<10000) i++;
  if (score<1000) i++;
  if (score<100) i++;
  sprintf(strint,"%ld",score);
  vec_wrline(strint,105+(i*4),470,2); /* 40/2 chars. */
 
  sprintf(strint,"%ld",hiscore);
  vec_wrline(strint,489,470,2); /* 40/2 chars. */
 }
 XSetForeground(display,gc,color_tab[5].pixel); /* create a lawn green background */
 crblank();
}

void read_logo(void) {
 if ((fpl=fopen(logofile,"rb")) == NULL){
  printf("file xworm.raw not found \n");
  exit (0);
 }
 while (logo_cnt<4000) logo_buf[logo_cnt++]=getc(fpl);
 fclose(fpl);
}

void plot_logo(int x, int y,int col) {
 char ch;
 int  xc,yc;
 XSetForeground(display,gc,color_tab[col].pixel);
 xc=x; yc=y;
 while (yc<y+100) { 
  xc=x;
  while (xc<x+640) {
   ch=logo_buf[logo_cnt++];
   if (ch & 128) XDrawRectangle(display,window,gc,xc,yc,1,1);
   if (ch & 64) XDrawRectangle(display,window,gc,xc+2,yc,1,1);
   if (ch & 32) XDrawRectangle(display,window,gc,xc+4,yc,1,1);
   if (ch & 16) XDrawRectangle(display,window,gc,xc+6,yc,1,1);
   if (ch & 8) XDrawRectangle(display,window,gc,xc+8,yc,1,1);
   if (ch & 4) XDrawRectangle(display,window,gc,xc+10,yc,1,1);
   if (ch & 2) XDrawRectangle(display,window,gc,xc+12,yc,1,1);
   if (ch & 1) XDrawRectangle(display,window,gc,xc+14,yc,1,1);
   xc=xc+16;
  }
  yc=yc+2;
 } 
}

void xwinintroactions(void){
 switch(event.type) {
 case Expose:
   if (event.xexpose.count==0) {
    XGetWindowAttributes(display,window,&attribs);
    if ((wx=attribs.width) || (wy=attribs.height)) {
      XResizeWindow(display,window,hint.width,hint.height);
    }
    if ((fpl=fopen(logofile,"rb")) == NULL){
     printf("file xworm.raw not found \n");
     exit (0);
    }
	logo_cnt=0;
    plot_logo(0,60,10); plot_logo(0,60,11);
    fclose(fpl);
   } 
  break;

 case MappingNotify:
  XRefreshKeyboardMapping((XMappingEvent *)&event); 
  break;

 case KeyPress:
  i=XLookupString((XKeyEvent *)&event,text,10,&key,0);
  if (i==1) switch (text[0]) {
   case 's': case '7': start=1; break; 
   case 'e': start=1; xit=1; break; 
   default: break; 
  }
  break;
 } /* switch */
}

/*----------------------*/
/* randomizer handling. */
/*----------------------*/

void randomize(void) {
 int stime;
 long ltime;

 ltime=time(NULL);     
 stime=(unsigned) ltime/2;
 srand(stime);
}

float rnd(int x) { /* This routine returns a random value between 0 and x-1 */
 return (rand() % x);
}

void rgrid(void){
 FILE *fpg;
 if ((fpg=fopen(gridfile,"rb")) == NULL) {
  printf("Error opening file /users/paalde/bin/xworm.grid. unrecoverable \n");
  exit (0);
 }
 for (i=1;i<maxGrid;i++) {
  gridX[i][0]=getc(fpg);
  gridX[i][1]=getc(fpg);
 } 
 fclose(fpg); 
}

/*-----------------------*/
/* vector font handling  */
/*-----------------------*/

void vec_init(void) {

 FILE *fpf;
 int i;
 if ((fpf=fopen(fontfile,"rb")) == NULL){
  printf("can't open file xworm.font\n");
  exit (0);
 }
 for (i=0; i<200; i++) {
  vec_tab[i][0]=getc(fpf); vec_tab[i][1]=getc(fpf);
  vec_tab[i][2]=getc(fpf); vec_tab[i][3]=getc(fpf);
 }
 fclose(fpf);

 for (i=0; i<200; i++) {
  vec_tabB[i][0]=vec_tab[i][0]; vec_tabB[i][1]=vec_tab[i][1];
  vec_tabB[i][2]=vec_tab[i][2]; vec_tabB[i][3]=vec_tab[i][3];
 }
}

int vec_wrline(char *s,int x,int y,int stp) {
 int X = x;
 if ((NULL != s) && ('\0' != *s)) while (*s) X += stp + vec_plot(*s++, X, y);
 return X;
}

int vec_wrlineX(char *s,int x,int y,int stp,float scale) {
 int X = x;
 int cnt;

 for (cnt=0; cnt<200; cnt++) { /* scale font */
  vec_tab[cnt][0]=vec_tab[cnt][0] * scale; vec_tab[cnt][1]=vec_tab[cnt][1] * scale;
  vec_tab[cnt][2]=vec_tab[cnt][2] * scale; vec_tab[cnt][3]=vec_tab[cnt][3] * scale; 
 }
 
 if ((NULL != s) && ('\0' != *s)) while (*s) X += (stp*scale) + (scale*vec_plot(*s++, X, y));

 for (cnt=0; cnt<200; cnt++) {   /* retract font from backup */
  vec_tab[cnt][0]=vec_tabB[cnt][0]; vec_tab[cnt][1]=vec_tabB[cnt][1];
  vec_tab[cnt][2]=vec_tabB[cnt][2]; vec_tab[cnt][3]=vec_tabB[cnt][3];
 } 

 return X;
}

int vec_plot(char ch,int x,int y){
 switch(ch) {
  case 'A':vec_line(x,y,0,2); return 8;break; 
  case 'B':vec_line(x,y,3,8); return 6;break; 
  case 'C':vec_line(x,y,9,15); return 8;break; 
  case 'D':vec_line(x,y,16,21); return 6;break; 
  case 'E':vec_line(x,y,22,25); return 5;break; 
  case 'F':vec_line(x,y,26,28); return 5;break; 
  case 'G':vec_line(x,y,29,35); return 6;break; 
  case 'H':vec_line(x,y,36,38); return 5;break; 
  case 'I':vec_line(x,y,39,41); return 3;break; 
  case 'J':vec_line(x,y,42,45); return 6;break; 
  case 'K':vec_line(x,y,46,48); return 6;break; 
  case 'L':vec_line(x,y,49,50); return 6;break; 
  case 'M':vec_line(x,y,51,54); return 7;break; 
  case 'N':vec_line(x,y,55,57); return 8;break; 
  case 'O':vec_line(x,y,58,65); return 7;break; 
  case 'P':vec_line(x,y,66,69); return 5;break; 
  case 'Q':vec_line(x,y,70,78); return 7;break; 
  case 'R':vec_line(x,y,79,83); return 5;break; 
  case 'S':vec_line(x,y,84,94); return 6;break; 
  case 'T':vec_line(x,y,95,96); return 7;break; 
  case 'U':vec_line(x,y,97,99); return 6;break; 
  case 'V':vec_line(x,y,100,101); return 7;break; 
  case 'W':vec_line(x,y,102,105); return 7;break; 
  case 'X':vec_line(x,y,106,107); return 8;break; 
  case 'Y':vec_line(x,y,108,112); return 7;break;
  case 'Z':vec_line(x,y,113,115); return 8;break;
  case '':vec_line(x,y,116,121); return 8;break;
  case '':vec_line(x,y,122,130); return 7;break;
  case '':vec_line(x,y,131,134); return 8;break;
  case '1':vec_line(x,y,135,137); return 3;break;
  case '2':vec_line(x,y,138,143); return 6;break;
  case '3':vec_line(x,y,144,149); return 6;break;
  case '4':vec_line(x,y,150,152); return 6;break;
  case '5':vec_line(x,y,153,157); return 6;break;
  case '6':vec_line(x,y,158,162); return 6;break;
  case '7':vec_line(x,y,163,164); return 4;break;
  case '8':vec_line(x,y,165,171); return 6;break;
  case '9':vec_line(x,y,172,175); return 6;break;
  case '0':vec_line(x,y,176,179); return 6;break; 
  case '.':vec_line(x,y,180,181); return 2;break;
  case ',':vec_line(x,y,182,183); return 4;break;
  case '-':vec_line(x,y,184,184); return 6;break;
  case '!':vec_line(x,y,185,189); return 4;break;
  case ' ': return 5;break;
  default:	return 0;
 }
}

void vec_line(int x,int y, int ts, int te) {
 int cnt;
 for (cnt=ts;cnt<=te;cnt++) {
  XDrawLine(display,window,gc,x+(int)vec_tab[cnt][0],y+(int)vec_tab[cnt][1],x+(int)vec_tab[cnt][2],y+(int)vec_tab[cnt][3]);
 } 
}

/*-------------------*/
/* Highscore handler */
/*-------------------*/

/* removed 7.5.97 */

