/* 
 * Copyright (C) 2006 Laird Breyer
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
 * 
 * Author:   Laird Breyer <laird@lbreyer.com>
 */

#ifndef LESSUI_H
#define LESSUI_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "fbparser.h"
#include "lessdisp.h"
#include "cursormgr.h"
#include "cursorrep.h"

typedef struct {
  display_t display;
  cursor_t cursor;
  cursormanager_t cmg;
  cursorrep_t cr;
  bool_t dirty;
} lessui_t;

bool_t create_lessui(lessui_t *ui);
bool_t reset_lessui(lessui_t *ui);
bool_t free_lessui(lessui_t *ui);
bool_t mainloop_lessui(lessui_t *ui, fbparser_t *fbp);

#endif
