/* 
 * Copyright (C) 2006 Laird Breyer
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
 * 
 * Author:   Laird Breyer <laird@lbreyer.com>
 */

#include "common.h"
#include "entities.h"

const char_t *entities[6] = {
  "",
  "&lt;",
  "&gt;",
  "&amp;",
  "&apos;",
  "&quot;"
};

static unsigned char specials[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 5, 0, 0, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

const char_t *find_next_special(const char_t *begin, const char_t *end) {
  while( begin ) {
    if( specials[(int)*begin] != 0 ||
	(begin == end) ) {
      return begin;
    }
    begin++;
  }
  return end;
}

const char_t *get_entity(char_t c) {
  return entities[(int)specials[(int)c]];
}

const char_t *skip_xml_whitespace(const char_t *begin, const char_t *end) {
  while( (begin < end) && xml_whitespace(*begin) ) { begin++; }
  return begin;
}

bool_t is_xml_space(const char_t *begin, const char_t *end) {
  return (skip_xml_whitespace(begin, end) == end);
}

const char_t *find_xml_whitespace(const char_t *begin, const char_t *end) {
  while( (begin < end) && !xml_whitespace(*begin) ) { begin++; }
  return begin;
}

const char_t *rskip_xml_whitespace(const char_t *begin, const char_t *end) {
  if( begin < end ) {
    end--;
    while( (begin <= end) && !xml_whitespace(*end) ) { end--; }
    return (end < begin) ? NULL : end; 
  }
  return NULL;
}

/* skip and convert an integer. This is a bit like atoi or strtol but
 * works even if the string is not NUL terminated.
 * returns NULL on error, or charpos after last digit otherwise.
 */
const char_t *skip_xml_integer(const char_t *begin, const char_t *end, long *val) {
  long v;
  const char_t *r;
  if( begin && (begin < end) ) {
    for(v = 0, r = begin; r && (r < end) && xml_isdigit(*r); r++) {
      v = 10 * v + (toascii(*r) - 0x30); /* ascii 0x30 = '0' */
    }
    if( val ) { *val = v; }
    return (r > begin) ? r : NULL;
  }
  return NULL;
}
