/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 L[{[h ]
 */

#include <string.h>
#include "xm7.h"
#include "keyboard.h"
#include "68k.h"

/*
 *	O[oϐ
 */
BYTE kbd_map[0x80];						/* L[{[h }bv */
BYTE kbd_old[0x80];						/* L[{[h 10msÕf[^ */
BYTE kbd_prcs[0x80];					/* L[{[h ς݃f[^ */

/*
 *	X^eBbNϐ
 */
static DWORD boot_kbdvct;				/* ÑL[{[hxN^ */
static BYTE boot_kbdled;				/* NLED */

/*
 *	L[{[hLED ON/OFF
 */
static void kbd_ledset(BYTE led)
{
	volatile BYTE *p;

	p = (volatile BYTE *)0xe8802d;

	_push();
	_disable();

	/* MFP MfB҂ */
	while (*p < 0x80) {
		;
	}
	/* f[^M */
	*(BYTE *)(0xe8802f) = (BYTE)(led | 0x80);

	_pop();
}

/*
 *	L[{[h荞
 */
interrupt void kbd_int(void)
{
	BYTE dat;
	BYTE x68;

	_push();
	_disable();

	/* f[^グ */
	dat = *(BYTE *)(0xe8802f);
	x68 = dat & 0x7f;

	/* }bsO */
	if (dat < 0x80) {
		kbd_prcs[x68] = TRUE;
	}
	else {
		kbd_prcs[x68] = FALSE;
	}

	/* [HELP]A[COPY]`FbN */
	if ((dat == 0x62) || (dat == 0x0054)) {
		disp_crtc(!disp_crtc_mode);
	}

	_pop();
}

/*
 *	L[{[h ^C}荞
 */
void kbd_timer(void)
{
	int i;
	BYTE fm7;

	/* [Nƌ݂̏ԂOR */
	for (i=0; i<0x80; i++) {
		kbd_old[i] |= kbd_prcs[i];
	}

	/* ȑȌԂƂ̕ω_𓾂 */
	for (i=0; i<0x80; i++) {
		if (kbd_map[i] != kbd_old[i]) {

				/*
				 * f[^ϊ
				 */
				fm7 = 0;

				/* tL[v,SPACE,CR */
				if ((i >= 0x01) && (i <= 0x35)) {
					fm7 = i;
				}

				/* eL[ */
				if ((i >= 0x3f) && (i <= 0x4f)) {
					fm7 = i - 9;
				}

				/* t@NV */
				if ((i >= 0x63) && (i <= 0x6c)) {
					fm7 = i - 6;
				}

				switch (i) {
					/* CTRL */
					case 0x71:
						fm7 = 0x52;
						break;
					/* AESHIFT */
					case 0x70:
						fm7 = 0x53;
						break;
					/* Ђ炪 */
					case 0x5f:
						fm7 = 0x55;
						break;
					/* XF1 */
					case 0x55:
						fm7 = 0x56;
						break;
					/* Sp */
					case 0x60:
						fm7 = 0x5a;
						break;
					/* BREAK */
					case 0x61:
						fm7 = 0x5c;
						break;
					/*  */
					case 0x3c:
						fm7 = 0x4d;
						break;
					/*  */
					case 0x3b:
						fm7 = 0x4f;
						break;
					/*  */
					case 0x3d:
						fm7 = 0x51;
						break;
					/*  */
					case 0x3e:
						fm7 = 0x50;
						break;
					/* INS */
					case 0x5e:
						fm7 = 0x48;
						break;
					/* DEL */
					case 0x37:
						fm7 = 0x4b;
						break;
				}

				/* Make,BreakM */
				if (fm7) {
					if (kbd_old[i]) {
						keyboard_make(fm7);
					}
					else {
						keyboard_break(fm7);
					}
				}
		}
	}

	/* [NRs[ */
	for (i=0; i<0x80; i++) {
		kbd_map[i] = kbd_old[i];
		kbd_old[i] = kbd_prcs[i];
	}
}

/*
 *	L[{[h
 */
int kbd_init(void)
{
	DWORD *p;

	/* LEDԎ擾ALEDS */
	boot_kbdled = *(BYTE *)(0x000810);
	kbd_ledset(0x7f);

	/* [NNA */
	memset(kbd_map, 0, sizeof(kbd_map));
	memset(kbd_old, 0, sizeof(kbd_old));
	memset(kbd_prcs, 0, sizeof(kbd_prcs));

	/* 荞݃xN^ݒ */
	p = (DWORD *)(0x000130);
	_push();
	_disable();
	boot_kbdvct = *p;
	*p = (DWORD)kbd_int;
	_pop();

	return TRUE;
}

/*
 *	L[{[hN[Abv
 */
void kbd_cleanup(void)
{
	DWORD *p;

	/* LEDA */
	kbd_ledset(boot_kbdled);

	/* 荞݃xN^A */
	p = (DWORD *)(0x000130);
	_push();
	_disable();
	*p = boot_kbdvct;
	_pop();
}

/*
 *	L[{[h LEDݒ
 */
void keyboard_setled(void)
{
	BYTE dat;

	/*  */
	dat = 0x7f;

	/* CAP */
	if (caps_flag) {
		dat &= ~0x20;
	}

	/*  */
	if (kana_flag) {
		dat &= ~0x40;
	}

	/* INS */
	if (ins_flag) {
		dat &= ~0x10;
	}

	/* ݒ */
	kbd_ledset(dat);
}
