/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 t@CI/O ]
 */

#include <assert.h>
#include "xm7.h"
#include "device.h"

#ifdef HUMAN68K
#include "68k.h"

/*
 *	t@Cǂݏo
 */
BOOL file_load(char *fname, BYTE *buf, int size)
{
	int handle;

	handle = dos_open(fname, 0);
	if (handle == 0) {
		return FALSE;
	}

	if (dos_read(handle, buf, size) != size) {
		dos_close(handle);
		return FALSE;
	}

	dos_close(handle);
	return TRUE;
}

/*
 *	t@CI[v
 */
int file_open(char *fname, int mode)
{
	int handle;

	handle = 0;

	switch (mode) {
		case OPEN_R:
			handle = dos_open(fname, 0);
			break;
		case OPEN_W:
			handle = dos_create(fname, 0x0020);
			break;
		case OPEN_RW:
			handle = dos_open(fname, 2);
			break;
	}

	if (handle == 0) {
		handle = -1;
	}

	return handle;
}

/*
 *	t@CN[Y
 */
void file_close(int handle)
{
	dos_close(handle);
}

/*
 *	t@CTCY擾
 */
DWORD file_getsize(int handle)
{
	int now;
	int end;

	now = dos_seek(handle, 0, 1);

	end = dos_seek(handle, 0, 2);
	dos_seek(handle, now, 0);

	return end;
}

/*
 *	t@CV[N
 */
BOOL file_seek(int handle, DWORD offset)
{
	int now;

	now = dos_seek(handle, offset, 0);
	if (now != (int)offset) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@Cǂݏo
 */
BOOL file_read(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)dos_read(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@C
 */
BOOL file_write(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)dos_write(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

#endif	/* HUMAN68K */
