/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 ʏ ]
 */

#include <string.h>
#include "xm7.h"
#include "68k.h"
#include "device.h"

/*
 *	O[o [N
 */
BOOL disp_crtc_mode;					/* 24kTRUE */

/*
 *	X^eBbN [N
 */
static int boot_conmode;				/* N̉ʃ[h */
static int boot_funcmode;				/* Ñt@NVL[[h */
static int boot_msmode;					/* Ñ}EX[h */

/*
 *	fW^pbge[u
 */
const WORD ttlpalet_tbl[] = {
	0x0000, 0x003e, 0x07c0, 0x07fe,
	0xf800, 0xf83e, 0xffc0, 0xfffe
};

/*
 *	24k CRTCe[u
 */
const WORD crtc24_tbl[] = {
	0x0074, 0x0009, 0x0014, 0x0064,
	0x01d0, 0x0007, 0x0020, 0x01b0,
	0x001b, 0x0015
};

/*
 *	31k CRTCe[u
 */
const WORD crtc31_tbl[] = {
	0x0089, 0x000e, 0x0024, 0x0074,
	0x0237, 0x0007, 0x0060, 0x01f0,
	0x001b, 0x0016
};

/*
 *	CRTCݒ
 */
void disp_crtc(BOOL crtc24_flag)
{
	WORD *p;
	const WORD *src;
	int i;

	/* [NɋL */
	disp_crtc_mode = crtc24_flag;

	p = (WORD *)0xe80000;
	if (crtc24_flag) {
		src = crtc24_tbl;
	}
	else {
		src = crtc31_tbl;
	}

	for (i=0; i<9; i++) {
		p[i] = src[i];
	}

	*(BYTE *)0x0e80029 = (BYTE)(src[i]);
}

/*
 *	eLXgʃNA
 */
static void text_clear(void)
{
	int i;
	DWORD *p;
	DWORD dat;

	p = (DWORD *)0xe00000;
	dat = 0;

	/* ANZXgpāASv[ɏ */
	*(WORD *)0xe8002a = 0x01f0;
	for (i=0; i<0x2000; i++) {
		*p++ = dat;
		*p++ = dat;
		*p++ = dat;
		*p++ = dat;
	}
	*(WORD *)0xe8002a = 0x0000;
}

/*
 *	ʏ
 */
int disp_init(void)
{
	int i;

	boot_conmode = dos_conmode(-1);
	boot_funcmode = dos_funcmode(-1);
	dos_conmode(0);
	dos_funcmode(2);
	dos_curoff();
	boot_msmode = iocs_msstat();
	iocs_msoff();
	text_clear();

	/* CRTC[h */
	disp_crtc(disp_crtc_mode);

	/* J[8ɐݒ */
	ttlpalet_setb(8, 0);

	/* C */
	for (i=1; i<=399; i+=2) {
		memset((BYTE *)(0xe60000 + 0x80 * i), 0xff, 0x50);
	}

	return TRUE;
}

/*
 *	ʃN[Abv
 */
void disp_cleanup(void)
{
	text_clear();

	dos_conmode(boot_conmode);
	dos_funcmode(boot_funcmode);
	dos_curon();
	if (boot_msmode != 0) {
		iocs_mson();
	}
}

/*
 *	uq`l
 */
void vram_setb(WORD addr, BYTE dat)
{
	asm("	lea.l	$e40000,a0");
	asm("	cmpi.w	#$8000,d0");
	asm("	bcc		_vram_writeb1");
	asm("	lea.l	$e20000,a0");
	asm("	cmpi.w	#$4000,d0");
	asm("	bcc		_vram_writeb1");
	asm("	lea.l	$e00000,a0");
	asm("_vram_writeb1:");
	asm("	andi.w	#$3fff,d0");
	asm("	move.l	d0,d2");
	asm("	movea.l	a0,a1");

	asm("	divu.w	#$0050,d0");
	asm("	swap.w	d0");
	asm("	adda.w	d0,a0");
	asm("	clr.w	d0");
	asm("	swap.w	d0");
	asm("	lsl.l	#8,d0");
	asm("	adda.l	d0,a0");
	asm("	move.b	d1,(a0)");
}

/*
 *	fW^pbgݒ
 */
void ttlpalet_setb(int no, BYTE dat)
{
	*(WORD *)(0xe82200 + no * 2) = ttlpalet_tbl[dat];
}

/*
 *	VRAMItZbgWX^ݒ
 */
void vramoff_setw(WORD offset)
{
	asm("	.xref	_vram_c");

	asm("	movea.l	_vram_c,a0");
	asm("	lea.l	$e00000,a1");
	asm("	move.w	#200-1,d0");
	asm("_vramofs1:");
	asm("	moveq.l	#5-1,d1");
	asm("_vramofs2:");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	dbra.w	d1,_vramofs2");
	asm("	lea.l	$00b0(a1),a1");
	asm("	dbra.w	d0,_vramofs1");

	asm("	movea.l	_vram_c,a0");
	asm("	lea.l	$4000(a0),a0");
	asm("	lea.l	$e20000,a1");
	asm("	move.w	#200-1,d0");
	asm("_vramofs3:");
	asm("	moveq.l	#5-1,d1");
	asm("_vramofs4:");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	dbra.w	d1,_vramofs4");
	asm("	lea.l	$00b0(a1),a1");
	asm("	dbra.w	d0,_vramofs3");

	asm("	movea.l	_vram_c,a0");
	asm("	lea.l	$4000(a0),a0");
	asm("	lea.l	$4000(a0),a0");
	asm("	lea.l	$e40000,a1");
	asm("	move.w	#200-1,d0");
	asm("_vramofs5:");
	asm("	moveq.l	#5-1,d1");
	asm("_vramofs6:");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	move.l	(a0)+,(a1)+");
	asm("	dbra.w	d1,_vramofs6");
	asm("	lea.l	$00b0(a1),a1");
	asm("	dbra.w	d0,_vramofs5");
}
