/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 L[{[h ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include "xm7.h"
#include "win.h"
#include "keyboard.h"
#include "gui.h"
#include "resource.h"

/*
 *	DirectInputR[hFM-7 R[h
 *	{106L[{[h R[hΏƕ\
 */
static BYTE jp106_key_table[] = {
	DIK_ESCAPE,			0x5c,			/* BREAK(ESC) */
	DIK_F1,				0x5d,			/* PF1 */
	DIK_F2,				0x5e,			/* PF2 */
	DIK_F3,				0x5f,			/* PF3 */
	DIK_F4,				0x60,			/* PF4 */
	DIK_F5,				0x61,			/* PF5 */
	DIK_F6,				0x62,			/* PF6 */
	DIK_F7,				0x63,			/* PF7 */
	DIK_F8,				0x64,			/* PF8 */
	DIK_F9,				0x65,			/* PF9 */
	DIK_F11,			0x66,			/* PF10(F11) */

	DIK_KANJI,			0x01,			/* ESC(p/Sp) */
	DIK_1,				0x02,			/* 1 */
	DIK_2,				0x03,			/* 2 */
	DIK_3,				0x04,			/* 3 */
	DIK_4,				0x05,			/* 4 */
	DIK_5,				0x06,			/* 5 */
	DIK_6,				0x07,			/* 6 */
	DIK_7,				0x08,			/* 7 */
	DIK_8,				0x09,			/* 8 */
	DIK_9,				0x0a,			/* 9 */
	DIK_0,				0x0b,			/* 0 */
	DIK_MINUS,			0x0c,			/* - */
	DIK_CIRCUMFLEX,		0x0d,			/* ^ */
	DIK_YEN,			0x0e,			/* \ */
	DIK_BACK,			0x0f,			/* BS */

	DIK_TAB,			0x10,			/* TAB */
	DIK_Q,				0x11,			/* Q */
	DIK_W,				0x12,			/* W */
	DIK_E,				0x13,			/* E */
	DIK_R,				0x14,			/* R */
	DIK_T,				0x15,			/* T */
	DIK_Y,				0x16,			/* Y */
	DIK_U,				0x17,			/* U */
	DIK_I,				0x18,			/* I */
	DIK_O,				0x19,			/* O */
	DIK_P,				0x1a,			/* P */
	DIK_AT,				0x1b,			/* @ */
	DIK_LBRACKET,		0x1c,			/* [ */
	DIK_RETURN,			0x1d,			/* CR */

	DIK_LCONTROL,		0x52,			/* CTRL(Ctrl) */
	DIK_A,				0x1e,			/* A */
	DIK_S,				0x1f,			/* S */
	DIK_D,				0x20,			/* D */
	DIK_F,				0x21,			/* F */
	DIK_G,				0x22,			/* G */
	DIK_H,				0x23,			/* H */
	DIK_J,				0x24,			/* J */
	DIK_K,				0x25,			/* K */
	DIK_L,				0x26,			/* L */
	DIK_SEMICOLON,		0x27,			/* ; */
	DIK_COLON,			0x28,			/* : */
	DIK_RBRACKET,		0x29,			/* ] */

	DIK_LSHIFT,			0x53,			/* SHIFT */
	DIK_Z,				0x2a,			/* Z */
	DIK_X,				0x2b,			/* X */
	DIK_C,				0x2c,			/* C */
	DIK_V,				0x2d,			/* V */
	DIK_B,				0x2e,			/* B */
	DIK_N,				0x2f,			/* N */
	DIK_M,				0x30,			/* M */
	DIK_COMMA,			0x31,			/* , */
	DIK_PERIOD,			0x32,			/* . */
	DIK_SLASH,			0x33,			/* / */
	DIK_BACKSLASH,		0x34,			/* _ */
	DIK_RSHIFT,			0x54,			/* ESHIFT */

	DIK_CAPITAL,		0x55,			/* CAP(Caps Lock) */
	DIK_NOCONVERT,		0x56,			/* GRAPH(ϊ) */
	DIK_SPACE,			0x57,			/* SPACE(SPACE) */
	DIK_CONVERT,		0x58,			/* SPACE(ϊ) */
	DIK_KANA,			0x35,			/* ESPACE(Ђ炪) */
	DIK_RCONTROL,		0x5a,			/* (ECtrl) */

	DIK_INSERT,			0x48,			/* INS(Insert) */
	DIK_DELETE,			0x4b,			/* DEL(Delete) */
	DIK_UP,				0x4d,			/*  */
	DIK_LEFT,			0x4f,			/*  */
	DIK_DOWN,			0x50,			/*  */
	DIK_RIGHT,			0x51,			/*  */

	DIK_HOME,			0x49,			/* EL(Home) */
	DIK_PRIOR,			0x4a,			/* CLS(Page Up) */
	DIK_END,			0x4c,			/* DUP(End) */
	DIK_NEXT,			0x4e,			/* HOME(Page Down) */

	DIK_MULTIPLY,		0x36,			/* Tenkey * */
	DIK_DIVIDE,			0x37,			/* Tenkey / */
	DIK_ADD,			0x38,			/* Tenkey + */
	DIK_SUBTRACT,		0x39,			/* Tenkey - */
	DIK_NUMPAD7,		0x3a,			/* Tenkey 7 */
	DIK_NUMPAD8,		0x3b,			/* Tenkey 8 */
	DIK_NUMPAD9,		0x3c,			/* Tenkey 9 */
	DIK_NUMPAD4,		0x3e,			/* Tenkey 4 */
	DIK_NUMPAD5,		0x3f,			/* Tenkey 5 */
	DIK_NUMPAD6,		0x40,			/* Tenkey 6 */
	DIK_NUMPAD1,		0x42,			/* Tenkey 1 */
	DIK_NUMPAD2,		0x43,			/* Tenkey 2 */
	DIK_NUMPAD3,		0x44,			/* Tenkey 3 */
	DIK_NUMPAD0,		0x46,			/* Tenkey 0 */
	DIK_DECIMAL,		0x47,			/* Tenkey . */
	DIK_NUMPADENTER,	0x45			/* Tenkey CR */
};

/*
 *	DirectInputR[hFM-7 R[h
 *	PC-9801L[{[h R[hΏƕ\
 */
static BYTE pc98_key_table[] = {
	DIK_SYSRQ,			0x5c,			/* BREAK(COPY) */
	DIK_F1,				0x5d,			/* PF1 */
	DIK_F2,				0x5e,			/* PF2 */
	DIK_F3,				0x5f,			/* PF3 */
	DIK_F4,				0x60,			/* PF4 */
	DIK_F5,				0x61,			/* PF5 */
	DIK_F6,				0x62,			/* PF6 */
	DIK_F7,				0x63,			/* PF7 */
	DIK_F8,				0x64,			/* PF8 */
	DIK_F9,				0x65,			/* PF9 */
	DIK_F11,			0x66,			/* PF10(vf1) */

	DIK_ESCAPE,			0x01,			/* ESC */
	DIK_1,				0x02,			/* 1 */
	DIK_2,				0x03,			/* 2 */
	DIK_3,				0x04,			/* 3 */
	DIK_4,				0x05,			/* 4 */
	DIK_5,				0x06,			/* 5 */
	DIK_6,				0x07,			/* 6 */
	DIK_7,				0x08,			/* 7 */
	DIK_8,				0x09,			/* 8 */
	DIK_9,				0x0a,			/* 9 */
	DIK_0,				0x0b,			/* 0 */
	DIK_MINUS,			0x0c,			/* - */
	DIK_CIRCUMFLEX,		0x0d,			/* ^ */
	DIK_YEN,			0x0e,			/* \ */
	DIK_BACK,			0x0f,			/* BS */

	DIK_TAB,			0x10,			/* TAB */
	DIK_Q,				0x11,			/* Q */
	DIK_W,				0x12,			/* W */
	DIK_E,				0x13,			/* E */
	DIK_R,				0x14,			/* R */
	DIK_T,				0x15,			/* T */
	DIK_Y,				0x16,			/* Y */
	DIK_U,				0x17,			/* U */
	DIK_I,				0x18,			/* I */
	DIK_O,				0x19,			/* O */
	DIK_P,				0x1a,			/* P */
	DIK_AT,				0x1b,			/* @ */
	DIK_LBRACKET,		0x1c,			/* [ */
	DIK_RETURN,			0x1d,			/* CR */

	DIK_LCONTROL,		0x52,			/* CTRL(Ctrl) */
	DIK_A,				0x1e,			/* A */
	DIK_S,				0x1f,			/* S */
	DIK_D,				0x20,			/* D */
	DIK_F,				0x21,			/* F */
	DIK_G,				0x22,			/* G */
	DIK_H,				0x23,			/* H */
	DIK_J,				0x24,			/* J */
	DIK_K,				0x25,			/* K */
	DIK_L,				0x26,			/* L */
	DIK_SEMICOLON,		0x27,			/* ; */
	DIK_COLON,			0x28,			/* : */
	DIK_RBRACKET,		0x29,			/* ] */

	DIK_LSHIFT,			0x53,			/* SHIFT(SHIFT) */
	DIK_Z,				0x2a,			/* Z */
	DIK_X,				0x2b,			/* X */
	DIK_C,				0x2c,			/* C */
	DIK_V,				0x2d,			/* V */
	DIK_B,				0x2e,			/* B */
	DIK_N,				0x2f,			/* N */
	DIK_M,				0x30,			/* M */
	DIK_COMMA,			0x31,			/* , */
	DIK_PERIOD,			0x32,			/* . */
	DIK_SLASH,			0x33,			/* / */
	DIK_UNDERLINE,		0x34,			/* _ */
	DIK_LSHIFT,			0x54,			/* ESHIFT(SHIFT) */

//	DIK_CAPITAL,		0x55,			/* CAP(CAPS) */
	DIK_NOCONVERT,		0x56,			/* GRAPH(NFER) */
	DIK_SPACE,			0x57,			/* SPACE(SPACE) */
	// SPACE̓T|[gȂ
	DIK_KANJI,			0x35,			/* ESPACE(XFER) */
//	DIK_KANA,			0x5a,			/* (Ji) */

	DIK_INSERT,			0x48,			/* INS(Insert) */
	DIK_DELETE,			0x4b,			/* DEL(Delete) */
	DIK_UP,				0x4d,			/*  */
	DIK_LEFT,			0x4f,			/*  */
	DIK_DOWN,			0x50,			/*  */
	DIK_RIGHT,			0x51,			/*  */

	DIK_HOME,			0x49,			/* EL(HOME CLR) */
	DIK_PRIOR,			0x4a,			/* CLS(ROLL DOWN) */
	DIK_END,			0x4c,			/* DUP(HELP) */
	DIK_NEXT,			0x4e,			/* HOME(ROLL UP) */

	DIK_MULTIPLY,		0x36,			/* Tenkey * */
	DIK_DIVIDE,			0x37,			/* Tenkey / */
	DIK_ADD,			0x38,			/* Tenkey + */
	DIK_SUBTRACT,		0x39,			/* Tenkey - */
	DIK_NUMPAD7,		0x3a,			/* Tenkey 7 */
	DIK_NUMPAD8,		0x3b,			/* Tenkey 8 */
	DIK_NUMPAD9,		0x3c,			/* Tenkey 9 */
	DIK_NUMPADEQUALS,	0x3d,			/* Tenkey = */
	DIK_NUMPAD4,		0x3e,			/* Tenkey 4 */
	DIK_NUMPAD5,		0x3f,			/* Tenkey 5 */
	DIK_NUMPAD6,		0x40,			/* Tenkey 6 */
	DIK_NUMPADCOMMA,	0x41,			/* Tenkey , */
	DIK_NUMPAD1,		0x42,			/* Tenkey 1 */
	DIK_NUMPAD2,		0x43,			/* Tenkey 2 */
	DIK_NUMPAD3,		0x44,			/* Tenkey 3 */
	DIK_NUMPAD0,		0x46,			/* Tenkey 0 */
	DIK_DECIMAL,		0x47,			/* Tenkey . */
	DIK_NUMPADENTER,	0x45			/* Tenkey CR */
};

/*
 *	L[{[h
 *	
 */
void CXM7Wnd::InitKbd()
{
	// o
	m_lpdi = NULL;
	m_lpkbd = NULL;
	memset(m_KbdMap, 0, sizeof(m_KbdMap));
	m_bKbd98 = FALSE;
	m_bKbdReal = FALSE;
	m_bKbdCap = FALSE;

	// WCXeBbN
	m_dwJoyTime = timeGetTime();
	m_dwJoyBlank = 20;
	m_bJoySwap = FALSE;
}

/*
 *	L[{[h
 *	I
 */
BOOL CXM7Wnd::SelectKbd()
{
	// DirectInputIuWFNg̍쐬
	if (DirectInputCreate(AfxGetApp()->m_hInstance, DIRECTINPUT_VERSION,
							&m_lpdi, NULL) != DI_OK) {
		return FALSE;
	}

	// L[{[hfoCX쐬
	if (m_lpdi->CreateDevice(GUID_SysKeyboard, &m_lpkbd, NULL) != DI_OK) {
		return FALSE;
	}

	// L[{[hf[^`ݒ
	if (m_lpkbd->SetDataFormat(&c_dfDIKeyboard) != DI_OK) {
		return FALSE;
	}

	// xݒ
	if (m_lpkbd->SetCooperativeLevel(m_hWnd,
						DISCL_FOREGROUND | DISCL_NONEXCLUSIVE) != DI_OK) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	L[{[h
 *	N[Abv
 */
void CXM7Wnd::CleanKbd()
{
	// DirectInputDevice(L[{[h)
	if (m_lpkbd) {
		m_lpkbd->Unacquire();
		m_lpkbd->Release();
		m_lpkbd = NULL;
	}

	// DirectInput
	if (m_lpdi) {
		m_lpdi->Release();
		m_lpdi = NULL;
	}
}

/*
 *	L[{[h
 *	|[O
 */
void CXM7Wnd::PollKbd()
{
	HRESULT hr;
	BYTE buf[256];
	int i;
	BYTE fm7;
	static BYTE key_last;

	// DirectInput`FbN
	if (!m_lpkbd) {
		return;
	}

	// foCX̃ANZX擾(擾Ă悢)
	hr = m_lpkbd->Acquire();
	if ((hr != DI_OK) && (hr != S_FALSE)) {
		return;
	}

	// foCXԂ擾
	if (m_lpkbd->GetDeviceState(sizeof(buf), buf) != DI_OK) {
		return;
	}

	// ܂ł̏ԂƔrāAɕϊ
	for (i=0; i<sizeof(buf); i++) {
		if ((buf[i] & 0x80) != (m_KbdMap[i] & 0x80)) {
			if (buf[i] & 0x80) {
				// L[
				fm7 = ConvKbd((BYTE)i);
				if (fm7 > 0) {
					if (fm7 != 0x5c) {
						key_last = fm7;
					}
					keyboard_make(fm7);
				}
			}
			else {
				// L[
				fm7 = ConvKbd((BYTE)i);
				if (fm7 > 0) {
					if (m_bKbdReal) {
						// ^A^CL[XL
						if ((fm7 >= 0x3a) && (fm7 <= 0x46)) {
							if (key_last == fm7) {
								keyboard_break(fm7);
								keyboard_make(0x3f);
								keyboard_break(0x3f);
								continue;
							}
						}
					}
					keyboard_break(fm7);
				}
			}
		}
	}

	// PC-98CAP,Ji͓ʈ
	if (m_bKbd98) {
		if ((buf[DIK_CAPITAL] & 0x80) && !caps_flag) {
			keyboard_make(0x55);
			keyboard_break(0x55);
		}
		if (!(buf[DIK_CAPITAL] & 0x80) && caps_flag) {
			keyboard_make(0x55);
			keyboard_break(0x55);
		}
		if ((buf[DIK_KANA] & 0x80) && !kana_flag) {
			keyboard_make(0x5a);
			keyboard_break(0x5a);
		}
		if (!(buf[DIK_KANA] & 0x80) && kana_flag) {
			keyboard_make(0x5a);
			keyboard_break(0x5a);
		}
	}

	// ԂRs[
	memcpy(m_KbdMap, buf, sizeof(buf));
}

/*
 *	L[{[h
 *	R[hϊ
 */
BYTE CXM7Wnd::ConvKbd(BYTE di)
{
	int i;
	BOOL flag;
	BYTE code;

	flag = FALSE;

	// JP106
	if (m_bKbd98) {
		for (i=0; i<(sizeof(pc98_key_table) / 2); i++) {
			if (di == pc98_key_table[i * 2]) {
				code = pc98_key_table[i * 2 + 1];
				flag = TRUE;
				break;
			}
		}
	}
	else {
		for (i=0; i<(sizeof(jp106_key_table) / 2); i++) {
			if (di == jp106_key_table[i * 2]) {
				code = jp106_key_table[i * 2 + 1];
				flag = TRUE;
				break;
			}
		}
	}

	// Ȃ΃^[
	if (!flag) {
		return 0;
	}

	// CTRL-CAPւ(JP106̂)
	if (!m_bKbd98 && m_bKbdCap) {
		if (code == 0x52) {
			code = 0x55;
		}
		else {
			if (code == 0x55) {
				code = 0x52;
			}
		}
	}

	// I
	return code;
}

/*
 *	WCXeBbN
 *	|[O
 */
void CXM7Wnd::PollJoy()
{
	JOYINFOEX jiex;
	int i;
	int num;

	// Ԋu`FbN
	if ((timeGetTime() - m_dwJoyTime) < m_dwJoyBlank) {
		return;
	}
	m_dwJoyTime = timeGetTime();

	// f[^NA
	m_joydat[0] = 0;
	m_joydat[1] = 0;

	// T|[gWCXeBbN擾
	num = joyGetNumDevs();
	if (num >= 2) {
		num = 2;
	}

	// őQfoCX擾
	for (i=0; i<num; i++) {
		// f[^擾
		memset(&jiex, 0, sizeof(jiex));
		jiex.dwSize = sizeof(jiex);
		jiex.dwFlags = JOY_RETURNX | JOY_RETURNY | JOY_RETURNBUTTONS |
						JOY_RETURNCENTERED;
		if (joyGetPosEx(i, &jiex) != JOYERR_NOERROR) {
			continue;
		}

		// f[^]()
		if (jiex.dwXpos < 0x4000) {
			m_joydat[i] |= 0x04;
		}
		if (jiex.dwXpos > 0xc000) {
			m_joydat[i] |= 0x08;
		}
		if (jiex.dwYpos < 0x4000) {
			m_joydat[i] |= 0x01;
		}
		if (jiex.dwYpos > 0xc000) {
			m_joydat[i] |= 0x02;
		}

		// f[^]({^)
		if (m_bJoySwap) {
			if (jiex.dwButtons & JOY_BUTTON1) {
				m_joydat[i] |= 0x10;
			}
			if (jiex.dwButtons & JOY_BUTTON2) {
				m_joydat[i] |= 0x20;
			}
		}
		else {
			if (jiex.dwButtons & JOY_BUTTON1) {
				m_joydat[i] |= 0x20;
			}
			if (jiex.dwButtons & JOY_BUTTON2) {
				m_joydat[i] |= 0x10;
			}
		}
	}
}

/*
 *	L[{[hLEDݒ
 */
extern "C" {
void keyboard_setled(void)
{
}
}

/*
 *	WCXeBbN擾
 */
extern "C" {
BYTE joy_getb(BYTE port)
{
	return pMainWnd->m_joydat[port];
}
}


#endif	/* _WIN32 */
