/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 t@CI/O ]
 */

#ifdef _WIN32

#include <assert.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include "xm7.h"
#include "device.h"

/*
 *	t@C[h
 */
BOOL file_load(char *fname, BYTE *buf, int size)
{
	int handle;

	// assert
	ASSERT(fname);
	ASSERT(buf);
	ASSERT(size > 0);

	handle = _open(fname, _O_BINARY);
	if (handle == -1) {
		return FALSE;
	}

	if (_read(handle, buf, size) != size) {
		_close(handle);
		return FALSE;
	}

	_close(handle);
	return TRUE;
}

/*
 *	t@CI[v
 */
int file_open(char *fname, int mode)
{
	// assert
	ASSERT(fname);

	switch (mode) {
		case OPEN_R:
			return _open(fname, _O_BINARY | O_RDONLY);
			break;
		case OPEN_W:
			return _open(fname, _O_BINARY | O_CREAT | O_WRONLY,
						_S_IWRITE);
			break;
		case OPEN_RW:
			return _open(fname, _O_BINARY | O_RDWR);
			break;
	}

	ASSERT(FALSE);
	return -1;
}

/*
 *	t@CN[Y
 */
void file_close(int handle)
{
	// assert
	ASSERT(handle >= 0);
	
	_close(handle);
}

/*
 *	t@CTCY擾
 */
DWORD file_getsize(int handle)
{
	long now;
	long end;

	// assert
	ASSERT(handle >= 0);

	now = _tell(handle);
	if (now == -1) {
		return 0;
	}

	end = _lseek(handle, 0L, SEEK_END);
	_lseek(handle, now, SEEK_SET);

	return end;
}

/*
 *	t@CV[N
 */
BOOL file_seek(int handle, DWORD offset)
{
	long now;

	// assert
	ASSERT(handle >= 0);
	
	now = _lseek(handle, offset, SEEK_SET);
	if (now != (long)offset) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@Cǂݏo
 */
BOOL file_read(int handle, BYTE *ptr, DWORD size)
{
	unsigned int cnt;

	// assert
	ASSERT(handle >= 0);
	ASSERT(ptr);
	ASSERT(size > 0);

	cnt = _read(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@C
 */
BOOL file_write(int handle, BYTE *ptr, DWORD size)
{
	unsigned int cnt;

	// assert
	ASSERT(handle >= 0);
	ASSERT(ptr);
	ASSERT(size > 0);

	cnt = _write(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

#endif	/* _WIN32 */
