/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 ̑ ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include <afxcmn.h>
#include <afxext.h>
#include "xm7.h"
#include "win_view.h"
#include "win_etc.h"
#include "win.h"
#include "device.h"
#include "resource.h"
#include "tools.h"

/*-[ IvV_CAO ]-------------------------------------------------*/

/*
 *	\IvVy[W
 *	RXgN^
 */
CXM7DispPage::CXM7DispPage() : CPropertyPage(IDD_DISPPAGE)
{
}

/*
 *	\IvVy[W
 *	_CAO
 */
BOOL CXM7DispPage::OnInitDialog()
{
	CSliderCtrl *pSliderCtrl;

	// {NX
	if (!CPropertyPage::OnInitDialog()) {
		return FALSE;
	}

	// f[^]
	pSliderCtrl = (CSliderCtrl*)GetDlgItem(IDC_FRAMESLIDER);
	pSliderCtrl->SetRange(5, 60, TRUE);
	pSliderCtrl->SetPos(m_nFrameRate);

	return TRUE;
}

/*
 *	\IvVy[W
 *	_CAOOK
 */
void CXM7DispPage::OnOK()
{
	CSliderCtrl *pSliderCtrl;

	// f[^]
	pSliderCtrl = (CSliderCtrl*)GetDlgItem(IDC_FRAMESLIDER);
	m_nFrameRate = pSliderCtrl->GetPos();

	// {NX
	CPropertyPage::OnOK();
}

/*
 *	TEhIvVy[W
 *	RXgN^
 */
CXM7SoundPage::CXM7SoundPage() : CPropertyPage(IDD_SOUNDPAGE)
{
}

/*
 *	TEhIvVy[W
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7SoundPage, CPropertyPage)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SOUNDBUFSPIN, OnDeltaPos)
END_MESSAGE_MAP()

/*
 *	TEhIvVy[W
 *	_CAO
 */
BOOL CXM7SoundPage::OnInitDialog()
{
	CButton *pButton;
	CSpinButtonCtrl *pSpinCtrl;
	CEdit *pEdit;
	char buf[32];

	// {NX
	if (!CPropertyPage::OnInitDialog()) {
		return FALSE;
	}

	// f[^]
	switch (m_sndrate) {
		case 0:
			pButton = (CButton*)GetDlgItem(IDC_NOSOUNDRADIO);
			pButton->SetCheck(1);
			break;
		case 22050:
			pButton = (CButton*)GetDlgItem(IDC_22KRADIO);
			pButton->SetCheck(1);
			break;
		case 44100:
			pButton = (CButton*)GetDlgItem(IDC_44KRADIO);
			pButton->SetCheck(1);
			break;
		default:
			ASSERT(FALSE);
	}

	pSpinCtrl = (CSpinButtonCtrl*)GetDlgItem(IDC_SOUNDBUFSPIN);
	pSpinCtrl->SetRange(5, 50);
	pSpinCtrl->SetPos(m_sndtick / 10);

	pEdit = (CEdit*)GetDlgItem(IDC_SOUNDBUFEDIT);
	sprintf(buf, "%d", m_sndtick * 2);
	pEdit->SetWindowText(buf);

	pButton = (CButton*)GetDlgItem(IDC_SOUNDOPNCHECK);
	if (m_bSndOPN) {
		pButton->SetCheck(1);
	}

	pButton = (CButton*)GetDlgItem(IDC_SOUNDPSGCHECK);
	if (m_bSndPSG) {
		pButton->SetCheck(1);
	}

	pButton = (CButton*)GetDlgItem(IDC_SOUNDBEEPCHECK);
	if (m_bSndBEEP) {
		pButton->SetCheck(1);
	}

	return TRUE;
}

/*
 *	TEhIvVy[W
 *	_CAOOK
 */
void CXM7SoundPage::OnOK()
{
	CButton *pButton;
	CSpinButtonCtrl *pSpinCtrl;

	// f[^]
	pButton = (CButton*)GetDlgItem(IDC_NOSOUNDRADIO);
	if (pButton->GetCheck() != 0) {
		m_sndrate = 0;
	}

	pButton = (CButton*)GetDlgItem(IDC_22KRADIO);
	if (pButton->GetCheck() != 0) {
		m_sndrate = 22050;
	}

	pButton = (CButton*)GetDlgItem(IDC_44KRADIO);
	if (pButton->GetCheck() != 0) {
		m_sndrate = 44100;
	}

	pSpinCtrl = (CSpinButtonCtrl*)GetDlgItem(IDC_SOUNDBUFSPIN);
	m_sndtick = pSpinCtrl->GetPos() * 10;

	pButton = (CButton*)GetDlgItem(IDC_SOUNDOPNCHECK);
	m_bSndOPN = (pButton->GetCheck() != 0);

	pButton = (CButton*)GetDlgItem(IDC_SOUNDPSGCHECK);
	m_bSndPSG = (pButton->GetCheck() != 0);

	pButton = (CButton*)GetDlgItem(IDC_SOUNDBEEPCHECK);
	m_bSndBEEP = (pButton->GetCheck() != 0);

	// {NX
	CPropertyPage::OnOK();
}

/*
 *	TEhIvVy[W
 *	XsωNotify
 */
void CXM7SoundPage::OnDeltaPos(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_UPDOWN *pUpDown;
	CEdit *pEdit;
	char buf[32];
	int val;

	// ~20l`
	pUpDown = (NM_UPDOWN*)pNMHDR;
	val = (pUpDown->iPos + pUpDown->iDelta) * 20;
	if (val < 100) {
		val = 100;
	}
	if (val > 1000) {
		val = 1000;
	}
	sprintf(buf, "%d", val);
	pEdit = (CEdit*)GetDlgItem(IDC_SOUNDBUFEDIT);
	pEdit->SetWindowText(buf);
}

/*
 *	̓IvVy[W
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7InputPage, CPropertyPage)
	ON_BN_CLICKED(IDC_JP106RADIO, OnJP106)
	ON_BN_CLICKED(IDC_NEC98RADIO, OnNEC98)
	ON_NOTIFY(UDN_DELTAPOS, IDC_JOYPOLLSPIN, OnDeltaPos)
END_MESSAGE_MAP()

/*
 *	̓IvVy[W
 *	RXgN^
 */
CXM7InputPage::CXM7InputPage() : CPropertyPage(IDD_INPUTPAGE)
{
}

/*
 *	̓IvVy[W
 *	_CAO
 */
BOOL CXM7InputPage::OnInitDialog()
{
	CButton *pButton;
	CSpinButtonCtrl *pSpinCtrl;
	CEdit *pEdit;
	char buf[32];

	// {NX
	if (!CPropertyPage::OnInitDialog()) {
		return FALSE;
	}

	// f[^]
	if (m_bKbd98) {
		pButton = (CButton*)GetDlgItem(IDC_NEC98RADIO);
		pButton->SetCheck(1);
		OnNEC98();
	}
	else {
		pButton = (CButton*)GetDlgItem(IDC_JP106RADIO);
		pButton->SetCheck(1);
	}

	pButton = (CButton*)GetDlgItem(IDC_REALKEYCHECK);
	if (m_bKbdReal) {
		pButton->SetCheck(1);
	}

	pButton = (CButton*)GetDlgItem(IDC_CAPSKEYCHECK);
	if (m_bKbdCap) {
		pButton->SetCheck(1);
	}

	pSpinCtrl = (CSpinButtonCtrl*)GetDlgItem(IDC_JOYPOLLSPIN);
	pSpinCtrl->SetRange(1, 10);
	pSpinCtrl->SetPos(m_dwJoyBlank / 10);

	pEdit = (CEdit*)GetDlgItem(IDC_JOYPOLLEDIT);
	sprintf(buf, "%d", m_dwJoyBlank);
	pEdit->SetWindowText(buf);

	pButton = (CButton*)GetDlgItem(IDC_JOYSWAPCHECK);
	if (m_bJoySwap) {
		pButton->SetCheck(1);
	}

	return TRUE;
}

/*
 *	̓IvVy[W
 *	_CAOOK
 */
void CXM7InputPage::OnOK()
{
	CButton *pButton;
	CSpinButtonCtrl *pSpinCtrl;

	// f[^]
	pButton = (CButton*)GetDlgItem(IDC_NEC98RADIO);
	m_bKbd98 = (pButton->GetCheck() != 0);

	pButton = (CButton*)GetDlgItem(IDC_REALKEYCHECK);
	m_bKbdReal = (pButton->GetCheck() != 0);

	pButton = (CButton*)GetDlgItem(IDC_CAPSKEYCHECK);
	m_bKbdCap = (pButton->GetCheck() != 0);

	pSpinCtrl = (CSpinButtonCtrl*)GetDlgItem(IDC_JOYPOLLSPIN);
	m_dwJoyBlank = pSpinCtrl->GetPos() * 10;

	pButton = (CButton*)GetDlgItem(IDC_JOYSWAPCHECK);
	m_bJoySwap = (pButton->GetCheck() != 0);

	// {NX
	CPropertyPage::OnOK();
}

/*
 *	̓IvVy[W
 *	JP106I
 */
void CXM7InputPage::OnJP106()
{
	CButton *pButton;

	pButton = (CButton*)GetDlgItem(IDC_CAPSKEYCHECK);
	pButton->EnableWindow(TRUE);
}

/*
 *	̓IvVy[W
 *	NEC PC-98I
 */
void CXM7InputPage::OnNEC98()
{
	CButton *pButton;

	pButton = (CButton*)GetDlgItem(IDC_CAPSKEYCHECK);
	pButton->EnableWindow(FALSE);
}
/*
 *	̓IvVy[W
 *	XsωNotify
 */
void CXM7InputPage::OnDeltaPos(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_UPDOWN *pUpDown;
	CEdit *pEdit;
	char buf[32];
	int val;

	// ~10l`
	pUpDown = (NM_UPDOWN*)pNMHDR;
	val = (pUpDown->iPos + pUpDown->iDelta) * 10;
	if (val < 10) {
		val = 10;
	}
	if (val > 100) {
		val = 100;
	}
	sprintf(buf, "%d", val);
	pEdit = (CEdit*)GetDlgItem(IDC_JOYPOLLEDIT);
	pEdit->SetWindowText(buf);
}

/*
 *	vpeBV[g
 *	RXgN^
 */
CXM7Property::CXM7Property(CWnd *pParent)
: CPropertySheet("Option", pParent, 0)
{
	m_psh.dwFlags |= PSH_NOAPPLYNOW;

	AddPage(&m_DispPage);
	AddPage(&m_SoundPage);
	AddPage(&m_InputPage);
}

/*-[ ^Cg̓_CAO ]-----------------------------------------------*/

/*
 *	^Cg̓_CAO쐬
 */
CXM7TitleDlg::CXM7TitleDlg(CWnd *pParent, char *title)
: CDialog(MAKEINTRESOURCE(IDD_TITLEDLG), pParent)
{
	// |C^LĂ
	m_pTitle = title;
}

/*
 *	_CAO
 */
BOOL CXM7TitleDlg::OnInitDialog()
{
	// EChE𒆉
	CenterWindow();

	// ftHgݒ
	SetDlgItemText(IDC_TITLEEDIT, "Default");

	return TRUE;
}

/*
 *	OK
 */
void CXM7TitleDlg::OnOK()
{
	char buffer[17];

	// f[^𓾂
	GetDlgItemText(IDC_TITLEEDIT, buffer, sizeof(buffer));
	buffer[16] = '\0';

	// eփRs[
	strcpy(m_pTitle, buffer);

	// I
	CDialog::OnOK();
}

/*-[ j[R}h ]-------------------------------------------------*/

/*
 *	Tools-Option
 *	IvV
 */
void CXM7Wnd::OnOption()
{
	CXM7Property dlg(this);
	CXM7DispPage *pDisp;
	CXM7SoundPage *pSound;
	CXM7InputPage *pInput;

	// f[^](Dispy[W)
	pDisp = (CXM7DispPage*)dlg.GetPage(0);
	ASSERT(pDisp);
	pDisp->m_nFrameRate = m_nFrameRate;

	// f[^](Soundy[W)
	pSound = (CXM7SoundPage*)dlg.GetPage(1);
	ASSERT(pSound);
	pSound->m_sndrate = m_sndrate;
	pSound->m_sndtick = m_sndtick;
	pSound->m_bSndOPN = m_bSndOPN;
	pSound->m_bSndPSG = m_bSndPSG;
	pSound->m_bSndBEEP = m_bSndBEEP;

	// f[^](Inputy[W)
	pInput = (CXM7InputPage*)dlg.GetPage(2);
	ASSERT(pInput);
	pInput->m_bKbd98 = m_bKbd98;
	pInput->m_bKbdReal = m_bKbdReal;
	pInput->m_bKbdCap = m_bKbdCap;
	pInput->m_bJoySwap = m_bJoySwap;
	pInput->m_dwJoyBlank = m_dwJoyBlank;

	// _CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// f[^](Dispy[W)
	m_nFrameRate = pDisp->m_nFrameRate;

	// f[^](Soundy[W)
	m_bSndOPN = pSound->m_bSndOPN;
	m_bSndPSG = pSound->m_bSndPSG;
	m_bSndBEEP = pSound->m_bSndBEEP;
	if ((m_sndrate != pSound->m_sndrate) || (m_sndtick != pSound->m_sndtick)) {
		CleanSnd();
		SelectSnd(pSound->m_sndrate, pSound->m_sndtick, 1);
	}

	// f[^](Inputy[W)
	m_bKbd98 = pInput->m_bKbd98;
	m_bKbdReal = pInput->m_bKbdReal;
	m_bKbdCap = pInput->m_bKbdCap;
	m_bJoySwap = pInput->m_bJoySwap;
	m_dwJoyBlank = pInput->m_dwJoyBlank;
}

/*
 *	Options-Capture Screen
 *	ʂ̃Lv`
 */
void CXM7Wnd::OnCapture(void)
{
	BITMAPFILEHEADER bmf;
	BITMAPINFOHEADER bmi;
	RGBQUAD rgb[16];
	BYTE *b;
	BYTE *g;
	BYTE *r;
	int i;
	int x;
	int n;
	BYTE bit, dat;
	BYTE buf[640];
	CFile file;
	CFileDialog dlg(FALSE, ".BMP", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"4-bit Bitmap Files (*.BMP)|*.BMP|All Files (*.*)|*.*||", this);
	static RGBQUAD RGBColor[] = {
		{   0,   0,   0,   0 },
		{ 255,   0,   0,   0 },
		{   0,   0, 255,   0 },
		{ 255,   0, 255,   0 },
		{   0, 255,   0,   0 },
		{ 255, 255,   0,   0 },
		{   0, 255, 255,   0 },
		{ 255, 255, 255,   0 }
	};

	// _CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// t@C쐬
	if (!file.Open(dlg.GetPathName(), CFile::modeCreate | CFile::modeWrite)) {
		MessageBox("File Create Error", NULL, MB_ICONSTOP | MB_OK);
		return;
	}

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// t@Cwb_쐬A
	memset(&bmf, 0, sizeof(bmf));
	bmf.bfType = 0x4d42;
	bmf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER)
					+ sizeof(RGBQUAD) * 16 + (640 / 2) * 400;
	bmf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER)
					+ sizeof(RGBQUAD) * 16;
	file.Write(&bmf, sizeof(bmf));

	// wb_쐬A
	memset(&bmi, 0, sizeof(bmi));
	bmi.biSize = sizeof(bmi);
	bmi.biWidth = 640;
	bmi.biHeight = 400;
	bmi.biPlanes = 1;
	bmi.biBitCount = 4;
	bmi.biCompression = BI_RGB;
	file.Write(&bmi, sizeof(bmi));

	// pbg쐬A
	memset(rgb, 0, sizeof(rgb));
	for (i=0; i<8; i++) {
		rgb[i] = RGBColor[m_Palette[i]];
	}
	file.Write(rgb, sizeof(rgb));

	// y[v
	memset(buf, 0x88, sizeof(buf));
	for (i=199; i>=0; i--) {
		b = &vram_c[0x0000 + i * 80];
		r = &vram_c[0x4000 + i * 80];
		g = &vram_c[0x8000 + i * 80];
		// x[v
		for (x=0; x<80; x++) {
			bit = 0x80;
			// 2bit~4[v
			for (n=0; n<4; n++) {
				// 
				dat = 0;

				// 4bit
				if (*g & bit) {
					dat |= 0x01;
				}
				dat <<= 1;
				if (*r & bit) {
					dat |= 0x01;
				}
				dat <<= 1;
				if (*b & bit) {
					dat |= 0x01;
				}
				bit >>= 1;
				dat <<= 2;

				// 4bit
				if (*g & bit) {
					dat |= 0x01;
				}
				dat <<= 1;
				if (*r & bit) {
					dat |= 0x01;
				}
				dat <<= 1;
				if (*b & bit) {
					dat |= 0x01;
				}
				bit >>= 1;

				// 
				buf[x * 4 + n] = dat;
			}
			b++;
			r++;
			g++;
		}
		// 
		file.Write(buf, sizeof(buf));
	}

	// N[Y
	file.Close();

	// vJ[\I
	AfxGetApp()->EndWaitCursor();
}

/*
 *	Tools-Make Blank Disk
 *	uNfBXN쐬
 */
void CXM7Wnd::OnMakeDisk()
{
	char title[17];
	CXM7TitleDlg titledlg(this, title);
	CFileDialog dlg(FALSE, ".D77", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"FM-7/77 Disk Image Files (*.D77)|*.D77|All Files (*.*)|*.*||", this);
	BOOL flag;
	LPCTSTR fname;

	// ^Cg̓_CAOs
	if (titledlg.DoModal() != IDOK) {
		return;
	}

	// t@C̓_CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// s
	fname = (LPCTSTR)dlg.GetPathName();
	flag = make_new_d77((char*)fname, title);

	// vJ[\I
	AfxGetApp()->EndWaitCursor();

	// Xe[^X`FbN
	if (!flag) {
		MessageBox("File Error", NULL, MB_ICONSTOP | MB_OK);
	}
}

/*
 *	Tools-Make Blank Tape
 *	uNe[v쐬
 */
void CXM7Wnd::OnMakeTape()
{
	CFileDialog dlg(FALSE, ".BMP", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"FM-7/77 Tape Image Files (*.T77)|*.T77|All Files (*.*)|*.*||", this);
	BOOL flag;
	LPCTSTR fname;

	// _CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// s
	fname = (LPCTSTR)dlg.GetPathName();
	flag = make_new_t77((char*)fname);

	// vJ[\I
	AfxGetApp()->EndWaitCursor();

	// Xe[^X`FbN
	if (!flag) {
		MessageBox("File Error", NULL, MB_ICONSTOP | MB_OK);
	}
}

/*
 *	Tools-Convert VFD to D77
 *	VFDD77ϊ
 */
void CXM7Wnd::OnVFDtoD77()
{
	char title[17];
	CXM7TitleDlg titledlg(this, title);
	CFileDialog vfddlg(TRUE, ".VFD", NULL, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
	"EM-7 Disk Image Files (*.VFD)|*.VFD|All Files (*.*)|*.*||", this);
	CFileDialog dlg(FALSE, ".D77", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"FM-7/77 Disk Image Files (*.D77)|*.D77|All Files (*.*)|*.*||", this);
	BOOL flag;
	CString vfd_fname;
	CString d77_fname;

	// VFD̓_CAOs
	if (vfddlg.DoModal() != IDOK) {
		return;
	}
	vfd_fname = vfddlg.GetPathName();

	// D77̓_CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}
	d77_fname = dlg.GetPathName();

	// ^Cg̓_CAOs
	if (titledlg.DoModal() != IDOK) {
		return;
	}

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// s
	flag = conv_vfd_to_d77((char*)(LPCTSTR)vfd_fname, (char*)(LPCTSTR)d77_fname, title);

	// vJ[\I
	AfxGetApp()->EndWaitCursor();

	// Xe[^X`FbN
	if (!flag) {
		MessageBox("Convert Error", NULL, MB_ICONSTOP | MB_OK);
	}
}

/*
 *	Tools-Convert 2D to D77
 *	2DD77ϊ
 */
void CXM7Wnd::On2DtoD77()
{
	char title[17];
	CXM7TitleDlg titledlg(this, title);
	CFileDialog dlg2d(TRUE, ".2D", NULL, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
	"320KB Disk Image Files (*.2D)|*.2D|All Files (*.*)|*.*||", this);
	CFileDialog dlg(FALSE, ".D77", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"FM-7/77 Disk Image Files (*.D77)|*.D77|All Files (*.*)|*.*||", this);
	BOOL flag;
	CString fname_2d;
	CString d77_fname;

	// 2D̓_CAOs
	if (dlg2d.DoModal() != IDOK) {
		return;
	}
	fname_2d = dlg2d.GetPathName();

	// D77̓_CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}
	d77_fname = dlg.GetPathName();

	// ^Cg̓_CAOs
	if (titledlg.DoModal() != IDOK) {
		return;
	}

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// s
	flag = conv_2d_to_d77((char*)(LPCTSTR)fname_2d, (char*)(LPCTSTR)d77_fname, title);

	// vJ[\I
	AfxGetApp()->EndWaitCursor();

	// Xe[^X`FbN
	if (!flag) {
		MessageBox("Convert Error", NULL, MB_ICONSTOP | MB_OK);
	}
}

/*
 *	Tools-Convert VTP to T77
 *	VTPT77ϊ
 */
void CXM7Wnd::OnVTPtoT77()
{
	CFileDialog dlgvtp(TRUE, ".VTP", NULL, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
	"EM-7 Tape Image Files (*.VTP)|*.VTP|All Files (*.*)|*.*||", this);
	CFileDialog dlg(FALSE, ".T77", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
	"FM-7/77 Tape Image Files (*.T77)|*.T77|All Files (*.*)|*.*||", this);
	BOOL flag;
	CString vtp_fname;
	CString t77_fname;

	// VTP̓_CAOs
	if (dlgvtp.DoModal() != IDOK) {
		return;
	}
	vtp_fname = dlgvtp.GetPathName();

	// T77̓_CAOs
	if (dlg.DoModal() != IDOK) {
		return;
	}
	t77_fname = dlg.GetPathName();

	// vJ[\Zbg
	AfxGetApp()->BeginWaitCursor();

	// s
	flag = conv_vtp_to_t77((char*)(LPCTSTR)vtp_fname, (char*)(LPCTSTR)t77_fname);

	// vJ[\I
	AfxGetApp()->EndWaitCursor();

	// Xe[^X`FbN
	if (!flag) {
		MessageBox("Convert Error", NULL, MB_ICONSTOP | MB_OK);
	}
}

/*-[ ݒǂݍ݁Eۑ ]---------------------------------------------------*/

/*
 *	ݒǂݍ
 */
void CXM7Wnd::LoadConfig()
{
	char *pszDisp = "Display1";
	char *pszSound = "Sound1";
	char *pszInput = "Input1";

	// \
	m_nFrameRate = AfxGetApp()->GetProfileInt(pszDisp, "FrameRate", 60);

	// TEh
	m_sndrate = AfxGetApp()->GetProfileInt(pszSound, "SampleRate", 44100);
	m_sndtick = AfxGetApp()->GetProfileInt(pszSound, "SoundTick", 50);
	m_bSndOPN = AfxGetApp()->GetProfileInt(pszSound, "OPNEnable", TRUE);
	m_bSndPSG = AfxGetApp()->GetProfileInt(pszSound, "PSGEnble", TRUE);
	m_bSndBEEP = AfxGetApp()->GetProfileInt(pszSound, "BEEPEnable", TRUE);

	// 
	m_bKbd98 = AfxGetApp()->GetProfileInt(pszInput, "NEC98Key", FALSE);
	m_bKbdReal = AfxGetApp()->GetProfileInt(pszInput, "RealTimeKeyScan", FALSE);
	m_bKbdCap = AfxGetApp()->GetProfileInt(pszInput, "SwapCapCtrl", FALSE);
	m_bJoySwap = AfxGetApp()->GetProfileInt(pszInput, "SwapJoyButton", FALSE);
	m_dwJoyBlank = AfxGetApp()->GetProfileInt(pszInput, "JoyPollTime", 20);
}

/*
 *	ݒۑ
 */
void CXM7Wnd::SaveConfig()
{
	char *pszDisp = "Display1";
	char *pszSound = "Sound1";
	char *pszInput = "Input1";

	// \
	AfxGetApp()->WriteProfileInt(pszDisp, "FrameRate", m_nFrameRate);

	// TEh
	AfxGetApp()->WriteProfileInt(pszSound, "SampleRate", m_sndrate);
	AfxGetApp()->WriteProfileInt(pszSound, "SoundTick", m_sndtick);
	AfxGetApp()->WriteProfileInt(pszSound, "OPNEnable", m_bSndOPN);
	AfxGetApp()->WriteProfileInt(pszSound, "PSGEnble", m_bSndPSG);
	AfxGetApp()->WriteProfileInt(pszSound, "BEEPEnable", m_bSndBEEP);

	// 
	AfxGetApp()->WriteProfileInt(pszInput, "NEC98Key", m_bKbd98);
	AfxGetApp()->WriteProfileInt(pszInput, "RealTimeKeyScan", m_bKbdReal);
	AfxGetApp()->WriteProfileInt(pszInput, "SwapCapCtrl", m_bKbdCap);
	AfxGetApp()->WriteProfileInt(pszInput, "SwapJoyButton", m_bJoySwap);
	AfxGetApp()->WriteProfileInt(pszInput, "JoyPollTime", m_dwJoyBlank);
}

#endif	/* _WIN32 */
