/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 ʕ\ ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include <ddraw.h>
#include "xm7.h"
#include "win.h"
#include "display.h"
#include "keyboard.h"
#include "fdc.h"
#include "tapelp.h"

/*-[ GDI(4bpp) ]------------------------------------------------------------*/

/*
 *	GDI(4bpp)
 *	
 */
void CXM7Wnd::InitGDI4()
{
	m_hBitmap4 = NULL;
	m_pBits4 = NULL;
}

/*
 *	GDI(4bpp)
 *	I
 */
BOOL CXM7Wnd::SelectGDI4()
{
	CClientDC dc(this);
	BYTE buf[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 16];
	BITMAPINFOHEADER *pbmi;
	int i;
	BYTE *p;

	// rbg}bvwb_쐬
	memset(buf, 0, sizeof(buf));
	pbmi = (BITMAPINFOHEADER *)buf;
	pbmi->biSize = sizeof(BITMAPINFOHEADER);
	pbmi->biWidth = 640;
	pbmi->biHeight = -400;
	pbmi->biPlanes = 1;
	pbmi->biBitCount = 4;
	pbmi->biCompression = BI_RGB;

	// DIBZNV쐬
	m_hBitmap4 = CreateDIBSection(dc.m_hDC, (BITMAPINFO *)buf, DIB_RGB_COLORS,
											(void **)&m_pBits4, NULL, NULL);
	if (m_hBitmap4 == NULL) {
		return FALSE;
	}

	// C̐ݒ
	p = m_pBits4 + 320;
	for (i=0; i<200; i++) {
		memset(p, 0x88, 320);
		p += 640;
	}

	// Sʕ`w
	m_bFullDraw = TRUE;

	return TRUE;
}

/*
 *	GDI(4bpp)
 *	N[Abv
 */
void CXM7Wnd::CleanGDI4()
{
	// \[X
	if (m_hBitmap4) {
		DeleteObject(m_hBitmap4);
		m_hBitmap4 = NULL;
		m_pBits4 = NULL;
	}
}

/*
 *	GDI(4bpp)
 *	_O
 */
void CXM7Wnd::RenderGDI4(int first, int last)
{
	_asm {
		push	esi
		push	edi
		mov		esi,vram_c
		add		esi,4000h
		mov		eax,first
		imul	eax,50h
		add		esi,eax
		mov		edi,[ecx]this.m_pBits4;
		mov		eax,first
		imul	eax,640
		add		edi,eax
		mov		edx,last
		sub		edx,first
; PC[v
Render41:
		mov		bh,80
; PoCg[v
Render42:
		mov		al,[esi+4000h]
		mov		bl,[esi]
		mov		dh,[esi-4000h];
		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx

		add		ecx,ecx
		add		al,al
		adc		ecx,ecx
		add		bl,bl
		adc		ecx,ecx
		add		dh,dh
		adc		ecx,ecx
; ̃oCg
		bswap	ecx
		mov		[edi],ecx
		add		edi,4
		inc		esi
		dec		bh
		jnz		Render42
; ̃C
		add		edi,320
		dec		dl
		jnz		Render41
; I
		pop		edi
		pop		esi
	}
}

/*
 *	GDI(4bpp)
 *	`
 */
void CXM7Wnd::DrawGDI4(CDC *pDC)
{
	CDC mDC;
	HBITMAP hBitmap;
	RGBQUAD Colors[9];
	int i;
	static RGBQUAD RGBColor[] = {
		{   0,   0,   0,   0 },
		{ 255,   0,   0,   0 },
		{   0,   0, 255,   0 },
		{ 255,   0, 255,   0 },
		{   0, 255,   0,   0 },
		{ 255, 255,   0,   0 },
		{   0, 255, 255,   0 },
		{ 255, 255, 255,   0 }
	};
	int first;
	int last;

	DWORD dwTime = timeGetTime();

	// [NmF
	if (m_bFullDraw) {
		first = 0;
		last = 200;
	}
	else {
		first = m_nFirstLine;
		last = m_nLastLine;
	}

	// `FbN
	if (first < last) {
		// _O
		RenderGDI4(first, last);
	}
	else {
		if (!m_bPalFlag) {
			return;
		}
	}

	// pbgݒ
	for (i=0; i<8; i++) {
		Colors[i] = RGBColor[m_Palette[i]];
	}
	Colors[8] = RGBColor[0];

	// DC쐬AIuWFNgI
	mDC.CreateCompatibleDC(pDC);
	hBitmap = (HBITMAP)::SelectObject(mDC.m_hDC, m_hBitmap4);

	// pbgݒABlt
	::SetDIBColorTable(mDC.m_hDC, 0, 9, Colors);
	if (m_bPalFlag || m_bFullDraw) {
		pDC->BitBlt(0, 0, 640, 400, &mDC, 0, 0, SRCCOPY);
	}
	else {
		pDC->BitBlt(0, first * 2, 640, (last-first) * 2, &mDC, 0, first * 2, SRCCOPY);
	}

	// IuWFNgđI
	::SelectObject(mDC.m_hDC, hBitmap);
}

/*-[ DirectDraw(Full Screen, 8bpp) ]----------------------------------------*/

/*
 *	DirectDraw(8bpp)
 *	
 */
void CXM7Wnd::InitDD8()
{
	// [N
	m_lpdd2 = NULL;
	m_lpdds[0] = NULL;
	m_lpdds[1] = NULL;
	m_lpddp = NULL;
	m_lpddc = NULL;
}

/*
 *	DirectDraw(8bpp)
 *	I
 */
BOOL CXM7Wnd::SelectDD8()
{
	LPDIRECTDRAW lpdd;
	DDSURFACEDESC ddsd;
	PALETTEENTRY pe[256];
	CRect wrect;
	CDC *pDC;

	// EChE`擾
	GetWindowRect(&m_ddrect);

	// EChEX^CARg[o[̕ύX
	ModifyStyle(WS_CAPTION | WS_BORDER | WS_SYSMENU, WS_POPUP, 0);
	ModifyStyleEx(WS_EX_CLIENTEDGE | WS_EX_WINDOWEDGE, 0, 0);
	ShowControlBar(&m_StatusBar, FALSE, FALSE);

	// EChETCY␳
	wrect.left = 0;
	wrect.top = 0;
	wrect.right = 640;
	wrect.bottom = 400;
	MoveWindow(&wrect, FALSE);

	// DirectDrawIuWFNg쐬
	if (DirectDrawCreate(NULL, &lpdd, NULL) != DD_OK) {
		return FALSE;
	}

	// [hݒ
	if (lpdd->SetCooperativeLevel(m_hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN)
			!= DD_OK) {
		lpdd->Release();
		return FALSE;
	}

	// IDirectDraw2C^tF[X擾
	if (lpdd->QueryInterface(IID_IDirectDraw2, (LPVOID*)&m_lpdd2) != S_OK) {
		lpdd->Release();
		return FALSE;
	}
	lpdd->Release();

	// ʃ[hݒB640~400640~480̏Ŏ
	if (m_lpdd2->SetDisplayMode(640, 400, 8, 0, 0) != DD_OK) {
		if (m_lpdd2->SetDisplayMode(640, 480, 8, 0, 0) != DD_OK) {
			return FALSE;
		}
	}

	// vC}T[tFCX쐬
	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	if (m_lpdd2->CreateSurface(&ddsd, &m_lpdds[0], NULL) != DD_OK) {
		return FALSE;
	}

	// [NT[tFCX쐬(DDSCAPS_SYSTEMMEMORYw肷)
	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.dwWidth = 640;
	ddsd.dwHeight = 400;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	if (m_lpdd2->CreateSurface(&ddsd, &m_lpdds[1], NULL) != DD_OK) {
		return FALSE;
	}

	// pbg쐬A蓖
	pDC = GetWindowDC();
	::GetSystemPaletteEntries(pDC->m_hDC, 0, 256, pe);
	ReleaseDC(pDC);
	if (m_lpdd2->CreatePalette(DDPCAPS_8BIT, pe, &m_lpddp, NULL) != DD_OK) {
		return FALSE;
	}
	if (m_lpdds[0]->SetPalette(m_lpddp) != DD_OK) {
		return FALSE;
	}

	// Nbp[쐬A蓖
	if (m_lpdd2->CreateClipper(NULL, &m_lpddc, NULL) != DD_OK) {
		return FALSE;
	}
	if (m_lpddc->SetHWnd(NULL, m_hWnd) != DD_OK) {
		return FALSE;
	}

	// Sʕ`w
	m_bFullDraw = TRUE;

	return TRUE;
}

/*
 *	DirectDraw(8bpp)
 *	N[Abv
 */
void CXM7Wnd::CleanDD8()
{
	// Nbp[
	if (m_lpddc) {
		m_lpddc->Release();
		m_lpddc = NULL;
	}

	// pbg
	if (m_lpddp) {
		m_lpddp->Release();
		m_lpddp = NULL;
	}

	// [NT[tFCX
	if (m_lpdds[1]) {
		m_lpdds[1]->Release();
		m_lpdds[1] = NULL;
	}

	// vC}T[tFCX
	if (m_lpdds[0]) {
		m_lpdds[0]->Release();
		m_lpdds[0] = NULL;
	}

	// IDirectDraw2C^tF[X
	if (m_lpdd2) {
		m_lpdd2->Release();
		m_lpdd2 = NULL;
	}

	// EChEX^CARg[o[
	ModifyStyle(WS_POPUP, WS_CAPTION | WS_BORDER | WS_SYSMENU, 0);
	ModifyStyleEx(0, WS_EX_CLIENTEDGE | WS_EX_WINDOWEDGE, 0);
	ShowControlBar(&m_StatusBar, TRUE, FALSE);

	// EChETCY␳
	SetWindowPos(&wndNoTopMost, m_ddrect.left, m_ddrect.top,
		m_ddrect.right - m_ddrect.left,
		m_ddrect.bottom - m_ddrect.top, SWP_DRAWFRAME);
}

/*
 *	DirectDraw(8bpp)
 *	_O
 */
void CXM7Wnd::RenderDD8(LPVOID lpSurface, LONG lPitch, int first, int last)
{
	_asm {
		push	esi
		push	edi
; T[tFCXݒ
		mov		edi,lpSurface
		mov		eax,lPitch
		imul	eax,first
		add		edi,eax
		add		edi,eax
; sb`OČvZ
		mov		esi,lPitch
		sub		esi,640
		mov		lPitch,esi
; VRAMAhXݒ
		mov		esi,vram_c
		add		esi,4000h
		mov		eax,first
		imul	eax,50h
		add		esi,eax
; Cݒ
		mov		edx,last
		sub		edx,first
; PC[v
Render81:
		mov		bh,80
; PoCg[v
Render82:
		mov		al,[esi+4000h]
		mov		bl,[esi]
		mov		dh,[esi-4000h];
; Prbg[v
		mov		ch,8
Render83:
		mov		cl,04h
		add		al,al
		adc		cl,cl
		add		bl,bl
		adc		cl,cl
		add		dh,dh
		adc		cl,cl
; 
		mov		[edi],cl
		inc		edi
		dec		ch
		jnz		Render83
; ̃oCg
		inc		esi
		dec		bh
		jnz		Render82
; ̃C
		add		edi,lPitch
		mov		ch,40
		mov		eax,28282828h
Render84:
		mov		[edi],eax
		mov		[edi+4],eax
		mov		[edi+8],eax
		mov		[edi+12],eax
		add		edi,16
		dec		ch
		jnz		Render84
; ̃C
		add		edi,lPitch
		dec		dl
		jnz		Render81
; I
		pop		edi
		pop		esi
	}
}

/*
 *	DirectDraw(8bpp)
 *	`
 */
void CXM7Wnd::DrawDD8()
{
	DDSURFACEDESC ddsd;
	HRESULT hResult;
	PALETTEENTRY pe[9];
	CRect rect;
	int i;
	int first;
	int last;
	static PALETTEENTRY PALColor[] = {
		{   0,   0,   0,   0 },
		{   0,   0, 255,   0 },
		{ 255,   0,   0,   0 },
		{ 255,   0, 255,   0 },
		{   0, 255,   0,   0 },
		{   0, 255, 255,   0 },
		{ 255, 255,   0,   0 },
		{ 255, 255, 255,   0 }
	};

	// [NmF
	if (m_bFullDraw) {
		first = 0;
		last = 200;
	}
	else {
		first = m_nFirstLine;
		last = m_nLastLine;
	}

	// _O`FbN
	if (first < last) {
		// T[tFCXbN
		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		hResult =m_lpdds[1]->Lock(NULL, &ddsd, 
				DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR | DDLOCK_WRITEONLY, NULL);
		if (hResult != DD_OK) {
			if (hResult == DDERR_SURFACELOST) {
				// T[tFCX̃XgA
				m_lpdds[1]->Restore();
			}
			// gC
			Invalidate(FALSE);
			return;
		}

		// _O
		RenderDD8(ddsd.lpSurface, ddsd.lPitch, first, last);

		// T[tFCXAbN
		m_lpdds[1]->Unlock(ddsd.lpSurface);

		// Blt
		rect.top = first * 2;
		rect.left = 0;
		rect.right = 640;
		rect.bottom = last * 2;
		hResult = m_lpdds[0]->Blt(&rect, m_lpdds[1], &rect, DDBLT_WAIT, NULL);
		if (hResult != DD_OK) {
			if (hResult == DDERR_SURFACELOST) {
				// T[tFCX̃XgA
				m_lpdds[0]->Restore();
				m_lpdds[1]->Restore();
			}
			// gC
			Invalidate(FALSE);
			return;
		}
	}

	// pbgݒ
	if (m_bPalFlag || m_bFullDraw) {
		for (i=0; i<8; i++) {
			pe[i] = PALColor[m_Palette[i]];
		}
		pe[8] = PALColor[0];
		m_lpddp->SetEntries(0, 32, 9, pe);
	}
}

/*-[ VMƂ̐ڑ֐ ]-------------------------------------------------------*/

/*
 *	VRAM
 */
extern "C" {
void vram_setb(WORD addr, BYTE dat)
{
	int y;

	/* tXN[̓`FbNȂ */
	if (pMainWnd->m_bFullDraw) {
		return;
	}

	/* yWZo */
	addr &= 0x3fff;
	y = addr / 80;
	if (y >= 200) {
		return;
	}

	/* XV */
	if (pMainWnd->m_nFirstLine > y) {
		pMainWnd->m_nFirstLine = y;
	}
	if (pMainWnd->m_nLastLine <= y) {
		pMainWnd->m_nLastLine = y + 1;
	}
}
}

/*
 *	pbgݒ
 */
extern "C" {
void ttlpalet_setb(int no, BYTE dat)
{
	ASSERT((no >= 0) && (no <= 7));
	ASSERT((dat >= 0) && (dat <= 7));

	// f[^Z[u
	pMainWnd->m_Palette[no] = dat;

	// pbgtOon
	pMainWnd->m_bPalFlag = TRUE;
}
}

/*
 *	VRAMItZbgWX^ݒ
 */
extern "C" {
void vramoff_setw(WORD offset)
{
	// Sʏ
	pMainWnd->m_bFullDraw = TRUE;
}
}

/*-[ EChE֐ ]-------------------------------------------------------*/

/*
 *	`(Windows)
 */
void CXM7Wnd::OnPaint()
{
	CPaintDC dc(this);

	// tOグ
	m_bCaptionFlag = TRUE;
	m_bFullDraw = TRUE;

	// `
	OnDraw(&dc);
}

/*
 *	wi`(Windows)
 */
BOOL CXM7Wnd::OnEraseBkgnd(CDC *pDC)
{
	// G[̂ݓh
	if (m_nErrorCode > 0) {
		return CFrameWnd::OnEraseBkgnd(pDC);
	}

	return TRUE;
}

/*
 *	`()
 */
void CXM7Wnd::OnDraw(CDC *pDC)
{
	if (m_hBitmap4) {
		// EChE[h
		DrawGDI4(pDC);
		UpdateCaption();
		UpdateBars();
		if (m_bSyncFlag) {
			OnRefresh();
		}
	}
	if (m_lpddc) {
		// Sʃ[h
		DrawDD8();
	}

	// [NNA
	m_bFullDraw = FALSE;
	m_nFirstLine = 200;
	m_nLastLine = -1;
	m_bPalFlag = FALSE;
}

/*
 *	LvVXV
 */
void CXM7Wnd::UpdateCaption()
{
#if 0
	char buf[32];
	static DWORD dwTime;

	if (dwTime == 0) {
		dwTime = timeGetTime();
	}

	if ((timeGetTime() - dwTime) < 2000) {
		return;
	}

	sprintf(buf, "XM7 - %d fps",
	(m_nDrawCount * 1000) / (timeGetTime() - dwTime));

	m_nDrawCount = 0;
	dwTime = timeGetTime();
#else
	char buf[256];
	char drv0[_MAX_FNAME+_MAX_EXT];
	char fname[_MAX_FNAME+_MAX_EXT];
	char ext[_MAX_EXT];
	static BOOL old_flag;
	BOOL flag;

	// XV`FbN
	if ((old_flag == run_flag) && !m_bCaptionFlag) {
		return;
	}

	// tO~낷
	m_bCaptionFlag = FALSE;
	old_flag = run_flag;

	// 쐬
	strcpy(buf, "XM7 ");
	if (run_flag) {
		strcat(buf, "[s]");
	}
	else {
		strcat(buf, "[~]");
	}

	// tO~낷
	flag = FALSE;
	drv0[0] = '\0';

	// hCu0
	if (fdc_ready[0] != FDC_TYPE_NOTREADY) {
		_splitpath(fdc_fname[0], NULL, NULL, fname, ext);
		strcat(fname, ext);
		strcpy(drv0, fname);
		strcat(buf, " - ");
		strcat(buf, drv0);
		flag = TRUE;
	}

	// hCu1
	if (fdc_ready[1] != FDC_TYPE_NOTREADY) {
		_splitpath(fdc_fname[1], NULL, NULL, fname, ext);
		strcat(fname, ext);
		if (strcmp(fname, drv0) != 0) {
			if (flag) {
				strcat(buf, "(");
			}
			else {
				strcat(buf, " - ");
			}
			strcat(buf, fname);
			if (flag) {
				strcat(buf, ")");
			}
		}
		flag = TRUE;
	}

	// e[v
	if (tape_fileh != -1) {
		_splitpath(tape_fname, NULL, NULL, fname, ext);
		strcat(fname, ext);
		strcat(buf, " - ");
		strcat(buf, fname);
	}
#endif

	SetWindowText(buf);
}

/*
 *	Rg[o[XV
 */
void CXM7Wnd::UpdateBars()
{
	int i;
	BOOL flag;
	char buf[64];
	static BYTE facc[2];
	static BYTE frdy[2];
	static int tfile;
	static DWORD toffset;
	static BOOL cap;
	static BOOL kana;
	static BOOL ins;

	// tbs[`FbN
	flag = FALSE;
	for (i=0; i<2; i++) {
		if (facc[i] != fdc_access[i]) {
			flag = TRUE;
		}
		if (frdy[i] != fdc_ready[i]) {
			flag = TRUE;
		}
	}

	// tbs[
	if (flag) {
		for (i=0; i<2; i++) {
			// f[^Rs[
			facc[i] = fdc_access[i];
			frdy[i] = fdc_ready[i];

			// 쐬
			if (frdy[i] == FDC_TYPE_NOTREADY) {
				buf[0] = '\0';
			}
			else {
				switch (facc[i]) {
					case FDC_ACCESS_READY:
						strcpy(buf, "READY");
						break;
					case FDC_ACCESS_SEEK:
						strcpy(buf, " SEEK");
						break;
					case FDC_ACCESS_READ:
						strcpy(buf, " READ");
						break;
					case FDC_ACCESS_WRITE:
						strcpy(buf, "WRITE");
						break;
					default:
						ASSERT(FALSE);
				}
			}
			m_StatusBar.SetPaneText((i ^ 1) + 1, buf);
		}
	}

	// e[v
	if ((tape_fileh != tfile) || (tape_offset != toffset)) {
		tfile= tape_fileh;
		toffset = tape_offset;

		if (tape_fileh == -1) {
			buf[0] = '\0';
		}
		else {
			sprintf(buf, "%04d", (tape_offset >> 8) % 10000);
		}
		m_StatusBar.SetPaneText(3, buf);
	}

	// CAP
	if (caps_flag != cap) {
		cap = caps_flag;
		if (caps_flag) {
			strcpy(buf, "CAP");
		}
		else {
			buf[0] = '\0';
		}
		m_StatusBar.SetPaneText(5, buf);
	}

	// 
	if (kana_flag != kana) {
		kana = kana_flag;
		if (kana_flag) {
			strcpy(buf, "");
		}
		else {
			buf[0] = '\0';
		}
		m_StatusBar.SetPaneText(6, buf);
	}

	// INS
	if (ins_flag != ins) {
		ins = ins_flag;
		if (ins_flag) {
			strcpy(buf, "INS");
		}
		else {
			buf[0] = '\0';
		}
		m_StatusBar.SetPaneText(7, buf);
	}
}

#endif	/* _WIN32 */
