/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win16 C ]
 */

#ifdef _WIN16

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\dc.h>
#include <owl\opensave.h>
#include <owl\menu.h>
#include <owl\listbox.h>
#include <winnls.h>
#include <mmsystem.h>
#include "xm7.h"
#include "w16.h"
#include "mainetc.h"
#include "fdc.h"
#include "gui.h"

/*
 *	pbge[u
 */
const RGBQUAD PaletTable[] = {
	{ 0, 0, 0, 0},
	{ 255, 0, 0, 0},
	{ 0, 0, 255, 0},
	{ 255, 0, 255, 0},
	{ 0, 255, 0, 0},
	{ 255, 255, 0, 0},
	{ 0, 255, 255, 0},
	{ 255, 255, 255, 0},
};

/*
 *	O[o [N
 */
TXM7Window *pMainWindow;
BOOL force_flag;

/*
 *	foCXˑ֐
 */
extern "C" {

/*
 *	VRAMPoCgZbg Tu
 */
void vram_setb_sub(WORD seg0, WORD seg1, WORD addr, BYTE dat)
{
	_asm {
		mov		ax,addr
		mov		dl,0x01
		cmp		ax,0x4000
		jc		vram_setb_s0
		add		dl,dl
		cmp		ax,0x8000
		jc		vram_setb_s0
		add		dl,dl
vram_setb_s0:
		mov		dh,dl
		shl		dh,4
		and		ax,0x3fff

		mov		bx,seg0
		mov		ch,0x50
		div		ch
		cmp		al,200
		jnc     vram_setb_s5
		cmp		al,100
		jc		vram_setb_s1
		sub		al,100
		mov		bx,seg1
vram_setb_s1:
		mov		es,bx

		mov		bl,ah
		xor		bh,bh
		shl		bx,2
		mov		cl,al
		mov		al,99
		sub		al,cl
		mov		ch,0x28
		mul		ch
		shl		ax,4
		add		bx,ax
		add		bx,40 + 4 * 16

		mov		cx,dx
		not		cx
		mov		si,4
		mov		al,dat

vram_setb_s2:
		mov		ah,es:[bx]
		and		ah,ch
		add		al,al
		jnc		vram_setb_s3
		or		ah,dh
vram_setb_s3:
		and		ah,cl
		add		al,al
		jnc		vram_setb_s4
		or		ah,dl
vram_setb_s4:
		mov		es:[bx],ah
		inc		bx
		dec		si
		jnz     vram_setb_s2
vram_setb_s5:
	}
}

/*
 *	VRAMPoCgݒ
 */
void vram_setb(WORD addr, BYTE dat)
{
	BYTE FAR *buf0;
	BYTE FAR *buf1;

	buf0 = (BYTE FAR *)GlobalLock(pMainWindow->hDIB[0]);
	buf1 = (BYTE FAR *)GlobalLock(pMainWindow->hDIB[1]);
	vram_setb_sub(FP_SEG(buf0), FP_SEG(buf1), addr, dat);
	GlobalUnlock(pMainWindow->hDIB[0]);
	GlobalUnlock(pMainWindow->hDIB[1]);

	// tOグ
	pMainWindow->bReqPaint = TRUE;
}

/*
 *	pbgݒ
 */
void ttlpalet_setb(int no, BYTE dat)
{
	BYTE FAR *p;
	RGBQUAD *rgb;

	// 㔼
	p = (BYTE FAR*)GlobalLock(pMainWindow->hDIB[0]);
	rgb = (RGBQUAD *)&p[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * no];
	*rgb = PaletTable[dat];
	GlobalUnlock(pMainWindow->hDIB[0]);

	// 
	p = (BYTE FAR*)GlobalLock(pMainWindow->hDIB[1]);
	rgb = (RGBQUAD *)&p[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * no];
	*rgb = PaletTable[dat];
	GlobalUnlock(pMainWindow->hDIB[1]);

	// tOグ
	pMainWindow->bReqPaint = TRUE;
}

/*
 *	VRAMItZbgWX^ݒ
 */
void vramoff_setw(WORD offset)
{
	WORD i;

	for (i=0; i<0xc000; i++) {
		vram_setb(i, vram_c[i]);
	}
}

/*
 *	L[{[hLEDݒ
 */
void keyboard_setled(void)
{
}

/*
 *	OPNPoCgo
 */
void opn_setb(BYTE reg, BYTE dat)
{
}

/*
 *	WCXeBbNPoCg
 */
BYTE joy_getb(BYTE index)
{
	return 0;
}

/*
 *	bZ[W
 */
void do_events(void)
{
	HDC hDC;

	pMainWindow->GetApplication()->PumpWaitingMessages();

	if (!pMainWindow->bTimerFlag) {
		return;
	}

	/* ĕ` */
	pMainWindow->ReDrawCnt++;
	if ((pMainWindow->ReDrawCnt >= 8) && pMainWindow->bReqPaint) {
		pMainWindow->bReqPaint = FALSE;
		hDC = GetDC(pMainWindow->HWindow);
		pMainWindow->EvDraw(hDC);
		ReleaseDC(pMainWindow->HWindow, hDC);
	}

	/* 荞 */
	pMainWindow->IntrCnt = (pMainWindow->IntrCnt + 1) & 1;
	if (pMainWindow->IntrCnt) {
		subcpu_nmi();
	}
	mainetc_timer();

	/* tOOFF */
	pMainWindow->bTimerFlag = FALSE;
}

}

/*
 *	}`fBA ^C}[
 */
void CALLBACK TimerFunc(UINT wTimerID, UINT wMsg,
	DWORD dwUser, DWORD dw1, DWORD dw2)
{
	/* EChE擾 */
	_DS = (WORD)dwUser;

	/* 쒆̂ */
	if (!run_flag) {
		return;
	}

	/* ^C}[ID */
	if (wTimerID != pMainWindow->nTimerID) {
		return;
	}

	/* tOAbv */
	pMainWindow->bTimerFlag = TRUE;
}

/*-[ CEChENX ]-----------------------------------------------*/

/*
 *	bZ[W }bv
 */
DEFINE_RESPONSE_TABLE1(TXM7Window, TFrameWindow)
	EV_WM_PAINT,
	EV_WM_CLOSE,
	EV_WM_KEYDOWN,
	EV_WM_KEYUP,
	EV_WM_SYSKEYDOWN,
	EV_WM_SYSKEYUP,
	EV_COMMAND(CM_USER, EvUser),
	EV_COMMAND(CM_APPEXIT, EvExit),
	EV_COMMAND(CM_SYSRESET, EvReset),
	EV_COMMAND_ENABLE(CM_SYSRESET, EvResetEn),
	EV_COMMAND(CM_DRV0OPEN, EvDrv0Open),
	EV_COMMAND_ENABLE(CM_DRV0OPEN, EvDrv0OpenEn),
	EV_COMMAND(CM_DRV0SEL, EvDrv0Sel),
	EV_COMMAND_ENABLE(CM_DRV0SEL, EvDrv0SelEn),
	EV_COMMAND(CM_DRV1OPEN, EvDrv1Open),
	EV_COMMAND_ENABLE(CM_DRV1OPEN, EvDrv1OpenEn),
	EV_COMMAND(CM_DRV1SEL, EvDrv1Sel),
	EV_COMMAND_ENABLE(CM_DRV1SEL, EvDrv1SelEn),
	EV_COMMAND(CM_KEY106, EvKey106),
	EV_COMMAND_ENABLE(CM_KEY106, EvKey106En),
	EV_COMMAND(CM_KEY98, EvKey98),
	EV_COMMAND_ENABLE(CM_KEY98, EvKey98En),
	EV_COMMAND(CM_KEYTOWNS, EvKeyTowns),
	EV_COMMAND_ENABLE(CM_KEYTOWNS, EvKeyTownsEn),
	EV_COMMAND(CM_APPABOUT, EvAbout),
END_RESPONSE_TABLE;

/*
 *	RXgN^
 */
TXM7Window::TXM7Window() : TFrameWindow(NULL, "XM7")
{
	// AttrύX
	Attr.Style &= ~WS_MAXIMIZEBOX;
	Attr.Style &= ~WS_MAXIMIZE;
	Attr.Style &= ~WS_THICKFRAME;
	Attr.Style |= WS_BORDER;
	Attr.AccelTable = MAINMENU;
	Attr.Menu = MAINMENU;
}

/*
 *	EChE
 */
void TXM7Window::SetupWindow()
{
	TRect crect;
	TRect wrect;
	int i;
	int j;
	WORD ver;
	BITMAPINFO *pbmi;
	BYTE FAR *p;
	WORD offset;

	// {NXĂяo
	TFrameWindow::SetupWindow();

	// TCYύX
	GetWindowRect(wrect);
	GetClientRect(crect);
	wrect.right -= (crect.right - crect.left);
	wrect.bottom -= (crect.bottom - crect.top);
	wrect.right += 640;
	wrect.bottom += 400;
	MoveWindow(wrect, FALSE);

	// ACRݒ
	SetIcon(GetApplication(), MAKEINTRESOURCE(XM7ICON));

	// rbg}bv
	for (i=0; i<2; i++) {
		hDIB[i] = GlobalAlloc(GHND, sizeof(BITMAPINFOHEADER) +
			sizeof(RGBQUAD) * 16 + 320 * 200);
		if (hDIB[i] != NULL) {
			pbmi = (BITMAPINFO*)GlobalLock(hDIB[i]);
			memset(pbmi, 0, sizeof(BITMAPINFOHEADER));
			pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
			pbmi->bmiHeader.biWidth = 640;
			pbmi->bmiHeader.biHeight = 200;
			pbmi->bmiHeader.biPlanes = 1;
			pbmi->bmiHeader.biBitCount = 4;
			pbmi->bmiHeader.biCompression = BI_RGB;

			p = (BYTE FAR *)pbmi;
			offset = sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 16 + 320;
			for (j=0; j<100; j++) {
				memset(&p[offset], 0x88, 320);
				offset += 640;
			}
			GlobalUnlock(hDIB[i]);
		}
	}

	// [N
	bReqPaint = FALSE;
	bTimerFlag = FALSE;
	m_nChar = 0;
	m_nFlags = 0xffff;
	nTimerID = 0;
	ErrorCode = 0;
	m_nKeyType = 0;

	// VXeEZbg
	if (!system_init()) {
		ErrorCode = 1;
		PostMessage(WM_COMMAND, CM_USER, 0);
		return;
	}
	system_reset();

	// t[obt@̃`FbN
	if ((hDIB[0] == NULL) || (hDIB[1] == NULL)) {
		ErrorCode = 3;
		PostMessage(WM_COMMAND, CM_USER, 0);
		return;
	}

	// _~[v[ݒ
	ttlpalet_setb(8, 0);

	// Windowso[W`FbN
	if (!force_flag) {
		ver = LOWORD(GetVersion());
		ver += 0x0101;
		if (ver != 0x0b04) {
			ErrorCode = 2;
			PostMessage(WM_COMMAND, CM_USER, 0);
			return;
		}
	}

	// ^C}[ݒ
	if (timeBeginPeriod(10) != 0) {
		ErrorCode = 3;
		PostMessage(WM_COMMAND, CM_USER, 0);
		return;
	}
	run_flag = FALSE;
	nTimerID = timeSetEvent(10, 10, TimerFunc, (DWORD)_DS, TIME_PERIODIC);
	if (nTimerID == NULL) {
		ErrorCode = 3;
		PostMessage(WM_COMMAND, CM_USER, 0);
		return;
	}

	// IMEgp֎~
	WINNLSEnableIME(HWindow, FALSE);

	// X^[g
	PostMessage(WM_COMMAND, CM_USER, 0);
}

/*
 *	EChEN[Abv
 */
void TXM7Window::CleanupWindow()
{
	int i;

	// VXe N[Abv
	system_cleanup();

	// ^C}[~
	if (nTimerID) {
		timeKillEvent(nTimerID);
	}
	timeEndPeriod(10);

	// EChE
	for (i=0; i<2; i++) {
		if (hDIB[i]!= NULL) {
			GlobalFree(hDIB[i]);
			hDIB[i] = NULL;
		}
	}

	// IMEgp\
	WINNLSEnableIME(HWindow, TRUE);

	// {NX
	TFrameWindow::CleanupWindow();
}

/*
 *	N[Y₢킹
 */
BOOL TXM7Window::CanClose()
{
	if (run_flag) {
		stopreq_flag = TRUE;
		return FALSE;
	}

	return TRUE;
}

/*
 *	[U(CPUX^[ĝ߂̃LbN)
 */
void TXM7Window::EvUser()
{
	switch (ErrorCode) {
		case 0:
			debug_run();
			CloseWindow();
			break;
		case 1:
			MessageBox("ROMt@C܂", 0, MB_ICONSTOP | MB_OK);
			CloseWindow();
			break;
		case 2:
			MessageBox(
				"Microsoft Windows 3.1pł\nWin32łg",
				0, MB_ICONSTOP | MB_OK);
			CloseWindow();
			return;
		case 3:
			MessageBox("̓\[X̕sł", 0,
						MB_ICONSTOP | MB_OK);
			CloseWindow();
			return;
	}
}

/*
 *	`
 */
void TXM7Window::EvPaint()
{
	HDC hDC;
	PAINTSTRUCT ps;

	hDC = BeginPaint(HWindow, &ps);

	// G[͕`KvȂ
	if (ErrorCode == 0) {
		EvDraw(hDC);
	}

	EndPaint(HWindow, &ps);
}

/*
 *	`Tu
 */
void TXM7Window::EvDraw(HDC hDC)
{
	BYTE FAR *p;

	// 㔼
	p = (BYTE FAR *)GlobalLock(hDIB[0]);
	SetDIBitsToDevice(hDC, 0, 0, 640, 200, 0, 0, 0, 200,
		&p[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 16],
		(BITMAPINFO*)p,
		DIB_RGB_COLORS);
	GlobalUnlock(hDIB[0]);

	// 
	p = (BYTE FAR *)GlobalLock(hDIB[1]);
	SetDIBitsToDevice(hDC, 0, 200, 640, 200, 0, 0, 0, 200,
		&p[sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 16],
		(BITMAPINFO*)p,
		DIB_RGB_COLORS);
	GlobalUnlock(hDIB[1]);
}

/*
 *	t@C(F)-Zbg(R)
 */
void TXM7Window::EvReset()
{
	system_reset();
}

/*
 *	t@C(F)-Zbg(R)
 */
void TXM7Window::EvResetEn(TCommandEnabler& ce)
{
	ce.Enable(!gui_flag);
}

/*
 *	t@C(F)-I(X)
 */
void TXM7Window::EvExit()
{
	CloseWindow();
}

/*
 *	fBXN(D)-hCu-J(O)
 */
void TXM7Window::EvDrvOpen(int drive)
{
	TData data;

	data.Flags |= OFN_HIDEREADONLY;
	data.SetFilter("D77fBXN (*.D77)|*.D77|2DfBXN (*.2D)|*.2D|\
SẴt@C (*.*)|*.*||");
	GetApplication()->EnableCtl3dAutosubclass(TRUE);
	TFileOpenDialog dlg(this, data);

	if (dlg.DoExecute() != IDOK) {
		fdc_setdisk(drive, NULL);
		GetApplication()->EnableCtl3dAutosubclass(FALSE);
		return;
	}
	GetApplication()->EnableCtl3dAutosubclass(FALSE);

	if (fdc_setdisk(drive, data.FileName) == 0) {
		MessageBox("fBXNt@CZbgł܂", NULL, MB_ICONSTOP | MB_OK);
		fdc_setdisk(drive, NULL);
	}
}

/*
 *	fBXN(D)-hCu0(0)-J(O)
 */
void TXM7Window::EvDrv0Open()
{
	EvDrvOpen(0);
}

/*
 *	fBXN(D)-hCu0(0)-J(O)
 */
void TXM7Window::EvDrv0OpenEn(TCommandEnabler& ce)
{
	ce.Enable(!gui_flag);
}

/*
 *	fBXN(D)-hCu0(0)-fBXNI(S)
 */
void TXM7Window::EvDrv0Sel()
{
	TDiskDlg dlg(this, 0, GetApplication());

	dlg.Execute();
}

/*
 *	fBXN(D)-hCu0(0)-fBXNI(S)
 */
void TXM7Window::EvDrv0SelEn(TCommandEnabler& ce)
{
	ce.Enable((fdc_ready[0] == FDC_TYPE_D77) && !gui_flag);
}

/*
 *	fBXN(D)-hCu1(1)-J(O)
 */
void TXM7Window::EvDrv1Open()
{
	EvDrvOpen(1);
}

/*
 *	fBXN(D)-hCu1(1)-J(O)
 */
void TXM7Window::EvDrv1OpenEn(TCommandEnabler& ce)
{
	ce.Enable(!gui_flag);
}

/*
 *	fBXN(D)-hCu1(1)-fBXNI(S)
 */
void TXM7Window::EvDrv1Sel()
{
	TDiskDlg dlg(this, 1, GetApplication());

	dlg.Execute();
}

/*
 *	fBXN(D)-hCu1(1)-fBXNI(S)
 */
void TXM7Window::EvDrv1SelEn(TCommandEnabler& ce)
{
	ce.Enable((fdc_ready[1] == FDC_TYPE_D77) && !gui_flag);
}

/*
 *	RtBO(C)-L[{[h(K)-106(6)
 */
void TXM7Window::EvKey106()
{
	m_nKeyType = 0;
}

/*
 *	RtBO(C)-L[{[h(K)-106(6)
 */
void TXM7Window::EvKey106En(TCommandEnabler& ce)
{
	ce.SetCheck(m_nKeyType == 0);
}

/*
 *	RtBO(C)-L[{[h(K)-98(9)
 */
void TXM7Window::EvKey98()
{
	m_nKeyType = 1;
}

/*
 *	RtBO(C)-L[{[h(K)-98(9)
 */
void TXM7Window::EvKey98En(TCommandEnabler& ce)
{
	ce.SetCheck(m_nKeyType == 1);
}

/*
 *	RtBO(C)-L[{[h(K)-TOWNS(T)
 */
void TXM7Window::EvKeyTowns()
{
	m_nKeyType = 2;
}

/*
 *	RtBO(C)-L[{[h(K)-TOWNS(T)
 */
void TXM7Window::EvKeyTownsEn(TCommandEnabler& ce)
{
	ce.SetCheck(m_nKeyType == 2);
}

/*
 *	wv(H)-o[W(A)
 */
void TXM7Window::EvAbout()
{
	TAboutDlg dlg(this, GetApplication());

	dlg.Execute();
}

/*-[ o[W_CAO ]---------------------------------------------*/

/*
 *	_CAO ZbgAbv
 */
BOOL TAboutDlg::EvInitDialog(HWND hWndFocus)
{
	TRect crect;
	TRect prect;

	// {NX
	if (!TDialog::EvInitDialog(hWndFocus)) {
		return FALSE;
	}

	// `擾
	GetWindowRect(crect);
	Parent->GetWindowRect(prect);

	// ύX
	crect.right -= crect.left;
	crect.left = prect.left + (prect.right - prect.left) / 2
					- crect.right / 2;
	crect.right += crect.left;
	crect.bottom -= crect.top;
	crect.top = prect.top + (prect.bottom - prect.top) / 2
					- crect.bottom / 2;
	crect.bottom += crect.top;
	MoveWindow(crect, FALSE);

	return TRUE;
}

/*-[ fBXNI_CAO ]-----------------------------------------------*/

/*
 *	RXgN^
 */
TDiskDlg::TDiskDlg(TWindow *parent, int drv, TModule *module)
	: TDialog(parent, DISKDLG, module)
{
	nDrive = drv;

	pListBox = new TListBox(this, IDC_LISTBOX);
	pListBox->Attr.Style &= ~LBS_SORT;
};

/*
 *	_CAO ZbgAbv
 */
BOOL TDiskDlg::EvInitDialog(HWND hWndFocus)
{
	TRect crect;
	TRect prect;
	int i;

	// {NX
	if (!TDialog::EvInitDialog(hWndFocus)) {
		return FALSE;
	}

	// `擾
	GetWindowRect(crect);
	Parent->GetWindowRect(prect);

	// ύX
	crect.right -= crect.left;
	crect.left = prect.left + (prect.right - prect.left) / 2
					- crect.right / 2;
	crect.right += crect.left;
	crect.bottom -= crect.top;
	crect.top = prect.top + (prect.bottom - prect.top) / 2
					- crect.bottom / 2;
	crect.bottom += crect.top;
	MoveWindow(crect, FALSE);

	// Xg{bNX
	pListBox->ClearList();
	for (i=0; i<fdc_medias[nDrive]; i++) {
		pListBox->AddString(fdc_name[nDrive][i]);
	}
	pListBox->SetSelIndex(fdc_media[nDrive]);

	return TRUE;
}

/*
 *	_CAOI
 */
void TDiskDlg::Destroy(int retValue)
{
	int i;

	// IDOK̏ꍇ̂
	if (retValue == IDOK) {
		// J[\]
		i = pListBox->GetSelIndex();
		if ((i >= 0) && (i < fdc_medias[nDrive])) {
			if (fdc_media[i] != i) {
				fdc_setmedia(nDrive, i);
			}
		}
	}

	// {NX
	TDialog::Destroy(retValue);
}

/*-[ AvP[VNX ]-----------------------------------------------*/

/*
 *	AvP[V
 */
void TXM7Application::InitInstance()
{
	// {NXĂяo
	TApplication::InitInstance();

	// Microsoft CTL3DV2.DLLgp
	EnableCtl3d(TRUE);
}

/*
 *	CEChEݒ
 */
void TXM7Application::InitMainWindow()
{
	::pMainWindow = new TXM7Window();
	SetMainWindow((TFrameWindow*)::pMainWindow);
}

/*
 *	OwlMain
 */
int OwlMain(int argc, char *argv[])
{
	char *force_cmd = "ecrof-";
	int i;

	force_flag = FALSE;
	if (argc >= 2) {
		for (i=0; i<6; i++) {
			if (force_cmd[5 - i] != argv[1][i]) {
				break;
			}
		}
		if (i == 6) {
			force_flag = TRUE;
		}
	}

	return TXM7Application().Run();
}

#endif	/* _WIN16 */
