/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ ⏕c[ ]
 */

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include "xm7.h"
#include "device.h"
#include "tools.h"

/*
 *	uNfBXN쐬 Tu
 */
BOOL make_d77_sub(int fileh, DWORD dat)
{
	BYTE buf[4];

	buf[0] = (BYTE)(dat & 0xff);
	buf[1] = (BYTE)((dat >> 8) & 0xff);
	buf[2] = (BYTE)((dat >> 16) & 0xff);
	buf[3] = (BYTE)((dat >> 24) & 0xff);

	return file_write(fileh, buf, 4);
}

/*
 *	uNfBXN쐬
 */
BOOL make_new_d77(char *fname, char *name)
{
	int fileh;
	BYTE header[0x2b0];
	DWORD offset;
	int i;
	int j;

	/* assert */
	ASSERT(fname);

	/* t@CI[v */
	fileh = file_open(fname, OPEN_W);
	if (fileh == -1) {
		return FALSE;
	}

	/* wb_쐬 */
	memset(header, 0, sizeof(header));
	if (name != NULL) {
		for (i=0; i<16; i++) {
			if (name[i] == '\0') {
				break;
			}
			header[i] = name[i];
		}
	}
	else {
		strcpy(header, "Default");
	}

	/* wb_ */
	if (!file_write(fileh, header, 0x1c)) {
		file_close(fileh);
		return FALSE;
	}

	/* t@Cg[^TCY */
	offset = 0x073ab0;
	if (!make_d77_sub(fileh, offset)) {
		file_close(fileh);
		return FALSE;
	}

	/* gbNItZbg */
	offset = 0x2b0;
	for (i=0; i<84; i++) {
		if (!make_d77_sub(fileh, offset)) {
			file_close(fileh);
			return FALSE;
		}
		offset += 0x1600;
	}

	/* wb_ */
	if (!file_write(fileh, &header[0x170], 0x2b0 - 0x170)) {
		file_close(fileh);
		return FALSE;
	}

	/* kf[^ */
	memset(header, 0, sizeof(header));
	for (i=0; i<84; i++) {
		for (j=0; j<11; j++) {
			if (!file_write(fileh, header, 0x200)) {
				file_close(fileh);
				return FALSE;
			}
		}
	}

	/* ok */
	file_close(fileh);
	return TRUE;
}

/*
 *	uNe[v쐬
 */
BOOL make_new_t77(char *fname)
{
	int fileh;

	ASSERT(fname);

	/* t@CI[v */
	fileh = file_open(fname, OPEN_W);
	if (fileh == -1) {
		return FALSE;
	}

	/* wb_ */
	if (!file_write(fileh, "XM7 TAPE IMAGE 0", 16)) {
		file_close(fileh);
		return FALSE;
	}

	/*  */
	file_close(fileh);
	return TRUE;
}

/*
 *	VFDD77ϊ
 */
BOOL conv_vfd_to_d77(char *src, char *dst, char *name)
{
	int files;
	int filed;
	BYTE vfd_h[480];
	BYTE d77_h[0x2b0];
	BYTE *buffer;
	int trk;
	int sec;
	int secs;
	int len;
	int trklen;
	DWORD offset;
	DWORD srclen;
	DWORD wrlen;
	BYTE *header;
	BYTE *ptr;

	/* assert */
	ASSERT(src);
	ASSERT(dst);
	ASSERT(name);

	/* [Nm */
	buffer = (BYTE *)malloc(8192);
	if (buffer == NULL) {
		return FALSE;
	}

	/* VFDt@CI[v */
	files = file_open(src, OPEN_R);
	if (files == -1) {
		free(buffer);
		return FALSE;
	}

	/* ŁAt@CTCY擾Ă */
	srclen = file_getsize(files);

	/* VFDwb_ǂݍ */
	if (!file_read(files, vfd_h, sizeof(vfd_h))) {
		free(buffer);
		file_close(files);
		return FALSE;
	}

	/* D77t@C쐬 */
	filed = file_open(dst, OPEN_W);
	if (filed == -1) {
		free(buffer);
		file_close(files);
		return FALSE;
	}

	/* wb_쐬 */
	memset(d77_h, 0, sizeof(d77_h));
	if (strlen(name) <= 16) {
		strcpy(d77_h, name);
	}
	else {
		memcpy(d77_h, name, 16);
	}

	/* UAwb_ */
	if (!file_write(filed, d77_h, sizeof(d77_h))) {
		free(buffer);
		file_close(files);
		file_close(filed);
		return FALSE;
	}

	/* ݃|C^ */
	wrlen = sizeof(d77_h);

	/* gbN[v */
	header = vfd_h;
	for (trk=0; trk<80; trk++) {
		/* wb_擾 */
		offset = header[3];
		offset *= 256;
		offset |= header[2];
		offset *= 256;
		offset |= header[1];
		offset *= 256;
		offset |= header[0];
		header += 4;
		len = *header++;
		len &= 3;
		secs = *header++;

		/* secs=0ւ̑Ή */
		if (secs == 0) {
			continue;
		}
		else {
			/* ݃|C^L */
			d77_h[trk * 4 + 0x20 + 3] = (BYTE)(wrlen >> 24);
			d77_h[trk * 4 + 0x20 + 2] = (BYTE)((wrlen >> 16) & 255);
			d77_h[trk * 4 + 0x20 + 1] = (BYTE)((wrlen >> 8) & 255);
			d77_h[trk * 4 + 0x20 + 0] = (BYTE)(wrlen & 255);
		}

		/* gbNvZ */
		switch (len) {
			case 0:
				trklen = secs * (128 + 16);
				break;
			case 1:
				trklen = secs * (256 + 16);
				break;
			case 2:
				trklen = secs * (512 + 16);
				break;
			case 3:
				trklen = secs * (1024 + 16);
				break;
		}

		/* wb_ */
		if ((offset > srclen) | (trklen > 8192)) {
			free(buffer);
			file_close(files);
			file_close(filed);
			return FALSE;
		}

		/* V[N */
		if (!file_seek(files, offset)) {
			free(buffer);
			file_close(files);
			file_close(filed);
			return FALSE;
		}

		/* ZN^[v */
		ptr = buffer;
		for (sec=1; sec<=secs; sec++) {
			memset(ptr, 0, 0x10);
			/* C,H,R,N */
			ptr[0] = trk >> 1;
			ptr[1] = trk & 1;
			ptr[2] = (BYTE)sec;
			ptr[3] = len;
			/* ZN^ */
			ptr[4] = secs;
			/* ZN^f[^ǂݍ */
			switch (len) {
				case 0:
					ptr[0x0e] = 0x80;
					ptr += 0x10;
					file_read(files, ptr, 128);
					ptr += 128;
					break;
				case 1:
					ptr[0x0f] = 0x01;
					ptr += 0x10;
					file_read(files, ptr, 256);
					ptr += 256;
					break;
				case 2:
					ptr[0x0f] = 0x02;
					ptr += 0x10;
					file_read(files, ptr, 512);
					ptr += 512;
					break;
				case 3:
					ptr[0x0f] = 0x04;
					ptr += 0x10;
					file_read(files, ptr, 1024);
					ptr += 1024;
					break;
			}
		}

		/* ꊇ */
		if (!file_write(filed, buffer, trklen)) {
			free(buffer);
			file_close(files);
			file_close(filed);
			return FALSE;
		}

		/* ݃|C^i߂ */
		wrlen += trklen;
	}

	/* t@CTCYݒ */
	d77_h[0x1f] = (BYTE)((wrlen >> 24) & 0xff);
	d77_h[0x1e] = (BYTE)((wrlen >> 16) & 0xff);
	d77_h[0x1d] = (BYTE)((wrlen >> 8) & 0xff);
	d77_h[0x1c] = (BYTE)(wrlen & 0xff);

	/* ēxAwb_ */
	if (!file_seek(filed, 0)) {
		free(buffer);
		file_close(files);
		file_close(filed);
		return FALSE;
	}
	if (!file_write(filed, d77_h, sizeof(d77_h))) {
		free(buffer);
		file_close(files);
		file_close(filed);
		return FALSE;
	}

	/* ׂďI */
	free(buffer);
	file_close(files);
	file_close(filed);
	return TRUE;
}

/*
 *	2DD77ϊ
 */
BOOL conv_2d_to_d77(char *src, char *dst, char *name)
{
	int files;
	int filed;
	BYTE d77_h[0x2b0];
	BYTE *buffer;
	BYTE *ptr;
	DWORD offset;
	int trk;
	int sec;

	/* assert */
	ASSERT(src);
	ASSERT(dst);
	ASSERT(name);

	/* [Nm */
	buffer = (BYTE *)malloc(0x1100);
	if (buffer == NULL) {
		return FALSE;
	}

	/* 2Dt@CI[vAt@CTCY`FbN */
	files = file_open(src, OPEN_R);
	if (files == -1) {
		free(buffer);
		return FALSE;
	}
	if (file_getsize(files) != 327680) {
		file_close(files);
		free(buffer);
		return FALSE;
	}

	/* D77t@C쐬 */
	filed = file_open(dst, OPEN_W);
	if (filed == -1) {
		free(buffer);
		file_close(files);
		return FALSE;
	}

	/* wb_쐬 */
	memset(d77_h, 0, sizeof(d77_h));
	if (strlen(name) <= 16) {
		strcpy(d77_h, name);
	}
	else {
		memcpy(d77_h, name, 16);
	}

	/* t@CTCY */
	d77_h[0x1c] = 0xb0;
	d77_h[0x1d] = 0x52;
	d77_h[0x1e] = 0x05;

	/* gbNItZbg */
	offset = 0x2b0;
	for (trk=0; trk<80; trk++) {
		d77_h[0x20 + trk * 4 + 0] = (BYTE)(offset & 0xff);
		d77_h[0x20 + trk * 4 + 1] = (BYTE)((offset >> 8) & 0xff);
		d77_h[0x20 + trk * 4 + 2] = (BYTE)((offset >> 16) & 0xff);
		d77_h[0x20 + trk * 4 + 3] = (BYTE)((offset >> 24) & 0xff);
		offset += 0x1100;
	}

	/* wb_ */
	if (!file_write(filed, d77_h, sizeof(d77_h))) {
		free(buffer);
		file_close(files);
		file_close(filed);
		return FALSE;
	}

	/* gbN[v */
	for (trk=0; trk<80; trk++) {
		ptr = buffer;
		/* ZN^[v */
		for (sec=1; sec<=16; sec++) {
			memset(ptr, 0, 0x10);
			/* C,H,R,N */
			ptr[0] = trk >> 1;
			ptr[1] = trk & 1;
			ptr[2] = (BYTE)sec;
			ptr[3] = 1;

			/* ZN^AOX */
			ptr[4] = 16;
			ptr[0x0f] = 0x01;
			ptr += 0x10;

			/* f[^ǂݍ */
			file_read(files, ptr, 256);
			ptr += 256;
		}

		/* ꊇ */
		if (!file_write(filed, buffer, 0x1100)) {
			free(buffer);
			file_close(files);
			file_close(filed);
			return FALSE;
		}
	}

	/* ׂďI */
	free(buffer);
	file_close(files);
	file_close(filed);
	return TRUE;
}

/*
 *	VTPT77ϊ
 */
BOOL conv_vtp_to_t77(char *src, char *dst)
{
	int files;
	int filed;
	DWORD fsize;
	DWORD l;
	int i;
	BYTE buf[44];
	char *header = "XM7 TAPE IMAGE 0";
	BYTE dat;

	/* assert */
	ASSERT(src);
	ASSERT(dst);

	/* VTPt@CI[v */
	files = file_open(src, OPEN_R);
	if (files == -1) {
		return FALSE;
	}
	fsize = file_getsize(files);

	/* T77t@C쐬 */
	filed = file_open(dst, OPEN_W);
	if (filed == -1) {
		file_close(files);
		return FALSE;
	}

	/* wb_A}[J */
	if (!file_write(filed, header, 16)) {
		file_close(filed);
		file_close(files);
		return FALSE;
	}
	buf[0] = 0;
	buf[1] = 0;
	if (!file_write(filed, buf, 2)) {
		file_close(filed);
		file_close(files);
		return FALSE;
	}
	buf[0] = 0x7f;
	buf[1] = 0xff;
	if (!file_write(filed, buf, 2)) {
		file_close(filed);
		file_close(files);
		return FALSE;
	}

	/* X^[grbgݒ */
	buf[0] = 0x00;
	buf[1] = 0x34;
	buf[2] = 0x80;
	buf[3] = 0x1a;
	buf[4] = 0x00;
	buf[5] = 0x1a;

	/* Xgbvrbgݒ */
	buf[38] = 0x80;
	buf[39] = 0x2f;
	buf[40] = 0x00;
	buf[41] = 0x37;
	buf[42] = 0x80;
	buf[43] = 0x2f;

	/* oCg[v */
	for (l=0; l<fsize; l++) {
		/* f[^ǂݍ */
		if (!file_read(files, &dat, 1)) {
			file_close(filed);
			file_close(files);
			return FALSE;
		}

		/* 8rbg */
		for (i=0; i<8; i++) {
			if (dat & 0x80) {
				buf[i * 4 + 6 + 0] = 0x80;
				buf[i * 4 + 6 + 1] = 0x18;
				buf[i * 4 + 6 + 2] = 0x00;
				buf[i * 4 + 6 + 3] = 0x1a;
			}
			else {
				buf[i * 4 + 6 + 0] = 0x80;
				buf[i * 4 + 6 + 1] = 0x30;
				buf[i * 4 + 6 + 2] = 0x00;
				buf[i * 4 + 6 + 3] = 0x30;
			}
			dat <<= 1;
		}

		/* 44oCgɊg債ď */
		if (!file_write(filed, buf, 44)) {
			file_close(filed);
			file_close(files);
			return FALSE;
		}
	}

	/* ׂďI */
	file_close(files);
	file_close(filed);
	return TRUE;
}
