/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ JZbge[vv^ ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "tapelp.h"
#include "mainetc.h"
#include "device.h"

/*
 *	O[o [N
 */
BOOL tape_in;							/* e[v ̓f[^ */
BOOL tape_out;							/* e[v o̓f[^ */
BOOL tape_motor;						/* e[v [^ */
BOOL tape_rec;							/* e[v RECtO */
BOOL tape_writep;						/* e[v ݋֎~ */
WORD tape_count;						/* e[v TCNJE^ */
BYTE tape_subcnt;						/* e[v TuJE^ */
int tape_fileh;							/* e[v t@Cnh */
DWORD tape_offset;						/* e[v t@CItZbg */
char tape_fname[128+1];					/* e[v t@Cl[ */

WORD tape_incnt;						/* e[v ǂݍ݃JE^ */
DWORD tape_fsize;						/* e[v t@CTCY */

BYTE lp_data;							/* v^ o̓f[^ */
BOOL lp_busy;							/* v^ BUSYtO */
BOOL lp_error;							/* v^ G[tO */
BOOL lp_pe;								/* v^ PEtO */
BOOL lp_ackng;							/* v^ ACKtO */
BOOL lp_online;							/* v^ IC */
BOOL lp_strobe;							/* v^ Xg[u */
int lp_fileh;							/* v^ t@Cnh */

char lp_fname[128+1];					/* v^ t@Cl[ */

/*
 *	JZbge[vv^
 *	
 */
BOOL tapelp_init(void)
{
	/* e[v */
	tape_fileh = -1;
	tape_fname[0] = '\0';
	tape_offset = 0;
	tape_fsize = 0;
	tape_writep = FALSE;

	/* v^ */
	lp_fileh = -1;
	lp_fname[0] = '\0';

	return TRUE;
}

/*
 *	JZbge[vv^
 *	N[Abv
 */
void tapelp_cleanup(void)
{
	/* t@CJĂ΁A */
	if (tape_fileh != -1) {
		file_close(tape_fileh);
		tape_fileh = -1;
	}

	/* [^OFF */
	tape_motor = FALSE;

	/* t@CJĂ΁A */
	if (lp_fileh != -1) {
		file_close(lp_fileh);
		lp_fileh = -1;
	}
}

/*
 *	JZbge[vv^
 *	Zbg
 */
void tapelp_reset(void)
{
	tape_motor = FALSE;
	tape_rec = FALSE;
	tape_count = 0;
	tape_in = FALSE;
	tape_out = FALSE;
	tape_incnt = 0;
	tape_subcnt = 0;

	lp_busy = FALSE;
	lp_error = FALSE;
	lp_ackng = TRUE;
	lp_pe = FALSE;
	lp_online = FALSE;
	lp_strobe = FALSE;
}

/*-[ v^ ]-------------------------------------------------------------*/

/*
 *	v^
 *	f[^o
 */
static void lp_output(BYTE dat)
{
	/* I[vĂȂ΁CJ */
	if (lp_fileh == -1) {
		if (lp_fname[0] != '\0') {
			lp_fileh = file_open(lp_fname, OPEN_W);
		}
	}

	/* I[v`FbN */
	if (lp_fileh == -1) {
		return;
	}

	/* Ayh */
	file_write(lp_fileh, &dat, 1);
}

/*
 *	v^
 *	t@Cݒ
 */
void lp_setfile(char *fname)
{
	/* xJĂ΁A */
	if (lp_fileh != -1) {
		file_close(lp_fileh);
		lp_fileh = -1;
	}

	/* t@CZbg */
	if (fname == NULL) {
		lp_fname[0] = '\0';
		return;
	}

	if (strlen(fname) < sizeof(lp_fname)) {
		strcpy(lp_fname, fname);
	}
	else {
		lp_fname[0] = '\0';
	}
}

/*-[ e[v ]---------------------------------------------------------------*/

/*
 *	e[v
 *	f[^
 */
static void tape_input(void)
{
	BYTE high;
	BYTE low;
	WORD dat;

	/* [^Ă邩 */
	if (tape_motor == FALSE) {
		return;
	}

	/* ^ĂΓ͂łȂ */
	if (tape_rec) {
		return;
	}

	/* VOJE^̓JE^zĂ΁A0ɂ */
	while (tape_count >= tape_incnt) {
		tape_count -= tape_incnt;
		tape_incnt = 0;

		/* f[^tFb` */
		tape_in = FALSE;

		if (tape_fileh == -1) {
			return;
		}

		if (tape_offset >= tape_fsize) {
			return;
		}

		if (!file_read(tape_fileh, &high, 1)) {
			return;
		}
		if (!file_read(tape_fileh, &low, 1)) {
			return;
		}

		/* ItZbgXV */
		tape_offset += 2;

		/* f[^AJE^ݒ */
		dat = high * 256 + low;
		if (dat > 0x7fff) {
			tape_in = TRUE;
		}
		tape_incnt = dat & 0x7fff;

		/* JE^J肷 */
		if (tape_count > tape_incnt) {
			tape_count -= tape_incnt;
			tape_incnt = 0;
		}
		else {
			tape_incnt -= tape_count;
			tape_count = 0;
		}
	}
}

/*
 *	e[v
 *	f[^o
 */
static void tape_output(BOOL flag)
{
	WORD dat;
	BYTE high, low;

	/* e[vĂ邩 */
	if (tape_motor == FALSE) {
		return;
	}

	/* ^ */
	if (tape_rec == FALSE) {
		return;
	}

	/* JE^Ă邩 */
	if (tape_count == 0) {
		return;
	}

	/* ݉\ */
	if (tape_writep) {
		return;
	}

	/* t@CI[vĂ΁Af[^ */
	dat = tape_count;
	if (dat >= 0x8000) {
		dat = 0x7fff;
	}
	if (flag) {
		dat |= 0x8000;
	}
	high = dat >> 8;
	low = dat & 0xff;
	if (tape_fileh != -1) {
		if (file_write(tape_fileh, &high, 1)) {
			if (file_write(tape_fileh, &low, 1)) {
				tape_offset += 2;
				if (tape_offset >= tape_fsize) {
					tape_fsize = tape_offset;
				}
			}
		}
	}

	/* JE^Zbg */
	tape_count = 0;
	tape_subcnt = 0;
}

/*
 *	e[v
 *	}[Jo
 */
static void tape_mark(void)
{
	BYTE dat;

	/* e[vĂ邩 */
	if (tape_motor == FALSE) {
		return;
	}

	/* ^ */
	if (tape_rec == FALSE) {
		return;
	}

	/* ݉\ */
	if (tape_writep) {
		return;
	}

	/* t@CI[vĂ΁Af[^ */
	if (tape_fileh != -1) {
		dat = 0;
		if (file_write(tape_fileh, &dat, 1)) {
			if (file_write(tape_fileh, &dat, 1)) {
				tape_offset += 2;
				if (tape_offset >= tape_fsize) {
					tape_fsize = tape_offset;
				}
			}
		}
	}
}

/*
 *	e[v
 *	߂
 */
void tape_rew(void)
{
	WORD dat;

	/*  */
	if (tape_fileh == -1) {
		return;
	}

	/* assert */
	ASSERT(tape_fsize >= 16);
	ASSERT(tape_offset >= 16);
	ASSERT(!(tape_fsize & 0x01));
	ASSERT(!(tape_offset & 0x01));

	while (tape_offset > 16) {
		/* QoCgOɖ߂Aǂݍ */
		tape_offset -= 2;
		if (!file_seek(tape_fileh, tape_offset)) {
			return;
		}
		file_read(tape_fileh, (BYTE *)&dat, 2);

		/* $0000ȂAɐݒ */
		if (dat == 0) {
			file_seek(tape_fileh, tape_offset);
			return;
		}

		/* ܓǂݍ񂾕߂ */
		if (!file_seek(tape_fileh, tape_offset)) {
			return;
		}
	}
}

/*
 *	e[v
 *	
 */
void tape_ff(void)
{
	WORD dat;

	/*  */
	if (tape_fileh == -1) {
		return;
	}

	/* assert */
	ASSERT(tape_fsize >= 16);
	ASSERT(tape_offset >= 16);
	ASSERT(!(tape_fsize & 0x01));
	ASSERT(!(tape_offset & 0x01));

	while (tape_offset < tape_fsize) {
		/* ֐i߂ */
		tape_offset += 2;
		if (tape_offset >= tape_fsize){
			return;
		}
		if (!file_seek(tape_fileh, tape_offset)) {
			return;
		}
		file_read(tape_fileh, (BYTE *)&dat, 2);

		/* $0000ȂA̎ɐݒ */
		if (dat == 0) {
			tape_offset += 2;
			if (tape_offset >= tape_fsize) {
				tape_fsize = tape_offset;
			}
			return;
		}
	}
}

/*
 *	e[v
 *	t@Cݒ
 */
void tape_setfile(char *fname)
{
	char *header = "XM7 TAPE IMAGE 0";
	char buf[17];

	/* xJĂ΁A */
	if (tape_fileh != -1) {
		file_close(tape_fileh);
		tape_fileh = -1;
		tape_writep = FALSE;
	}

	/* t@CZbg */
	if (fname == NULL) {
		tape_fname[0] = '\0';
	}
	else {
		if (strlen(fname) < sizeof(tape_fname)) {
			strcpy(tape_fname, fname);
		}
		else {
			tape_fname[0] = '\0';
		}
	}

	/* t@CI[v݂ */
	if (tape_fname[0] != '\0') {
		tape_fileh = file_open(tape_fname, OPEN_RW);
		if (tape_fileh != -1) {
			tape_writep = FALSE;
		}
		else {
			tape_fileh = file_open(tape_fname, OPEN_R);
			tape_writep = TRUE;
		}
	}

	/* JĂ΁Awb_ǂݍ݃`FbN */
	if (tape_fileh != -1) {
		memset(buf, 0, sizeof(buf));
		file_read(tape_fileh, buf, 16);
		if (strcmp(buf, header) != 0) {
			file_close(tape_fileh);
			tape_fileh = -1;
			tape_writep = FALSE;
		}
	}

	/* tȌ */
	tape_setrec(FALSE);
	tape_count = 0;
	tape_incnt = 0;
	tape_subcnt = 0;

	/* t@CJĂ΁At@CTCYAItZbg */
	if (tape_fileh != -1) {
		tape_fsize = file_getsize(tape_fileh);
		tape_offset = 16;
	}
}

/*
 *	e[v
 *	^tOݒ
 */
void tape_setrec(BOOL flag)
{
	/* [^Ă΁A}[J */
	if (tape_motor && !tape_rec) {
		if (flag == TRUE) {
			tape_rec = TRUE;
			tape_mark();
			return;
		}
	}

	tape_rec = flag;
}

/*-[ R/W ]------------------------------------------------------------*/

/*
 *	JZbge[vv^
 *	PoCgǂݏo
 */
BOOL tapelp_readb(WORD addr, BYTE *dat)
{
	BYTE ret;

	/* AhX`FbN */
	if (addr != 0xfd02) {
		return FALSE;
	}

	/* v^ Xe[^X쐬 */
	ret = 0x30;
#if 0
	if (lp_busy) {
		ret |= 0x01;
	}
	if (!lp_error) {
		ret |= 0x02;
	}
	if (!lp_ackng) {
		ret |= 0x04;
	}
	if (lp_pe) {
		ret |= 0x08;
	}
#else
	ret |= 0x0f;
#endif

	/* JZbg f[^쐬 */
	tape_input();
	if (tape_in) {
		ret |= 0x80;
	}

	/*  */
	*dat = ret;
	return TRUE;
}

/*
 *	JZbge[vv^
 *	PoCg
 */
BOOL tapelp_writeb(WORD addr, BYTE dat)
{
	switch (addr) {
		/* JZbgAv^ */
		case 0xfd00:
			/* v^ IC */
			if (dat & 0x80) {
				lp_online = FALSE;
			}
			else {
				lp_online = TRUE;
			}

			/* v^ Xg[u */
			if (dat & 0x40) {
				lp_strobe = TRUE;
			}
			else {
				if (lp_strobe && lp_online) {
					lp_output(lp_data);
					mainetc_lp();
				}
				lp_strobe = FALSE;
			}

			/* e[v o̓f[^ */
			if (dat & 0x01) {
				if (!tape_out) {
					tape_output(FALSE);
				}
				tape_out = TRUE;
			}
			else {
				if (tape_out) {
					tape_output(TRUE);
				}
				tape_out = FALSE;
			}

			/* e[v [^ */
			if (dat & 0x02) {
				if (tape_motor == FALSE) {
					/* VKX^[g */
					tape_count = 0;
					tape_subcnt = 0;
					tape_motor = TRUE;
					if (tape_rec == TRUE) {
						tape_mark();
					}
				}
			}
			else {
				/* [^~ */
				tape_motor = FALSE;
			}

			return TRUE;

		/* v^o̓f[^ */
		case 0xfd01:
			lp_data = dat;
			return TRUE;
	}

	return FALSE;
}

/*
 *	JZbge[vv^
 *	Z[u
 */
BOOL tapelp_save(int fileh)
{
	BOOL tmp;

	if (!file_bool_write(fileh, tape_in)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, tape_out)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, tape_motor)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, tape_rec)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, tape_writep)) {
		return FALSE;
	}
	if (!file_word_write(fileh, tape_count)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, tape_subcnt)) {
		return FALSE;
	}

	if (!file_dword_write(fileh, tape_offset)) {
		return FALSE;
	}
	if (!file_write(fileh, tape_fname, 128 + 1)) {
		return FALSE;
	}
	tmp = (tape_fileh != -1);
	if (!file_bool_write(fileh, tmp)) {
		return FALSE;
	}

	if (!file_word_write(fileh, tape_incnt)) {
		return FALSE;
	}
	if (!file_dword_write(fileh, tape_fsize)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, lp_data)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_busy)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_error)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_pe)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_ackng)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_online)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_strobe)) {
		return FALSE;
	}

	if (!file_write(fileh, lp_fname, 128 + 1)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	JZbge[vv^
 *	[h
 */
BOOL tapelp_load(int fileh, int ver)
{
	DWORD offset;
	char fname[128 + 1];
	BOOL flag;

	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &tape_in)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &tape_out)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &tape_motor)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &tape_rec)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &tape_writep)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &tape_count)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &tape_subcnt)) {
		return FALSE;
	}

	if (!file_dword_read(fileh, &offset)) {
		return FALSE;
	}
	if (!file_read(fileh, fname, 128 + 1)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &flag)) {
		return FALSE;
	}

	/* }Eg */
	tape_setfile(NULL);
	if (flag) {
		tape_setfile(fname);
		if ((tape_fileh != -1) && ((tape_fsize +1 ) >= tape_offset)) {
			file_seek(tape_fileh, offset);
		}
	}

	if (!file_word_read(fileh, &tape_incnt)) {
		return FALSE;
	}
	/* tape_fsize͖ */
	if (!file_dword_read(fileh, &offset)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &lp_data)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_busy)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_error)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_pe)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_ackng)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_online)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_strobe)) {
		return FALSE;
	}

	if (!file_read(fileh, lp_fname, 128 + 1)) {
		return FALSE;
	}

	return TRUE;
}
