/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ VXeǗ ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "display.h"
#include "ttlpalet.h"
#include "subctrl.h"
#include "keyboard.h"
#include "fdc.h"
#include "mainetc.h"
#include "multipag.h"
#include "kanji.h"
#include "gui.h"
#include "tapelp.h"
#include "display.h"
#include "opn.h"
#include "device.h"

/*
 *	O[o [N
 */
int fm7_ver;							/* n[hEFAo[W */
int boot_mode;							/* N[h BASIC/DOS */
WORD cpu_speed;							/* CPUXs[h */

/*
 *	VXe
 *	
 */
BOOL system_init(void)
{
	/* [hݒ */
	fm7_ver = 1;					/* FM-7ɐݒ */
	boot_mode = BOOT_BASIC;			/* BASIC MODE */
	cpu_speed = 0x4580;				/* 2MHz */

	if (!mainmem_init()) {
		return FALSE;
	}
	if (!submem_init()) {
		return FALSE;
	}
	if (!maincpu_init()) {
		return FALSE;
	}
	if (!subcpu_init()) {
		return FALSE;
	}
	if (!debug_init()) {
		return FALSE;
	}
	if (!display_init()) {
		return FALSE;
	}
	if (!ttlpalet_init()) {
		return FALSE;
	}
	if (!subctrl_init()) {
		return FALSE;
	}
	if (!keyboard_init()) {
		return FALSE;
	}
	if (!fdc_init()) {
		return FALSE;
	}
	if (!mainetc_init()) {
		return FALSE;
	}
	if (!multipag_init()) {
		return FALSE;
	}
	if (!kanji_init()) {
		return FALSE;
	}
	if (!tapelp_init()) {
		return FALSE;
	}
	if (!opn_init()) {
		return FALSE;
	}
	if (!gui_init()) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	VXe
 *	N[Abv
 */
void system_cleanup(void)
{
	gui_cleanup();
	opn_cleanup();
	tapelp_cleanup();
	kanji_cleanup();
	multipag_cleanup();
	mainetc_cleanup();
	fdc_cleanup();
	keyboard_cleanup();
	subctrl_cleanup();
	ttlpalet_cleanup();
	display_cleanup();
	debug_cleanup();
	subcpu_cleanup();
	maincpu_cleanup();
	submem_cleanup();
	mainmem_cleanup();
}

/*
 *	VXe
 *	Zbg
 */
void system_reset(void)
{
	mainmem_reset();
	submem_reset();
	maincpu_reset();
	subcpu_reset();
	debug_reset();
	display_reset();
	ttlpalet_reset();
	subctrl_reset();
	keyboard_reset();
	fdc_reset();
	mainetc_reset();
	multipag_reset();
	kanji_reset();
	tapelp_reset();
	opn_reset();
	gui_reset();
}

/*
 *	VXe
 *	t@CZ[u
 */
BOOL system_save(char *filename)
{
	int fileh;
	char *header = "XM7 VM STATE   1";
	BOOL flag;
	ASSERT(filename);

	/* t@CI[v */
	fileh = file_open(filename, OPEN_W);
	if (fileh == -1) {
		return FALSE;
	}

	/* tO */
	flag = TRUE;

	/* wb_Z[u */
	if (!file_write(fileh, header, 16)) {
		flag = FALSE;
	}

	/* ԂɌĂяo */
	if (!mainmem_save(fileh)) {
		flag = FALSE;
	}
	if (!submem_save(fileh)) {
		flag = FALSE;
	}
	if (!maincpu_save(fileh)) {
		flag = FALSE;
	}
	if (!subcpu_save(fileh)) {
		flag = FALSE;
	}
	if (!debug_save(fileh)) {
		flag = FALSE;
	}
	if (!display_save(fileh)) {
		flag = FALSE;
	}
	if (!ttlpalet_save(fileh)) {
		flag = FALSE;
	}
	if (!subctrl_save(fileh)) {
		flag = FALSE;
	}
	if (!keyboard_save(fileh)) {
		flag = FALSE;
	}
	if (!fdc_save(fileh)) {
		flag = FALSE;
	}
	if (!mainetc_save(fileh)) {
		flag = FALSE;
	}
	if (!multipag_save(fileh)) {
		flag = FALSE;
	}
	if (!kanji_save(fileh)) {
		flag = FALSE;
	}
	if (!tapelp_save(fileh)) {
		flag = FALSE;
	}
	if (!opn_save(fileh)) {
		flag = FALSE;
	}
	if (!gui_save(fileh)) {
		flag = FALSE;
	}

	file_close(fileh);
	return flag;
}

/*
 *	VXe
 *	t@C[h
 */
BOOL system_load(char *filename)
{
	int fileh;
	int ver;
	char header[16];
	BOOL flag;
	ASSERT(filename);

	/* t@CI[v */
	fileh = file_open(filename, OPEN_R);
	if (fileh == -1) {
		return FALSE;
	}

	/* tO */
	flag = TRUE;

	/* wb_[h */
	if (!file_read(fileh, header, 16)) {
		flag = FALSE;
	}
	else {
		if (memcmp(header, "XM7 VM STATE   ", 15) != 0) {
			flag = FALSE;
		}
	}

	/* t@Co[W0(V1.0L10), 1(V1.0L20)T|[g */
	ver = header[15];
	ver -= 0x30;
	if ((ver != 0) && (ver != 1)) {
		flag = FALSE;
	}
	if (!flag) {
		file_close(fileh);
		return FALSE;
	}

	/* ԂɌĂяo */
	if (!mainmem_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!submem_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!maincpu_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!subcpu_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!debug_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!display_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!ttlpalet_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!subctrl_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!keyboard_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!fdc_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!mainetc_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!multipag_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!kanji_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!tapelp_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!opn_load(fileh, ver)) {
		flag = FALSE;
	}
	if (!gui_load(fileh, ver)) {
		flag = FALSE;
	}

	file_close(fileh);
	return flag;
}

/*
 *	t@Cǂݍ(BYTE)
 */
BOOL file_byte_read(int fileh, BYTE *dat)
{
	return file_read(fileh, dat, 1);
}

/*
 *	t@Cǂݍ(WORD)
 */
BOOL file_word_read(int fileh, WORD *dat)
{
	BYTE tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat = tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat *= 256;
	*dat |= tmp;

	return TRUE;
}

/*
 *	t@Cǂݍ(DWORD)
 */
BOOL file_dword_read(int fileh, DWORD *dat)
{
	BYTE tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat = tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat *= 256;
	*dat |= tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat *= 256;
	*dat |= tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}
	*dat *= 256;
	*dat |= tmp;

	return TRUE;
}

/*
 *	t@Cǂݍ(BOOL)
 */
BOOL file_bool_read(int fileh, BOOL *dat)
{
	BYTE tmp;

	if (!file_read(fileh, &tmp, 1)) {
		return FALSE;
	}

	switch (tmp) {
		case 0:
			*dat = FALSE;
			return TRUE;
		case 0xff:
			*dat = TRUE;
			return TRUE;
	}

	return FALSE;
}

/*
 *	t@C(BYTE)
 */
BOOL file_byte_write(int fileh, BYTE dat)
{
	return file_write(fileh, &dat, 1);
}

/*
 *	t@C(WORD)
 */
BOOL file_word_write(int fileh, WORD dat)
{
	BYTE tmp;

	tmp = (BYTE)(dat >> 8);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	tmp = (BYTE)(dat & 0xff);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@C(DWORD)
 */
BOOL file_dword_write(int fileh, DWORD dat)
{
	BYTE tmp;

	tmp = (BYTE)(dat >> 24);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	tmp = (BYTE)(dat >> 16);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	tmp = (BYTE)(dat >> 8);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	tmp = (BYTE)(dat & 0xff);
	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@C(BOOL)
 */
BOOL file_bool_write(int fileh, BOOL dat)
{
	BYTE tmp;

	if (dat) {
		tmp = 0xff;
	}
	else {
		tmp = 0;
	}

	if (!file_write(fileh, &tmp, 1)) {
		return FALSE;
	}

	return TRUE;
}
