/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ TuCPU ]
 */

#include <assert.h>
#include "xm7.h"
#include "subctrl.h"
#include "mainetc.h"
#include "gui.h"
#include "device.h"

/*
 *	O[o [N
 */
cpu6809_t subcpu;

/*
 *	vg^Cv錾
 */
#ifdef CPU_ASM
void sub_reset(void);
void sub_line(void);
void sub_exec(void);
#else
static void cpu_reset(void);
static void cpu_execline(void);
static void cpu_exec(void);
#endif

/*
 *	TuCPU
 *	
 */
BOOL subcpu_init(void)
{
	subcpu.readmem = (DWORD)submem_readb;
	subcpu.writemem = (DWORD)submem_writeb;

	return TRUE;
}

/*
 *	TuCPU
 *	N[Abv
 */
void subcpu_cleanup(void)
{
	return;
}

/*
 *	TuCPU
 *	Zbg
 */
void subcpu_reset(void)
{
#ifdef	CPU_ASM
	sub_reset();
#else
	cpu_reset();
#endif
}

/*
 *	TuCPU
 *	Pss
 */
void subcpu_execline(void)
{
#ifdef CPU_ASM
	sub_line();
#else
	cpu_execline();
#endif
}

/*
 *	TuCPU
 *	s
 */
void subcpu_exec(void)
{
#ifdef CPU_ASM
	sub_exec();
#else
	cpu_exec();
#endif
}

/*
 *	TuCPU
 *	NMI荞ݐݒ
 */
void subcpu_nmi(void)
{
	/* vbgtH[ʃ^C}nh璼ڌĂ΂ */
	if (!gui_flag && run_flag) {
		if (subcpu.intr & INTR_SLOAD){
			subcpu.intr |= INTR_NMI;
			if (subfast_flag > 0) {
				subfast_flag = 1;
			}
		}
	}
}

/*
 *	TuCPU
 *	FIRQ荞ݐݒ
 */
void subcpu_firq(void)
{
	if (!key_irq_mask) {
		/* CCPUɂȂĂꍇ́A荞݂Ȃ */
		subcpu.intr &= ~INTR_FIRQ;
	}
	else {
		/* L[荞݂̗Lŕ */
		if (key_irq_flag) {
			subcpu.intr |= INTR_FIRQ;
			if (subfast_flag > 0) {
				subfast_flag = 1;
			}
		}
		else {
			subcpu.intr &= ~INTR_FIRQ;
		}
	}
}

/*
 *	TuCPU
 *	IRQ荞ݐݒ
 */
void subcpu_irq(void)
{
	/* LZIRQ */
	if (subcancel_flag) {
		subcpu.intr |= INTR_IRQ;
		if (subfast_flag > 0) {
			subfast_flag = 1;
		}
	}
	else {
		subcpu.intr &= ~INTR_IRQ;
	}
}

/*
 *	TuCPU
 *	Z[u
 */
BOOL subcpu_save(int fileh)
{
	/* vbgtH[Ƃ̃pbLO邽߁A */
	if (!file_byte_write(fileh, subcpu.cc)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, subcpu.dp)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.acc.d)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.x)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.y)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.u)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.s)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.pc)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.intr)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.cycle)) {
		return FALSE;
	}

	if (!file_word_write(fileh, subcpu.total)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	TuCPU
 *	[h
 */
BOOL subcpu_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	/* vbgtH[Ƃ̃pbLO邽߁A */
	if (!file_byte_read(fileh, &subcpu.cc)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &subcpu.dp)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.acc.d)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.x)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.y)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.u)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.s)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.pc)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.intr)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.cycle)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &subcpu.total)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	C6809RA
 */
#ifndef CPU_ASM

#define CCREG			subcpu.cc
#define AREG			subcpu.acc.h.a
#define BREG			subcpu.acc.h.b
#define DREG			subcpu.acc.d
#define DPREG			subcpu.dp
#define XREG			subcpu.x
#define YREG			subcpu.y
#define UREG			subcpu.u
#define SREG			subcpu.s
#define PCREG			subcpu.pc
#define INTR			subcpu.intr
#define CYCLE			subcpu.cycle
#define TOTAL			subcpu.total

#define READB(addr)		submem_readb((WORD)(addr))
#define READW(addr)		((submem_readb((WORD)(addr)) << 8) | submem_readb((WORD)((addr) + 1)))
#define WRITEB(addr,b)	submem_writeb((WORD)(addr), (BYTE)(b))
#define WRITEW(addr,w)	{submem_writeb((WORD)(addr), (BYTE)((w) >> 8)); submem_writeb((WORD)((addr) + 1), (BYTE)((w) & 0xff));}

#include "cpu.c"

#endif
