/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ CCPUeI/O ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "mainetc.h"
#include "gui.h"
#include "keyboard.h"
#include "opn.h"
#include "device.h"

/*
 *	O[o [N
 */
BOOL key_irq_flag;					/* L[{[h荞 v */
BOOL key_irq_mask;					/* L[{[h荞 }XN */
BOOL lp_irq_flag;					/* v^荞 v */
BOOL lp_irq_mask;					/* v^荞 }XN */
BOOL timer_irq_flag;				/* ^C}[荞 v */
BOOL timer_irq_mask;				/* ^C}[荞 }XN */

BOOL mfd_irq_flag;					/* FDC荞 tO */
BOOL mfd_irq_mask;					/* FDC荞 }XN */
BOOL txrdy_irq_flag;				/* TxRDY荞 tO */
BOOL txrdy_irq_mask;				/* TxRDY荞 }XN */
BOOL rxrdy_irq_flag;				/* RxRDY荞 tO */
BOOL rxrdy_irq_mask;				/* RxRDY荞 }XN */
BOOL syndet_irq_flag;				/* SYNDET荞 tO */
BOOL syndet_irq_mask;				/* SYNDET荞 }XN */
BOOL opn_irq_flag;					/* OPN荞 tO */
BOOL opn_irq_mask;					/* OPN荞 }XN */

BYTE timer_irq_count;				/* C^[o^C} JE^ */
BYTE timer_irq_mod;					/* C^[o^C} MOD */ 

BYTE beep_count;					/* BEEPJE^ */
BOOL beep_flag;						/* BEEPtO */
BOOL speaker_flag;					/* Xs[JtO */

/*
 *	CCPU I/O
 *	
 */
BOOL mainetc_init(void)
{
	return TRUE;
}

/*
 *	CCPU I/O
 *	N[Abv
 */
void mainetc_cleanup(void)
{
}

/*
 *	CCPU I/O
 *	Zbg
 */
void mainetc_reset(void)
{
	key_irq_flag = FALSE;
	key_irq_mask = TRUE;
	lp_irq_flag = FALSE;
	lp_irq_mask = TRUE;
	timer_irq_flag = FALSE;
	timer_irq_mask = TRUE;

	mfd_irq_flag = FALSE;
	mfd_irq_mask = TRUE;
	txrdy_irq_flag = FALSE;
	txrdy_irq_mask = TRUE;
	rxrdy_irq_flag = FALSE;
	rxrdy_irq_mask = TRUE;
	syndet_irq_flag = FALSE;
	syndet_irq_mask = TRUE;
	opn_irq_flag = FALSE;
	opn_irq_mask = FALSE;

	timer_irq_count = 0;
	timer_irq_mod = 0;

	beep_count = 0;
	beep_flag = FALSE;

	/* BASIC[hł΁ABASIC ROMCl[u */
	if (boot_mode == BOOT_BASIC) {
		basicrom_en = TRUE;
	}
	else {
		basicrom_en = FALSE;
	}
}


/*
 *	^C}[荞
 *	(10msĂ΂)
 */
void mainetc_timer(void)
{
	/* słȂ΁AȂ */
	if (!run_flag) {
		return;
	}

	/* L[{[h s[g^C}[ */
	keyboard_timer();

	/* BEEP */
	if (beep_count > 0) {
		beep_count--;
		if (beep_count == 0) {
			beep_flag = FALSE;
		}
	}

	/* GUIj[ȂAGUI^C}[sI */
	if (gui_flag) {
		gui_timer();
		return;
	}

	/* fobK CPUx^C}[ */
	debug_timer();

	/* OPN^C}[ */
	opn_timer();

	/* }XNĂ΁A荞݂Ƃ߂ */
	/* ΍ */
	if (timer_irq_mask) {
		timer_irq_flag = FALSE;
		timer_irq_count = 0;
		maincpu_irq();
		return;
	}

	/* 400ms197񊄂荞݂oB2.03ms/ */
	if ((timer_irq_mod % 10) == 0) {
		if (timer_irq_mod == 40) {
			timer_irq_count = 5;
			timer_irq_mod = 0;
		}
		else {
			timer_irq_count = 4;
			timer_irq_mod++;
		}
	}
	else {
		timer_irq_count = 5;
		timer_irq_mod++;
	}

	/* CCPUIRQ荞݂ */
	timer_irq_flag = TRUE;

	/*  */
	maincpu_irq();
}

/*
 *	FDC荞
 *	(fdc.cR}hEُIAtH[XC^vgŌĂ΂)
 */
void mainetc_fdc(void)
{
	/* }XNĂ΁AȂ */
	if (mfd_irq_mask) {
		return;
	}

	/* CCPUIRQ荞݂ */
	mfd_irq_flag = TRUE;

	/*  */
	maincpu_irq();
}

/*
 *	LP荞
 *	(tapelp.cv^f[^o͎ɌĂ΂)
 */
void mainetc_lp(void)
{
	/* }XNĂ΁AȂ */
	if (lp_irq_mask) {
		return;
	}

	/* CCPUIRQ荞݂ */
	lp_irq_flag = TRUE;

	/*  */
	maincpu_irq();
}

/*
 *	OPN荞
 *	(opn.c^C}I[o[t[ŌĂ΂)
 */
void mainetc_opn(void)
{
	/* }XNĂ΁AȂ */
	if (opn_irq_mask) {
		return;
	}

	/* CCPUIRQ荞݂ */
	opn_irq_flag = TRUE;

	/*  */
	maincpu_irq();
}

/*
 *	CCPU I/O
 *	PoCgǂݏo
 */
BOOL mainetc_readb(WORD addr, BYTE *dat)
{
	BYTE ret;

	switch (addr) {
		/* L[{[h  */
		case 0xfd00:
			if (key_fm7 & 0x0100) {
				*dat = 0xff;
			}
			else {
				*dat = 0x7f;
			}
			return TRUE;

		/* L[{[h  */
		case 0xfd01:
			*dat = (BYTE)(key_fm7 & 0xff);
			key_irq_flag = FALSE;
			maincpu_irq();
			subcpu_firq();
			return TRUE;

		/* IRQv */
		case 0xfd03:
			ret = 0xff;
			if ((key_irq_flag) && !(key_irq_mask)) {
				ret &= ~0x01;
			}
			if (lp_irq_flag) {
				lp_irq_flag = FALSE;
				ret &= ~0x02;
			}
			if (timer_irq_flag) {
				timer_irq_flag = FALSE;
				ret &= ~0x04;

				/* JEg`FbNAAĊ荞݂ */
				ASSERT(timer_irq_count);
				timer_irq_count--;
				if (timer_irq_count) {
					if (!timer_irq_mask) {
						/* ̎}XNԂȂ犄荞݃Jbg */
						/* oOtBbNXy ΍ */
						timer_irq_flag = TRUE;
					}
				}
			}
			if (mfd_irq_flag ||
				txrdy_irq_flag ||
				rxrdy_irq_flag ||
				syndet_irq_flag ||
				opn_irq_flag) {
				ret &= ~0x08;
			}

			/* ʂ */
			*dat = ret;
			maincpu_irq();
			return TRUE;

		/* BASIC ROM */
		case 0xfd0f:
			basicrom_en = TRUE;
			*dat = 0xff;
			return TRUE;

	}

	return FALSE;
}

/*
 *	CCPU I/O
 *	PoCg
 */
BOOL mainetc_writeb(WORD addr, BYTE dat)
{
	switch (addr) {
		/* 荞݃}XN */
		case 0xfd02:
			if (dat & 0x80) {
				syndet_irq_mask = FALSE;
			}
			else {
				syndet_irq_mask = TRUE;
			}
			if (dat & 0x40) {
				rxrdy_irq_mask = FALSE;
			}
			else {
				rxrdy_irq_mask = TRUE;
			}
			if (dat & 0x20) {
				txrdy_irq_mask = FALSE;
			}
			else {
				txrdy_irq_mask = TRUE;
			}
			if (dat & 0x10) {
				mfd_irq_mask = FALSE;
			}
			else {
				mfd_irq_mask = TRUE;
			}
			if (dat & 0x04) {
				timer_irq_mask = FALSE;
			}
			else {
				timer_irq_mask = TRUE;
			}
			if (dat & 0x02) {
				lp_irq_mask = FALSE;
			}
			else {
				lp_irq_mask = TRUE;
			}
			if (dat & 0x01) {
				key_irq_mask = FALSE;
			}
			else {
				key_irq_mask = TRUE;
			}
			maincpu_irq();
			subcpu_firq();
			return TRUE;

		/* BEEP */
		case 0xfd03:
			/* Xs[JtȌ */
			if (dat & 0x01) {
				speaker_flag = TRUE;
			}
			else {
				speaker_flag = FALSE;
			}
			if (dat & 0x40) {
				/* PBEEP */
				beep_count = 20;
				beep_flag = TRUE;
			}
			else {
				if (dat & 0x80) {
					/* ABEEP */
					beep_count = 0;
					beep_flag = TRUE;
				}
				else {
					/* BEEP OFF */
					beep_flag = FALSE;
				}
			}
			return TRUE;

		/* BASIC ROM */
		case 0xfd0f:
			basicrom_en = FALSE;
			return TRUE;
	}

	return FALSE;
}

/*
 *	CCPU I/O
 *	Z[u
 */
BOOL mainetc_save(int fileh)
{
	if (!file_bool_write(fileh, key_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, key_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, lp_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, timer_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, timer_irq_mask)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, mfd_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, mfd_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, txrdy_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, txrdy_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, rxrdy_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, rxrdy_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, syndet_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, syndet_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_irq_mask)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, timer_irq_count)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, timer_irq_mod)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, beep_count)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, beep_flag)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, speaker_flag)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	CCPU I/O
 *	[h
 */
BOOL mainetc_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &key_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &key_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &lp_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &timer_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &timer_irq_mask)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &mfd_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &mfd_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &txrdy_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &txrdy_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &rxrdy_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &rxrdy_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &syndet_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &syndet_irq_mask)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_irq_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_irq_mask)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &timer_irq_count)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &timer_irq_mod)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &beep_count)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &beep_flag)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &speaker_flag)) {
		return FALSE;
	}

	return TRUE;
}
