// ---------------------------------------------------------------------------
//	FM Sound Generator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: fmgen.h,v 1.13 1999/08/26 08:06:29 cisc Exp $

#ifndef FM_GEN_H
#define FM_GEN_H

// ---------------------------------------------------------------------------
//	萔̂P
//	ÓIe[ũTCY

#define FM_EGBITS		20
#define FM_OPSINBITS	10
#define FM_LFOBITS		8
#define FM_TLBITS		7

// ---------------------------------------------------------------------------

#define FM_EGENTS		(1L << FM_EGBITS)
#define FM_OPSINENTS	(1 << FM_OPSINBITS)
#define FM_TLENTS		(1 << FM_TLBITS)
#define FM_LFOENTS		(1 << FM_LFOBITS)
#define FM_TLPOS		(FM_TLENTS/4)

// ---------------------------------------------------------------------------

#if 0
namespace FM
{
#endif
	//	Types ----------------------------------------------------------------
	typedef int32	ISample;
	typedef int32 	Sample;

	//	Tables (O[oȂ̂ asm QƂ̓) -----------------
	void MakeTable();
	void MakeTimeTable(uint32 ratio);
	extern uint32 tltable[];
	extern uint32 cltable[];
	extern uint32 dltable[];
	extern int32 sinetable[];
	extern uint32 pmtable[][FM_LFOENTS];
	extern uint32 amtable[][FM_LFOENTS];
	extern uint32 lfotable[8];

	//	Operator -------------------------------------------------------------
	class Operator
	{
	public:
		Operator();
		static void MakeTable();
		static void	MakeTimeTable(uint32 ratio);
		
		ISample	Calc2(ISample in);
		ISample	CalcFB2(ISample in);
		ISample	Calc(ISample in);
		ISample CalcFB(uint8 fb);
		void	Prepare();
		void	KeyOn();
		void	KeyOff();
		void	Reset();
		void	ResetFB();
		int		IsOn();
		
		void	SetDT(uint8 dt);
		void	SetMULTI(uint8 multi);
		void	SetTL(uint8 tl, bool csm);
		void	SetKS(uint8 ks);
		void	SetAR(uint8 ar);
		void	SetDR(uint8 dr);
		void	SetSR(uint8 sr);
		void	SetRR(uint8 rr);
		void	SetSL(uint8 sl);
		void	SetSSGEC(uint8 ssgec);
		void	SetFNum(uint32 fnum);
		void	SetDPBN(uint32 dp, uint16 bn);
		void	SetMode(bool modulator);
		void	SetAMON(bool on);
		void	Mute(bool);
	
	private:
		typedef uint32 Counter;
		
		ISample	out, out2;
		uint32	dp;
		uint16	bn;

	//	Phase Generator ------------------------------------------------------
		
		uint32	PGCalc();

		uint16	detune;		// Detune
		uint16	multiple;	// Multiple
		uint32	pgcount;
		uint32	pgdcount;

	//	Envelope Generator ---------------------------------------------------
		
		enum	EGPhase { next, attack, decay, sustain, release, off };
		
		int32	EGCalc();
		void	ShiftPhase(EGPhase nextphase);
		
		Counter	egcount;	// JEgl
		Counter	egdcount;	// JEg
		Counter eglimit;	// JEg
		uint32	tllinear;	// Total Level (linear)
		uint16	ksr;		// key scale rate
		EGPhase	phase;
//		bool	modulator;
		
		uint8	tl;			// Total Level	 (0-127)
		uint8	tll;		// Total Level Latch (for CSM mode)
		uint8	ar;			// Attack Rate   (0-63)
		uint8	dr;			// Decay Rate    (0-63)
		uint8	sr;			// Sustain Rate  (0-63)
		uint8	sl;			// Sustain Level (0-127)
		uint8	rr;			// Release Rate  (0-63)
		uint8	ks;			// Keyscale      (0-3)
		uint8	ssgtype;	// SSG-Type Envelop Control

		bool	amon;		// enable Amplitude Modulation
		bool	paramchanged;	// p[^XVꂽ
		bool	mute;

	//	Tables ---------------------------------------------------------------
		
		enum TableIndex { dldecay = 0, dlattack = 0x400, };
		
		static Counter d2atable[0x400];
		static Counter a2dtable[0x44];
		static Counter ratetable[64];
		static int32 dttable[256];
		static uint32 multable[16];

		friend class Channel4;
	};
	
	//	4-op Channel ----------------------------------------------------------
	class Channel4
	{
	public:
		Channel4() { SetAlgorithm(0); }
		
		ISample Calc();				// 1 sample vZ
		ISample Calc2(uint lfo);	// 1 sample vZ
		void SetFNum(uint32 fnum);
		void SetFB(uint8 fb);
		void SetAlgorithm(uint8 algo);
		int Prepare();
		void KeyControl(uint key);
		void Reset();
		void SetMS(uint ms);
		void Mute(bool);

	private:
		static const uint8 fbtable[8];
		uint8	fb;
		int32	buf[4];
		int32*	in[3];			// e OP ̓̓|C^
		int32*	out[3];			// e OP ̏o̓|C^
		uint32	pmc;			// Phase Modulator (1.0 = 10000h)
		uint32	amc;			// Amplitude Modulator
		uint32*	ams;
		uint32*	pms;

	public:
		Operator op[4];
	};
#if 0
}
#endif

#endif // FM_GEN_H
