/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ fBXvC ]
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "xm7.h"
#include "display.h"
#include "subctrl.h"
#include "device.h"
#include "ttlpalet.h"
#include "multipag.h"
#include "mainetc.h"

/*
 *	O[o [N
 */
BOOL crt_flag;				/* CRT ONtO */
BOOL vrama_flag;			/* VRAMANZXtO */
WORD vram_offset;			/* VRAMItZbgWX^ */
WORD crtc_offset;			/* CRTCItZbg */

/*
 *	X^eBbN [N
 */
static BYTE *vram_buf;		/* VRAMXN[obt@ */
static BYTE vramoff_count;	/* VRAMItZbgWX^ */

/*
 *	fBXvC
 *	
 */
BOOL display_init(void)
{
	vram_buf = (BYTE *)malloc(0x4000);

	if (vram_buf == NULL) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	fBXvC
 *	N[Abv
 */
void display_cleanup(void)
{
	ASSERT(vram_buf);
	if (vram_buf) {
		free(vram_buf);
	}
}

/*
 *	fBXvC
 *	Zbg
 */
void display_reset(void)
{
	int i;
	WORD addr;

	crt_flag = FALSE;
	vrama_flag = FALSE;
	vram_offset = 0;
	crtc_offset = 0;
	vramoff_count = 0;

	/* CRT OFF */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, 0);
	}

	/* {AVRAMNA͕KvȂ */
	for (addr=0; addr<0xc000; addr++) {
		vram_setb(addr, 0);
	}
}

/*
 *	VRAMXN[
 */
static void vram_scroll(WORD offset)
{
	int i;
	BYTE *vram;

	/* ItZbg }XN */
	offset &= 0x3fe0;

	/* [v */
	for (i=0; i<3; i++) {
		vram = (BYTE *)(vram_c + 0x4000 * i);

		/* e|obt@փRs[ */
		memcpy(vram_buf, vram, offset);

		/* O֋l߂ */
		memcpy(vram, (vram + offset), 0x4000 - offset);

		/* e|obt@蕜 */
		memcpy(vram + (0x4000 - offset), vram_buf, offset);
	}
}

/*
 *	fBXvC
 *	PoCgǂݍ
 *	C|TuC^tF[XM܂
 */
BOOL display_readb(WORD addr, BYTE *dat)
{
	switch (addr) {
		/* LZIRQ ACK */
		case 0xd402: 
			subcancel_flag = FALSE;
			subcpu_irq();
			*dat = 0xff;
			return TRUE;

		/* BEEP */
		case 0xd403:
			beep_count = 20;
			beep_flag = TRUE;
			return TRUE;

		/* AeVIRQ ON */
		case 0xd404:
			subattn_flag = TRUE;
			*dat = 0xff;
			maincpu_firq();
			return TRUE;

		/* CRT ON */
		case 0xd408:
			if (!crt_flag) {
				crt_flag = TRUE;
				/* CRT OFFON */
				multipag_writeb(0xfd37, multi_page);
			}
			*dat = 0xff;
			return TRUE;

		/* VRAMANZX ON */
		case 0xd409:
			vrama_flag = TRUE;
			*dat = 0xff;
			return TRUE;

		/* BUSYtO OFF */
		case 0xd40a:
			subbusy_flag = FALSE;
			*dat = 0xff;
			/* Tu[h̏ꍇ́Asleep */
			if (subfast_flag > 0) {
				subfast_flag = 2;
			}
			return TRUE;
	}

	return FALSE;
}

/*
 *	fBXvC
 *	PoCg
 *	C|TuC^tF[XM܂
 */
BOOL display_writeb(WORD addr, BYTE dat)
{
	switch (addr) {
		/* CRT OFF */
		case 0xd408:
			if (crt_flag) {
				/* CRT ONOFF */
				crt_flag = FALSE;
				multipag_writeb(0xfd37, multi_page);
			}
			crt_flag = FALSE;
			return TRUE;

		/* VRAMANZX OFF */
		case 0xd409:
			vrama_flag = FALSE;
			return TRUE;

		/* BUSYtO ON */
		case 0xd40a:
			subbusy_flag = TRUE;
			return TRUE;

		/* VRAMItZbgAhX  */
		case 0xd40e:
			vram_offset = ((dat & 0x3f) << 8) | (vram_offset & 0xff);
			vramoff_count++;
			if (!(vramoff_count & 1)) {
				vram_scroll((WORD)(vram_offset - crtc_offset));
				vramoff_setw((WORD)(vram_offset - crtc_offset));
				crtc_offset = vram_offset;
			}
			return TRUE;

		/* VRAMItZbgAhX  */
		case 0xd40f:
			vram_offset = (vram_offset & 0x3f00) | (dat & 0xe0);
			vramoff_count++;
			if (!(vramoff_count & 1)) {
				vram_scroll((WORD)(vram_offset - crtc_offset));
				vramoff_setw((WORD)(vram_offset - crtc_offset));
				crtc_offset = vram_offset;
			}
			return TRUE;
	}

	return FALSE;
}

/*
 *	fBXvC
 *	Z[u
 */
BOOL display_save(int fileh)
{
	if (!file_bool_write(fileh, crt_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, vrama_flag)) {
		return FALSE;
	}

	if (!file_word_write(fileh, vram_offset)) {
		return FALSE;
	}

	if (!file_word_write(fileh, crtc_offset)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, vramoff_count)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	fBXvC
 *	[h
 */
BOOL display_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &crt_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &vrama_flag)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &vram_offset)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &crtc_offset)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &vramoff_count)) {
		return FALSE;
	}

	return TRUE;
}
