;
; FM-7 EMULATOR "XM7"
;
; Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
; [ 6809CPU(x86AZu) ]
;

;
; NASM(Netwide Assembler) Only!
;
; ^[QbgEvbgtH[ɉăV{`邱
;
; MS-DOS	-d __MSDOS__	-f obj
; Win32		-d _WIN32	-f win32
; Linux		-d _XWIN	-f elf
;

;
; O`
;
	%ifdef	_WIN32
		section	.data data align=4
		extern	_maincpu
		extern	_subcpu
		extern	_stopreq_flag

		section	.text code align=16
		global	_main_exec
		global	_sub_exec
		global	_main_line
		global	_sub_line
		global	_main_reset
		global	_sub_reset
	%endif
	%ifdef __MSDOS__
		segment	_data public align=2 class=DATA
		extern	_maincpu
		extern	_subcpu
		extern	_stopreq_flag

		segment	_cpu_x86_text public align=1 class=CODE
		global	_main_exec
		global	_sub_exec
		global	_main_line
		global	_sub_line
		global	_main_reset
		global	_sub_reset
	%endif

	%ifdef	_XWIN
		section	.data data align=16
		extern	maincpu
		extern	subcpu
		extern	stopreq_flag
		%define	_maincpu	maincpu
		%define	_subcpu		subcpu
		%define	_stopreq_flag	stopreq_flag
		section	.text code align=16
		global	main_exec
		global	sub_exec
		global	main_line
		global	sub_line
		global	main_reset
		global	sub_reset
	%endif
	
;
; WX^`
;
	%ifdef	__MSDOS__
		%define	CCREG	byte [si]
		%define	DPREG	byte [si+1]
		%define	BREG	byte [si+2]
		%define	AREG	byte [si+3]
		%define	DREG	word [si+2]
		%define	XREG	word [si+4]
		%define	YREG	word [si+6]
		%define	UREG	word [si+8]
		%define	SREG	word [si+10]
		%define	PCREG	word [si+12]
		%define	INTR	word [si+14]
		%define	CYCLE	word [si+16]
		%define	TOTAL	word [si+18]
		%define	READMEM	far [si+20]
		%define	WRITEMEM far [si+24]
	%else
		%define	CCREG	byte [esi]
		%define	DPREG	byte [esi+1]
		%define	BREG	byte [esi+2]
		%define	AREG	byte [esi+3]
		%define	DREG	word [esi+2]
		%define	XREG	word [esi+4]
		%define	YREG	word [esi+6]
		%define	UREG	word [esi+8]
		%define	SREG	word [esi+10]
		%define	PCREG	word [esi+12]
		%define	INTR	word [esi+14]
		%define	CYCLE	word [esi+16]
		%define	TOTAL	word [esi+18]
		%define	READMEM	dword [esi+20]
		%define	WRITEMEM dword [esi+24]
	%endif

;
; AhXe[u
;
	%ifdef	__MSDOS__
		%define	ADDR	dw
	%else
		%define	ADDR	dd
	%endif

;
; ǂݏo(BYTE)
;
		%macro	READB	0
	%ifdef	__MSDOS__
		push	bp
		call	READMEM
		add	sp,2
	%else
		push	ebp
		call	READMEM
		add	esp,byte 4
	%endif
		%endmacro

;
; ǂݏo(WORD)
;
		%macro	READW	0
	%ifdef	__MSDOS__
		push	bp
		call	READMEM
	%else
		push	ebp
		call	READMEM
	%endif
		mov	ah,al
		xor	al,al
		mov	di,ax
		inc	bp
	%ifdef	__MSDOS__
		push	bp
		call	READMEM
		add	sp,4
	%else
		push	ebp
		call	READMEM
		add	esp,byte 8
	%endif
		xor	ah,ah
		or	ax,di
		%endmacro

;
; (BYTE)
;
		%macro	WRITEB	0
	%ifdef	__MSDOS__
		push	ax
		push	bp
		call	WRITEMEM
		add	sp,4
	%else
		push	eax
		push	ebp
		call	WRITEMEM
		add	esp,byte 8
	%endif
		%endmacro

;
; (WORD)
;
		%macro	WRITEW	0

		mov	di,ax
		xchg	ah,al
	%ifdef	__MSDOS__
		push	ax
		push	bp
		call	WRITEMEM
		inc	bp
		push	di
		push	bp
		call	WRITEMEM
		add	esp,8
	%else
		push	eax
		push	ebp
		call	WRITEMEM
		inc	bp
		push	edi
		push	ebp
		call	WRITEMEM
		add	esp,byte 16
	%endif
		%endmacro

;
; ZtONA
;
		%macro	CLR_Z	0
		and	CCREG,0fbh
		%endmacro

;
; N,ZtONA
;
		%macro	CLR_NZ	0
		and	CCREG,0f3h
		%endmacro

;
; N,Z,VtONA
;
		%macro	CLR_NZV	0
		and	CCREG,0f1h
		%endmacro

;
; N,Z,CtONA
;
		%macro	CLR_NZC	0
		and	CCREG,0f2h
		%endmacro

;
; N,Z,V,CtONA
;
		%macro	CLR_NZVC	0
		and	CCREG,0f0h
		%endmacro

;
; H,N,Z,V,CtONA
;
		%macro	CLR_HNZVC	0
		and	CCREG,0d0h
		%endmacro

;
; CtOZbg
;
		%macro	SET_C	0
		or	CCREG,01h
		%endmacro

;
; ZtOZbg
;
		%macro	SET_Z	0
		or	CCREG,04h
		%endmacro

;
; N,ZtOZbg
;
		%macro	SET_NZ	0
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		shr	al,4
		and	al,0ch
		or	CCREG,al
		%endmacro

;
; N,Z,VtOZbg
;
		%macro	SET_NZV	0
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		shr	ah,2
		and	ah,02h
		or	CCREG,ah
		shr	al,4
		and	al,0ch
		or	CCREG,al
		%endmacro

;
; N,Z,CtOZbg
;
		%macro	SET_NZC	0
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		mov	ah,al
		and	ah,01h
		or	CCREG,ah
		shr	al,4
		and	al,0ch
		or	CCREG,al
		%endmacro

;
; N,Z,V,CtOZbg
;
		%macro	SET_NZVC	0
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		shr	ah,2
		and	ah,02h
		or	CCREG,ah
		mov	ah,al
		and	ah,01h
		or	CCREG,ah
		shr	al,4
		and	al,0ch
		or	CCREG,al
		%endmacro

;
; H,N,Z,V,CtOZbg
;
		%macro	SET_HNZVC	0
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		shr	ah,2
		and	ah,02h
		or	CCREG,ah
		mov	ah,al
		and	ah,01h
		or	CCREG,ah
		mov	ah,al
		add	ah,ah
		and	ah,20h
		or	CCREG,ah
		shr	al,4
		and	al,0ch
		or	CCREG,al
		%endmacro

;
; C~fBGCg[h(BYTE)
;
		%macro	IMMB	0
		READB
		inc	PCREG
		%endmacro

;
; C~fBGCg[h(WORD)
;
		%macro	IMMW	0
		READW
		add	PCREG,2
		%endmacro

;
; _CNg[h
;
		%macro	DIRECT	0
		READB
		inc	PCREG
		mov	ah,DPREG
		mov	bp,ax
		%endmacro

;
; GNXeh[h
;
		%macro	EXTEND	0
		READW
		add	PCREG,2
		mov	bp,ax
		%endmacro

;
; [h(BYTE)
;
		%macro	LOADB	1
		mov	%1,al
		or	al,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; [h(WORD)
;
		%macro	LOADW	1
		mov	%1,ax
		or	ax,ax
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; XgA(BYTE)
;
		%macro	STOREB	1
		mov	al,%1
		or	al,al
		pushf
		CLR_NZV
		SET_NZ
		mov	al,%1
		WRITEB
		%endmacro

;
; XgA(WORD)
;
		%macro	STOREW	1
		mov	ax,%1
		or	ax,ax
		pushf
		CLR_NZV
		SET_NZ
		mov	ax,%1
		WRITEW
		%endmacro

;
; NA(BYTE)
;
		%macro	CLRB	1
		mov	%1,00h
		CLR_NZVC
		SET_Z
		%endmacro

;
; NA(MEMORY)
;
		%macro	CLRM	0
; [hETCN܂
; Alpha΍ (CLR $D404)
		READB
		xor	al,al
		WRITEB
		CLR_NZVC
		SET_Z
		%endmacro

;
; tOŒNA(BYTE)
;
		%macro	CLCB	1
		mov	%1,0
		CLR_NZV
		SET_Z
		%endmacro

;
; Z(BYTE)
;
		%macro	ADDB	1
		add	%1,al
		pushf
		CLR_HNZVC
		SET_HNZVC
		%endmacro

;
; Z(WORD)
;
		%macro	ADDW	1
		add	%1,ax
		pushf
		CLR_HNZVC
		SET_HNZVC
		%endmacro

;
; L[Z(BYTE)
;
		%macro	ADCB	1
		mov	ah,CCREG
		rcr	ah,1
		adc	%1,al
		pushf
		CLR_HNZVC
		SET_HNZVC
		%endmacro

;
; Z(BYTE)
;
		%macro	SUBB	1
		sub	%1,al
		pushf
		CLR_HNZVC
		SET_NZVC
		%endmacro

;
; L[Z(BYTE)
;
		%macro	SBCB	1
		mov	ah,CCREG
		rcr	ah,1
		sbb	%1,al
		pushf
		CLR_HNZVC
		SET_NZVC
		%endmacro

;
; Z(WORD)
;
		%macro	SUBW	1
		sub	%1,ax
		pushf
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; RyA(BYTE)
;
		%macro	CMPB	1
		mov	bl,%1
		sub	bl,al
		pushf
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; RyA(WORD)
;
		%macro	CMPW	1
		mov	bx,%1
		sub	bx,ax
		pushf
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; eXg(BYTE)
;
		%macro	TSTB	1
		mov	al,%1
		or	al,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; eXg(MEMORY)
;
		%macro	TSTM	0
		READB
		or	al,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; CNg(BYTE)
;
		%macro	INCB	1
		inc	%1
		pushf
		CLR_NZV
		SET_NZV
		%endmacro

;
; CNg(MEMORY)
;
		%macro	INCM	0
		READB
		inc	al
		pushf
		WRITEB
		CLR_NZV
		SET_NZV
		%endmacro

;
; fNg(BYTE)
;
		%macro	DECB	1
		dec	%1
		pushf
		CLR_NZV
		SET_NZV
		%endmacro

;
; fNg(MEMORY)
;
		%macro	DECM	0
		READB
		dec	al
		pushf
		WRITEB
		CLR_NZV
		SET_NZV
		%endmacro

;
; fNgEL[(BYTE)
;
		%macro	DCCB	1
		dec	%1
		pushf
		CLR_NZVC
		SET_NZV
		mov	al,CCREG
		shr	al,2
		not	al
		and	al,01h
		or	CCREG,al
		%endmacro

;
; fNgEL[(MEMORY)
;
		%macro	DCCM	0
		READB
		dec	al
		pushf
		WRITEB
		CLR_NZVC
		SET_NZV
		mov	al,CCREG
		shr	al,2
		not	al
		and	al,01h
		or	CCREG,al
		%endmacro

;
; lKeBu(BYTE)
;
		%macro	NEGB	1
		neg	%1
		pushf
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; lKeBu(MEMORY)
;
		%macro	NEGM	0
		READB
		neg	al
		pushf
		WRITEB
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; ے(BYTE)
;
		%macro	COMB	1
		mov	al,%1
		not	al
		or	al,al
		pushf
		mov	%1,al
		CLR_NZVC
		SET_NZ
		SET_C
		%endmacro

;
; ے(MEMORY)
;
		%macro	COMM	0
		READB
		not	al
		or	al,al
		pushf
		WRITEB
		CLR_NZVC
		SET_NZ
		SET_C
		%endmacro

;
; _(BYTE)
;
		%macro	ANDB	1
		and	%1,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; _a(BYTE)
;
		%macro	ORB	1
		or	%1,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; rI_a(BYTE)
;
		%macro	EORB	1
		xor	%1,al
		pushf
		CLR_NZV
		SET_NZ
		%endmacro

;
; rbgeXg(BYTE)
;
		%macro	BITB	1
		and	al,%1
		pushf
		CLR_NZV
		SET_NZV
		%endmacro

;
; E_Vtg(BYTE)
;
		%macro	LSRB	1
		shr	%1,1
		pushf
		CLR_NZC
		SET_NZC
		%endmacro

;
; E_Vtg(MEMORY)
;
		%macro	LSRM	0
		READB
		shr	al,1
		pushf
		WRITEB
		CLR_NZC
		SET_NZC
		%endmacro

;
; _Vtg(BYTE)
;
		%macro	LSLB	1
		shl	%1,1
		pushf
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; _Vtg(MEMORY)
;
		%macro	LSLM	0
		READB
		shl	al,1
		pushf
		WRITEB
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; EZpVtg(BYTE)
;
		%macro	ASRB	1
		sar	%1,1
		pushf
		CLR_NZC
		SET_NZC
		%endmacro

;
; EZpVtg(MEMORY)
;
		%macro	ASRM	0
		READB
		sar	al,1
		pushf
		WRITEB
		CLR_NZC
		SET_NZC
		%endmacro

;
; E[e[g(BYTE)
;
		%macro	RORB	1
		mov	al,CCREG
		CLR_NZVC
		shr	al,1
		rcr	%1,1
		adc	CCREG,0
		mov	al,%1
		or	al,al
		pushf
		SET_NZ
		%endmacro

;
; E[e[g(MEMORY)
;
		%macro	RORM	0
		READB
		mov	ah,CCREG
		CLR_NZVC
		shr	ah,1
		rcr	al,1
		adc	CCREG,0
		or	al,al
		pushf
		WRITEB
		SET_NZ
		%endmacro

;
; [e[g(BYTE)
;
		%macro	ROLB	1
		mov	ah,CCREG
		mov	al,%1
		shr	ah,1
		adc	al,al
		pushf
		mov	%1,al
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; [e[g(MEMORY)
;
		%macro	ROLM	0
		READB
		mov	ah,CCREG
		shr	ah,1
		adc	al,al
		pushf
		WRITEB
		CLR_NZVC
		SET_NZVC
		%endmacro

;
; AhX(WORD)
;
		%macro	LEAW	1
		CLR_Z
		mov	%1,bp
		or	bp,bp
		pushf
	%ifdef	__MSDOS__
		pop	ax
	%else
		pop	eax
	%endif
		shr	al,4
		and	al,04h
		or	CCREG,al
		%endmacro

;
; u`(BYTE)
;
		%macro	BRANCHB	0
		READB
		cbw
		inc	ax
		add	PCREG,ax
		%endmacro

;
; u`(WORD)
;
		%macro	BRANCHW	0
		READW
		add	ax,2
		add	PCREG,ax
		%endmacro

;
; Wv
;
		%macro	JUMPAB	0
		mov	PCREG,bp
		%endmacro

;
; Tu[`R[()
;
		%macro	JUMPSR	0
		push	bp
		PSHSW	PCREG
		pop	PCREG
		%endmacro

;
; Tu[`R[()
;
		%macro	BRANCHSR	0
		push	ax
		PSHSW	PCREG
		pop	ax
		add	PCREG,ax
		%endmacro

;
; vbV(BYTE,S)
; |C^fNgOɁAǂ
;
		%macro	PSHSB	1
		mov	bp,SREG
		READB
		dec	SREG
		mov	bp,SREG
		mov	al,%1
		WRITEB
		%endmacro

;
; vbV(BYTE,U)
; |C^fNgOɁAǂ
;
		%macro	PSHUB	1
		mov	bp,UREG
		READB
		dec	UREG
		mov	bp,UREG
		mov	al,%1
		WRITEB
		%endmacro

;
; vbV(WORD,S)
;
		%macro	PSHSW	1
		mov	bp,SREG
		READB
		sub	SREG,2
		mov	bp,SREG
		mov	ax,%1
		WRITEW
		%endmacro

;
; vbV(WORD,U)
; |C^fNgOɁAǂ
;
		%macro	PSHUW	1
		mov	bp,UREG
		READB
		sub	UREG,2
		mov	bp,UREG
		mov	ax,%1
		WRITEW
		%endmacro

;
; v(BYTE,S)
; |C^CNgAǂ
;
		%macro	PULSB	1
		mov	bp,SREG
		READB
		mov	%1,al
		inc	bp
		READB
		mov	SREG,bp
		%endmacro

;
; v(WORD,S)
; |C^CNgAǂ
;
		%macro	PULSW	1
		mov	bp,SREG
		READW
		mov	%1,ax
		inc	bp
		READB
		mov	SREG,bp
		%endmacro

;
; v(BYTE,U)
; |C^CNgAǂ
;
		%macro	PULUB	1
		mov	bp,UREG
		READB
		mov	%1,al
		inc	bp
		READB
		mov	UREG,bp
		%endmacro

;
; vbV(WORD,U)
; |C^CNgAǂ
;
		%macro	PULUW	1
		mov	bp,UREG
		READW
		mov	%1,ax
		inc	bp
		READB
		mov	UREG,bp
		%endmacro

;
; WX^擾(TFR,EXG)
;
; param.: si	REG
;	  ah	WX^w(0`15)
; result: bx	f[^
; usereg: di
;
getreg:
	%ifdef	__MSDOS__
		mov	di,getreg_table
		xor	bh,bh
		mov	bl,ah
		add	bl,bl
		jmp	near [cs:bx+di]
	%else
		mov	edi,getreg_table
		xor	ebx,ebx
		mov	bl,ah
		shl	bl,2
		jmp	near [ebx+edi]
	%endif

;
; WX^擾e[u
;
getreg_table:
		ADDR	getreg_d
		ADDR	getreg_x
		ADDR	getreg_y
		ADDR	getreg_u
		ADDR	getreg_s
		ADDR	getreg_pc
		ADDR	getreg_dmy
		ADDR	getreg_dmy
		ADDR	getreg_a
		ADDR	getreg_b
		ADDR	getreg_cc
		ADDR	getreg_dp
		ADDR	getreg_dmy
		ADDR	getreg_dmy
		ADDR	getreg_dmy
		ADDR	getreg_dmy

;
; WX^擾[`Q
;
getreg_d:
		mov	bx,DREG
		ret
getreg_x:
		mov	bx,XREG
		ret
getreg_y:
		mov	bx,YREG
		ret
getreg_u:
		mov	bx,UREG
		ret
getreg_s:
		mov	bx,SREG
		ret
getreg_pc:
		mov	bx,PCREG
		ret
getreg_a:
		mov	bh,0ffh
		mov	bl,AREG
		ret
getreg_b:
		mov	bh,0ffh
		mov	bl,BREG
		ret
getreg_cc:
		mov	bh,0ffh
		mov	bl,CCREG
		ret
getreg_dp:
		mov	bh,0ffh
		mov	bl,DPREG
		ret
getreg_dmy:
		mov	bx,0ffffh
		ret

;
; WX^Zbg(TFR,EXG)
;
; param.: si	REG
;	  ah	WX^w(0`15)
;	  bx	f[^
; usereg: cx,di
;
setreg:
	%ifdef	__MSDOS__
		mov	di,setreg_table
		mov	cl,ah
		xor	ch,ch
		add	cl,cl
		add	di,cx
		jmp	near [cs:di]
	%else
		mov	edi,setreg_table
		xor	ecx,ecx
		mov	cl,ah
		shl	cl,2
		jmp	near [ecx+edi]
	%endif

;
; WX^Zbge[u
;
setreg_table:
		ADDR	setreg_d
		ADDR	setreg_x
		ADDR	setreg_y
		ADDR	setreg_u
		ADDR	setreg_s
		ADDR	setreg_pc
		ADDR	setreg_dmy
		ADDR	setreg_dmy
		ADDR	setreg_a
		ADDR	setreg_b
		ADDR	setreg_cc
		ADDR	setreg_dp
		ADDR	setreg_dmy
		ADDR	setreg_dmy
		ADDR	setreg_dmy
		ADDR	setreg_dmy

;
; WX^Zbg[`Q
;
setreg_d:
		mov	DREG,bx
		ret
setreg_x:
		mov	XREG,bx
		ret
setreg_y:
		mov	YREG,bx
		ret
setreg_u:
		mov	UREG,bx
		ret
setreg_s:
		mov	SREG,bx
; NMI
		or	INTR,0010h
		ret
setreg_pc:
		mov	PCREG,bx
		ret
setreg_a:
		mov	AREG,bl
		ret
setreg_b:
		mov	BREG,bl
		ret
setreg_cc:
		mov	CCREG,bl
		ret
setreg_dp:
		mov	DPREG,bl
setreg_dmy:
		ret

;
; TCNe[uP
;
cycle_table1:
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	6
		db	3
		db	6
; $10
		db	255
		db	255
		db	2
		db	2
		db	0
		db	0
		db	5
		db	9
		db	3
		db	2
		db	3
		db	2
		db	3
		db	2
		db	8
		db	6
; $20
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
		db	3
; $30
		db	132
		db	132
		db	132
		db	132
		db	5
		db	5
		db	5
		db	5
		db	4
		db	5
		db	3
		db	6
		db	20
		db	11
		db	1
		db	19
; $40
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
; $50
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
; $60
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	134
		db	131
		db	134
; $70
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	7
		db	4
		db	7
; $80
		db	2
		db	2
		db	2
		db	4
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	4
		db	7
		db	3
		db	3
; $90
		db	4
		db	4
		db	4
		db	6
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	6
		db	7
		db	5
		db	5
; $A0
		db	132
		db	132
		db	132
		db	134
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	134
		db	135
		db	133
		db	133
; $B0
		db	5
		db	5
		db	5
		db	7
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	7
		db	8
		db	6
		db	6
; $C0
		db	2
		db	2
		db	2
		db	4
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	2
		db	3
		db	0
		db	3
		db	3
; $D0
		db	4
		db	4
		db	4
		db	6
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	4
		db	5
		db	5
		db	5
		db	5
; $E0
		db	132
		db	132
		db	132
		db	134
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	132
		db	133
		db	133
		db	133
		db	133
; $F0
		db	5
		db	5
		db	5
		db	7
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	6
		db	6
		db	6
		db	6

;
; TCNe[uQ
;
cycle_table2:
; $00
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
; $10
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
; $20
		db	0
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
		db	5
; $30
		db	128
		db	128
		db	128
		db	128
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	20
; $40
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
; $50
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
; $60
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
; $70
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
; $80
		db	0
		db	0
		db	0
		db	5
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	5
		db	0
		db	4
		db	0
; $90
		db	0
		db	0
		db	0
		db	7
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	7
		db	0
		db	6
		db	6
; $A0
		db	128
		db	128
		db	128
		db	135
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	135
		db	128
		db	134
		db	134
; $B0
		db	0
		db	0
		db	0
		db	8
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	8
		db	0
		db	7
		db	7
; $C0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	4
		db	0
; $D0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	6
		db	6
; $E0
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	128
		db	134
		db	134
; $F0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	0
		db	7
		db	7

;
; $00
; NEG (DIR)
;
neg_di:
		DIRECT
		NEGM
		ret

;
; $02
; NGC (DIR)
;
ngc_di:
		test	CCREG,01h
		jz	neg_di

;
; $03
; COM (DIR)
;
com_di:
		DIRECT
		COMM
		ret

;
; $04
; LSR (DIR)
;
lsr_di:
		DIRECT
		LSRM
		ret

;
; $06
; ROR (DIR)
;
ror_di:
		DIRECT
		RORM
		ret

;
; $07
; ASR (DIR)
;
asr_di:
		DIRECT
		ASRM
		ret

;
; $08
; LSL (DIR)
;
lsl_di:
		DIRECT
		LSLM
		ret

;
; $09
; ROL (DIR)
;
rol_di:
		DIRECT
		ROLM
		ret

;
; $0A
; DEC (DIR)
;
dec_di:
		DIRECT
		DECM
		ret

;
; $0B
; DCC (DIR)
;
dcc_di:
		DIRECT
		DCCM
		ret

;
; $0C
; INC (DIR)
;
inc_di:
		DIRECT
		INCM
		ret

;
; $0D
; TST (DIR)
;
tst_di:
		DIRECT
		TSTM
		ret

;
; $0E
; JMP (DIR)
;
jmp_di:
		DIRECT
		JUMPAB
		ret

;
; $0F
; CLR (DIR)
;
clr_di:
		DIRECT
		CLRM
		ret

;
; $12
; NOP
;
nop_in:
		ret

;
; $13
; SYNC
;
sync_in:
		test	INTR,0020h
		jnz	.next
; 񏉂߂SYNCs
		or	INTR,0020h
		and	INTR,0ffbfh
		dec	PCREG
		ret
; SYNCs
.next:
		test	INTR,0040h
		jnz	.exit
		dec	PCREG
		ret
; 荞݂
.exit:
		and	INTR,0ff9fh
		ret

;
; $16
; LBRA
;
lbra_re:
		BRANCHW
		ret

;
; $17
; LBSR
;
lbsr_re:
		IMMW
		BRANCHSR
		ret

;
; $18
; ASLCC
;
aslcc_in:
		mov	al,CCREG
		test	al,04h
		jz	.next
		or	al,01h
.next:
		add	al,al
		and	al,3eh
		mov	CCREG,al
		ret

;
; $19
; DAA
;
daa_in:
		mov	al,AREG
		mov	ah,al
		and	al,0fh
		and	ah,0f0h
		xor	bl,bl
		mov	bh,CCREG
; step 1
.step1
		cmp	al,0ah
		jnc	.step1ok
		test	bh,20h
		jz	.step2
.step1ok:
		or	bl,06h
; step2
.step2:
		cmp	ah,90h
		jc	.step3
		cmp	al,0ah
		jc	.step3
.step2ok:
		or	bl,60h
; step3
.step3:
		cmp	ah,0a0h
		jnc	.step3ok
		test	bh,01h
		jz	.ok
.step3ok:
		or	bl,60h
; ok
.ok:
		add	bl,AREG
		pushf
		mov	AREG,bl
		CLR_NZV
		SET_NZC
		ret

;
; $1A
; ORCC
;
orcc_im:
		IMMB
		or	CCREG,al
		ret

;
; $1C
; ANDCC
;
andcc_im:
		IMMB
		and	CCREG,al
		ret

;
; $1D
; SEX
;
sex_in:
		mov	al,BREG
		cbw
		or	ax,ax
		pushf
		mov	DREG,ax
		CLR_NZ
		SET_NZ
		ret

;
; $1E
; EXG
;
exg_in:
		READB
		inc	PCREG
; p[^擾
		mov	ah,al
		and	ah,0fh
		shr	al,4
; 16bit<>16bitɉzĈ
.exgok:
		call	getreg
		mov	bp,bx
		xchg	ah,al
		call	getreg
		xchg	ah,al
		call	setreg
		xchg	ah,al
		mov	bx,bp
		call	setreg
		ret

;
; $1F
; TFR
;
tfr_in:
		READB
		inc	PCREG
; 16bit<>16bitɉzĈ
		mov	ah,al
		shr	ah,4
		and	al,0fh
		call	getreg
		mov	ah,al
		jmp	setreg

;
; $20
; BRA
;
bra_re:
		BRANCHB
		ret

;
; $21
; BRN
;
brn_re:
		inc	PCREG
		ret

;
; $10 $21
; LBRN
;
lbrn_re:
		add	PCREG,2
		ret

;
; $22
; BHI
;
bhi_re:
		test	CCREG,05h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $22
; LBHI
;
lbhi_re:
		test	CCREG,05h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $23
; BLS
;
bls_re:
		test	CCREG,05h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $23
; LBLS
;
lbls_re:
		test	CCREG,05h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $24
; BCC
;
bcc_re:
		test	CCREG,01h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $24
; LBCC
;
lbcc_re:
		test	CCREG,01h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $25
; BCS
;
bcs_re:
		test	CCREG,01h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $25
; LBCS
;
lbcs_re:
		test	CCREG,01h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $26
; BNE
;
bne_re:
		test	CCREG,04h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $26
; LBNE
;
lbne_re:
		test	CCREG,04h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $27
; BEQ
;
beq_re:
		test	CCREG,04h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $27
; LBEQ
;
lbeq_re:
		test	CCREG,04h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $28
; BVC
;
bvc_re:
		test	CCREG,02h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $28
; LBVC
;
lbvc_re:
		test	CCREG,02h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $29
; BVS
;
bvs_re:
		test	CCREG,02h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $29
; LBVS
;
lbvs_re:
		test	CCREG,02h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2A
; BPL
;
bpl_re:
		test	CCREG,08h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $2A
; LBPL
;
lbpl_re:
		test	CCREG,08h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2B
; BMI
;
bmi_re:
		test	CCREG,08h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $2B
; LBMI
;
lbmi_re:
		test	CCREG,08h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2C
; BGE
;
bge_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $2C
; LBGE
;
lbge_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2D
; BLT
;
blt_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $2D
; LBLT
;
lblt_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2E
; BGT
;
bgt_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.exit
		test	ah,04h
		jnz	.exit
		BRANCHB
		ret
.exit:
		inc	PCREG
		ret

;
; $10 $2E
; LBGT
;
lbgt_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.exit
		test	ah,04h
		jnz	.exit
		BRANCHW
		inc	CYCLE
		ret
.exit:
		add	PCREG,2
		ret

;
; $2F
; BLE
;
ble_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.jump
		test	ah,04h
		jnz	.jump
		inc	PCREG
		ret
.jump:
		BRANCHB
		ret

;
; $10 $2F
; LBLE
;
lble_re:
		mov	al,CCREG
		mov	ah,al
		shl	al,2
		xor	al,ah
		test	al,08h
		jnz	.jump
		test	ah,04h
		jnz	.jump
		add	PCREG,2
		ret
.jump:
		BRANCHW
		inc	CYCLE
		ret

;
; $31
; LEAX (IDX)
;
leax_ix:
		LEAW	XREG
		ret

;
; $31
; LEAY (IDX)
;
leay_ix:
		LEAW	YREG
		ret

;
; $32
; LEAS (IDX)
;
leas_ix:
		mov	SREG,bp
		ret

;
; $33
; LEAU (IDX)
;
leau_ix:
		mov	UREG,bp
		ret

;
; $34
; PSHS
;
pshs_in:
		IMMB
; PC
.pcreg:
		add	al,al
		jnc	.ureg
		push	ax
		PSHSW	PCREG
		pop	ax
		add	CYCLE,2
; U
.ureg:
		add	al,al
		jnc	.yreg
		push	ax
		PSHSW	UREG
		pop	ax
		add	CYCLE,2
; Y
.yreg:
		add	al,al
		jnc	.xreg
		push	ax
		PSHSW	YREG
		pop	ax
		add	CYCLE,2
; X
.xreg:
		add	al,al
		jnc	.dpreg
		push	ax
		PSHSW	XREG
		pop	ax
		add	CYCLE,2
; DP
.dpreg:
		add	al,al
		jnc	.breg
		push	ax
		PSHSB	DPREG
		pop	ax
		inc	CYCLE
; B
.breg:
		add	al,al
		jnc	.areg
		push	ax
		PSHSB	BREG
		pop	ax
		inc	CYCLE
; A
.areg:
		add	al,al
		jnc	.ccreg
		push	ax
		PSHSB	AREG
		pop	ax
		inc	CYCLE
; CC
.ccreg:
		add	al,al
		jnc	.exit
		PSHSB	CCREG
		inc	CYCLE
.exit:
		ret

;
; $35
; PULS
;
puls_in:
		IMMB
; CC
.ccreg:
		shr	al,1
		jnc	.areg
		push	ax
		PULSB	CCREG
		pop	ax
		inc	CYCLE
; A
.areg:
		shr	al,1
		jnc	.breg
		push	ax
		PULSB	AREG
		pop	ax
		inc	CYCLE
; B
.breg:
		shr	al,1
		jnc	.dpreg
		push	ax
		PULSB	BREG
		pop	ax
		inc	CYCLE
; DP
.dpreg:
		shr	al,1
		jnc	.xreg
		push	ax
		PULSB	DPREG
		pop	ax
		inc	CYCLE
; X
.xreg:
		shr	al,1
		jnc	.yreg
		push	ax
		PULSW	XREG
		pop	ax
		add	CYCLE,2
; Y
.yreg:
		shr	al,1
		jnc	.ureg
		push	ax
		PULSW	YREG
		pop	ax
		add	CYCLE,2
; U
.ureg:
		shr	al,1
		jnc	.pcreg
		push	ax
		PULSW	UREG
		pop	ax
		add	CYCLE,2
; PC
.pcreg:
		shr	al,1
		jnc	.exit
		PULSW	PCREG
		add	CYCLE,2
.exit:
		ret

;
; $36
; PSHU
;
pshu_in:
		IMMB
; PC
.pcreg:
		add	al,al
		jnc	.sreg
		push	ax
		PSHUW	PCREG
		pop	ax
		add	CYCLE,2
; S
.sreg:
		add	al,al
		jnc	.yreg
		push	ax
		PSHUW	UREG
		pop	ax
		add	CYCLE,2
; Y
.yreg:
		add	al,al
		jnc	.xreg
		push	ax
		PSHUW	YREG
		pop	ax
		add	CYCLE,2
; X
.xreg:
		add	al,al
		jnc	.dpreg
		push	ax
		PSHUW	XREG
		pop	ax
		add	CYCLE,2
; DP
.dpreg:
		add	al,al
		jnc	.breg
		push	ax
		PSHUB	DPREG
		pop	ax
		inc	CYCLE
; B
.breg:
		add	al,al
		jnc	.areg
		push	ax
		PSHUB	BREG
		pop	ax
		inc	CYCLE
; A
.areg:
		add	al,al
		jnc	.ccreg
		push	ax
		PSHUB	AREG
		pop	ax
		inc	CYCLE
; CC
.ccreg:
		add	al,al
		jnc	.exit
		PSHUB	CCREG
		inc	CYCLE
.exit:
		ret

;
; $37
; PULU
;
pulu_in:
		IMMB
; CC
.ccreg:
		shr	al,1
		jnc	.areg
		push	ax
		PULUB	CCREG
		pop	ax
		inc	CYCLE
; A
.areg:
		shr	al,1
		jnc	.breg
		push	ax
		PULUB	AREG
		pop	ax
		inc	CYCLE
; B
.breg:
		shr	al,1
		jnc	.dpreg
		push	ax
		PULUB	BREG
		pop	ax
		inc	CYCLE
; DP
.dpreg:
		shr	al,1
		jnc	.xreg
		push	ax
		PULUB	DPREG
		pop	ax
		inc	CYCLE
; X
.xreg:
		shr	al,1
		jnc	.yreg
		push	ax
		PULUW	XREG
		pop	ax
		add	CYCLE,2
; Y
.yreg:
		shr	al,1
		jnc	.sreg
		push	ax
		PULUW	YREG
		pop	ax
		add	CYCLE,2
; S
.sreg:
		shr	al,1
		jnc	.pcreg
		push	ax
		PULUW	SREG
		pop	ax
		add	CYCLE,2
; PC
.pcreg:
		shr	al,1
		jnc	.exit
		PULUW	PCREG
		add	CYCLE,2
.exit:
		ret

;
; $39
; RTS
;
rts_in:
		PULSW	PCREG
		ret

;
; $3A
; ABX
;
abx_in:
		xor	ah,ah
		mov	al,BREG
		add	XREG,ax
		ret

;
; $3B
; RTI
;
rti_in:
		PULSB	CCREG
; EtO
		test	CCREG,80h
		jnz	.nmiirq
; FIRQ
		PULSW	PCREG
		ret
; NMI,IRQ
.nmiirq:
		PULSB	AREG
		PULSB	BREG
		PULSB	DPREG
		PULSW	XREG
		PULSW	YREG
		PULSW	UREG
		PULSW	PCREG
		add	CYCLE,9
		ret

;
; $3C
; CWAI
;
cwai_im:
		test	INTR,0080h
		jnz	.next
; 񏉂߂CWAIs
		IMMB
		and	CCREG,al
		or	INTR,0080h
		and	INTR,0feffh
		sub	PCREG,2
		ret
; CWAIs
.next:
		test	INTR,0100h
		jnz	.exit
		dec	PCREG
		ret
; 荞݂āARTǏ
.exit:
		and	INTR,0fe7fh
		inc	PCREG
		ret

;
; $3D
; MUL
;
mul_in:
		mov	al,AREG
		mul	BREG
		mov	DREG,ax
		and	CCREG,0fah
		or	ax,ax
		jnz	.cy
		SET_Z
.cy:
		shr	al,7
		or	CCREG,al
		ret

;
; $3E
; RST
;
rst_in:
		call	cpu_reset
		ret

;
; $3F
; SWI
;
swi_in:
		or	CCREG,80h
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
		mov	bp,0fffah
		READW
		mov	PCREG,ax
; SWÎ
		or	CCREG,50h
		ret

;
; $10 $3F
; SWI2
;
swi2_in:
		or	CCREG,80h
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
		mov	bp,0fff4h
		READW
		mov	PCREG,ax
		ret
;
; $11 $3F
; SWI3
;
swi3_in:
		or	CCREG,80h
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
		mov	bp,0fff2h
		READW
		mov	PCREG,ax
		ret

;
; $40
; NEGA
;
nega_in:
		NEGB	AREG
		ret

;
; $42
; NGCA
;
ngca_in:
		test	CCREG,01h
		jz	nega_in

;
; $43
; COMA
;
coma_in:
		COMB	AREG
		ret

;
; $44
; LSRA
;
lsra_in:
		LSRB	AREG
		ret

;
; $46
; RORA
;
rora_in:
		RORB	AREG
		ret

;
; $47
; ASRA
;
asra_in:
		ASRB	AREG
		ret

;
; $48
; LSLA
;
lsla_in:
		LSLB	AREG
		ret

;
; $49
; ROLA
;
rola_in:
		ROLB	AREG
		ret

;
; $4A
; DECA
;
deca_in:
		DECB	AREG
		ret

;
; $4B
; DCCA
;
dcca_in:
		DCCB	AREG
		ret

;
; $4C
; INCA
;
inca_in:
		INCB	AREG
		ret

;
; $4D
; TSTA
;
tsta_in:
		TSTB	AREG
		ret

;
; $4E
; CLCA
;
clca_in:
		CLCB	AREG
		ret

;
; $4F
; CLRA
;
clra_in:
		CLRB	AREG
		ret

;
; $50
; NEGB
;
negb_in:
		NEGB	BREG
		ret

;
; $52
; NGCB
;
ngcb_in:
		test	CCREG,01h
		jz	negb_in

;
; $53
; COMB
;
comb_in:
		COMB	BREG
		ret

;
; $54
; LSRB
;
lsrb_in:
		LSRB	BREG
		ret

;
; $56
; RORB
;
rorb_in:
		RORB	BREG
		ret

;
; $57
; ASRB
;
asrb_in:
		ASRB	BREG
		ret

;
; $58
; LSLB
;
lslb_in:
		LSLB	BREG
		ret

;
; $59
; ROLB
;
rolb_in:
		ROLB	BREG
		ret

;
; $5A
; DECB
;
decb_in:
		DECB	BREG
		ret

;
; $5B
; DCCB
;
dccb_in:
		DCCB	BREG
		ret

;
; $5C
; INCB
;
incb_in:
		INCB	BREG
		ret

;
; $5D
; TSTB
;
tstb_in:
		TSTB	BREG
		ret

;
; $5E
; CLCB
;
clcb_in:
		CLCB	BREG
		ret

;
; $5F
; CLRB
;
clrb_in:
		CLRB	BREG
		ret

;
; $60
; NEG (IDX)
;
neg_ix:
		NEGM
		ret

;
; $62
; NGC (IDX)
;
ngc_ix:
		test	CCREG,01h
		jz	neg_ix

;
; $63
; COM (IDX)
;
com_ix:
		COMM
		ret

;
; $64
; LSR (IDX)
;
lsr_ix:
		LSRM
		ret

;
; $66
; ROR (IDX)
;
ror_ix:
		RORM
		ret

;
; $67
; ASR (IDX)
;
asr_ix:
		ASRM
		ret

;
; $68
; LSL (IDX)
;
lsl_ix:
		LSLM
		ret

;
; $69
; ROL (IDX)
;
rol_ix:
		ROLM
		ret

;
; $6A
; DEC (IDX)
;
dec_ix:
		DECM
		ret

;
; $6B
; DCC (IDX)
;
dcc_ix:
		DCCM
		ret

;
; $6C
; INC (IDX)
;
inc_ix:
		INCM
		ret

;
; $6D
; TST (IDX)
;
tst_ix:
		TSTM
		ret

;
; $6E
; JMP (IDX)
;
jmp_ix:
		JUMPAB
		ret

;
; $6F
; CLR (IDX)
;
clr_ix:
		CLRM
		ret

;
; $70
; NEG (EXT)
;
neg_ex:
		EXTEND
		NEGM
		ret

;
; $72
; NGC (EXT)
;
ngc_ex:
		test	CCREG,01h
		jz	neg_ex

;
; $73
; COM (EXT)
;
com_ex:
		EXTEND
		COMM
		ret

;
; $74
; LSR (EXT)
;
lsr_ex:
		EXTEND
		LSRM
		ret

;
; $76
; ROR (EXT)
;
ror_ex:
		EXTEND
		RORM
		ret

;
; $77
; ASR (EXT)
;
asr_ex:
		EXTEND
		ASRM
		ret

;
; $78
; LSL (EXT)
;
lsl_ex:
		EXTEND
		LSLM
		ret

;
; $79
; ROL (EXT)
;
rol_ex:
		EXTEND
		ROLM
		ret

;
; $7A
; DEC (EXT)
;
dec_ex:
		EXTEND
		DECM
		ret

;
; $7B
; DCC (EXT)
;
dcc_ex:
		EXTEND
		DCCM
		ret

;
; $7C
; INC (EXT)
;
inc_ex:
		EXTEND
		INCM
		ret

;
; $7D
; TST (EXT)
;
tst_ex:
		EXTEND
		TSTM
		ret

;
; $7E
; JMP (EXT)
;
jmp_ex:
		EXTEND
		JUMPAB
		ret

;
; $7F
; CLR (EXT)
;
clr_ex:
		EXTEND
		CLRM
		ret

;
; $80
; SUBA (IMM)
;
suba_im:
		IMMB
		SUBB	AREG
		ret

;
; $81
; CMPA (IMM)
;
cmpa_im:
		IMMB
		CMPB	AREG
		ret

;
; $82
; SBCA (IMM)
;
sbca_im:
		IMMB
		SBCB	AREG
		ret

;
; $83
; SUBD (IMM)
;
subd_im:
		IMMW
		SUBW	DREG
		ret

;
; $10 $83
; CMPD (IMM)
;
cmpd_im:
		IMMW
		CMPW	DREG
		ret

;
; $11 $83
; CMPU (IMM)
;
cmpu_im:
		IMMW
		CMPW	UREG
		ret

;
; $84
; ANDA (IMM)
;
anda_im:
		IMMB
		ANDB	AREG
		ret

;
; $85
; BITA (IMM)
;
bita_im:
		IMMB
		BITB	AREG
		ret

;
; $86
; LDA (IMM)
;
lda_im:
		IMMB
		LOADB	AREG
		ret

;
; $87
; FLAG8 (IMM)
;
flag8_im:
		IMMB
		CLR_NZV
		or	CCREG,08h
		ret

;
; $88
; EORA (IMM)
;
eora_im:
		IMMB
		EORB	AREG
		ret

;
; $89
; ADCA (IMM)
;
adca_im:
		IMMB
		ADCB	AREG
		ret

;
; $8A
; ORA (IMM)
;
ora_im:
		IMMB
		ORB	AREG
		ret

;
; $8B
; ADDA (IMM)
;
adda_im:
		IMMB
		ADDB	AREG
		ret

;
; $8C
; CMPX (IMM)
;
cmpx_im:
		IMMW
		CMPW	XREG
		ret

;
; $11 $8C
; CMPS (IMM)
;
cmps_im:
		IMMW
		CMPW	SREG
		ret

;
; $10 $8C
; CMPY (IMM)
;
cmpy_im:
		IMMW
		CMPW	YREG
		ret

;
; $8D
; BSR
;
bsr_re:
		IMMB
		cbw
		BRANCHSR
		ret

;
; $8E
; LDX (IMM)
;
ldx_im:
		IMMW
		LOADW	XREG
		ret

;
; $10 $8E
; LDY (IMM)
;
ldy_im:
		IMMW
		LOADW	YREG
		ret

; $8F
; FLAG16 (IMM)
;
flag16_im:
		IMMW
		CLR_NZV
		or	CCREG,08h
		ret

;
; $90
; SUBA (DIR)
;
suba_di:
		DIRECT
		READB
		SUBB	AREG
		ret

;
; $91
; CMPA (DIR)
;
cmpa_di:
		DIRECT
		READB
		CMPB	AREG
		ret

;
; $92
; SBCA (DIR)
;
sbca_di:
		DIRECT
		READB
		SBCB	AREG
		ret

;
; $93
; SUBD (DIR)
;
subd_di:
		DIRECT
		READW
		SUBW	DREG
		ret

;
; $10 $93
; CMPD (DIR)
;
cmpd_di:
		DIRECT
		READW
		CMPW	DREG
		ret

;
; $11 $93
; CMPU (DIR)
;
cmpu_di:
		DIRECT
		READW
		CMPW	UREG
		ret

;
; $94
; ANDA (DIR)
;
anda_di:
		DIRECT
		READB
		ANDB	AREG
		ret

;
; $95
; BITA (DIR)
;
bita_di:
		DIRECT
		READB
		BITB	AREG
		ret

;
; $96
; LDA (DIR)
;
lda_di:
		DIRECT
		READB
		LOADB	AREG
		ret

;
; $97
; STA (DIR)
;
sta_di:
		DIRECT
		STOREB	AREG
		ret

;
; $98
; EORA (DIR)
;
eora_di:
		DIRECT
		READB
		EORB	AREG
		ret

;
; $99
; ADCA (DIR)
;
adca_di:
		DIRECT
		READB
		ADCB	AREG
		ret

;
; $9A
; ORA (DIR)
;
ora_di:
		DIRECT
		READB
		ORB	AREG
		ret

;
; $9B
; ADDA (DIR)
;
adda_di:
		DIRECT
		READB
		ADDB	AREG
		ret

;
; $9C
; CMPX (DIR)
;
cmpx_di:
		DIRECT
		READW
		CMPW	XREG
		ret

;
; $11 $9C
; CMPS (DIR)
;
cmps_di:
		DIRECT
		READW
		CMPW	SREG
		ret

;
; $10 $9C
; CMPY (DIR)
;
cmpy_di:
		DIRECT
		READW
		CMPW	YREG
		ret

;
; $9D
; JSR (DIR)
;
jsr_di:
		DIRECT
		JUMPSR
		ret

;
; $9E
; LDX (DIR)
;
ldx_di:
		DIRECT
		READW
		LOADW	XREG
		ret

;
; $10 $9E
; LDY (DIR)
;
ldy_di:
		DIRECT
		READW
		LOADW	YREG
		ret

;
; $9F
; STX (DIR)
;
stx_di:
		DIRECT
		STOREW	XREG
		ret

;
; $10 $9F
; STY (DIR)
;
sty_di:
		DIRECT
		STOREW	YREG
		ret

;
; $A0
; SUBA (IDX)
;
suba_ix:
		READB
		SUBB	AREG
		ret

;
; $A1
; CMPA (IDX)
;
cmpa_ix:
		READB
		CMPB	AREG
		ret

;
; $A2
; SBCA (IDX)
;
sbca_ix:
		READB
		SBCB	AREG
		ret

;
; $A3
; SUBD (IDX)
;
subd_ix:
		READW
		SUBW	DREG
		ret

;
; $10 $A3
; CMPD (IDX)
;
cmpd_ix:
		READW
		CMPW	DREG
		ret

;
; $11 $A3
; CMPU (IDX)
;
cmpu_ix:
		READW
		CMPW	UREG
		ret

;
; $A4
; ANDA (IDX)
;
anda_ix:
		READB
		ANDB	AREG
		ret

;
; $A5
; BITA (IDX)
;
bita_ix:
		READB
		BITB	AREG
		ret

;
; $A6
; LDA (IDX)
;
lda_ix:
		READB
		LOADB	AREG
		ret

;
; $A7
; STA (IDX)
;
sta_ix:
		STOREB	AREG
		ret

;
; $A8
; EORA (IDX)
;
eora_ix:
		READB
		EORB	AREG
		ret

;
; $A9
; ADCA (IDX)
;
adca_ix:
		READB
		ADCB	AREG
		ret

;
; $AA
; ORA (IDX)
;
ora_ix:
		READB
		ORB	AREG
		ret

;
; $AB
; ADDA (IDX)
;
adda_ix:
		READB
		ADDB	AREG
		ret

;
; $AC
; CMPX (IDX)
;
cmpx_ix:
		READW
		CMPW	XREG
		ret

;
; $11 $AC
; CMPS (IDX)
;
cmps_ix:
		READW
		CMPW	SREG
		ret

;
; $10 $AC
; CMPY (IDX)
;
cmpy_ix:
		READW
		CMPW	YREG
		ret

;
; $AD
; JSR (IDX)
;
jsr_ix:
		JUMPSR
		ret

;
; $AE
; LDX (IDX)
;
ldx_ix:
		READW
		LOADW	XREG
		ret

;
; $10 AE
; LDY (IDX)
;
ldy_ix:
		READW
		LOADW	YREG
		ret

;
; $AF
; STX (IDX)
;
stx_ix:
		STOREW	XREG
		ret

;
; $10 $AF
; STY (IDX)
;
sty_ix:
		STOREW	YREG
		ret

;
; $B0
; SUBA (EXT)
;
suba_ex:
		EXTEND
		READB
		SUBB	AREG
		ret

;
; $B1
; CMPA (EXT)
;
cmpa_ex:
		EXTEND
		READB
		CMPB	AREG
		ret

;
; $B2
; SBCA (EXT)
;
sbca_ex:
		EXTEND
		READB
		SBCB	AREG
		ret

;
; $B3
; SUBD (EXT)
;
subd_ex:
		EXTEND
		READW
		SUBW	DREG
		ret

;
; $10 $B3
; CMPD (EXT)
;
cmpd_ex:
		EXTEND
		READW
		CMPW	DREG
		ret

;
; $11 $B3
; CMPU (EXT)
;
cmpu_ex:
		EXTEND
		READW
		CMPW	UREG
		ret

;
; $B4
; ANDA (EXT)
;
anda_ex:
		EXTEND
		READB
		ANDB	AREG
		ret

;
; $B5
; BITA (EXT)
;
bita_ex:
		EXTEND
		READB
		BITB	AREG
		ret

;
; $B6
; LDA (EXT)
;
lda_ex:
		EXTEND
		READB
		LOADB	AREG
		ret

;
; $B7
; STA (EXT)
;
sta_ex:
		EXTEND
		STOREB	AREG
		ret

;
; $B8
; EORA (EXT)
;
eora_ex:
		EXTEND
		READB
		EORB	AREG
		ret

;
; $B9
; ADCA (EXT)
;
adca_ex:
		EXTEND
		READB
		ADCB	AREG
		ret

;
; $BA
; ORA (EXT)
;
ora_ex:
		EXTEND
		READB
		ORB	AREG
		ret

;
; $BB
; ADDA (EXT)
;
adda_ex:
		EXTEND
		READB
		ADDB	AREG
		ret

;
; $BC
; CMPX (EXT)
;
cmpx_ex:
		EXTEND
		READW
		CMPW	XREG
		ret

;
; $11 $BC
; CMPS (EXT)
;
cmps_ex:
		EXTEND
		READW
		CMPW	SREG
		ret

;
; $10 $BC
; CMPY (EXT)
;
cmpy_ex:
		EXTEND
		READW
		CMPW	YREG
		ret

;
; $BD
; JSR (EXT)
;
jsr_ex:
		EXTEND
		JUMPSR
		ret

;
; $BE
; LDX (EXT)
;
ldx_ex:
		EXTEND
		READW
		LOADW	XREG
		ret

;
; $10 BE
; LDY (EXT)
;
ldy_ex:
		EXTEND
		READW
		LOADW	YREG
		ret

;
; $BF
; STX (EXT)
;
stx_ex:
		EXTEND
		STOREW	XREG
		ret

;
; $10 $BF
; STY (EXT)
;
sty_ex:
		EXTEND
		STOREW	YREG
		ret

;
; $C0
; SUBB (IMM)
;
subb_im:
		IMMB
		SUBB	BREG
		ret

;
; $C1
; CMPB (IMM)
;
cmpb_im:
		IMMB
		CMPB	BREG
		ret

;
; $C2
; SBCB (IMM)
;
sbcb_im:
		IMMB
		SBCB	BREG
		ret

;
; $C3
; ADDD (IMM)
;
addd_im:
		IMMW
		ADDW	DREG
		ret

;
; $C4
; ANDB (IMM)
;
andb_im:
		IMMB
		ANDB	BREG
		ret

;
; $C5
; BITB (IMM)
;
bitb_im:
		IMMB
		BITB	BREG
		ret

;
; $C6
; LDB (IMM)
;
ldb_im:
		IMMB
		LOADB	BREG
		ret

;
; $C8
; EORB (IMM)
;
eorb_im:
		IMMB
		EORB	BREG
		ret

;
; $C9
; ADCB (IMM)
;
adcb_im:
		IMMB
		ADCB	BREG
		ret

;
; $CA
; ORB (IMM)
;
orb_im:
		IMMB
		ORB	BREG
		ret

;
; $CB
; ADDB (IMM)
;
addb_im:
		IMMB
		ADDB	BREG
		ret

;
; $CC
; LDD (IMM)
;
ldd_im:
		IMMW
		LOADW	DREG
		ret

;
; $CE
; LDU (IMM)
;
ldu_im:
		IMMW
		LOADW	UREG
		ret

;
; $10 $CE
; LDS (IMM)
;
lds_im:
		IMMW
		LOADW	SREG
; NMI
		or	INTR,0010h
		ret

;
; $D0
; SUBB (DIR)
;
subb_di:
		DIRECT
		READB
		SUBB	BREG
		ret

;
; $D1
; CMPB (DIR)
;
cmpb_di:
		DIRECT
		READB
		CMPB	BREG
		ret

;
; $D2
; SBCB (DIR)
;
sbcb_di:
		DIRECT
		READB
		SBCB	BREG
		ret

;
; $D3
; ADDD (DIR)
;
addd_di:
		DIRECT
		READW
		ADDW	DREG
		ret

;
; $D4
; ANDB (DIR)
;
andb_di:
		DIRECT
		READB
		ANDB	BREG
		ret

;
; $D5
; BITB (DIR)
;
bitb_di:
		DIRECT
		READB
		BITB	BREG
		ret

;
; $D6
; LDB (DIR)
;
ldb_di:
		DIRECT
		READB
		LOADB	BREG
		ret

;
; $D7
; STB (DIR)
;
stb_di:
		DIRECT
		STOREB	BREG
		ret

;
; $D8
; EORB (DIR)
;
eorb_di:
		DIRECT
		READB
		EORB	BREG
		ret

;
; $D9
; ADCB (DIR)
;
adcb_di:
		DIRECT
		READB
		ADCB	BREG
		ret

;
; $DA
; ORB (DIR)
;
orb_di:
		DIRECT
		READB
		ORB	BREG
		ret

;
; $DB
; ADDB (DIR)
;
addb_di:
		DIRECT
		READB
		ADDB	BREG
		ret

;
; $DC
; LDD (DIR)
;
ldd_di:
		DIRECT
		READW
		LOADW	DREG
		ret

;
; $DD
; STD (DIR)
;
std_di:
		DIRECT
		STOREW	DREG
		ret

;
; $DE
; LDU (DIR)
;
ldu_di:
		DIRECT
		READW
		LOADW	UREG
		ret

;
; $10 $DE
; LDS (DIR)
;
lds_di:
		DIRECT
		READW
		LOADW	SREG
; NMI
		or	INTR,0010h
		ret

;
; $DF
; STU (DIR)
;
stu_di:
		DIRECT
		STOREW	UREG
		ret

;
; $10 $DF
; STS (DIR)
;
sts_di:
		DIRECT
		STOREW	SREG
		ret

;
; $E0
; SUBB (IDX)
;
subb_ix:
		READB
		SUBB	BREG
		ret

;
; $E1
; CMPB (IDX)
;
cmpb_ix:
		READB
		CMPB	BREG
		ret

;
; $E2
; SBCB (IDX)
;
sbcb_ix:
		READB
		SBCB	BREG
		ret

;
; $E3
; ADDD (IDX)
;
addd_ix:
		READW
		ADDW	DREG
		ret

;
; $E4
; ANDB (IDX)
;
andb_ix:
		READB
		ANDB	BREG
		ret

;
; $E5
; BITB (IDX)
;
bitb_ix:
		READB
		BITB	BREG
		ret

;
; $E6
; LDB (IDX)
;
ldb_ix:
		READB
		LOADB	BREG
		ret

;
; $E7
; STB (IDX)
;
stb_ix:
		STOREB	BREG
		ret

;
; $E8
; EORB (IDX)
;
eorb_ix:
		READB
		EORB	BREG
		ret

;
; $E9
; ADCB (IDX)
;
adcb_ix:
		READB
		ADCB	BREG
		ret

;
; $EA
; ORB (IDX)
;
orb_ix:
		READB
		ORB	BREG
		ret

;
; $EB
; ADDB (IDX)
;
addb_ix:
		READB
		ADDB	BREG
		ret

;
; $EC
; LDD (IDX)
;
ldd_ix:
		READW
		LOADW	DREG
		ret

;
; $ED
; STD (IDX)
;
std_ix:
		STOREW	DREG
		ret

;
; $EE
; LDU (IDX)
;
ldu_ix:
		READW
		LOADW	UREG
		ret

;
; $10 $EE
; LDS (IDX)
;
lds_ix:
		READW
		LOADW	SREG
; NMI
		or	INTR,0010h
		ret

;
; $EF
; STU (IDX)
;
stu_ix:
		STOREW	UREG
		ret

;
; $10 $EF
; STS (IDX)
;
sts_ix:
		STOREW	SREG
		ret

;
; $F0
; SUBB (EXT)
;
subb_ex:
		EXTEND
		READB
		SUBB	BREG
		ret

;
; $F1
; CMPB (EXT)
;
cmpb_ex:
		EXTEND
		READB
		CMPB	BREG
		ret

;
; $F2
; SBCB (EXT)
;
sbcb_ex:
		EXTEND
		READB
		SBCB	BREG
		ret

;
; $F3
; ADDD (EXT)
;
addd_ex:
		EXTEND
		READW
		ADDW	DREG
		ret

;
; $F4
; ANDB (EXT)
;
andb_ex:
		EXTEND
		READB
		ANDB	BREG
		ret

;
; $F5
; BITB (EXT)
;
bitb_ex:
		EXTEND
		READB
		BITB	BREG
		ret

;
; $F6
; LDB (EXT)
;
ldb_ex:
		EXTEND
		READB
		LOADB	BREG
		ret

;
; $F7
; STB (EXT)
;
stb_ex:
		EXTEND
		STOREB	BREG
		ret

;
; $F8
; EORB (EXT)
;
eorb_ex:
		EXTEND
		READB
		EORB	BREG
		ret

;
; $F9
; ADCB (EXT)
;
adcb_ex:
		EXTEND
		READB
		ADCB	BREG
		ret

;
; $FA
; ORB (EXT)
;
orb_ex:
		EXTEND
		READB
		ORB	BREG
		ret

;
; $FB
; ADDB (EXT)
;
addb_ex:
		EXTEND
		READB
		ADDB	BREG
		ret

;
; $FC
; LDD (EXT)
;
ldd_ex:
		EXTEND
		READW
		LOADW	DREG
		ret

;
; $FD
; STD (EXT)
;
std_ex:
		EXTEND
		STOREW	DREG
		ret

;
; $FE
; LDU (EXT)
;
ldu_ex:
		EXTEND
		READW
		LOADW	UREG
		ret

;
; $10 FE
; LDS (EXT)
;
lds_ex:
		EXTEND
		READW
		LOADW	SREG
; NMI
		or	INTR,0010h
		ret

;
; $FF
; STU (EXT)
;
stu_ex:
		EXTEND
		STOREW	UREG
		ret

;
; $10 $FF
; STS (EXT)
;
sts_ex:
		EXTEND
		STOREW	SREG
		ret

;
; Wve[uP
;
jump_table1:
; $00
		ADDR	neg_di
		ADDR	neg_di
		ADDR	ngc_di
		ADDR	com_di
		ADDR	lsr_di
		ADDR	lsr_di
		ADDR	ror_di
		ADDR	asr_di
		ADDR	lsl_di
		ADDR	rol_di
		ADDR	dec_di
		ADDR	dcc_di
		ADDR	inc_di
		ADDR	tst_di
		ADDR	jmp_di
		ADDR	clr_di
; $10
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	nop_in
		ADDR	sync_in
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	lbra_re
		ADDR	lbsr_re
		ADDR	aslcc_in
		ADDR	daa_in
		ADDR	orcc_im
		ADDR	nop_in
		ADDR	andcc_im
		ADDR	sex_in
		ADDR	exg_in
		ADDR	tfr_in
; $20
		ADDR	bra_re
		ADDR	brn_re
		ADDR	bhi_re
		ADDR	bls_re
		ADDR	bcc_re
		ADDR	bcs_re
		ADDR	bne_re
		ADDR	beq_re
		ADDR	bvc_re
		ADDR	bvs_re
		ADDR	bpl_re
		ADDR	bmi_re
		ADDR	bge_re
		ADDR	blt_re
		ADDR	bgt_re
		ADDR	ble_re
; $30
		ADDR	leax_ix
		ADDR	leay_ix
		ADDR	leas_ix
		ADDR	leau_ix
		ADDR	pshs_in
		ADDR	puls_in
		ADDR	pshu_in
		ADDR	pulu_in
		ADDR	andcc_im
		ADDR	rts_in
		ADDR	abx_in
		ADDR	rti_in
		ADDR	cwai_im
		ADDR	mul_in
		ADDR	rst_in
		ADDR	swi_in
; $40
		ADDR	nega_in
		ADDR	nega_in
		ADDR	ngca_in
		ADDR	coma_in
		ADDR	lsra_in
		ADDR	lsra_in
		ADDR	rora_in
		ADDR	asra_in
		ADDR	lsla_in
		ADDR	rola_in
		ADDR	deca_in
		ADDR	dcca_in
		ADDR	inca_in
		ADDR	tsta_in
		ADDR	clca_in
		ADDR	clra_in
; $50
		ADDR	negb_in
		ADDR	negb_in
		ADDR	ngcb_in
		ADDR	comb_in
		ADDR	lsrb_in
		ADDR	lsrb_in
		ADDR	rorb_in
		ADDR	asrb_in
		ADDR	lslb_in
		ADDR	rolb_in
		ADDR	decb_in
		ADDR	dccb_in
		ADDR	incb_in
		ADDR	tstb_in
		ADDR	clcb_in
		ADDR	clrb_in
; $60
		ADDR	neg_ix
		ADDR	neg_ix
		ADDR	ngc_ix
		ADDR	com_ix
		ADDR	lsr_ix
		ADDR	lsr_ix
		ADDR	ror_ix
		ADDR	asr_ix
		ADDR	lsl_ix
		ADDR	rol_ix
		ADDR	dec_ix
		ADDR	dcc_ix
		ADDR	inc_ix
		ADDR	tst_ix
		ADDR	jmp_ix
		ADDR	clr_ix
; $70
		ADDR	neg_ex
		ADDR	neg_ex
		ADDR	ngc_ex
		ADDR	com_ex
		ADDR	lsr_ex
		ADDR	lsr_ex
		ADDR	ror_ex
		ADDR	asr_ex
		ADDR	lsl_ex
		ADDR	rol_ex
		ADDR	dec_ex
		ADDR	dcc_ex
		ADDR	inc_ex
		ADDR	tst_ex
		ADDR	jmp_ex
		ADDR	clr_ex
; $80
		ADDR	suba_im
		ADDR	cmpa_im
		ADDR	sbca_im
		ADDR	subd_im
		ADDR	anda_im
		ADDR	bita_im
		ADDR	lda_im
		ADDR	flag8_im
		ADDR	eora_im
		ADDR	adca_im
		ADDR	ora_im
		ADDR	adda_im
		ADDR	cmpx_im
		ADDR	bsr_re
		ADDR	ldx_im
		ADDR	flag16_im
; $90
		ADDR	suba_di
		ADDR	cmpa_di
		ADDR	sbca_di
		ADDR	subd_di
		ADDR	anda_di
		ADDR	bita_di
		ADDR	lda_di
		ADDR	sta_di
		ADDR	eora_di
		ADDR	adca_di
		ADDR	ora_di
		ADDR	adda_di
		ADDR	cmpx_di
		ADDR	jsr_di
		ADDR	ldx_di
		ADDR	stx_di
; $A0
		ADDR	suba_ix
		ADDR	cmpa_ix
		ADDR	sbca_ix
		ADDR	subd_ix
		ADDR	anda_ix
		ADDR	bita_ix
		ADDR	lda_ix
		ADDR	sta_ix
		ADDR	eora_ix
		ADDR	adca_ix
		ADDR	ora_ix
		ADDR	adda_ix
		ADDR	cmpx_ix
		ADDR	jsr_ix
		ADDR	ldx_ix
		ADDR	stx_ix
; $B0
		ADDR	suba_ex
		ADDR	cmpa_ex
		ADDR	sbca_ex
		ADDR	subd_ex
		ADDR	anda_ex
		ADDR	bita_ex
		ADDR	lda_ex
		ADDR	sta_ex
		ADDR	eora_ex
		ADDR	adca_ex
		ADDR	ora_ex
		ADDR	adda_ex
		ADDR	cmpx_ex
		ADDR	jsr_ex
		ADDR	ldx_ex
		ADDR	stx_ex
; $C0
		ADDR	subb_im
		ADDR	cmpb_im
		ADDR	sbcb_im
		ADDR	addd_im
		ADDR	andb_im
		ADDR	bitb_im
		ADDR	ldb_im
		ADDR	flag8_im
		ADDR	eorb_im
		ADDR	adcb_im
		ADDR	orb_im
		ADDR	addb_im
		ADDR	ldd_im
		ADDR	cpu_error
		ADDR	ldu_im
		ADDR	flag16_im
; $D0
		ADDR	subb_di
		ADDR	cmpb_di
		ADDR	sbcb_di
		ADDR	addd_di
		ADDR	andb_di
		ADDR	bitb_di
		ADDR	ldb_di
		ADDR	stb_di
		ADDR	eorb_di
		ADDR	adcb_di
		ADDR	orb_di
		ADDR	addb_di
		ADDR	ldd_di
		ADDR	std_di
		ADDR	ldu_di
		ADDR	stu_di
; $E0
		ADDR	subb_ix
		ADDR	cmpb_ix
		ADDR	sbcb_ix
		ADDR	addd_ix
		ADDR	andb_ix
		ADDR	bitb_ix
		ADDR	ldb_ix
		ADDR	stb_ix
		ADDR	eorb_ix
		ADDR	adcb_ix
		ADDR	orb_ix
		ADDR	addb_ix
		ADDR	ldd_ix
		ADDR	std_ix
		ADDR	ldu_ix
		ADDR	stu_ix
; $F0
		ADDR	subb_ex
		ADDR	cmpb_ex
		ADDR	sbcb_ex
		ADDR	addd_ex
		ADDR	andb_ex
		ADDR	bitb_ex
		ADDR	ldb_ex
		ADDR	stb_ex
		ADDR	eorb_ex
		ADDR	adcb_ex
		ADDR	orb_ex
		ADDR	addb_ex
		ADDR	ldd_ex
		ADDR	std_ex
		ADDR	ldu_ex
		ADDR	stu_ex

;
; Wve[uQ
;
jump_table2:
; $00
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $10
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $20
		ADDR	cpu_error
		ADDR	lbrn_re
		ADDR	lbhi_re
		ADDR	lbls_re
		ADDR	lbcc_re
		ADDR	lbcs_re
		ADDR	lbne_re
		ADDR	lbeq_re
		ADDR	lbvc_re
		ADDR	lbvs_re
		ADDR	lbpl_re
		ADDR	lbmi_re
		ADDR	lbge_re
		ADDR	lblt_re
		ADDR	lbgt_re
		ADDR	lble_re
; $30
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	swi2_in
; $40
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $50
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $60
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $70
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
; $80
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpd_im
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpy_im
		ADDR	cpu_error
		ADDR	ldy_im
		ADDR	cpu_error
; $90
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpd_di
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpy_di
		ADDR	cpu_error
		ADDR	ldy_di
		ADDR	sty_di
; $A0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpd_ix
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpy_ix
		ADDR	cpu_error
		ADDR	ldy_ix
		ADDR	sty_ix
; $B0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpd_ex
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cmpy_ex
		ADDR	cpu_error
		ADDR	ldy_ex
		ADDR	sty_ex
; $C0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	lds_im
		ADDR	cpu_error
; $D0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	lds_di
		ADDR	sts_di
; $E0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	lds_ix
		ADDR	sts_ix
; $F0
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	cpu_error
		ADDR	lds_ex
		ADDR	sts_ex

;
; Wve[uR
;
jump_table3:
		db	3fh,0
		ADDR	swi3_in
		db	83h, 0
		ADDR	cmpu_im
		db	8ch, 0
		ADDR	cmps_im
		db	093h, 0
		ADDR	cmpu_di
		db	09ch, 0
		ADDR	cmps_di
		db	0a3h, 0
		ADDR	cmpu_ix
		db	0ach, 0
		ADDR	cmps_ix
		db	0b3h, 0
		ADDR	cmpu_ex
		db	0bch, 0
		ADDR	cmps_ex
		db	0,0

;
; CfbNX[h}N
;
		%macro	INORM	1
		mov	bp,%1
		%endmacro
		%macro	INDNORM	1
		mov	bp,%1
		READW
		mov	bp,ax
		%endmacro
		%macro	IINC1	1
		mov	bp,%1
		inc	%1
		add	CYCLE,2
		%endmacro
		%macro	IINC2	1
		mov	bp,%1
		add	%1,2
		add	CYCLE,3
		%endmacro
		%macro	INDINC2	1
		mov	bp,%1
		READW
		mov	bp,ax
		add	%1,2
		add	CYCLE,6
		%endmacro
		%macro	IDEC1	1
		dec	%1
		mov	bp,%1
		add	CYCLE,2
		%endmacro
		%macro	IDEC2	1
		sub	%1,2
		mov	bp,%1
		add	CYCLE,3
		%endmacro
		%macro	INDDEC2	1
		sub	%1,2
		mov	bp,%1
		READW
		mov	bp,ax
		add	CYCLE,6
		%endmacro
		%macro	IAREG	1
		mov	al,AREG
		cbw
		mov	bp,%1
		add	bp,ax
		inc	CYCLE
		%endmacro
		%macro	INDAREG	1
		mov	al,AREG
		cbw
		mov	bp,%1
		add	bp,ax
		READW
		mov	bp,ax
		add	CYCLE,4
		%endmacro
		%macro	IBREG	1
		mov	al,BREG
		cbw
		mov	bp,%1
		add	bp,ax
		inc	CYCLE
		%endmacro
		%macro	INDBREG	1
		mov	al,BREG
		cbw
		mov	bp,%1
		add	bp,ax
		READW
		mov	bp,ax
		add	CYCLE,4
		%endmacro
		%macro	IDREG	1
		mov	bp,%1
		add	bp,DREG
		add	CYCLE,4
		%endmacro
		%macro	INDDREG	1
		mov	bp,%1
		add	bp,DREG
		READW
		mov	bp,ax
		add	CYCLE,7
		%endmacro
		%macro	I8OFF	1
		IMMB
		cbw
		mov	bp,%1
		add	bp,ax
		inc	CYCLE
		%endmacro
		%macro	IND8OFF	1
		IMMB
		cbw
		mov	bp,%1
		add	bp,ax
		READW
		mov	bp,ax
		add	CYCLE,4
		%endmacro
		%macro	I16OFF	1
		IMMW
		mov	bp,%1
		add	bp,ax
		add	CYCLE,4
		%endmacro
		%macro	IND16OFF	1
		IMMW
		mov	bp,%1
		add	bp,ax
		READW
		mov	bp,ax
		add	CYCLE,7
		%endmacro

;
; |XgoCg $80
; ,X+
;
xinc:
		IINC1	XREG
		ret

;
; |XgoCg $81
; ,X++
;
xincinc:
		IINC2	XREG
		ret

;
; |XgoCg $82
; ,-X
;
xdec:
		IDEC1	XREG
		ret

;
; |XgoCg $83
; ,--X
;
xdecdec:
		IDEC2	XREG
		ret

;
; |XgoCg $84
; ,X
;
xnormal:
		INORM	XREG
		ret

;
; |XgoCg $85
; B,X
;
xbreg:
		IBREG	XREG
		ret

;
; |XgoCg $86
; A,X
;
xareg:
		IAREG	XREG
		ret

;
; |XgoCg $88
; 8bit,X
;
x8off:
		I8OFF	XREG
		ret

;
; |XgoCg $89
; 16bit,X
;
x16off:
		I16OFF	XREG
		ret

;
; |XgoCg $8B
; D,X
;
xdreg:
		IDREG	XREG
		ret

;
; |XgoCg $8C,$AC,$CC,$EC
; 8bit,PCR
;
pcr8:
		I8OFF	PCREG
		ret

;
; |XgoCg $8D,$AD,$CD,$ED
; 16bit,PCR
;
pcr16:
		I16OFF	PCREG
		inc	CYCLE
		ret

;
; |XgoCg $91
; [,X++]
;
ixincinc:
		INDINC2	XREG
		ret

;
; |XgoCg $93
; [,--X]
;
ixdecdec:
		INDDEC2	XREG
		ret

;
; |XgoCg $94
; [,X]
;
ixnormal:
		INDNORM	XREG
		ret

;
; |XgoCg $95
; [B,X]
;
ixbreg:
		INDBREG	XREG
		ret

;
; |XgoCg $96
; [A,X]
;
ixareg:
		INDAREG	XREG
		ret

;
; |XgoCg $98
; [8bit,X]
;
ix8off:
		IND8OFF	XREG
		ret

;
; |XgoCg $99
; [16bit,X]
;
ix16off:
		IND16OFF XREG
		ret

;
; |XgoCg $9B
; [D,X]
;
ixdreg:
		INDDREG	XREG
		ret

;
; |XgoCg $9C,$BC,$DC,$FC
; [8bit,PCR]
;
ipcr8:
		IND8OFF PCREG
		ret

;
; |XgoCg $9D,$BD,$DD,$FD
; [16bit,PCR]
;
ipcr16:
		IND16OFF PCREG
		inc	CYCLE
		ret

;
; |XgoCg $9F,$BF,$DF,$FF
; [addr]
;
indirect:
		EXTEND
		READW
		mov	bp,ax
		add	CYCLE,5
		ret

;
; |XgoCg $A0
; ,Y+
;
yinc:
		IINC1	YREG
		ret

;
; |XgoCg $A1
; ,Y++
;
yincinc:
		IINC2	YREG
		ret

;
; |XgoCg $A2
; ,-Y
;
ydec:
		IDEC1	YREG
		ret

;
; |XgoCg $A3
; ,--Y
;
ydecdec:
		IDEC2	YREG
		ret

;
; |XgoCg $A4
; ,Y
;
ynormal:
		INORM	YREG
		ret

;
; |XgoCg $A5
; B,Y
;
ybreg:
		IBREG	YREG
		ret

;
; |XgoCg $A6
; A,Y
;
yareg:
		IAREG	YREG
		ret

;
; |XgoCg $A8
; 8bit,Y
;
y8off:
		I8OFF	YREG
		ret

;
; |XgoCg $A9
; 16bit,S
;
y16off:
		I16OFF	YREG
		ret

;
; |XgoCg $AB
; D,Y
;
ydreg:
		IDREG	YREG
		ret

;
; |XgoCg $B1
; [,Y++]
;
iyincinc:
		INDINC2	YREG
		ret

;
; |XgoCg $B3
; [,--Y]
;
iydecdec:
		INDDEC2	YREG
		ret

;
; |XgoCg $B4
; [,Y]
;
iynormal:
		INDNORM	YREG
		ret

;
; |XgoCg $B5
; [B,Y]
;
iybreg:
		INDBREG	YREG
		ret

;
; |XgoCg $B6
; [A,Y]
;
iyareg:
		INDAREG	YREG
		ret

;
; |XgoCg $B8
; [8bit,Y]
;
iy8off:
		IND8OFF	YREG
		ret

;
; |XgoCg $B9
; [16bit,Y]
;
iy16off:
		IND16OFF YREG
		ret

;
; |XgoCg $BB
; [D,Y]
;
iydreg:
		INDDREG	YREG
		ret

;
; |XgoCg $C0
; ,U+
;
uinc:
		IINC1	UREG
		ret

;
; |XgoCg $C1
; ,U++
;
uincinc:
		IINC2	UREG
		ret

;
; |XgoCg $C2
; ,-U
;
udec:
		IDEC1	UREG
		ret

;
; |XgoCg $C3
; ,--U
;
udecdec:
		IDEC2	UREG
		ret

;
; |XgoCg $C4
; ,U
;
unormal:
		INORM	UREG
		ret

;
; |XgoCg $C5
; B,U
;
ubreg:
		IBREG	UREG
		ret

;
; |XgoCg $C6
; A,U
;
uareg:
		IAREG	UREG
		ret

;
; |XgoCg $C8
; 8bit,U
;
u8off:
		I8OFF	UREG
		ret

;
; |XgoCg $C9
; 16bit,U
;
u16off:
		I16OFF	UREG
		ret

;
; |XgoCg $CB
; D,U
;
udreg:
		IDREG	UREG
		ret

;
; |XgoCg $D1
; [,U++]
;
iuincinc:
		INDINC2	UREG
		ret

;
; |XgoCg $D3
; [,--U]
;
iudecdec:
		INDDEC2	UREG
		ret

;
; |XgoCg $D4
; [,U]
;
iunormal:
		INDNORM	UREG
		ret

;
; |XgoCg $D5
; [B,U]
;
iubreg:
		INDBREG	UREG
		ret

;
; |XgoCg $D6
; [A,U]
;
iuareg:
		INDAREG	UREG
		ret

;
; |XgoCg $D8
; [8bit,U]
;
iu8off:
		IND8OFF	UREG
		ret

;
; |XgoCg $D9
; [16bit,U]
;
iu16off:
		IND16OFF UREG
		ret

;
; |XgoCg $DB
; [D,U]
;
iudreg:
		INDDREG	UREG
		ret

;
; |XgoCg $E0
; ,S+
;
sinc:
		IINC1	SREG
		ret

;
; |XgoCg $E1
; ,S++
;
sincinc:
		IINC2	SREG
		ret

;
; |XgoCg $E2
; ,-S
;
sdec:
		IDEC1	SREG
		ret

;
; |XgoCg $E3
; ,--S
;
sdecdec:
		IDEC2	SREG
		ret

;
; |XgoCg $E4
; ,S
;
snormal:
		INORM	SREG
		ret

;
; |XgoCg $E5
; B,S
;
sbreg:
		IBREG	SREG
		ret

;
; |XgoCg $E6
; A,S
;
sareg:
		IAREG	SREG
		ret

;
; |XgoCg $E8
; 8bit,S
;
s8off:
		I8OFF	SREG
		ret

;
; |XgoCg $E9
; 16bit,S
;
s16off:
		I16OFF	SREG
		ret

;
; |XgoCg $EB
; D,S
;
sdreg:
		IDREG	SREG
		ret

;
; |XgoCg $F1
; [,S++]
;
isincinc:
		INDINC2	SREG
		ret

;
; |XgoCg $F3
; [,--S]
;
isdecdec:
		INDDEC2	SREG
		ret

;
; |XgoCg $F4
; [,S]
;
isnormal:
		INDNORM	SREG
		ret

;
; |XgoCg $F5
; [B,U]
;
isbreg:
		INDBREG	SREG
		ret

;
; |XgoCg $F6
; [A,S]
;
isareg:
		INDAREG	SREG
		ret

;
; |XgoCg $F8
; [8bit,S]
;
is8off:
		IND8OFF	SREG
		ret

;
; |XgoCg $F9
; [16bit,S]
;
is16off:
		IND16OFF SREG
		ret

;
; |XgoCg $FB
; [D,S]
;
isdreg:
		INDDREG	SREG
		ret

;
; Wve[u(CfbNX)
;
jump_table_idx:
; $80
		ADDR	xinc
		ADDR	xincinc
		ADDR	xdec
		ADDR	xdecdec
		ADDR	xnormal
		ADDR	xbreg
		ADDR	xareg
		ADDR	cpu_error
		ADDR	x8off
		ADDR	x16off
		ADDR	cpu_error
		ADDR	xdreg
		ADDR	pcr8
		ADDR	pcr16
		ADDR	cpu_error
		ADDR	cpu_error
; $90
		ADDR	cpu_error
		ADDR	ixincinc
		ADDR	cpu_error
		ADDR	ixdecdec
		ADDR	ixnormal
		ADDR	ixbreg
		ADDR	ixareg
		ADDR	cpu_error
		ADDR	ix8off
		ADDR	ix16off
		ADDR	cpu_error
		ADDR	ixdreg
		ADDR	ipcr8
		ADDR	ipcr16
		ADDR	cpu_error
		ADDR	indirect
; $A0
		ADDR	yinc
		ADDR	yincinc
		ADDR	ydec
		ADDR	ydecdec
		ADDR	ynormal
		ADDR	ybreg
		ADDR	yareg
		ADDR	cpu_error
		ADDR	y8off
		ADDR	y16off
		ADDR	cpu_error
		ADDR	ydreg
		ADDR	pcr8
		ADDR	pcr16
		ADDR	cpu_error
		ADDR	cpu_error
; $B0
		ADDR	cpu_error
		ADDR	iyincinc
		ADDR	cpu_error
		ADDR	iydecdec
		ADDR	iynormal
		ADDR	iybreg
		ADDR	iyareg
		ADDR	cpu_error
		ADDR	iy8off
		ADDR	iy16off
		ADDR	cpu_error
		ADDR	iydreg
		ADDR	ipcr8
		ADDR	ipcr16
		ADDR	cpu_error
		ADDR	indirect
; $C0
		ADDR	uinc
		ADDR	uincinc
		ADDR	udec
		ADDR	udecdec
		ADDR	unormal
		ADDR	ubreg
		ADDR	uareg
		ADDR	cpu_error
		ADDR	u8off
		ADDR	u16off
		ADDR	cpu_error
		ADDR	udreg
		ADDR	pcr8
		ADDR	pcr16
		ADDR	cpu_error
		ADDR	cpu_error
; $D0
		ADDR	cpu_error
		ADDR	iuincinc
		ADDR	cpu_error
		ADDR	iudecdec
		ADDR	iunormal
		ADDR	iubreg
		ADDR	iuareg
		ADDR	cpu_error
		ADDR	iu8off
		ADDR	iu16off
		ADDR	cpu_error
		ADDR	iudreg
		ADDR	ipcr8
		ADDR	ipcr16
		ADDR	cpu_error
		ADDR	indirect
; $E0
		ADDR	sinc
		ADDR	sincinc
		ADDR	sdec
		ADDR	sdecdec
		ADDR	snormal
		ADDR	sbreg
		ADDR	sareg
		ADDR	cpu_error
		ADDR	s8off
		ADDR	s16off
		ADDR	cpu_error
		ADDR	sdreg
		ADDR	pcr8
		ADDR	pcr16
		ADDR	cpu_error
		ADDR	cpu_error
; $F0
		ADDR	cpu_error
		ADDR	isincinc
		ADDR	cpu_error
		ADDR	isdecdec
		ADDR	isnormal
		ADDR	isbreg
		ADDR	isareg
		ADDR	cpu_error
		ADDR	is8off
		ADDR	is16off
		ADDR	cpu_error
		ADDR	isdreg
		ADDR	ipcr8
		ADDR	ipcr16
		ADDR	cpu_error
		ADDR	indirect

;
; CfbNX[h
;
; param.: bp	PCREG
;	  dh	TCN
; result: bp	EA
;
cpu_index:
; |XgoCg擾
		READB
		inc	PCREG
		inc	bp
; 
		or	al,al
		js	.jump
; 5bit ItZbg
		mov	bp,XREG
		cmp	al,20h
		jc	.bitok
		mov	bp,YREG
		cmp	al,40h
		jc	.bitok
		mov	bp,UREG
		cmp	al,60h
		jc	.bitok
		mov	bp,SREG
.bitok:
		and	al,1fh
		cmp	al,10h
		jnc	.bitminus
; 5bit ItZbg(0`15)
		and	ax,000fh
		add	bp,ax
		inc	CYCLE
		ret
; 5bit ItZbg(-0`-15)
.bitminus:
		or	ax,0fff0h
		add	bp,ax
		inc	CYCLE
		ret
; Wv
.jump:
	%ifdef	__MSDOS__
		mov	di,jump_table_idx
		mov	bl,al
		and	bl,7fh
		xor	bh,bh
		add	bx,bx
		jmp	near [cs:bx+di]
	%else
		mov	edi,jump_table_idx
		xor	ebx,ebx
		mov	bl,al
		and	bl,7fh
		shl	bx,2
		jmp	near [ebx+edi]
	%endif

;
; `߁A͖T|[g
;
cpu_error:
		xor	al,al
		ret

;
; CPUs()
;
cpu_exec:
		mov	cx,INTR
		mov	dl,CCREG
; NMI`FbN
.nmi_chk:
		test	cx,0007h
		jz	.ok
		test	cx,0001h
		jz	.firq_chk
; ~NMI
		or	INTR,0040h
		test	cx,0010h
		jz	.firq_chk
		call	cpu_nmi
		jmp	.ok
; FIRQ`FbN
.firq_chk:
		test	cx,0002h
		jz	.irq_chk
; ~FIRQ
		or	INTR,0040h
		test	dl,040h
		jnz	.irq_chk
		call	cpu_firq
		jmp	.ok
; IRQ`FbN
.irq_chk:
		test	cx,0004h
		jz	.ok
; ~IRQ
		or	INTR,0040h
		test	dl,10h
		jnz	.ok
		call	cpu_irq
; s
.ok:
; Xebvsɑ

;
; CPUXebvs
;
cpu_execline:
; ߃tFb`
		mov	bp,PCREG
		READB
		inc	PCREG
		inc	bp
; TCNe[uPQ
	%ifdef	__MSDOS__
		mov	di,cycle_table1
		mov	bl,al
		xor	bh,bh
		mov	dl,[cs:bx+di]
	%else
		mov	edi,cycle_table1
		xor	ebx,ebx
		mov	bl,al
		mov	dl,[ebx+edi]
	%endif
		cmp	dl,0ffh
		jz	.second
		mov	CYCLE,dx
		and	CYCLE,007fh
		or	dl,dl
		jns	.normal
; CfbNX[h
		push	bx
		call	cpu_index
		pop	bx
; PoCgߌĂяo si=REG bp=PCREG
.normal:
	%ifdef	__MSDOS__
		mov	di,jump_table1
		shl	bx,1
		jmp	near [cs:bx+di]
	%else
		mov	edi,jump_table1
		shl	bx,2
		jmp	near [ebx+edi]
	%endif
; $10 2ndy[W
.second:
		cmp	al,10h
		jnz	.third
		READB
		inc	PCREG
		inc	bp
; TCNe[uQQ
	%ifdef	__MSDOS__
		mov	di,cycle_table2
		mov	bl,al
		xor	bh,bh
		mov	dl,[cs:bx+di]
	%else
		mov	edi,cycle_table2
		xor	ebx,ebx
		mov	bl,al
		mov	dl,[ebx+edi]
	%endif
		mov	CYCLE,dx
		and	CYCLE,007fh
		or	dl,dl
		jns	.sec_norm
; CfbNX[h
		push	bx
		call	cpu_index
		pop	bx
; PoCgߌĂяo si=REG bp=PCREG
.sec_norm:
	%ifdef	__MSDOS__
		mov	di,jump_table2
		shl	bx,1
		jmp	near [cs:bx+di]
	%else
		mov	edi,jump_table2
		shl	bx,2
		jmp	near [ebx+edi]
	%endif
; $11 3rdy[W
.third:
		cmp	al,11h
		jnz	.error
		READB
		inc	PCREG
		inc	bp
; TCNe[uQQ
	%ifdef	__MSDOS__
		mov	di,cycle_table2
		mov	bl,al
		xor	bh,bh
		mov	dl,[cs:bx+di]
	%else
		mov	edi,cycle_table2
		xor	ebx,ebx
		mov	bl,al
		mov	dl,[ebx+edi]
	%endif
		mov	CYCLE,dx
		and	CYCLE,007fh
		or	dl,dl
		jns	.third_ok
; CfbNX[h
		push	ax
		call	cpu_index
		pop	ax
; e[u
.third_ok:
	%ifdef	__MSDOS__
		mov	bx,jump_table3
.third_loop:
		cmp	byte [cs:bx],00h
		jz	.error
		cmp	al,[cs:bx]
		jz	.third_jump
		add	bx,4
		jmp	.third_loop
; TCNo
.third_jump:
		add	bx,2
		jmp	near [cs:bx]
	%else
		mov	ebx,jump_table3
.third_loop:
		cmp	byte [ebx],00h
		jz	.error
		cmp	al,[ebx]
		jz	.third_jump
		add	bx,6
		jmp	.third_loop
; TCNo
.third_jump:
		add	bx,2
		jmp	near [ebx]
	%endif
.error:
		call	cpu_error
		ret

;
; CPUZbg
;
cpu_reset:
		mov	CCREG,50h
		xor	ax,ax
		mov	DPREG,al
		mov	DREG,ax
		mov	XREG,ax
		mov	YREG,ax
		mov	UREG,ax
		mov	SREG,ax
		mov	INTR,ax
		mov	CYCLE,ax
		mov	TOTAL,ax
		mov	bp,0fffeh
		READW
		mov	PCREG,ax
		ret

;
; NMI
;
; param.: si	REG
;	  cx	INTR
;
cpu_nmi:
; CWAI΍
		or	INTR,0100h
; EtOݒ
		or	CCREG,80h
; WX^ޔ
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
; NMI
		or	CCREG,50h
		mov	bp,0fffch
		READW
		mov	PCREG,ax
; tO
		and	INTR,0fffeh
		ret

;
; FIRQ
;
; param.: si	REG
;
cpu_firq:
; CWAI`FbN
		test	INTR,0080h
		jnz	.cwai
; EtONA
		and	CCREG,7fh
; WX^ޔ
		PSHSW	PCREG
		PSHSB	CCREG
; FIRQ
		or	CCREG,50h
		mov	bp,0fff6h
		READW
		mov	PCREG,ax
; tO
		and	INTR,0fffdh
		ret
; CWAȈꍇ́AEtO=1ōŝŒ
.cwai:
		or	INTR,0100h
; EtOݒ
		or	CCREG,80h
; WX^ޔ
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
; FIRQ
		or	CCREG,50h
		mov	bp,0fff6h
		READW
		mov	PCREG,ax
; tO
		and	INTR,0fffdh
		ret

;
; IRQ
;
; param.: si	REG
;
cpu_irq:
; CWAI΍
		or	INTR,0100h
; EtOݒ
		or	CCREG,80h
; WX^ޔ
		PSHSW	PCREG
		PSHSW	UREG
		PSHSW	YREG
		PSHSW	XREG
		PSHSB	DPREG
		PSHSB	BREG
		PSHSB	AREG
		PSHSB	CCREG
; IRQ
		or	CCREG,10h
		mov	bp,0fff8h
		READW
		mov	PCREG,ax
; tO
		and	INTR,0fffbh
		ret

;
; CCPUXebvs
;
%ifdef	_XWIN
main_line:
%else
_main_line:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_maincpu
		call	cpu_execline
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_maincpu
		call	cpu_execline
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif

;
; TuCPUXebvs
;
%ifdef	_XWIN
sub_line:
%else
_sub_line:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_subcpu
		call	cpu_execline
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_subcpu
		call	cpu_execline
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif

;
; CCPUs
;
%ifdef	_XWIN
main_exec:
%else
_main_exec:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_maincpu
		call	cpu_exec
		mov	ax,CYCLE
		add	TOTAL,ax
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_maincpu
		call	cpu_exec
		mov	ax,CYCLE
		add	TOTAL,ax
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif

;
; TuCPUs
;
%ifdef	_XWIN
sub_exec:
%else
_sub_exec:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_subcpu
		call	cpu_exec
		mov	ax,CYCLE
		add	TOTAL,ax
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_subcpu
		call	cpu_exec
		mov	ax,CYCLE
		add	TOTAL,ax
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif


;
; CCPUZbg
;
%ifdef	_XWIN
main_reset:
%else
_main_reset:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_maincpu
		call	cpu_reset
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_maincpu
		call	cpu_reset
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif

;
; TuCPUZbg
;
%ifdef	_XWIN
sub_reset:
%else
_sub_reset:
%endif
	%ifdef	__MSDOS__
		push	si
		push	di
		push	bp
		mov	si,_subcpu
		call	cpu_reset
		pop	bp
		pop	di
		pop	si
		retf
	%else
		push	ebx
		push	esi
		push	edi
		push	ebp
		mov	esi,_subcpu
		call	cpu_reset
		pop	ebp
		pop	edi
		pop	esi
		pop	ebx
		ret
	%endif

;
; vOI
;
		end
