/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ ʒ` ]
 */

#ifndef _xm7_h_
#define _xm7_h_

#include <stdio.h>

/*
 *	萔A^`
 */

/* ėp萔 */
#ifndef FALSE
#define FALSE			0
#define TRUE			(!FALSE)
#endif
#ifndef NULL
#define NULL			((void)0)
#endif

/* ff */
#ifndef ASSERT
#ifdef NDEBUG
#define ASSERT(exp)		((void)0)
#else
#define ASSERT(exp)		assert(exp)
#endif
#endif

/* {^` */
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef int BOOL;

/* CPUWX^` */
typedef struct {
	BYTE cc;
	BYTE dp;
	union {
		struct {
#ifdef _WIN32
			BYTE b;
			BYTE a;
#endif
#ifdef __MSDOS__
			BYTE b;
			BYTE a;
#endif
#ifdef HUMAN68K
			BYTE a;
			BYTE b;
#endif
#ifdef _XWIN
			BYTE b __attribute__((aligned(1)));
			BYTE a __attribute__((aligned(1)));
#endif
		} h;
		WORD d;
	} acc;
	WORD x;
	WORD y;
	WORD u;
	WORD s;
	WORD pc;
	WORD intr;
	WORD cycle;
	WORD total;
	DWORD readmem;
	DWORD writemem;
} cpu6809_t;

/* 荞ݒ` */
#define INTR_NMI		0x0001
#define INTR_FIRQ		0x0002
#define INTR_IRQ		0x0004
#define INTR_RELOAD		0x0008
#define INTR_SLOAD		0x0010
#define INTR_SYNC_IN	0x0020
#define INTR_SYNC_OUT	0x0040
#define INTR_CWAI_IN	0x0080
#define INTR_CWAI_OUT	0x0100

/* u[N|Cg` */
#define BREAKP_NOTUSE	0
#define BREAKP_ENABLED	1
#define BREAKP_DISABLED	2
#define BREAKP_STOPPED	3
#define BREAKP_MAX		8
typedef struct {
	int flag;
	int cpu;
	WORD addr;
} breakp_t;

/* ̑萔 */
#define MAINCPU			0
#define SUBCPU			1

#define BOOT_BASIC		0
#define BOOT_DOS		1

/*
 * t@C`
 */
#define FBASIC_ROM		"FBASIC30.ROM"
#define BOOTBAS_ROM		"BOOT_BAS.ROM"
#define BOOTDOS_ROM		"BOOT_DOS.ROM"
#define SUBSYSC_ROM		"SUBSYS_C.ROM"
#define KANJI_ROM		"KANJI.ROM"

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */

/* VXe(system.c) */
BOOL system_init(void);
										/* VXe  */
void system_cleanup(void);
										/* VXe N[Abv */
void system_reset(void);
										/* VXe Zbg */
BOOL system_save(char *filename);
										/* VXe Z[u */
BOOL system_load(char *filename);
										/* VXe [h */

/* tAZu(disasm.c) */
int disline(int cputype, WORD pc, char *buffer);
										/* PstAZu */

/* CCPU(mainmem.c) */
BOOL mainmem_init(void);				
										/* CCPU  */
void mainmem_cleanup(void);
										/* CCPU N[Abv */
void mainmem_reset(void);
										/* CCPU Zbg */
BYTE mainmem_readb(WORD addr);
										/* CCPU ǂݏo */
BYTE mainmem_readbnio(WORD addr);
										/* CCPU ǂݏo(I/OȂ) */
void mainmem_writeb(WORD addr, BYTE dat);
										/* CCPU  */
BOOL mainmem_save(int fileh);
										/* CCPU Z[u */
BOOL mainmem_load(int fileh, int ver);
										/* CCPU [h */

/* TuCPU(submem.c) */
BOOL submem_init(void);
										/* TuCPU  */
void submem_cleanup(void);
										/* TuCPU N[Abv */
void submem_reset(void);
										/* TuCPU Zbg */
BYTE submem_readb(WORD addr);
										/* TuCPU ǂݏo */
BYTE submem_readbnio(WORD addr);
										/* TuCPU ǂݏo(I/OȂ) */
void submem_writeb(WORD addr, BYTE dat);
										/* TuCPU  */
BOOL submem_save(int fileh);
										/* TuCPU Z[u */
BOOL submem_load(int fileh, int ver);
										/* TuCPU [h */

/* CCPU(maincpu.c) */
BOOL maincpu_init(void);
										/* CCPU  */
void maincpu_cleanup(void);
										/* CCPU N[Abv */
void maincpu_reset(void);
										/* CCPU Zbg */
void maincpu_execline(void);
										/* CCPU Pss */
void maincpu_exec(void);
										/* CCPU s */
void maincpu_firq(void);
										/* CCPU FIRQ荞ݗv */
void maincpu_irq(void);
										/* CCPU IRQ荞ݗv */
BOOL maincpu_save(int fileh);
										/* CCPU Z[u */
BOOL maincpu_load(int fileh, int ver);
										/* CCPU [h */

/* TuCPU(subcpu.c) */
BOOL subcpu_init(void);
										/* TuCPU  */
void subcpu_cleanup(void);
										/* TuCPU N[Abv */
void subcpu_reset(void);
										/* TuCPU Zbg */
void subcpu_execline(void);
										/* TuCPU Pss */
void subcpu_exec(void);
										/* TuCPU s */
void subcpu_nmi(void);
										/* TuCPU NMI荞ݗv */
void subcpu_firq(void);
										/* TuCPU FIRQ荞ݗv */
void subcpu_irq(void);
										/* TuCPU IRQ荞ݗv */
BOOL subcpu_save(int fileh);
										/* TuCPU Z[u */
BOOL subcpu_load(int fileh, int ver);
										/* TuCPU [h */

/* fobK(debug.c) */
BOOL debug_init(void);
										/* fobK  */
void debug_cleanup(void);
										/* fobK N[Abv */
void debug_reset(void);
										/* fobK Zbg */
void debug_run(void);
										/*  */
void debug_trace(void);
										/* XebvC */
void debug_timer(void);
										/* 10ms^C}[ */
BOOL debug_setbreak(int cpu, WORD addr);
										/* u[N|Cgݒ */
BOOL debug_runbreak(void);
										/* u[N|CgZbg */
BOOL debug_chkbreak(void);
										/* u[N|Cg`FbN */
BOOL debug_stopbreak(void);
										/* u[N|CgZbg */
BOOL debug_save(int fileh);
										/* fobK Z[u */
BOOL debug_load(int fileh, int ver);
										/* fobK [h */

/*
 *	v[NGA
 */
extern cpu6809_t maincpu;
										/* CCPU(maincpu.c) */
extern cpu6809_t subcpu;
										/* TuCPU(subcpu.c) */
extern WORD cpu_speed;
										/* CPUx(W0x4700) */
extern breakp_t breakp[BREAKP_MAX];
										/* u[N|Cg(debug.c) */
extern BOOL run_flag;
										/* tO(debug.c) */
extern BOOL stopreq_flag;
										/* ~vtO(debug.c) */
extern BOOL boot_mode;
										/* N[h(system.c) */
extern BYTE *mainram_a;
										/* RAM (\RAM)   $8000 */
extern BYTE *mainram_b;
										/* RAM (RAM)   $7C80 */
extern BYTE *basic_rom;
										/* ROM (F-BASIC) $7C00 */
extern BYTE *main_io;
										/* CCPU I/O $0100 */
extern BYTE *bootbas_rom;
										/* BOOT (BASIC)  $0200 */
extern BYTE *bootdos_rom;
										/* BOOT (DOS)    $0200 */
extern BOOL basicrom_en;
										/* F-BASIC 3.0 ROM Cl[u */
extern BYTE *vram_c;
										/* VRAM(^CvC) $C000 */
extern BYTE *subrom_c;
										/* ROM (^CvC) $2800 */
extern BYTE *sub_ram;
										/* R\[RAM $1380 */
extern BYTE *sub_io;
										/* TuCPU I/O   $0400 */
#ifdef __cplusplus
}
#endif

#endif	/* _xm7_h_ */
