/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 Toshio ISHIZAKA(vh6t-iszk@asahi-net.or.jp)
 *	[ Sound routine for unix-like OSes w/ "Open Sound System" API ]
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "xm7.h"
#include "opn.h"
#include "device.h"
#include "mainetc.h"
#include "cisc.h"
#include "opna.h"
#include "xw.h"

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#ifdef __FreeBSD__
#include <machine/soundcard.h>
#else
#include <linux/soundcard.h>
#endif

/*
 *	static work
 */
static OPN *pOPN;					/* virtual OPN */
static BYTE *pBuffer;				/* output buffer */
static BYTE InCount;				/* data insert counter */
static BYTE* pLoad;					/* data destination */

static char* snd_dev;
static int snd_devfd;

static int sample_rate;
static int sample_size;
static int sample_fmt;
static int beepcount;
static BYTE pres = 3;
static struct timeval snd_tvnow, snd_tvold;

#define BLOCK_LIMIT 16384		// generally enough for almost machine

struct oss_type_t {
	int	sample_rate;
	int	sample_size;
	int	sample_fmt;
} oss_type[] = {
	{ 44000, 16, AFMT_S16_LE },
//	{ 22000, 16, AFMT_S16_LE }, // noisy, hard to hear....disable forever!
	{ 44000,  8, AFMT_U8 },
	{ 22000,  8, AFMT_U8 },
	{    -1, -1, -1}
};

/*
 *	sound initialize
 */
BOOL snd_init(void)
{
	int i, arg, ret;
	
	if( no_fm ){
		snd_devfd = -1;
		return FALSE;
	}

	snd_dev = "/dev/dsp";
	snd_devfd = open( snd_dev, O_WRONLY );

	if( snd_devfd < 0 ){
		printf( "cannot open audio device %s\n", snd_dev );
		return FALSE;
	}
	ret = ioctl( snd_devfd, SNDCTL_DSP_RESET, NULL );
	if( ret < 0 ){
		printf( "cannot reset audio device %s\n", snd_dev );
		close( snd_devfd );
		snd_devfd = -1;
		return FALSE;
	}
	for( i = 0;; i++ ){
		if( oss_type[i].sample_rate < 0 ){
			printf( "cannot find matching configuration\n" );
			close( snd_devfd );
			snd_devfd = -1;
			return FALSE;
		}
		sample_fmt = oss_type[i].sample_fmt;
		ret = ioctl( snd_devfd, SNDCTL_DSP_SETFMT, &sample_fmt );
		if( ret < 0 ) continue;
		arg = 0; /* fixed for 1ch(monoral) */
		ret = ioctl( snd_devfd, SNDCTL_DSP_STEREO, &arg );
		if( ret < 0 ) continue;
		sample_rate = oss_type[i].sample_rate;
		ret = ioctl( snd_devfd, SNDCTL_DSP_SPEED, &sample_rate );
		if( ret < 0 ) continue;
		break;
	}
	/* sample rate  */
	printf( "%dHz/%dbit audio enabled.\n", sample_rate,
			(sample_fmt==AFMT_U8) ? 8 : 16 );

	arg = 1; /* fixed for nonblocking I/O */
	ret = ioctl( snd_devfd, SNDCTL_DSP_NONBLOCK, &arg );
	if( ret < 0 ) {
		printf( "cannot set to NBIO mode\n" );
		close( snd_devfd );
		snd_devfd = -1;
		return FALSE;
	}
	
	sample_size = (sample_fmt==AFMT_U8) ? 1 : 2 ;
	
	/* OPN unit initialize starts here */
	pBuffer = NULL;
	InCount = 0;
	pLoad = NULL;

	/* create OPN unit */
	pOPN = new OPN;
	if( pOPN ) {
		pOPN->Init(1228800, sample_rate, TRUE, NULL);
		pOPN->Reset();
		pOPN->SetReg(0x2e, 0);
		pBuffer = (BYTE *)malloc( BLOCK_LIMIT * sizeof(int) );
		pLoad   = (BYTE *)malloc( BLOCK_LIMIT * 2 );
	}
	bzero( &snd_tvold, sizeof(struct timeval) );
	return TRUE;
}


/*
 *	sound cleanup
 */
void snd_cleanup(void)
{
	if( snd_devfd > 0 ){
		close( snd_devfd );
	}
	
	if( pOPN ) {
		delete pOPN;
		pOPN = NULL;
	}
	
	if( pBuffer ) {
		free( pBuffer );
		pBuffer = NULL;
	}
}

void BeepSnd(int *buf, int samples)
{
	unsigned int half;
	int i;
	
	if (!beep_flag || !speaker_flag) {
		return;
	}
	half = ( sample_rate * 4305) / 10000000;
	
	for (i=0; i<samples; i++) {
		if (beepcount < half) {
			*buf += 0x00000800;
		}
		else {
			*buf -= 0x00000800;
		}
		buf++;
		
		beepcount++;
		if (beepcount >= (half * 2)) {
			beepcount = 0;
		}
	}
}

/*
 *	sound timer
 */
void snd_timer(void)
{
	int i, samples, blksize, *p;
	BYTE *q;
	count_info ci;
	
	if ( !pOPN || !pBuffer || (snd_devfd < 0) ) {
		return;
	}
	
	// calculate sample count to mix
//	samples = sample_rate / 100;	// very easy, but works fine in most case
	gettimeofday( &snd_tvnow, NULL );
	if( (snd_tvold.tv_sec == 0) && (snd_tvold.tv_usec == 0) ){
		bcopy( &snd_tvnow, &snd_tvold, sizeof(struct timeval) );
	}
	timersub( &snd_tvnow, &snd_tvold, &snd_tvold );
	samples = (((snd_tvold.tv_usec) * sample_rate )/ 1000000);
//	printf("! %d\n", samples);

	// check blocksize
	blksize = samples * sample_size;
	if( blksize > BLOCK_LIMIT ) {
//		printf("!maybe heavy....%d\n", samples);
		samples = BLOCK_LIMIT / sample_size;
		blksize = samples * sample_size;
	}
	p = (int *)&pBuffer[ 0 ];
	bzero( p, BLOCK_LIMIT );
	pOPN->Mix( p, samples );
	BeepSnd( p, samples );
	
	// SNDCTL_DSP_GETOSPACE may needed....
	p = (int *)pBuffer;
	q = pLoad;
	if( sample_fmt == AFMT_U8 ) {
		int dat;
		
		for (i = 0; i < samples; i++) {
			dat = *p++;
			q[i] = (dat >> 9)+128;
		}
	}else{
		int dat;
		WORD highlow;
		for( i = 0; i < samples; i++ ) {
			
			dat = *p++;
			highlow = (WORD)(dat & 0xffffL);
			
			if (dat > 0x8000){
				highlow = 0x7fff;
			}else if (dat < -0x8000){
				highlow = 0x8001;
			}
			q[i*2+0] = highlow & 0xFF;
			q[i*2+1] = highlow >> 8;
		}
	}
	InCount = 0;
	write( snd_devfd, pLoad, samples * sample_size );

	// all done
	bcopy( &snd_tvnow, &snd_tvold, sizeof(struct timeval) );
}


void snd_guitimer(void){
	bzero( &snd_tvold, sizeof(struct timeval) );
}


void opn_setb(BYTE reg, BYTE dat){
	if( snd_devfd > 0 ){
		if (opn_scale != pres) {
			pres = opn_scale;
			switch (pres) {
			case 2:
				pOPN->SetReg(0x2f, 0);
				break;
			case 3:
				pOPN->SetReg(0x2e, 0);
				break;
			}
		}
		pOPN->SetReg((uint8)reg, (uint8)dat);
	}
}

BYTE joy_getb(BYTE port){
//    return 0xFF;
    return 0;
}
