/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC CvO ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <stdio.h>
#include <conio.h>
#include <assert.h>
#include <dos.h>
#include "xm7.h"
#include "mainetc.h"
#include "fdc.h"
#include "gui.h"
#include "ibm.h"

/*
 *	X^bNTCY
 */
extern unsigned _stksiz = 8192U;

/*
 *	^Cg
 */
char *pszTitle =
	 "FM-7 EMULATOR XM7 V1.0L20 (for IBM-PC)  (C) 1999-2001 ohD";

/*
 *	FM-TOWNS(FM-R)`FbN
 */
static BOOL isfm_check(void)
{
	WORD far *p;

	p = (WORD far *)(0xffff0003L);
	if (*p == 0xfc00) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	PC-98`FbN
 */
static BOOL is98_check(void)
{
	union REGS regs;

	regs.h.ah = 0x0f;
	int86(0x10, &regs, &regs);
	if (regs.h.ah == 0x0f) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	Cxg
 */
void do_events(void)
{
	static BYTE count;
	static BYTE tcount;

	/* ^C}[ */
	if (timer_flag) {
		tcount++;
		if (tcount >= 5) {
			count++;
			if (count & 1) {
				subcpu_nmi();
			}
			mainetc_timer();
			tcount = 0;
		}
		snd_timer();
		timer_flag = FALSE;
	}

	/* L[ */
	if (kbd_flag) {
		kbd_check();
	}
}

/*
 *	CvO
 */
int main(int argc, char *argv[])
{
	BOOL machine;

	puts(pszTitle);

	/* }V^Cv */
	machine = TRUE;
	if (isfm_check()) {
		machine = FALSE;
	}
	else {
		if (is98_check()) {
			machine = FALSE;
		}
	}
	if (!machine) {
		puts("This program is designed for IBM-PC architecture.");
		return 1;
	}

	if (!system_init()) {
		puts("Initialize failed.");
		return 1;
	}

	if (argc >= 2) {
		fdc_setdisk(0, argv[1]);
	}
	if (argc >= 3) {
		fdc_setdisk(1, argv[2]);
	}
	else {
		if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
			fdc_setdisk(1, argv[1]);
			fdc_setmedia(1, 1);
		}
	}

	/* TEh`FbN */
	if (snd_init()) {
		/* ̑ */
		scr_init();
		timer_init();
		kbd_init();

		/* ZbgACPUs */
		system_reset();
		debug_run();

		/* N[Abv */
		system_cleanup();
		kbd_cleanup();
		timer_cleanup();
		scr_cleanup();
	}
	snd_cleanup();

	return 0;
}

#endif	/* __MSDOS__ && IBM */
