/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ FM-TOWNS CvO ]
 */

#if defined(__MSDOS__) && defined(FMT)

#include <stdio.h>
#include <conio.h>
#include <assert.h>
#include <dos.h>
#include "xm7.h"
#include "device.h"
#include "fmt.h"
#include "fdc.h"
#include "gui.h"

/*
 *	X^bNTCY
 */
extern unsigned _stksiz = 8192U;

/*
 *	O|o |N
 */
BOOL timer_flag;

/*
 *	^Cg
 */
char *pszTitle =
	 "FM-7 EMULATOR XM7 V1.0L20 (for FM-TOWNS)  (C) 1999-2001 ohD";

/*
 *	FM-TOWNS(FM-R)`FbN
 */
static BOOL isfm_check(void)
{
	WORD far *p;

	p = (WORD far *)(0xffff0003L);
	if (*p == 0xfc00) {
		return TRUE;
	}

	return FALSE;
}

/*
 *	Cxg
 */
void do_events(void)
{
	static BYTE count;

	/* GUI`FbN */
	if (kbd_map[11] & 0x08) {
		gui_start();
	}
	if (kbd_map[13] & 0x02) {
		gui_start();
	}

	/* ^C}|`FbN */
	if (timer_flag){
		count++;
		if (count & 1) {
			subcpu_nmi();
		}
		mainetc_timer();
		kbd_timer();
		timer_flag = FALSE;
	}
}

/*
 *	CvO
 */
int main(int argc, char *argv[])
{
	puts(pszTitle);

	/* }V^Cv */
	if (!isfm_check()) {
		puts("This program is designed for FUJITSU FM-TOWNS architecture.");
		return 1;
	}

	if (!system_init()) {
		puts("ROMt@C܂");
		return 1;
	}

	if (argc >= 2) {
		fdc_setdisk(0, argv[1]);
	}
	if (argc >= 3) {
		fdc_setdisk(1, argv[2]);
	}
	else {
		if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
			fdc_setdisk(1, argv[1]);
			fdc_setmedia(1, 1);
		}
	}

	scr_init();
	timer_init();
	kbd_init();

	system_reset();
	debug_run();

	system_cleanup();
	kbd_cleanup();
	timer_cleanup();
	scr_cleanup();

	return 0;
}

#endif	/* __MSDOS__ && FMT */
