/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ FM-TOWNS L[{[h ]
 */

#if defined(__MSDOS__) && defined(FMT)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "fmt.h"
#include "keyboard.h"

/*
 *	X^eBbN [N
 */
static BYTE kbd_work[32];
static BYTE kbd_count;

/*
 *	O[o [N
 */
BYTE kbd_map[16];

/*
 *	L[{[hϊe[u
 */
typedef struct {
	BYTE fmt;
	BYTE fm7;
} key_table_t;

const key_table_t key_table[] = {
	{ 0x7c, 0x5c },				/* BREAK(Pause) */
	{ 0x6b, 0x49 },				/* EL() */
	{ 0x6c, 0x4a },				/* CLS(Pꖕ) */
	{ 0x6e, 0x4c },				/* DUP(p/Sp) */
};

/*
 *	L[{[h 
 */
void kbd_init(void)
{
	union REGS regs;

	memset(kbd_work, 0, sizeof(kbd_work));
	memset(kbd_map, 0, sizeof(kbd_map));

	/* L[{[hobt@NA */
	regs.h.ah = 0x06;
	regs.h.al = 0x00;
	int86(0x90, &regs, &regs);

	/* NbNȂ */
	regs.h.ah = 0x05;
	regs.h.al = 0x01;
	int86(0x90, &regs, &regs);

	kbd_count = 0;
}

/*
 *	L[{[h N[Abv
 */
void kbd_cleanup(void)
{
	union REGS regs;

	/* L[{[hobt@NA */
	regs.h.ah = 0x06;
	regs.h.al = 0x00;
	int86(0x90, &regs, &regs);
}

/*
 *	L[R[hϊ
 *	FM-TOWNS  FM7
 */
static BYTE fmt_to_fm7(BYTE fmt)
{
	int i;

	/* L[ϊe[u */
	for (i=0; i< sizeof(key_table)/sizeof(key_table_t); i++) {
		if (key_table[i].fmt == fmt) {
			return key_table[i].fm7;
		}
	}

	return fmt;
}

/*
 *	^C}荞
 *	L[{[h
 */
void kbd_timer(void)
{
	BYTE *p;
	int i;
	int j;
	BYTE bit;
	BYTE dat;
	BYTE code;
	int count;
	union REGS regs;
	BYTE kbd_buf[16];

	/* f[^擾 */
	regs.h.ah = 0x0a;
	regs.x.di = FP_OFF(kbd_work);
	int86(0x90, &regs, &regs);
	memcpy(kbd_buf, kbd_work, 16);

	/* ȑÕf[^or */
	for (i=0; i<16; i++) {
		kbd_work[i] |= kbd_work[i + 16];
	}

	/* kbd_mapxor,ω_𓾂 */
	for (i=0; i<16; i++) {
		kbd_map[i] ^= kbd_work[i];
	}

	/* ω_`FbNAKvłmake / breako */
	count = 0;
	for (i=0; i<16; i++) {
		bit = 0x01;
		dat = kbd_map[i];
		for (j=0; j<8; j++) {
			if (dat & bit) {
				/* ω_ */
				code = fmt_to_fm7(count);
				if (code != 0) {
					if (kbd_work[i] & bit) {
						keyboard_make(code);
					}
					else {
						keyboard_break(code);
					}
				}
			}
			count++;
			bit += bit;
		}
	}

	/* kbd_mapXV */
	for (i=0; i<16; i++) {
		kbd_map[i] = kbd_work[i];
	}

	/* ēxAf[^擾 */
	memcpy(kbd_work+16, kbd_buf, 16);

	kbd_count++;
	if (!(kbd_count)) {
		/* L[{[hobt@NA */
		regs.h.ah = 0x06;
		regs.h.al = 0x00;
		int86(0x90, &regs, &regs);
	}
}

#endif	/* __MSDOS__  && FMT */
