#include "xev.h"
#include "enemy.h"

#define A_NUM 16

typedef struct {
      int flag;
      ZAHYOU x,y;
      ZAHYOU vx,vy;
      int tmp1;
      int tmp2;
} E_MISSILE;

PRIVATE E_MISSILE emsl[ENEMY_MISSILE];
PRIVATE Pixmap pixmap[2] , pixmap_mask[2];
PRIVATE GC gc[2];
PRIVATE char *fn[2] = {"tekitama.img","tekitama2.img"};
PRIVATE int anim[A_NUM] = {0,0,0,0,1,1,1,1,
			     0,0,0,0,1,1,1,1};

void EnemyMissileSet()
{
      char img[CSIZE*CSIZE], mask[7];
      int x,y,i;
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(i = 0 ; i < 2 ; i++ ){
	    gc[i] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i]);
	    LoadChar(tpath,img , sizeof(img));

	    pixmap[i] = XCreatePixmap(d,w,8,7,depth);
	    bzero(mask,sizeof(mask));

	    for(y = 0 ; y < 7 ; y++) 
	      for(x = 0 ; x < 8 ; x++)
		if(img[y*CSIZE+x] != 100) {
		      mask[y+x/8] |= (1<< (x%8));
		      XSetForeground(d,gc[i],
				     pixel[img[y*CSIZE+x]]);
		      XDrawPoint(d,pixmap[i],gc[i],x,y);
	  }
      
	    pixmap_mask[i] = XCreateBitmapFromData(d,w,mask,8,7);
	    XSetClipMask(d,gc[i],pixmap_mask[i]);
      }
}

void EnemyMissileFree()
{
      int i;

      for(i = 0 ; i < 2 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void InitEnemyMissile()
{
      int i;
      
      for( i = 0 ; i < ENEMY_MISSILE ; i++)
        emsl[i].flag = 0;
}

void EShut(enemy_no,x,y)
     int enemy_no,x,y;
{
      int i;
      int v;

      for(i = 0 ; i < ENEMY_MISSILE -1 ; i++)
        {
	      int sgnx,sgny;
              int absxy;
	 
              if(emsl[i].flag == 1)
                continue;
              
              v = (rand() % 3 + 6)*STPF;
	      emsl[i].tmp1 = 0;
	      emsl[i].tmp2 = 0;
              emsl[i].x.dummy = x;
              emsl[i].y.dummy = y;
              sgnx = jx.sht[UNION]+ 16 - emsl[i].x.sht[UNION];
              sgny = jy.sht[UNION] - emsl[i].y.sht[UNION];
              absxy = 1+ABS(sgnx) + ABS(sgny);
	      if(absxy < 100)  {
		    emsl[i].flag = 0;
		    return;
	      } else {
		    emsl[i].flag = 1;
	      }

              emsl[i].vx.dummy = v*sgnx*33000/absxy;
              emsl[i].vy.dummy = v*sgny*33000/absxy;
              break;
        }
      
}

void GZEShut(enemy_no,x,y)
     int enemy_no,x,y;
{
      int i,j;
      int v;
      int sgnx,sgny;
      int absxy1,absxy2;
      int vxy[5][2] = {
	    {100,  0},{ 95, 31},{ 81, 59},{ 59, 81},{ 31, 95}
      };
      
      sgnx = SGN(jx.dummy - x);
      sgny = SGN(jy.dummy - y);
      v = (rand() % 5 + 8)*STPF;

      for(j = 0 ; j < 5 ; j++) 
	for(i = 0 ; i < ENEMY_MISSILE -1 ; i++)
	  {
		if(emsl[i].flag == 1)
		  continue;
	
		emsl[i].x.dummy = x;
		emsl[i].y.dummy = y;
		emsl[i].flag = 1;
		emsl[i].vx.dummy = sgnx*210*v*vxy[j][0];
		emsl[i].vy.dummy = sgny*210*v*vxy[j][1];

		break;
	  }
      
}

void GBZEShut(enemy_no,x,y)
     int enemy_no,x,y;
{
      int i,j;
      int v;
      int sgnx,sgny;
      int absxy1,absxy2;
      int vxy[20][2] = {
	    {100,  0},{ 95, 31},{ 81, 59},{ 59, 81},{ 31, 95},
	    {-100,  0},{- 95, 31},{-81, 59},{-59, 81},{-31, 95},
	    { 0,  100},{ 95,-31},{ 81,-59},{ 59,-81},{ 31,-95},
	    {0, -100},{-95,-31},{-81,-59},{-59,-81},{-31,-95}
      };
      for(j = 0 ; j < 20 ; j++) 
	for(i = 0 ; i < ENEMY_MISSILE -1 ; i++)
	  {
		if(emsl[i].flag == 1)
		  continue;
	
		emsl[i].x.dummy = x;
		emsl[i].y.dummy = y;
		emsl[i].flag = 1;
		emsl[i].vx.dummy = 6330*vxy[j][0];
		emsl[i].vy.dummy = 6330*vxy[j][1];
		break;
	  }
      
}

int EMissile()
{
      int i;
      int yararetaEM = 0;
      
      for(i = 0 ; i < ENEMY_MISSILE ; i++)
        {
              int sx,sy;
              
              if(!emsl[i].flag)
                continue;
              emsl[i].tmp1++;
	      emsl[i].tmp1&=15;
	      emsl[i].tmp2 = 1-emsl[i].tmp2;
              emsl[i].x.dummy += emsl[i].vx.dummy;
              emsl[i].y.dummy += emsl[i].vy.dummy;
              
	      sx = emsl[i].x.sht[UNION];
              sy = emsl[i].y.sht[UNION];
	      
              if(sx < 0 || sx > XSIZE
                 || sy < 0 || sy > YSIZE)
                {
                      emsl[i].flag = 0;
                }
              else
                {
                      if(emsl[i].tmp2)
			if(( sx - jx.sht[UNION]) > 4  
			   && (sx - jx.sht[UNION]) < 22 &&
			   (sy - jy.sht[UNION]) > 4  
			   && (sy - jy.sht[UNION]) < 22)
			  yararetaEM=1;
		      
		      SetSprite(emsl[i].x.sht[UNION],
				emsl[i].y.sht[UNION],
				pixmap[anim[emsl[i].tmp1]],
				gc[anim[emsl[i].tmp1]],8,7);

		}
	      
        }
      return yararetaEM;
}

int Gemini(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      int dx,dy;
      int sx,sy, fx,fy;
      int absxy;
	 
      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
      enemy[enemy_no].tmp1++;
      enemy[enemy_no].tmp1&=15;

      if(ABS(enemy[enemy_no].vx + SGN(dx)*65536) < 20*65536)
	enemy[enemy_no].vx += SGN(dx)*65536;

      if(ABS(enemy[enemy_no].vy + SGN(dy)*65536) < 20*65536)
        enemy[enemy_no].vy += SGN(dy)*65536;


      if(dx > 4 && dx < 22 && dy > 4 && dy < 22)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;
              
              if((shot[i].x.sht[UNION] - sx) > -20 && 
                 (shot[i].x.sht[UNION] - sx) < 20
                 && (shot[i].y.sht[UNION] - sy) > -24 && 
                 (shot[i].y.sht[UNION] - sy) < 2)
                {
                      score += 500;
                      shot[i].flag = 0;
		}
        }

      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)
        {
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[anim[enemy[enemy_no].tmp1]],
			gc[anim[enemy[enemy_no].tmp1]],8,7);
        }
      
      return yararetaTL;
}

void GeminiInit(x,y)
     int x,y;
{
      int enemy_no, i;
      int vxy[4][2] = {
            {3,3},{-3,3},{-3,-3},{3,-3}
      };
      
      for(i = 0 ; i < 4 ; i++) {
            for(enemy_no = 0 ; enemy_no < ENEMY_MAX ; enemy_no++) {
                  if(!enemy[enemy_no].enemy_no) {
			enemy[enemy_no].x.dummy = x;
			enemy[enemy_no].y.dummy = y;
			enemy[enemy_no].enemy_no = GEMINI;
			enemy[enemy_no].vx = 65536*vxy[i][0];
			enemy[enemy_no].vy = 65536*vxy[i][1];
			enemy[enemy_no].tmp1 = 1;
			break;
		  }
	    }
      }
}




