/***************************************************************************
        xbindkeys : a program to bind keys to commands under X11.
                           -------------------
    begin                : Sat Oct 13 14:11:34 CEST 2001
    copyright            : (C) 2001 by Philippe Brochard
    email                : hocwp@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keys.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <X11/keysym.h>
#include "xbindkeys.h"
#include "keys.h"
#include "config.h"
#include "options.h"
#include "grab_key.h"



int nb_keys;
Keys_t *keys;

extern char rc_file[512];

static char *modifier_string[] = { "Control", "Shift", "Alt", "Mod2",
  "Mod3", "Mod4", "Mod5"
};


int
init_keys (void)
{
  nb_keys = 0;
  keys = NULL;

  return 0;
}

void
close_keys (void)
{
  int i;

  for (i = 0; i < nb_keys; i++)
    free_key (&keys[i]);

  if (keys != NULL)
    free (keys);
}



int
add_key (KeyType_t type, EventType_t event_type, KeySym keysym, KeyCode keycode,
	 unsigned int button, unsigned int modifier, char *command)
{
  Keys_t *keys_bis = NULL;
  int i;

  if (keysym == 0 && keycode == 0 && button == 0)
    {
      fprintf (stderr, "Warning: unkown key in RC file : %s\n", rc_file);
      return (-1);
    }

  /* make new array keys_bis */
  keys_bis = (Keys_t *) malloc ((nb_keys + 1) * sizeof (Keys_t));
  if (keys_bis == NULL)
    return (-1);

  if (keys != NULL)
    {
      /* copy keys in keys_bis */
      for (i = 0; i < nb_keys; i++)
	{
	  keys_bis[i] = keys[i];
	}

      /* delete old keys array */
      free (keys);
    }

  /* make keys_bis as keys */
  keys = keys_bis;

  modifier &= ~(numlock_mask | capslock_mask | scrolllock_mask);

  /* set key */
  if (type == SYM)
    {
      set_keysym (&keys[nb_keys], event_type, keysym, modifier, command);
    }
  else if (type == BUTTON)
    {
      set_button (&keys[nb_keys], event_type, button, modifier, command);
    }
  else
    {
      set_keycode (&keys[nb_keys], event_type, keycode, modifier, command);
    }

  /* new key */
  nb_keys += 1;

  return (0);
}



void
show_key_binding (Display * d)
{
  int i;
  int last_verbose = verbose;

  verbose = 1;

  for (i = 0; i < nb_keys; i++)
    {
      print_key (d, &keys[i]);
    }

  verbose = last_verbose;
}



void
modifier_to_string (unsigned int modifier, char *str)
{
  str[0] = '\0';

  if (modifier & ControlMask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[0]);
    }

  if (modifier & ShiftMask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[1]);
    }


  if (modifier & Mod1Mask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[2]);
    }

  if (modifier & Mod2Mask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[3]);
    }

  if (modifier & Mod3Mask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[4]);
    }

  if (modifier & Mod4Mask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[5]);
    }

  if (modifier & Mod5Mask)
    {
      if (str[0])
	strcat (str, "+");
      strcat (str, modifier_string[6]);
    }
}


void
print_key (Display * d, Keys_t * key)
{
  char str[1000];

  if (verbose)
    {
      if (key->type == SYM)
	{
	  modifier_to_string (key->modifier, str);

	  printf ("\"%s\"\n    %s%s%s%s\n",
		  key->command != NULL ? key->command : "NoCommand",
		  key->event_type == PRESS ? "" : "Release + ",
		  str, str[0] ? " + " : "", XKeysymToString (key->key.sym));
	}
      else if (key->type == BUTTON)
	{
	  printf ("\"%s\"\n    %sm:0x%x + b:%d   (mouse)\n",
		  key->command != NULL ? key->command : "NoCommand",
		  key->event_type == PRESS ? "" : "Release + ",
		  key->modifier, key->key.button);
	}
      else
	{
	  printf ("\"%s\"\n    %sm:0x%x + c:%d\n",
		  key->command != NULL ? key->command : "NoCommand",
		  key->event_type == PRESS ? "" : "Release + ",
		  key->modifier, key->key.code);
	  if (d != NULL)
	    {
	      modifier_to_string (key->modifier, str);
	      printf ("    %s%s%s%s\n",
		      str,
		      str[0] ? " + " : "",
		      key->event_type == PRESS ? "" : "Release + ",
		      (XKeysymToString
		       (XKeycodeToKeysym (d, key->key.code, 0)) !=
		       NULL) ? XKeysymToString (XKeycodeToKeysym (d,
								  key->key.
								  code,
								  0)) :
		      "NoSymbol");
	    }
	}
    }
}


void
set_keysym (Keys_t * key, EventType_t event_type, KeySym keysym,
	    unsigned int modifier, char *command)
{
  key->type = SYM;
  key->event_type = event_type;
  key->key.sym = keysym;
  key->modifier = modifier;

  key->command = (char *) malloc ((strlen (command) + 1) * sizeof (char));

  if (key->command != NULL)
    strcpy (key->command, command);
}

void
set_keycode (Keys_t * key, EventType_t event_type, KeySym keycode, 
	     unsigned int modifier, char *command)
{
  key->type = CODE;
  key->event_type = event_type;
  key->key.code = keycode;
  key->modifier = modifier;

  key->command = (char *) malloc ((strlen (command) + 1) * sizeof (char));

  if (key->command != NULL)
    strcpy (key->command, command);
}


void
set_button (Keys_t * key, EventType_t event_type, unsigned int button, 
	    unsigned int modifier, char *command)
{
  key->type = BUTTON;
  key->event_type = event_type;
  key->key.button = button;
  key->modifier = modifier;

  key->command = (char *) malloc ((strlen (command) + 1) * sizeof (char));

  if (key->command != NULL)
    strcpy (key->command, command);
}




void
free_key (Keys_t * key)
{
  key->type = SYM;
  key->event_type = PRESS;
  key->key.sym = 0;
  key->modifier = 0;

  if (key->command != NULL)
    free (key->command);
}





void
start_command_key (Keys_t * key)
{
  pid_t pid;
  
  if (key->command == NULL)
    return;

#ifdef FORK_FLAG  
  if (verbose)
    printf ("Start program with fork+exec call\n");

  //  if (fork() == 0)
  //  execlp ("sh", "sh", "-c", key->command, NULL);
  if (!(pid = fork()))
    {
      setsid();
      switch (fork())
	{
	case 0: execlp ("sh", "sh", "-c", key->command, NULL);
	  break;
	default: _exit(0);
	  break;
	}
    }
  if (pid > 0)
    wait(NULL);
#else
  if (verbose)
    printf ("Start program with system call\n");
  
  system (key->command);
#endif
}
