/* fileviewer.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "fileviewer.hh"
#include "worker.h"
#include <aguix/textview.h>
#include "textstoragefile.h"

bool FileViewer::last_wrap_mode = false;
bool FileViewer::last_showlinenumbers_mode = false;

FileViewer::FileViewer()
{
}

FileViewer::~FileViewer()
{
}

void FileViewer::view( const std::list<std::string> &filelist, int initial_line_number )
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  TextStorageFile *ts = NULL;
  TextView *tv = NULL;
  std::list<std::string>::const_iterator it1;
  int w, h, sw, sh;

  AWindow *win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocaleCom( 49 ) );
  win->create();
  /*  if ( aguix->getTransientWindow() != NULL ) {
    win->setTransientForAWindow( aguix->getTransientWindow() );
    }*/

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 404 ), 1 ), 0, 0, cfix );
  Text *fnt = (Text*)ac1_1->add( new Text( aguix, 0, 0, "", 1 ), 1, 0, cincwnr );

  it1 = filelist.begin();
  
  AFontWidth lencalc( aguix, NULL );

  buildTextView( *it1, &ts, &tv, ac1, fnt, lencalc );
  ac1->readLimits();
  ac1_1->readLimits();

  AContainer *ac1_3 = ac1->add( new AContainer( win, 4, 1 ), 0, 2 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );
  
  /*nextb = (Button*)ac1_3->add( new Button( aguix, 0, 0, "Next", 1, 0, 2 ),
    0, 0, cfix );
    prevb = (Button*)ac1_3->add( new Button( aguix, 0, 0, "Prev", 1, 0, 2 ),
    1, 0, cfix );*/
  ChooseButton *wcb = (ChooseButton*)ac1_3->add( new ChooseButton( aguix, 0, 0,
                                                                   last_wrap_mode, catalog.getLocale( 637 ),
                                                                   LABEL_RIGHT, 1, 0 ),
                                                 0, 0, cincwnr );
  ChooseButton *slncb = (ChooseButton*)ac1_3->add( new ChooseButton( aguix, 0, 0,
                                                                     last_showlinenumbers_mode, catalog.getLocale( 715 ),
                                                                     LABEL_RIGHT, 1, 0 ),
                                                   1, 0, cincwnr );
  Button *jumplineb = (Button*)ac1_3->add( new Button( aguix, 0, 0, catalog.getLocale( 716 ), 1, 0, 2 ),
                                           2, 0, cfix );
  okb = (Button*)ac1_3->add( new Button( aguix, 0, 0, catalog.getLocale( 633 ), 1, 0, 2 ),
			     3, 0, cfix );

  win->setDoTabCycling( true );
  win->contMaximize( true );
  
  w = win->getWidth();
  h = win->getHeight();

  sw = aguix->getRootWindowWidth();
  sh = aguix->getRootWindowHeight();
  sw = (int)( (double)sw * 0.8 );
  sh = (int)( (double)sh * 0.8 );
  if ( sw < 200 ) sw = 200;
  if ( sh < 100 ) sh = 100;
  if ( w < sw ) w = sw;
  if ( h < sh ) h = sh;
  win->resize( w, h );

  tv->setLineWrap( wcb->getState() );
  tv->setShowLineNumbers( slncb->getState() );
  tv->jumpToLine( initial_line_number );

  win->useStippleBackground();
  win->centerScreen();
  win->show();

  win->applyFocus( tv );

  AGMessage *msg;
  int endmode = -1;
  //  bool ignore_key_release = true;
  
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) {
	    endmode = 0;
	  }
          break;
	case AG_CHOOSECLICKED:
	  if ( msg->choose.button == wcb ) {
	    tv->setLineWrap( msg->choose.state );
	  } else if ( msg->choose.button == slncb ) {
	    tv->setShowLineNumbers( msg->choose.state );
          }
	  break;
        case AG_BUTTONCLICKED:
	  if ( msg->button.button == okb ) {
	    endmode = 0;
	    /*	  } else if ( msg->button.button == nextb ) {
		  it1++;
		  if ( it1 == filelist.end() ) it1 = filelist.begin();
		  buildTextView( *it1, &ts, &tv, ac1 );
		  } else if ( msg->button.button == prevb ) {
		  if ( it1 == filelist.begin() )
		  it1 = filelist.end();
		  it1--;
		  buildTextView( *it1, &ts, &tv, ac1 );*/
	  } else if ( msg->button.button == jumplineb ) {
            jumpToLine( *win, *tv );
          }
          break;
          /*        case AG_KEYPRESSED:
          ignore_key_release = false;
          break;*/
	case AG_KEYPRESSED:
	  if ( /*ignore_key_release == false && */win->isParent( msg->key.window, false ) == true ) {
	    wcb->setState( tv->getLineWrap() );
	    slncb->setState( tv->getShowLineNumbers() );
	    switch ( msg->key.key ) {
	      case XK_q:
	      case XK_Escape:
	      case XK_F3:
	      case XK_F10:
	        endmode = 0;
	        break;
              case XK_l:
                if ( ( msg->key.keystate & ( ControlMask | Mod1Mask ) ) != 0 ) {
                  jumpToLine( *win, *tv );
                }
                break;
	    }
	  }
	  break;
      }
      aguix->ReplyMessage( msg );
    }
  }

  last_wrap_mode = tv->getLineWrap();
  last_showlinenumbers_mode = tv->getShowLineNumbers();

  delete win;
  if ( ts != NULL ) delete ts;
}

void FileViewer::buildTextView( const std::string &filename,
                                TextStorageFile **ts,
                                TextView **tv,
                                AContainer *ac1,
                                class Text *fnt,
                                AWidth &lencalc )
{
  AGUIX *aguix = Worker::getAGUIX();
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  
  if ( ts == NULL || tv == NULL || ac1 == NULL ) return;
  
  delete *tv;
  *ts = new TextStorageFile( filename, lencalc );
  *tv = new TextView( aguix, 0, 0, 100, 100, 0, "", **ts );
  (*tv)->setDisplayFocus( true );
  ac1->add( *tv, 0, 1, cmin );
  (*tv)->create();
  if ( fnt != NULL ) fnt->setText( filename.c_str() );
  ac1->rearrange();
  (*tv)->show();
}

void FileViewer::setLineWrap( bool nv )
{
  last_wrap_mode = nv;
}

bool FileViewer::getLineWrap()
{
  return last_wrap_mode;
}

void FileViewer::setShowLineNumbers( bool nv )
{
  last_showlinenumbers_mode = nv;
}

bool FileViewer::getShowLineNumbers()
{
  return last_showlinenumbers_mode;
}

void FileViewer::jumpToLine( AWindow &win, TextView &tv )
{
  int erg;
  std::string buttons;
  char *return_str = NULL;

  buttons = catalog.getLocale( 716 );
  buttons += "|";
  buttons += catalog.getLocale( 8 );

  //TODO use current line number as default but I need the interface in tv for this first
  erg = win.string_request( catalog.getLocale( 123 ),
                            catalog.getLocale( 717 ),
                            "",
                            buttons.c_str(),
                            &return_str );
  if ( erg == 0 && return_str != NULL ) {
    int line_nr = 0;
    line_nr = atoi( return_str ) - 1;
    tv.jumpToLine( line_nr );
  }
  if ( return_str != NULL )
    _freesafe( return_str );
}
