/* condvar.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONDVAR_H
#define CONDVAR_H

#include "aguixdefs.h"
#include "mutex.h"

class CondVar:public MutEx
{
public:
  CondVar();
  ~CondVar();
  CondVar( const CondVar &other );
  CondVar &operator=( const CondVar &other );

  virtual void wait();
  virtual void signal();
  virtual void bcast();
protected:
  pthread_cond_t _condvar;
};

#endif
