/* @(#)strtoi.c	1.6 */

#include <config.h>

#include <stdlib.h>
#include <errno.h>
#include <limits.h>

#include <utftools.h>

/*
 * strtoi(nptr, endptr, base)
 *
 * The strtoi() function is an int version of strtol().
 */
int
strtoi(const char *nptr, char **endptr, int base)
{
	long value;
	int olderrno;
	
	olderrno = errno;
	errno = 0;

	value = strtol(nptr, endptr, base);
	
	if (value > INT_MAX) {
		errno = ERANGE;
		value = INT_MAX;
	} else if (value < INT_MIN) {
		errno = ERANGE;
		value = INT_MIN;
	} else
		errno = olderrno;
	
	return value;
}
