/* @(#)error.c	1.6 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <utftools.h>

char *errorname = 0;

/*
 * error(fmt, ...)
 *
 * The error() function reports an error and returns.
 */
void
error(const char *fmt, ...)
{
	va_list ap;

	if (errorname != 0)
		fprintf(stderr, "%s: ", errorname);
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
}

/*
 * fatal(fmt, ...)
 *
 * The fatal() function reports an error and exits with a status of 1.
 */
void
fatal(const char *fmt, ...)
{
	va_list ap;

	if (errorname != 0)
		fprintf(stderr, "%s: ", errorname);
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");

	exit(1);
}

