/**
 * @filename	stats-sol.c
 *
 * @desc	Retrieve stats for the Solaris platform
 */

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <utmpx.h>
#include <fcntl.h>
#include <strings.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/systeminfo.h>
#include <sys/utsname.h>

/**
 * @desc	Get statistics
 */
void getstats(unsigned long *puptime, double *pload, int *pidle, char *os, char *oslevel, char *cpu) {
  int fd;
  time_t thetime;
  struct utmpx ut;
  int cpulevel;
  int found;

  fd = open(UTMPX_FILE, O_RDONLY);
  if(fd < 0) {
    perror("UTMPX_FILE");
    exit(1);
  }

  found = 0;
  while(!found) {
    if(read(fd, &ut, sizeof(ut)) < 0)
      found = -1;
    else
      if(ut.ut_type == BOOT_TIME)
        found = 1;
  }
  close(fd);

  if(found == -1) {
    fprintf(stderr, "Could not find uptime.\n");
    exit (1);
  }

  time(&thetime);
  *puptime = (thetime - ut.ut_tv.tv_sec) / 60;

  if(cfg_sendos) {
    if(sysinfo(SI_SYSNAME, os, OS_SIZE - 1) < 0) {
      perror("sysinfo() call");
    }
  }

  if(cfg_sendos && cfg_sendoslevel) {
    if(sysinfo(SI_RELEASE, oslevel, OSLEVEL_SIZE - 1) < 0) {
      perror("sysinfo() call");
    }
  }

  if(cfg_sendcpu) {
    if(cfg_sendcpulevel == 1) {
      cpulevel = SI_ARCHITECTURE; /* Send architecture */
    } else {
      cpulevel = SI_MACHINE;      /* Send architecture's specific model */
    }
    if(sysinfo(cpulevel, cpu, CPU_SIZE - 1) < 0) {
      perror("sysinfo() call");
    }
  }
}
