/**
 * @filename	stats-beos.c
 *
 * @desc	Retrieve stats for the BeOS platform
 */

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <stdio.h>
#include <errno.h>
#include <sys/utsname.h>
#include <OS.h>

/**
 * @desc	Get statistics
 */
void getstats(unsigned long *puptime, double *pload, int *pidle, char *os, char *oslevel, char *cpu) {
  struct utsname uts;
  double up=0;

  /* Get uptime */
  up = system_time();

  *puptime = (int)(up / 60000000);
  if(up == 0) {
    up = 1;
  }

  /* Get os info */
  if(cfg_sendos) {
    uname(&uts);
  } else {
    /* Get CPU info */
    if(cfg_sendcpu) {
      uname(&uts);
    }
  }

  if(cfg_sendos) {
    strncpy(os, uts.sysname, OS_SIZE - 1);
    if(cfg_sendoslevel) {
      strncpy(oslevel, uts.release, OSLEVEL_SIZE - 1);
    }
  }

  if(cfg_sendcpu) {
    strncpy(cpu, uts.machine, CPU_SIZE - 1);
  }
}
