/**
 * @filename	network.c
 *
 * @desc	Networking functions
 */

/* My includes */
#include "network.h"
#include "upclient.h"

/* System includes */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef PLATFORM_WINNT
  #include <windows.h>
#endif

/**
 * @desc	Wrapper function for writing to our file descriptor
 */
int socket_write(int fd, const char *buf, size_t nbytes) {
  ssize_t write_ret;
  size_t nwritten;

  nwritten = 0;
  while(nwritten < nbytes) {
    write_ret = write(fd, buf+nwritten, nbytes-nwritten);
    if(write_ret <= 0) {
      return -1;
    }
    nwritten += write_ret;
  }
  return nwritten;
}

/**
 * @desc	Wrapper function for reading from our file descriptor
 */
int socket_read(int fd, char *buf, size_t nbytes) {
  ssize_t read_ret;
  size_t nread;

  nread = 0;
  while(nread < nbytes) {
    read_ret = read(fd, buf+nread, nbytes-nread);
    if(read_ret < 0) {
      return -1;
    }
    if(read_ret == 0) {
      return nread;
    }
    nread += read_ret;
  }
  return nread;
}

#if defined(PLATFORM_WINNT)
void startWinsock(void) {
  // ensures winsock dll gets loaded if it wasn't already
  WSADATA wsaData;
  int err;
  WORD wVersionRequested = 0x0101;

  if(WSAStartup(wVersionRequested, &wsaData) != 0) {
    printf("Cannot load WINSOCK.DLL nor WSOCK32.DLL\n");
  }
}
#endif
