//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  tagtext.h   - include file containing the string descriptions for
//                Object-Based Messaging objects.
//
//  Compiler: VC
//  Version: 1.00
//  Revisions:
//

// structure to hold message text translations
typedef struct
{
   ushort val;    // object descriptor
   char msg[80];  // string representation
} TextLookup;

#ifdef TAG_MSGS

// Translations to Text
TextLookup TAGMsgs[] = {   
      // Data Object Descriptors
      {  DOD_ByteArray,    "Byte array of hex digits"  },
      {  DOD_Integer,      "decimal numeric value, leading zero supressed"  },
      {  DOD_String,       "printable ASCII string"  },
      {  DOD_DSROM,        "Dallas Serial ROM number uncompressed"  },
      {  DOD_DSROM_Comp,   "Dallas Serial ROM number compressed (nocrc)"  },
      {  DOD_DotDec,       "Dotted-decimal notation (as in IP addresses) NBO"  },
      {  DOD_ColHex,       "Colon delimited Hex (as in eithernet address) NBO"  },
      {  DOD_TimeDate,     "Time / Date"  },
      {  DOD_Boolean,      "flags"  },
      {  DOD_Password,     "password (not displayed or masked by * characters"  },
      {  DOD_NBO_Int,      "NBO decimal integer"  },
      // Data Object Modifiers
      {  DOM_Person,       "Noun: Person (name, unique ID)"  },
      {  DOM_Place,        "Noun: Place (location, address)"  },
      {  DOM_Thing,        "Noun: Thing (item, component"  },
      {  DOM_Action,       "Verb: Action (event)"  },
      {  DOM_Status,       "Verb status (state of being)"  },
      {  DOM_Adjective,    "Adjective: Modifier"  },
      {  DOM_Undefined,    "Undefined"  },
      // Group Object Descriptors
      {  GOD_SYS,          "System Control, administration"  },
      {  GOD_TMEX,         "Dallas Semiconductor Inc. TMEX"  },
      {  GOD_TRACK,        "Asset/People/Document Tracking"  },
      {  GOD_ACCESS,       "Access Control, Security"  },
      {  GOD_DATA,         "General Data Collection"  },
      {  GOD_SERIAL,       "Serial-to-One-Wire Bridge Applications"  },
      {  GOD_DYNDATA1,     "Dynamic Data Objects"  },
      {  GOD_DYNDATA2,     "Dynamic Data Objects"  },
      {  GOD_EXPER,        "Experimental"  },
      {  GOD_OBJECT,       "Object"  },
      // Predefined Data
      {DD_AccessStatus,"AccessStatus"},
      {DD_AdminPage,"AdminPage"},
      {DD_AppState,"AppState"},
      {DD_Auxiliary,"Auxiliary"},
      {DD_AuxResourceCode,"AuxResourceCode"},
      {DD_AuxResourceDesc,"AuxResourceDesc"},
      {DD_BlockLength,"BlockLength"},
      {DD_BOSClock,"BOSClock"},
      {DD_Channel,"Channel"},
      {DD_ConfigurationDate,"ConfigurationDate"},
      {DD_DateCode,"DateCode"},
      {DD_Depth,"Depth"},
      {DD_Device,"Device"},
      {DD_DoorProfile,"DoorProfile"},
      {DD_DoorSchedule,"DoorSchedule"},
      {DD_DoorStrike,"DoorStrike"},
      {DD_DoorSwitch,"DoorSwitch"},
      {DD_DoorSwPolarity,"DoorSwPolarity"},
      {DD_Duration,"Duration"},
      {DD_EndDate,"EndDate"},
      {DD_EndRunTimeOut,"EndRunTimeOut"},
      {DD_EngineerName,"EngineerName"},
      {DD_EngResourceCode,"EngResourceCode"},
      {DD_FWFileName,"FWFileName"},
      {DD_Handle,"Handle"},
      {DD_HandlerResCode,"HandlerResCode"},
      {DD_HandlerResDesc,"HandlerResDesc"},
      {DD_HandlerResID,"HandlerResID"},
      {DD_HoldLimit,"HoldLimit"},
      {DD_HostPort,"HostPort"},
      {DD_HVACCool,"HVACCool"},
      {DD_HVACFan,"HVACFan"},
      {DD_HVACHeat,"HVACHeat"},
      {DD_iBArray,"iBArray"},
      {DD_iBClass,"iBClass"},
      {DD_IndexTime,"IndexTime"},
      {DD_InitialQuantity,"InitialQuantity"},
      {DD_InterfaceClass,"InterfaceClass"},
      {DD_InterfaceType,"InterfaceType"},
      {DD_LaserResCode,"LaserResCode"},
      {DD_LaserResDesc,"LaserResDesc"},
      {DD_LineControl,"LineControl"},
      {DD_Location,"Location"},
      {DD_LocationCode,"LocationCode"},
      {DD_LotNumber,"LotNumber"},
      {DD_MemAddress,"MemAddress"},
      {DD_Message,"Message"},
      {DD_MyIPAddr,"MyIPAddr"},
      {DD_Number,"Number"},
      {DD_NumPauses,"NumPauses"},
      {DD_OperatorName,"OperatorName"},
      {DD_OperatorResCode,"OperatorResCode"},
      {DD_OperatorResID,"OperatorResID"},
      {DD_OWStatus,"OWStatus"},
      {DD_PartNumber,"PartNumber"},
      {DD_PartsTested,"PartsTested"},
      {DD_PauseTime,"PauseTime"},
      {DD_PeerAddress,"PeerAddress"},
      {DD_PeerEth,"PeerEth"},
      {DD_PeerIP,"PeerIP"},
      {DD_PeerPort,"PeerPort"},
      {DD_Prober,"Prober"},
      {DD_ProberDesc,"ProberDesc"},
      {DD_ProberResCode,"ProberResCode"},
      {DD_ProberResDesc,"ProberResDesc"},
      {DD_Relay,"Relay"},
      {DD_ReportDateTime,"ReportDateTime"},
      {DD_ResourceCode,"ResourceCode"},
      {DD_ResourceID,"ResourceID"},
      {DD_RingSeq,"RingSeq"},
      {DD_RomData,"OWNetAddress"},
      {DD_RTrackSequence,"RTrackSequence"},
      {DD_RTrkServerAddress,"RTrkServerAddress"},
      {DD_SearchType,"SearchType"},
      {DD_Sense,"Sense"},
      {DD_SeqNum,"SeqNum"},
      {DD_SiteState,"SiteState"},
      {DD_SkipFam,"SkipFam"},
      {DD_SmartProbe,"SmartProbe"},
      {DD_Speed,"Speed"},
      {DD_StartDate,"StartDate"},
      {DD_StateSequence,"StateSequence"},
      {DD_StateServerAddress,"StateServerAddress"},
      {DD_StatsPage,"StatsPage"},
      {DD_StopTimeOut,"StopTimeOut"},
      {DD_StrikePol,"StrikePol"},
      {DD_StrikeTime,"StrikeTime"},
      {DD_SysFlags,"SysFlags"},
      {DD_TagID,"TagID"},
      {DD_TagState,"TagState"},
      {DD_TagType,"TagType"},
      {DD_TCount,"TCount"},
      {DD_TechnicianName,"TechnicianName"},
      {DD_TechnicianResourceCode,"TechnicianResourceCode"},
      {DD_Telephone,"Telephone"},
      {DD_TestBinInfo,"TestBinInfo"},
      {DD_TestDataSequence,"TestDataSequence"},
      {DD_Tester,"Tester"},
      {DD_TesterInfo,"TesterInfo"},
      {DD_TesterResCode,"TesterResCode"},
      {DD_TesterResDesc,"TesterResDesc"},
      {DD_TesterResID,"TesterResID"},
      {DD_TestServerAddress,"TestServerAddress"},
      {DD_TestTime,"TestTime"},
      {DD_TimeCalibrate,"TimeCalibrate"},
      {DD_TrvDate,"TrvDate"},
      {DD_TrvDesc,"TrvDesc"},
      {DD_TrvOpCode,"TrvOpCode"},
      {DD_TrvOpDate,"TrvOpDate"},
      {DD_TrvOpSeq,"TrvOpSeq"},
      {DD_TrvResp,"TrvResp"},
      {DD_TrvRTCode,"TrvRTCode"},
      {DD_TrvRTCType,"TrvRTCType"},
      {DD_TrvWOType,"TrvWOType"},
      {DD_Trv_ERC,"Trv_ERC"},
      {DD_UserPassword,"UserPassword"},
      {DD_WkstnIPAddr,"WkstnIPAddr"},
      {DD_WkstnName,"WkstnName"},
      {DD_WorkID,"WorkID"},
      {DD_Workspace,"Workspace"},
      {DD_WorkStationResCode,"WorkStationResCode"},
      {DD_WorkStationResDesc,"WorkStationResDesc"},
      {DD_WorkStationResID,"WorkStationResID"},
      {DD_WorkTote,"WorkTote"},
      {DD_WorkToteInfo,"WorkToteInfo"},
      {DD_WTrackSequence,"WTrackSequence"},
      {DD_WTrkServerAddress,"WTrkServerAddress"},
      {DD_XEthAddr,"XEthAddr"},
      {DD_XIPAddr,"XIPAddr"},
      {DD_XUDPDPort,"XUDPDPort"},
      {GD_ACXAddKey,"ACXAddKey"},
      {GD_AcxConnect,"AcxConnect"},
      {GD_ACXDelKey,"ACXDelKey"},
      {GD_ACXDoorClosed,"ACXDoorClosed"},
      {GD_ACXDOorOpened,"ACXDOorOpened"},
      {GD_ACXGranted,"ACXGranted"},
      {GD_ACXHoldOpenAlarm,"ACXHoldOpenAlarm"},
      {GD_ACXLockFail,"ACXLockFail"},
      {GD_ACXOpenDoor,"ACXOpenDoor"},
      {GD_ACXPurgeList,"ACXPurgeList"},
      {GD_ACXRefused,"ACXRefused"},
      {GD_ArgusEvent,"ArgusEvent"},
      {GD_ColdBoot,"ColdBoot"},
      {GD_DoAlphaPage,"DoAlphaPage"},
      {GD_ExecMode,"ExecMode"},
      {GD_GroupEnd,"GroupEnd"},
      {GD_iBAccess,"iBAccess"},
      {GD_iBArrival,"iBArrival"},
      {GD_iBBlock,"iBBlock"},
      {GD_iBBlockRead,"iBBlockRead"},
      {GD_iBDelay,"iBDelay"},
      {GD_iBLock,"iBLock"},
      {GD_iBNext,"iBNext"},
      {GD_iBPulse,"iBPulse"},
      {GD_iBTBit,"iBTBit"},
      {GD_iBTReset,"iBTReset"},
      {GD_iBUnLock,"iBUnLock"},
      {GD_KeepAlive,"KeepAlive"},
      {GD_NetACK,"NetACK"},
      {GD_NetConnect,"NetConnect"},
      {GD_NetDownLoad,"NetDownLoad"},
      {GD_NetInBound,"NetInBound"},
      {GD_NetOutBound,"NetOutBound"},
      {GD_NetPeerData,"NetPeerData"},
      {GD_NetStartHost,"NetStartHost"},
      {GD_NetStartReply,"NetStartReply"},
      {GD_NetValidate,"NetValidate"},
      {GD_NetXData,"NetXData"},
      {GD_Observation,"Observation"},
      {GD_ParseData,"ParseData"},
      {GD_PowerIf,"PowerIf"},
      {GD_PowerOff,"PowerOff"},
      {GD_ProcessPW,"ProcessPW"},
      {GD_ReplaceBOS,"ReplaceBOS"},
      {GD_Report,"Report"},
      {GD_ResourceDeparture,"ResourceDeparture"},
      {GD_RTrkConnect,"RTrkConnect"},
      {GD_SafeMode,"SafeMode"},
      {GD_ScanInit,"ScanInit"},
      {GD_ScreenEnd,"ScreenEnd"},
      {GD_SeqValidate,"SeqValidate"},
      {GD_SetManualMode,"SetManualMode"},
      {GD_SoundAck,"SoundAck"},
      {GD_StartUnRelMsg,"StartUnRelMsg"},
      {GD_StateChange,"StateChange"},
      {GD_StateConnect,"StateConnect"},
      {GD_TestConnect,"TestConnect"},
      {GD_TiaACK,"TiaACK"},
      {GD_TiaConnect,"TiaConnect"},
      {GD_TimeCalibrate,"TimeCalibrate"},
      {GD_TrackResource,"TrackResource"},
      {GD_TrackWork,"TrackWork"},
      {GD_WarmBoot,"WarmBoot"},
      {GD_WTrkConnect,"WTrkConnect"},
      {DD_GPIBChannel,"GPIBChannel"},
      {DD_UserResCode,"UserResCode"},
      {DD_UserName,"UserName"},
      {GD_Branch,"Branch"},
      {GD_SetClock,"SetClock"},
      {DD_ManualMode,"ManualMode"},
      {DD_CiBSignature,"CiBSignature"},
      {DD_DigitalSignature,"DigitalSignature"},
      {DD_EncryptedPWD,"EncryptedPWD"},
      {DD_FirstName,"FirstName"},
      {DD_LastName,"LastName"},
      {DD_MiddleName,"MiddleName"},
      {DD_UserRoleID,"UserRoleID"},
      {GD_AuthenticateGroup,"AuthenticateGroup"},
      {GD_BufPurge,"BufPurge"},
      {GD_ToWorkSvr,"ToWorkSvr"},
      {GD_ToRTrkSvr,"ToRTrkSvr"},
      {GD_ToStateSvr,"ToStateSvr"},
      {GD_ToTestSvr,"ToTestSvr"},
      {GD_ReadPagedRAM,"ReadPagedRAM"},
      {GD_ClearPagedRam,"ClearPagedRam"},
      {GD_ACXWriteBack,"ACXWriteBack"},
      {DD_RecordNumber,"RecordNumber"},
      {GD_WriteBackFail,"WriteBackFail"},
      {DD_Balance,"Balance"},
      {DD_WriteCounter,"WriteCounter"},
      {GD_CiBDebit,"CiBDebit"},
      {DD_PageNumber,"PageNumber"},
      {DD_DebitorID,"DebitorID"},
      {GD_ACXTTMFail,"ACXTTMFail"},
      {DD_TTMStatus,"TTMStatus"},
      {DD_PrevState,"PrevState"},
      {DD_PrevTimeStamp,"PrevTimeStamp"},
      {DD_ArgDSeverAddress,"ArgDSeverAddress"},
      {DD_ArgDataSequence,"ArgDataSequence"},
      {GD_ArgDConnect,"ArgDConnect"},
      {GD_ToArgSvr,"ToArgSvr"},
      {GD_ArgData,"ArgData"},
      {DD_CurrentTemp,"CurrentTemp"},
      {DD_DesiredTemp,"DesiredTemp"},
      {DD_TempSensor,"TempSensor"},
      {DD_DoorSerialNumber,"DoorSerialNumber"},
      {DD_HVACMode,"HVACMode"},
      {DD_HVACFanMode,"HVACFanMode"},
      {DD_HVACModeSwitchHigh,"HVACModeSwitchHigh"},
      {DD_HVACModeSwitchLow,"HVACModeSwitchLow"},
      {DD_TestSequenceNumber,"TestSequenceNumber"},
      {GD_ACXUnLock,"ACXUnLock"},
      {GD_ACXReLock,"ACXReLock"},
      {DD_eCertificate,"eCertificate"},
      // new descriptors
      // groups
      {  GD_OWBranch,         "OWBranch"  },
      {  GD_OWSensor,         "OWSensor"  },
      {  GD_OWActuator,       "OWActuator"  },
      {  GD_OWCluster,        "OWCluster"  },
      // data
      {  DD_Description,      "Description"  },
      {  DD_ScaleFactorM,     "ScaleFactorM" },
      {  DD_ScaleFactorD,     "ScaleFactorD" },
      {  DD_UnitName,         "UnitName" },
      {  DD_ChannelMask,      "ChannelMask" },
      {  DD_ChannelState,     "ChannelState" },
      {  DD_InitState,        "InitState" },
      {  DD_AccessMethod,     "AccessMethod" },
      {  DD_ClusterID,        "ClusterNum" },
      {  DD_ClusterRev,       "ClusterRev" },
      {  DD_Manufacturer,     "Manufacturer" },
      {  DD_ManufacturerCode, "ManufacturerCode"},
      {  DD_Enum,             "Enum" },
      {  DD_SecondsSince1970, "SecondsSince1970" },
      {  0,                  ""  }  };

#else

extern TextLookup TAGMsgs[];

#endif   
